10 '*************************************************************************
20 '*   SHELLCAT/BAS - INTERFACE PROGRAM FOR SHELL VERSION 1.9 CATALOGS     *
30 '*                                                                       *
40 '*   Written by Steven C. Jerkins    CIS 72407,2012   Genie S.JERKINS    *
50 '*                                                                       *
60 '*   This program is released to the Public Domain.  SHELL version 1.9   *
70 '*   is copyrighted by Steve Milliken.                                   *
80 '*************************************************************************
99 '
100 '           DISPLAY CATAOGS AND QUERY
110 ON ERROR GOTO 9000:CLS:CLOSE:DEFINT C,L,I:SIZE=24 'SIZE IS SCREEN SIZE
120 PRINT "DISK CATALOGS AVAILABLE ";CHR$(13):COUNT=1:LINES=0
130 SYSTEM "CAT /CAT:1 (I)"     'GET DIRECTORY OF DRIVE CATALOGS (NOTE DRIVE#)
140 PRINT@ (23,5),"  ";:LINE INPUT "Which catalog would you like to see? ",CAT$:IF LEN(CAT$)>12 THEN PRINT@ (22,5),"File name is too long.  Try Again! ":GOTO 120 ELSE GOSUB 1000
199 '
200 '   OPEN SELECTED CATALOG AND CHECK FOR ERRORS
210 OPEN "D",1,CAT$,60
220 FIELD 1,8 AS FILE$, 3 AS EXT$, 49 AS DESC$
230 GET #1,1                    'GET FIRST RECORD (SHOULD BE DISK NAME & SPACE
240 GOSUB 2000                  'CHECK FOR PROPER RECORD TYPE
250 IF BADFILE%=0 THEN CLS:PRINT@ (23,1),"BAD FILE NAME - Please Check The Spelling and TRY AGAIN ":CLOSE:SYSTEM "REMOVE "+CAT$:CLS:GOTO 120 ELSE TITLE$=FILE$+EXT$+DESC$
299 '
300 '                   OUTPUT OF CATALOG
310 CLS:PRINT TITLE$
320 WHILE COUNT
330     COUNT=COUNT+1:LINES=LINES+1:CHAR=0:INC=1
340     GET #1, COUNT:GOSUB 2000:IF BADFILE%=0 THEN PRINT CHR$(13);"***** END OF CATALOG *****":COUNT=0:INC=0
350     IF LINES=SIZE-3 THEN GOSUB 4000         'PAGING HANDLER
360 'TRUNCATE DESC$ TO ACTUAL MESSAGE LENGTH
370     WHILE INC
380          CHAR=CHAR+1
390          IF MID$(DESC$,CHAR,1)=CHR$(13) THEN PRINT FILE$;" ";EXT$,LEFT$(DESC$,CHAR-1):INC=0:BADFILE%=1
400          IF CHAR>49 THEN PRINT "DESCRIPTION LONGER THAN FIELDED - POSSIBLE FILE ERROR ":CLOSE:GOTO 120
420     WEND
450 WEND
500 '           DO NEW CATALOG OR EXIT
510 PRINT@ (22,5),"Would you like to have a look at another catalog? (Y or N) "
520 Q$=INKEY$
530 IF Q$= "Y" OR Q$="y" THEN CLOSE:CLS:GOTO 120:IF Q$="N" OR Q$="n" THEN CLOSE:SYSTEM
540 GOTO 520
1000 '          INSERT EXTENSION IF NOT PRESENT AND ADD DISK DRIVE #
1010 IF RIGHT$(CAT$,4)="/CAT" OR RIGHT$(CAT$,4)="/cat" THEN CAT$=CAT$+":1"
1020 IF RIGHT$(CAT$,6)="/CAT:1" OR RIGHT$(CAT$,6)="/cat:1" THEN RETURN
1030 IF INSTR(CAT$,"/")<>0 THEN CLS:PRINT@ (12,10),"INCORRECT FILE NAME FORMAT":GOTO 120
1035 IF RIGHT$(CAT$,2)=":1" THEN CAT$=LEFT$(CAT$,LEN(CAT$)-2)
1040 CAT$=CAT$+"/CAT:1"
1050 RETURN
1999 '
2000 '          CHECK FOR BAD FILE OR FOR FILE OVER RUN
2010 IF ASC(LEFT$(FILE$,1))<32 OR ASC(LEFT$(FILE$,1))>128 THEN BADFILE%=0 ELSE BADFILE%=1
2020 RETURN
4000 '                  PAGINATION CONTROL
4010 LINES=0:PRINT@ (22,10), "Press <ENTER> to continue, <E> to end session, and <N> to look at a new catalog. ";
4020 Q$=INKEY$
4030 IF Q$=CHR$(13) THEN CLS:PRINT TITLE$:RETURN
4040 IF Q$="E" OR Q$="e" THEN CLOSE:SYSTEM
4050 IF Q$="N" OR Q$="n" THEN CLOSE:CLS:GOTO 120
4060 GOTO 4020
4998 '
4999 ' TRUNCATE DESCRIPTION TO ACTUAL DESCRIPTION LENGTH
8999 '
9000 '          ERROR HANDLING ROUTINES
9010 IF ERR=5 THEN PRINT "An Illegal Function Call ERROR HAS OCCURRED - Re-Running Program from Start":RUN 
9020 IF ERR=53 THEN PRINT "A file not found ERROR HAS OCCURRED - Let's try again":CLOSE:GOTO 10
9030 PRINT "AN ERROR HAS OCCURRED",ERRS$:END
