;------------------------------------------------------
;	Model 4 Disk name, file names, and dates to file
;		program
;	Useage:  CATDSK :D [(F="FILENAME",PARM1,PARM2,...)]
;
;	Parmeters:
;
;		CONT	Specifies continuous operation
;			Default CONT=ON
;
;		INV	Specifies whether invisible
;			files should be included.
;			Default INV=OFF
;
;		SYS	Specifies whether system files
;			should be included.
;			Default SYS=OFF
;
;		MOD	Specifies whether files with
;			the Mod flag set should be
;			included.
;			Default MOD=ON
;
;		UNMOD	Specifies whether files with
;			the Mod flag reset should be
;			included.
;			Default UNMOD=ON
;
;		QUERY	Specifies whether user should
;			be asked before each mod-flag
;			change.
;			Default QUERY=OFF
;
;		FILE	Specifies what file to use for
;			output of disk name, creation date,
;			free space, file names, creation
;			date, and disk name
;			Default FILE=DISK/CAT
;
;		ABBREV  specifies that only disk names
;			and file names should be output
;			Default ABBREV = OFF
;
;	Abbreviations: I=INV, S=SYS, M=MOD, U=UNMOD,
;			 Q=QUERY,F=FILE,C=CONT,A=ABBREV
;
;	modifications: 09/20/91 -- modified for 6.3.1
;			ADDED ABBREV MODE & PARAM
;
;------------------------------------------------------
;
*LIST OFF
*GET	MACLIB/ASM
*LIST ON
;
;-----
;	Sign on
;-----
	ORG	3000H
;
START	@@DSPLY	HELLO		;Print sign on message
	@@CKBRKC		;Does user want out?
	JR	Z,START1	;Begin if no break
	@@EXIT	-1		;Else ret error code to DOS
;
START1	CALL	PARSE		;Parse cmd line
	CALL	GET_INFO	;Get drive info
	JP	NZ,DRV_NOT_RDY1	;Go, error, no open files
	CALL	SET_UP		;open cat file
START1A	CALL	ADD_DSK		;Process disk
	TEST_PARM CONT$,-1	;Continuous operation?
				;Default is on
	JR	Z,EXIT		;NO, LEAVE
	@@DSPLY	CONTMSG		;display continue msg
GET_KEY	@@KEY			;wait for key
	PUSH	AF		;Save key stroke
	@@CKBRKC		;Ck for break exit
	JR	NZ,EXIT		;Yes, go no error exit
	POP	AF		;P/u key stroke
	CP	CR		;Was it CR?
	JR	NZ,GET_KEY	;no, loop for key
	@@DSP	CR		;else, display CR
	CALL	GET_INFO	;Get new disk info
	JP	NZ,DRV_NOT_RDY
	JR	START1A		;and process next disk
;
EXIT	@@CLOSE	FCB
	@@EXIT	0		;And leave
;
PARSE	LD	A,(HL)		;P/U cmd line char
	IFNE_JR	':',BAD_DRIVE	;Go if not a colon
	INC	HL		;HL=>drive number
	LD	A,(HL)		;Get ASCII number
	SUB	'0'		;Make binary
	IFLT_JR	0,BAD_DRIVE	;Go if too small
	IFGE_JR	8,BAD_DRIVE	;Go if too large
	LD	(DRIVE),A	;Drive okay -- save
	INC	HL		;HL=>past drive #
	@@PARAM	PARM_TBL	;Parse parameters
	RET
;
BAD_DRIVE:
	@@DSPLY	DRIVE_BAD	;Display error msg
	@@EXIT	-1		;And quit
;
;-----
;	Get drive info
;-----
GET_INFO:
	DEFINE	@CKDRV,21H
	LD	A,(DRIVE)	;Is drive ready?
	LD	C,A
	SVC	@CKDRV
	RET	NZ		;back to caller if not ready
	@@GTDCT			;Yes -- IY==>DCT
	LD	A,(IY+9)	;Get dir. cyl.
	LD	(DIRCYL),A	;And save it
	LD	E,3		;Read sector 3
	CALL	READ_SEC	;Move sec. to buf.
	LD	A,(IX+20)	;Get sector count
	DEC	A		;Offset from 0
	LD	(SECTOR),A	;Save it
	XOR	A		;ret with NZ
	RET
;
;-----
;	SET_UP -- Open catalog file
;-----
SET_UP	LD	HL,(OFILE_NM)	;HL=>FILE NAME BUF
SU1	LD	A,(HL)		;p/u char
	INC	HL		;bump ptr
	CP	' '		;is it a space or less?
	JR	Z,SU2		;yes, mark end of file name
	JR	NC,SU1		;is it < space, no, loop
SU2	DEC	HL		;HL=>SPACE OR LESS CHAR
	LD	(HL),CR		;mark end of file name
	@@FSPEC	(OFILE_NM),FCB	;Ck file name
	JR	NZ,BAD_FILE	;Go if bad file name
	@@INIT	FILE_BUF,0,FCB	;Open file
	@@PEOF	FCB		;Always append to file
	LD	IY,FCB		;IY==>out file DCB
	LD	A,(IY+6)	;p/u logical drive
	AND	03H		;mask off all but drive #
	LD	C,A		;Move to C
	LD	A,(DRIVE)	;p/u drive TO cat
	CP	C
	RET	NZ		;Okay, drives are diff
	@@CLOSE	FCB		;Else, close file
	@@DSPLY	DIF_DRV		;Display error msg
	@@DSPLY	USEAGE$		;DISPLAY SYNTAX
	@@EXIT	-1		;Quit with error
;
BAD_FILE:
	@@DSPLY	BAD_FIL$	;Bad file message
	@@EXIT	-1		;Quit with error
;
;-----
;	Add disk to catalog file
;		Outer loop -- repeat for each sector
;-----
ADD_DSK	CALL	GET_DSK_NM	;Get disk name and add
	RET	NZ		;Did not add disk return
ADD_DSK1 LD	A,(SECTOR)	;Get highest unmod sec.
	CP	1		;Ignore GAT & HIT sec.
	RET	Z		;Ret if done
	LD	E,A		;Select this sector
	CALL	READ_SEC	;Move sector to buffer
;
;-----
;	Inner loop -- repeat 8 times for 8 entries
;	per sector
;-----
	LD	B,8		;Set up for loop
ADD_DSK2 PUSH	BC		;Save loop counter
	CALL	ONE_FILE	;Work with one entry
	@@CKBRKC		;Does user want out?
	JR	Z,ADD_DSK3	;No -- continue
	@@CLOSE	FCB		;ELSE close file
	@@EXIT	-1		;AND leave
ADD_DSK3 LD	BC,20H		;Offset to next entry
	ADD	IX,BC		;Point to next entry
	POP	BC		;P/U loop counter
	DJNZ	ADD_DSK2		;Repeat for all entries
;-----
;	End inner loop -- terminate outer loop
;-----
	LD	A,(SECTOR)	;Get current sector
	DEC	A		;Move down one
	LD	(SECTOR),A	;Save next sector
	JR	ADD_DSK1	;Repeat until done
;
;-----
;	Handle one FILE entry
;-----
ONE_FILE:
	BIT	4,(IX)		;File in use?
	RET	Z		;No -- return
	BIT	7,(IX)		;FPDE?
	RET	NZ		;No, return
	BIT	6,(IX)		;SYStem file?
	JR	Z,CHK_INV	;No, go
	TEST_PARM SYS$,0	;Test sys file parm
				;default is off
	RET	Z		;If SYS off, go back
	JR	CHK_MOD		;Else ck mod stat.
;
CHK_INV	BIT	3,(IX)		;Inv. file?
	JR	Z,CHK_MOD	;No, go
	TEST_PARM INV$,0	;Test INV parm
				;Default is off
	RET	Z		;If INV off, ret
;
CHK_MOD	BIT	6,(IX+1)	;Ck MOD flag
	JR	Z,NO_MOD	;Flag is off, go
	TEST_PARM MOD$,-1	;Test MOD parm.
				;Default is on
	RET	Z		;Go if parm. off
	JR	DO_THIS		;Else do this file
;
NO_MOD	TEST_PARM UNMOD$,-1	;Test UNMOD$ parm
				;default is on
	RET	Z		;Go if parm off
;
;-----
;	DISPALY file AND DATA
;-----
DO_THIS	CALL	SHOW_NAME	;Disply file name
	CALL	CK_ABMODE
	JR	NZ,DO_THISA
	CALL	SHOW_DATE	;DATE TO ASCII & DSPLY
	@@DSPLY	DSK_NM_BUF-1	;SHOW DISK NAME
	JR	DO_THISB
DO_THISA:
	@@DSP	CR
DO_THISB:
	TEST_PARM QUERY$,0	;Ask to toggle?
				;Default is off
	CALL	NZ,ASK		;Yes, prompt for ADD
	RET	NZ		;Go if no ADD
	PUSH	IX		;Copy entry ptr to HL
	POP	HL
	LD	A,5		;Offset to file name
	ADD	A,L		;Add to ptr
	LD	L,A		;HL=>file name
	LD	BC,8<8+0	;8 in name, CHR COUNT=0
DOTHIS1	LD	A,(HL)		;p/u char
	@@PUT	A,FCB		;else SAVE it
	INC	C		;bump count of chars
DOTHIS2	INC	HL		;bump ptr
	DJNZ	DOTHIS1		;Repeat for full name
	@@PUT	' ',FCB		;SAVE extent separator
	INC	C		;bump count of chars
	LD	B,3		;3 char in ext
DOTHIS3	LD	A,(HL)		;P/U char
	@@PUT	A,FCB		;Else save it
	INC	C		;bump count of chars
DOTHIS4	INC	HL		;Bump ptr
	DJNZ	DOTHIS3		;Repeat for full extent
	CALL	CK_ABMODE	;ck for abbreviated output
	JR	NZ,DOTHIS8	;MODE IS ON, GO
	LD	A,13		;file/etx+1
	SUB	C		;subtract num of char saved
	LD	B,A
DOTHIS5	@@PUT	' ',FCB		;Save a space
	DJNZ	DOTHIS5
	LD	B,8		;NUM CHR IN DATE
	LD	HL,DATE_BUF	;HL=>date buffer
DOTHIS6	LD	A,(HL)		;P/U CHAR
	@@PUT	A,FCB		;save char
	INC	HL
	DJNZ	DOTHIS6		;loop for date
	@@PUT	' ',FCB		;save a space
	LD	B,9		;len disk name + 1
	LD	HL,DSK_NM_BUF-1	;HL=>Disk name buffer
DOTHIS7	LD	A,(HL)		;p/u char
	@@PUT	A,FCB		;save char
	INC	HL
	DJNZ	DOTHIS7		;loop for chars
DOTHIS8:
	@@PUT	CR,FCB		;mark end of entry
	RET
;
;-----
;	Read dir. sec. On entry, sec. num in E
;	return with IX==>sec buf
;-----
READ_SEC:
	RPUSH	HL,DE,BC	;Save regs
	LD	HL,SEC_BUF	;HL=>Sec. buf.
	LD	A,(DIRCYL)	;Get dir cyl
	LD	D,A		;Set cyl. to read
	LD	A,(DRIVE)	;Get drive number
	LD	C,A		;Drive in C
	@@RDSSC			;Read the sector
	PUSH	HL		;Trans. buf addr.
	POP	IX		;  to IX
	RPOP	BC,DE,HL	;Restore regs
	RET
;
;-----
;	Show filename and status of dir entry
;-----
SHOW_NAME:
	PUSH	IX		;Copy entry ptr to HL
	POP	HL
	LD	A,5		;Offset to file name
	ADD	A,L		;Add to ptr
	LD	L,A		;HL=>file name
	LD	BC,8<8+0	;8 char in name
SHOW1	LD	A,(HL)		;p/u char
	PUSH	BC
	@@DSP	A		;else display it
	POP	BC
	INC	C
SHOW2	INC	HL		;bump ptr
	DJNZ	SHOW1		;Repeat for full name
	PUSH	BC
	@@DSP	' '		;Print extent separator
	POP	BC
	LD	B,3		;3 char in ext
SHOW3	LD	A,(HL)		;P/U char
	PUSH	BC
	@@DSP	A		;Else display it
	POP	BC
	INC	C
SHOW4	INC	HL		;Bump ptr
	DJNZ	SHOW3		;Repeat for full extent
	LD	A,13
	SUB	C
	LD	B,A
SHOW5	@@DSP	' '		;show a space
	DJNZ	SHOW5
	RET
;
;-----
;	Ask to toggle Mod flag,
;	Ret Z to toggle, NZ no toggle
;-----
ASK	@@DSPLY	QUESTION	;"Add (Y/N/Q) ? "
ASK1	@@KEY			;Wait for reply
	AND	0DFH		;Force to UC
	IFNE_JR	'Q',ASK2	;Not Q -- go
	@@DSP	'Q'		;Display response
	@@CLOSE	FCB		;Else save prev. changes
	@@EXIT	0		;And end program
ASK2	IFNE_JR	'N',ASK3	;Not 'N' -- go
	@@DSP	'N'		;Show response
	@@DSP	CR		;Move to new line
	XOR	A		;A=0
	INC	A		;Set NZ, i.e., no toggle
	RET
ASK3	IFNE_JR	'Y',ASK1	;loop if illegal entry
	@@DSP	'Y'		;Show response
	@@DSP	CR		;Move to next line
	XOR	A		;Set Z, i.e., toggle
	RET
;
;-----
;	Get disk name in buffer
;-----
GET_DSK_NM:
	LD	A,(DRIVE)	;P/U drive number
	@@DODIR	4,A,DSK_NM_BUF
				;Read disk name, date
				;orig free space, and
				;current free space into
				;buffer
	@@HEXDEC (DSK_OFS),TOTALSP
				;convert total to ascII
        @@HEXDEC (DSK_CFS),FREESP
				;convert current free space
				;to ASCII
	LD	B,9
	LD	HL,DSK_NM_BUF-1
GDLP1	LD	A,(HL)
	@@DSP	A
	INC	HL
	DJNZ	GDLP1
	@@DSP	'>'
	CALL	CK_ABMODE
	JP	NZ,GDLP3B
	LD	B,4
GDLP1A	@@DSP	' '
	DJNZ	GDLP1A
	LD	A,(HL)		;P/U FIRS CHAR OF DATE
	INC	HL		;BUMP DISK DATE POINTER
	CP	'0'		;CK FOR ZERO LEADING DATE
	JR	NZ,GDLP21
	LD	A,' '		;REPLACE LEADING 0 WITH SPACE
GDLP21:	@@DSP	A
	LD	A,(HL)		;P/U SECOND DIGIT OF MONTH
	INC	HL
	@@DSP	A
	LD	A,(HL)
	INC	HL
	@@DSP	A
	LD	A,(HL)		;p/u first digit of day
	INC	HL
	CP	'0'
	JR	NZ,GDLP22
	LD	A,' '
GDLP22:	@@DSP	A
	LD	B,4		;NOW DISPLAY REST OF DATE
GDLP2	LD	A,(HL)
	INC	HL
	@@DSP	A
	DJNZ	GDLP2
	LD	HL,FREESP+1
	LD	B,5
GDLP3	LD	A,(HL)
	@@DSP	A
	INC	HL
	DJNZ	GDLP3
	LD	HL,TOTALSP+1
	LD	B,5
GDLP3A	LD	A,(HL)
	@@DSP	A
	INC	HL
	DJNZ	GDLP3A
GDLP3B	@@DSP	CR
	LD	DE,(QUERY$)	;p/u query flag
	LD	A,D
	OR	E		;Test if off
	JR	Z,GDN1		;Is off go
	CALL	ASK		;See if add disk
	RET	NZ		;Back, do not add disk
GDN1	LD	B,9
	LD	HL,DSK_NM_BUF-1
GDLP4	LD	A,(HL)
	@@PUT	A,FCB
	INC	HL
	DJNZ	GDLP4
	@@PUT	'>',FCB
	CALL	CK_ABMODE
	JP	NZ,GDLP6B
	LD	B,3		;3 SPACES FOR PADDING
GDLP4A	@@PUT	' ',FCB
	DJNZ	GDLP4A
	LD	A,(HL)		;P/U FIRS CHAR OF DATE
	INC	HL		;BUMP DISK DATE POINTER
	CP	'0'		;CK FOR ZERO LEADING DATE
	JR	NZ,GDLP51
	LD	A,' '		;REPLACE LEADING 0 WITH SPACE
GDLP51:	@@PUT	A,FCB
	LD	A,(HL)		;P/U SECOND DIGIT OF MONTH
	INC	HL
	@@PUT	A,FCB
	LD	A,(HL)
	INC	HL
	@@PUT	A,FCB
	LD	A,(HL)		;p/u first digit of day
	INC	HL
	CP	'0'
	JR	NZ,GDLP52
	LD	A,' '
GDLP52:	@@PUT	A,FCB
	LD	B,4		;NOW SAVE REST OF DATE
GDLP5	LD	A,(HL)
	INC	HL
	@@PUT	A,FCB
	DJNZ	GDLP5
	LD	HL,FREESP+1
	LD	B,5		;4 CHAR FROM FREE BUF
GDLP6	LD	A,(HL)
	@@PUT	A,FCB
	INC	HL
	DJNZ	GDLP6
	LD	HL,TOTALSP+1
	LD	B,5		;6 CHAR FROM TOTAL BUF
GDLP6A	LD	A,(HL)
	@@PUT	A,FCB
	INC	HL
	DJNZ	GDLP6A
GDLP6B	@@PUT	CR,FCB
	LD	A,CR		;MARK END OF DISK NAME
	LD	(DSK_CD),A	;WITH CR
	XOR	A		;SET Z FLAG
	RET
;
;-----
;	Convert date info on file to ASCII
;-----
SHOW_DATE:
	RPUSH	HL,DE,BC
	LD	A,(IX+1)	;P/U BYTE WITH MONTH
	AND	0FH		;MASK OFF FOR MONTH
	JR	Z,SDNONE	;GO IF NO DATE SET
	DEFINE	@HEXD,5FH	;6.3 DECIMAL DISPLAY ROUTINE
	LD	B,2		;WANT ONLY TWO DIGITS
	LD	H,0		;MOVE MONTH TO HL
	LD	L,A
	LD	DE,DATE_BUF	;DE==>LOC FOR ASCII NUMS
	SVC	@HEXD
	LD	A,'/'
	LD	(DATE_BUF+2),A
	LD	A,(IX+2)	;p/u day of file
	SRL	A		;move down to bits 0-4
	SRL	A
	SRL	A
	AND	1FH		;mask off top three bits
	DEFINE	@HEXD,5FH	;6.3 DECIMAL DISPLAY ROUTINE
	LD	B,2		;WANT ONLY TWO DIGITS
	LD	H,0		;MOVE DAY TO HL
	LD	L,A
	LD	DE,DATE_BUF+3	;DE==>LOC FOR ASCII NUMS
	SVC	@HEXD
	LD	A,'/'
	LD	(DATE_BUF+5),A
	DEFINE	@FLAGS,65H	;POINT IY TO FLAGS TABLE
	SVC	@FLAGS
	LD	A,(DRIVE)	;P/U DRIVE NUMBER
	LD	B,A		;move drive num to B
	INC	B		;set up for dec test below
	LD	A,(IY+'Y'-'A')	;p/u date type flags
	LD	C,A		;put flag in C
	LD	A,01H		;set bit 1 of A
SDSK6:	DEC	B		;ROTATE A TO DRIVE NUMBER BIT
	JR	Z,SDSK5
	ADD	A,A		;SHIFT BIT LEFT 1
	JR	SDSK6		;AND LOOP
SDSK5:	AND	C		;compare to drive flag
	JR	Z,SDSK7		;GO, OLD STYLE DATING
	LD	A,(IX+19)	;ELSE P/U 6.3 YEAR OFFSET
	AND	00011111B	;mask off minute
	JR	SDSK8
SDSK7:	LD	A,(IX+2)	;GET LAST DIGIT OF YEAR
	AND	07H		;MASK OFF DAY BITS
SDSK8	ADD	A,80		;add offset from 1980
	DEFINE	@HEXD,5FH	;6.3 DECIMAL DISPLAY ROUTINE
	LD	B,2		;WANT ONLY TWO DIGITS
	LD	H,0		;MOVE YEAR TO HL
	LD	L,A
	LD	DE,DATE_BUF+6	;DE==>LOC FOR ASCII NUMS
	SVC	@HEXD
SDSK3	@@DSPLY	DATE_BUF
	@@DSP	' '
	RPOP	BC,DE,HL
	RET
;
SDNONE	LD	A,'0'
	LD	(DATE_BUF),A
	LD	(DATE_BUF+1),A
	LD	(DATE_BUF+3),A
	LD	(DATE_BUF+4),A
	LD	(DATE_BUF+6),A
	LD	(DATE_BUF+7),A
	LD	A,'/'
	LD	(DATE_BUF+2),A
	LD	(DATE_BUF+5),A
	JR	SDSK3
;
DRV_NOT_RDY:
	@@CLOSE	FCB
DRV_NOT_RDY1:
	@@DSPLY	NOT_RDY
	@@EXIT	-1
;
CK_ABMODE:
	TEST_PARM ABBREV$,0
	RET
;
;-----
;	Data area & messages
;-----
HELLO	DB	'CATDSK -- Write disk and file information to a file',LF
	DB	'Written Aaron O''Neill, December 13, 1990',LF,CR
DRIVE_BAD DB	'Illegal drive specified on command line',LF,LF
USEAGE$	DB	'Useage: CATDSK :D [(C,I,U,M,S,Q,A,F="FILENAME")]',LF
	DB	'Where: D=Drive number             (required)',LF
	DB	'       C=Continuous operation     (default is on)',LF
	DB	'         [Exit program by using <BREAK>]',LF
	DB	'       I=Invisible files          (default is off)',LF
	DB	'       U=Unmodified files         (default is on)',LF
	DB	'       M=Modified files           (default is on)',LF
	DB	'       S=System files             (default is off)',LF
	DB	'       Q=Query for disk and files (default is off)',LF
	DB	'       A=Abbreviated (names only) (default is off)',LF
	DB	'       F="Filename", filename is the file name',LF
	DB	'         of the catlog file to be added to',LF
	DB	'                                  (default is DISK/CAT)',CR
QUESTION DB	' Add (Y/N/Q) ? ',ETX
DIF_DRV	DB	'Drive to add & drive of output file must be different.'
	DB	LF,CR
BAD_FIL$ DB	'Output File name error.',CR
NOT_RDY	DB	'Input drive not ready (Check disk & if drive is disabled).  '
	DB	'Program aborted.',CR
CONTMSG DB	'Mount next disk.  Press <ENTER> to continue or '
	DB	'<BREAK> to quit',CR
DEFAULT_FILE DB	'DISK/CAT',CR
;
DRIVE	DB	0
SECTOR	DB	0
DIRCYL	DB	0
;
PARM_TBL DB	80H
	IRP	XX,<SYS,INV,MOD,UNMOD,QUERY,CONT,ABBREV>
	PFLG_ENTRY	XX
	ENDM
	DB	00110100B	;Str parm, abbrv
	DB	'FILE'
FRESP	DB	0		;response byte
	DW	OFILE_NM	;VEC to receive parm
	DB	00		;Mark end of table
;
OFILE_NM DW	DEFAULT_FILE	;Buffer for file name
;
FCB	DS	32		;FCB FOR OUTPUT FILE
FILE_BUF DS	256		;BUFFER FOR FILE
;
	DB	'<'		;Disk name flag
DSK_NM_BUF DS	8		;Disk name buffer
DSK_CD	DS	8		;Creation date
DSK_OFS	DS	2		;Original Free space MSB,LSB
DSK_CFS	DS	2		;Current Free space MSB,LSB
FREESP	EQU	$-1
	DS	4
	DB	'K/'
TOTALSP	DS	5		;extra byte for conversion
	DB	'K'
	DB	CR		;To mark end of buffer
;
DATE_BUF DS	8
	DB	ETX
;
SEC_BUF	EQU	$+255&0FF00H	;Put buffer on page boundary
;
	END	START
