1 ' SUBROUTINES USED IN THIS PROGRAM
5 ' 20100       DISPLAY ENTRY FORMAT
10 '20200       DISPLAY FILE INFO
15 '20300       LOAD SKELETON FOR A NEW RECORD
20 '20400       DISPLAY CURRENT B$() ARRAY
25 '20500       HELP SCREENS
30 '20700       DECREASE FILE POINTER IF NOT PAST BOF(1)
35 '20800       INCREASE FILE POINTER IF NOT PAST EOF(1)
40 '20900       VALIDATE SEARCH BY RECORD NUMBER
45 '21000       GLOBAL SEARCH
50 '21200       FILE RECORD
55 '21300       UPDATE MOD DATE IN FORMAT FILE
60 '21500       SHORTCUT TO A NEW PROGRAM
65 '24300       FIELD STATEMENTS
85 '29000       SYSTEM ERROR HANDLING
90 '29100       PRINT ERROR MESSAGES
95 '29900       CLOSE FILES, RETURN TO MENU
100 '-----------------------
101 ' MAIN BODY OF PROGRAM
102 '-----------------------
105 PNAME$ = "DAT01":
    PTITLE$ = "DATA ENTRY"
    ' REVISION 10/01/88
106 '11/21/87 line 29030 not an error if FMTFIL/DIR already open
                         upon return from BSORT
107 '06/21/88 revised sort & rewrite at line 1500 to close FMTFIL/DIR
              before chaining to BSORT
108 '10/08/88 revised shortcut to new program at line 21500 to close
              files before chaining to a new program
110 ON ERROR GOTO 29000
111 DEF FNV1$(X$) = "0"+X$
112 DEF FNV1(X) = X+5
113 DEF FNV2(X) = X*2
120 EL$ = CHR$(30)      ' ERASE TO END OF LINE
121 ES$ = CHR$(31)      ' ERASE TO END OF SCREEN
122 F.KEY$(1) = CHR$(129):
    F.KEY$(2) = CHR$(130):
    F.KEY$(3) = CHR$(131):
    F.KEY$(4) = CHR$(145):
    F.KEY$(5) = CHR$(146):
    F.KEY$(6) = CHR$(147)
130 DIM KY$(200)
180 COMMON USER
200 '------------------------------
201 ' OBTAIN FILENAME, RECORDSIZE
202 '------------------------------
205 OPEN "R", 5, "FMTFIL/DIR:1", 12
210 FS$(5) = "FMTFIL/DIR:1"
215 FIELD 5, 1 AS F5$(1), 8 AS F5$(2), 3 AS F5$(3)
220 GOSUB 20000
225 PRINT @ (2,0), ES$;
230 FOR K = 1 TO LOF(5)
235    GET 5,K
240    IF F5$(1) <> "D"
                THEN PRINT USING "##"; K;:
                     PRINT " - "; F5$(2)
245 NEXT K
250 PRINT "99 - REDISPLAY FILE DIRECTORY":
    PRINT
255 VP = ROW(X)
260 PRINT @ (VP,0), "ENTER SELECTION OR <M> <ENTER>";
        " TO RETURN TO PREVIOUS MENU :";
265 PRINT @ (VP,60), EL$; "__";:
    PRINT @ (VP,60), ;:
    LINE INPUT R$
270 IF LEN(R$) < 1 OR LEN(R$) > 2
        THEN SOUND 1,0:
             GOTO 265
275 IF R$ = "M"
        THEN PRINT @ (VP,60), EL$; "M":
             GOTO 29900
280 IF LEFT$(R$,1) = F.KEY$(5)
        THEN GOSUB 21500:
             GOTO 200
285 IF LEN(R$) < 2
        THEN R1$ = FNV1$(R$)
        ELSE R1$ = R$
290 PRINT @ (VP,60), EL$; R1$
295 IF R1$ = "99"
        THEN CLOSE:
             PRINT @ (20,0), "INSERT DATA DISK IN DRIVE 1, ";
                "THEN TYPE <ENTER> TO CONTINUE.";:
             LINE INPUT R$:
             GOTO 200
300 FKY = VAL(R1$)
305 IF FKY < 1 OR FKY > LOF(5)
        THEN GOOF$ = "INVALID SELECTION.":
             GOSUB 29100:
             GOTO 265
310 GET 5,FKY
315 IF F5$(1) = "D"
        THEN GOOF$ = "INVALID SELECTION.":
             GOSUB 29100:
             GOTO 265
320 FI$ = F5$(2)
325 SP = INSTR(FI$," "):
    IF SP > 0 THEN FI$ = LEFT$(FI$,SP-1)
330 RS = VAL(F5$(3))
335 CLOSE 5
340 FS$(5) = ""
345 IF FI$ = "CC"
        THEN COMMON FI$, RS:
             CHAIN MERGE "CC/TXT"
500 '-----------------------------
501 ' OPEN DATA AND FORMAT FILES
502 '-----------------------------
505 OPEN "R", 1, FI$+"/DAT:1", RS
510 FS$(1) = FI$ + "/DAT:1"
515 OPEN "R", 2, FI$+"/FMT:1", 25
520 FS$(2) = FI$ + "/FMT:1"
525 FIELD 2, 1 AS F2$(1), 8 AS F2$(2), 3 AS F2$(3), 2 AS F2$(4), 8 AS F2$(5)
600 '-----------------
601 ' SET UP FORMATS
602 '-----------------
605 MOD.FLAG = 0
610 GET 2,1
615 NF = VAL(F2$(4))                    ' NUMBER OF FIELDS IN DATAFILE
620 MOD.DAT$ = F2$(5)                   ' DATE FILE WAS LAST MODIFIED
625 FIELD 2, 1 AS F2$(1), 2 AS F2$(2), 2 AS F2$(3), 20 AS F2$(4)
630 FOR K = 1 TO NF
635     GET 2, K+1
640     F = VAL(F2$(2))                 ' FIELD NUMBER
645     A2(F) = VAL(F2$(3))             ' FIELD LENGTH
650     D$(F) = F2$(4)                  ' FIELD DESCRIPTION
655 NEXT K
660 ON NF GOSUB 24310,24320,24330,24340,24350,24360,24370,24380,24390
700 '---------------------------
701 ' BUILD DATAFILE KEY ARRAY
702 '---------------------------
705 AR = 0                              ' NUMBER OF ACTIVE RECORDS
710 FOR RL = 1 TO LOF(1)
715     GET 1,RL
720     KY$(RL) = F1$(2)
725     IF F1$(1) <> "D" THEN AR = AR + 1
730 NEXT RL
800 '-----------------------------------------
801 ' INTRO TO FILE, INITIALIZE FILE POINTER
802 '-----------------------------------------
805 GOSUB 20100:
    GOSUB 20200                         ' DISPLAY FILE INFO
810 KY = 0
815 GOSUB 20800
900 '------------------------------
901 ' LOAD RECORD INTO B$() ARRAY
902 '------------------------------
905 NEW.REC = 0
910 IF AR < 1
        THEN GOSUB 20300:
             GOTO 1000
915 FOR K = 1 TO NF
920     B2$(K) = F1$(K)
925 NEXT K
1000 '-------------------------------
1001 ' DISPLAY RECORD, CHANGE LINE#
1002 '-------------------------------
1005 GOSUB 20400         ' DISPLAY RECORD
1010 PRINT @ (21,0), "ENTER <H>=HELP, COMMAND, KEY, OR LINE# TO CHANGE : _";:
     PRINT @ (21,51), ;:
     LINE INPUT KR$:
     PRINT @ (21,51), EL$; KR$
1015 IF KR$ = "" THEN 1000
1020 IF INSTR(".1.2.3.4.5.6.7.8.9.", "."+KR$+".") = 0 THEN 1100
1025 IF KR$ = "1" AND USER > 6
        THEN SOUND 1,0:
             GOTO 1000
1030 R = VAL(KR$):
     VP = FNV2(R)
1035 IF R > NF
        THEN GOOF$ = "INVALID FIELD NUMBER.":
             GOSUB 29100:
             GOTO 1000
1040 PRINT @ (VP,3), ;:
     LINE INPUT R$
1045 IF R$ = ""
        THEN PRINT @ (VP+1,3), D$(R);:
                GOTO 1000
1050 PRINT @ (VP,3), EL$; R$;:
     PRINT @ (VP+1,3), D$(R);
1055 IF LEN(R$) > A2(R)
        THEN GOOF$ = "TOO MANY CHARACTERS.":
             GOSUB 29100:
             GOTO 1000
1060 B2$(R) = R$
1065 GOTO 1000
1100 '-------------------
1101 ' EXECUTE COMMANDS
1102 '-------------------
1105 IF KR$ = "H"
        THEN GOSUB 20500:
             GOTO 1000          ' DISPLAY HELP MESSAGES
1110 IF KR$ = "I"
        THEN GOSUB 20100:
             GOSUB 20200:
             GOTO 1000          ' DISPLAY FILE INFO
1115 IF KR$ = "Q"
        THEN CLOSE 1:
          FS$(1) = "":
          GOSUB 21300:
          GOTO 200              ' QUIT WORK ON THIS FILE
1120 IF LEFT$(KR$,1) = F.KEY$(5)
        THEN GOSUB 21500:
             GOTO 900           ' CHAIN TO A NEW PROGRAM
1125 IF KR$ = "N"
        THEN GOSUB 20300:
             GOTO 1000          ' SET UP NEW RECORD
1130 IF KR$ = "S"
        THEN GOSUB 21300:
             GOTO 1500          ' SORT THE FILE BY STORED PARAMETERS
1135 IF KR$ = F.KEY$(1)
        THEN GOSUB 20700:
             GOTO 900           ' GET PREVIOUS ACTIVE RECORD
1140 IF KR$ = F.KEY$(2)
        THEN GOSUB 20800:
             GOTO 900           ' GET NEXT ACTIVE RECORD
1145 IF KR$ = "R:FIRST"
        THEN KY = 0:
             GOSUB 20800:
             GOTO 900           ' GET FIRST ACTIVE RECORD IN FILE
1150 IF KR$ = "R:LAST"
        THEN KY = LOF(1)+1:
             GOSUB 20700:
             GOTO 900           ' GET LAST ACTIVE RECORD IN FILE
1155 IF LEFT$(KR$,2) = "R:"
        THEN GOSUB 20900:
             GOTO 900           ' GET RECORD BY NUMBER
1160 IF KR$ = "F"
        THEN GOSUB 21200:
             GOSUB 20800:
             GOTO 900           ' FILE THE CURRENT RECORD
1165 IF KR$ = "D"
        THEN GOSUB 21200:
             GOSUB 20800:
             GOTO 900           ' DELETE THE CURRENT RECORD
1170 IF KR$ = "M"
        THEN GOSUB 21000:
             KY = 0:
             GOSUB 20800:
             GOTO 900           ' MATCH A USER-GIVEN CHAR STRING
1175 IF LEN(KR$) > A2(2)
        THEN GOOF$ = "MAXIMUM LENGTH OF" + STR$(A2(2)) + " CHARACTERS.":
             GOSUB 29100:
             GOTO 800
1180 IF NEW.REC
        THEN SOUND 1,0:
             GOTO 1000
1185 KR$ = KR$ + STRING$(A2(2)-LEN(KR$),32)
1190 FOR KY = 1 TO LOF(1)
1195    IF KY$(KY) <> KR$ THEN 1215
1200    GET 1, KY
1205    IF F1$(1) = "D" THEN 1215
1210 GOTO 900
1215 NEXT KY
1220 GOOF$ = "RECORD NOT FOUND.":
     GOSUB 29100
1225 KY = 0:
     GOSUB 20800
1230 GOTO 900
1500 '------------------------
1501 ' SORT AND REWRITE FILE
1502 '------------------------
1503 CLOSE 5
1504 F2$(5) = ""
1505 FI$ = FI$ + "/DAT:1"
1510 FIELD 1, RS AS IREC$
1515 Q.SW = 0        ' SKIP QUESTIONS FOR SORT PARAMETERS
1520 COMMON PNAME$, FI$, RS, Q.SW, IREC$
1525 CHAIN "BSORT/BAS:0", 230
1530 STOP
5000 '--------------------
5001 ' PRINT FILE STATUS
5002 '--------------------
5003 FOR K = 1 TO 5
5004    PRINT "FILE"; K; "- "; FS$(K)
5005 NEXT K
5006 RETURN
20000 '-----------------------
20001 ' PRINT SCREEN HEADING
20002 '-----------------------
20003 CLS
20004 PRINT PNAME$; TAB(41-(LEN(PTITLE$)/2)); PTITLE$; TAB(73); DATE$:
      PRINT
20005 RETURN
20100 '-----------------------
20101 ' DISPLAY ENTRY FORMAT
20102 '-----------------------
20105 GOSUB 20000
20110 PRINT @ (2,0), ES$;
20115 PRINT "THE FORMATS FOR '"; FI$; "' ARE :":
     PRINT
20120 PRINT TAB(8); "length"; TAB(25); "description"
20125 PRINT TAB(8); STRING$(6,61); TAB(25); STRING$(10,61)
20130 FOR K = 1 TO NF
20135    VP = FNV1(K)
20140    PRINT @ (VP,0), ;:
        PRINT USING "#"; K;:
        PRINT ") "; TAB(10);:
        PRINT USING "##"; A2(K);:
        PRINT TAB(25); D$(K);
20145 NEXT K
20150 PRINT
20155 RETURN
20200 '--------------------
20201 ' DISPLAY FILE INFO
20202 '--------------------
20205 PRINT STRING$(45,95):
      PRINT
20210 PRINT "RECORDSIZE ="; RS
20215 PRINT "TOTAL NUMBER OF RECORDS ="; LOF(1)
20220 PRINT "NUMBER OF ACTIVE RECORDS ="; AR
20225 PRINT:
     PRINT "DATE OF LAST MODIFICATION = "; MOD.DAT$
20230 PRINT @ (22,0), "TYPE <ENTER> TO CONTINUE.";
20235 LINE INPUT R$
20240 RETURN
20300 '---------------------------------
20301 ' LOAD SKELETON FOR A NEW RECORD
20302 '---------------------------------
20305 B2$(1) = "A"
20310 FOR K = 2 TO NF
20315   B2$(K) = STRING$(A2(K),95)
20320 NEXT K
20325 NEW.REC = -1
20330 RETURN
20400 '-----------------------------
20401 ' DISPLAY CURRENT B$() ARRAY
20402 '-----------------------------
20405 PRINT @ (2,0), ES$;
20410 FOR K = 1 TO NF
20415    VP = FNV2(K)
20420    PRINT @ (VP,0), ;:
         PRINT USING "#"; K;:
         PRINT ")"; TAB(4); B2$(K);
20425    IF K = 1 AND NOT NEW.REC THEN PRINT LOC(1);
20430    PRINT @ (VP+1,3), D$(K)
20435 NEXT K
20440 RETURN
20500 '---------------
20501 ' HELP SCREENS
20502 '---------------
20505 PRINT @ (2,0), ES$; TAB(33); "HELP SCREEN 1/2":
      PRINT @ (4,0), ;
20510 PRINT "<D> - Delete the current record.":
      PRINT
20515 PRINT "<F> - File the current record.":
      PRINT
20520 PRINT "<H> - Display this Help screen.":
      PRINT
20525 PRINT "<I> - Display file Information.":
      PRINT
20530 PRINT "<M> - Match a character string you're looking for.":
      PRINT
20535 PRINT "<N> - Create a New record.":
      PRINT
20540 PRINT "<Q> - Quit work on this data file.":
      PRINT
20545 PRINT "<S> - Sort this file by its stored sort parameters.";
20550 LINE INPUT R$
20555 PRINT @ (2,0), ES$; TAB(33); "HELP SCREEN 2/2":
      PRINT @ (4,0), ;
20560 PRINT "R:#"; TAB(11); "- Retrieve record number #.":
      PRINT
20565 PRINT "R:FIRST"; TAB(11); "- Retrieve the first active record.":
      PRINT
20570 PRINT "R:LAST"; TAB(11); "- Retrieve the last active record.":
      PRINT
20575 PRINT "<F1>"; TAB(11); "- Retrieve the next previous active record.":
      PRINT
20580 PRINT "<F2>"; TAB(11); "- Retrieve the next following active record.":
      PRINT
20590 PRINT "<F5>"; TAB(11); "- Shortcut to the program name you enter.":
      PRINT
20595 PRINT "<CTRL><:>"; TAB(11); "- Print hardcopy of any screen including Help screens.";
20600 LINE INPUT R$
20605 RETURN
20700 '-------------------------------------------
20701 ' DECREASE FILE POINTER IF NOT PAST BOF(1)
20702 '-------------------------------------------
20705 IF AR < 1
        THEN GOOF$ = "NO ACTIVE RECORDS.":
             GOSUB 29100:
             GOTO 20730
20710 KY = KY - 1
20715 IF KY < 1
        THEN GOOF$ = "BEGINNING OF FILE.":
             GOSUB 29100:
             GOSUB 20800
20720 GET 1, KY
20725 IF F1$(1) = "D" THEN 20710
20730 RETURN
20800 '-------------------------------------------
20801 ' INCREASE FILE POINTER IF NOT PAST EOF(1)
20802 '-------------------------------------------
20805 IF AR < 1
        THEN GOOF$ = "NO ACTIVE RECORDS.":
             GOSUB 29100:
             GOTO 20830
20810 KY = KY + 1
20815 IF KY > LOF(1)
        THEN GOOF$ = "END OF FILE.":
             GOSUB 29100:
             GOSUB 20700
20820 GET 1, KY
20825 IF F1$(1) = "D" THEN 20810
20830 RETURN
20900 '-----------------------------------
20901 ' VALIDATE SEARCH BY RECORD NUMBER
20902 '-----------------------------------
20905 KY = VAL(RIGHT$(KR$,LEN(KR$)-2))
20910 IF KY > 0 AND KY <= LOF(1)
        THEN GET 1,KY
        ELSE GOOF$ = "INVALID RECORD NUMBER.:
             GOSUB 29100:
             KY = 0
20915 RETURN
21000 '----------------
21001 ' GLOBAL SEARCH
21002 '----------------
21005 SW1 = 0           ' INITIALIZE NO MATCH FOUND
21010 GOSUB 20100       ' DISPLAY SEARCH FIELDS
21015 PRINT @ (16,0), ES$; "ENTER FIELD# TO SEARCH WITH : _";:
      PRINT @ (16,30), ;:
      LINE INPUT R$:
      PRINT @ (16,30), EL$; R$
21020 IF R$ = "" THEN 21125
21025 SF = VAL(R$)
21030 IF SF < 1 OR SF > NF
        THEN GOOF$ = "INVALID FIELD NUMBER.":
             GOSUB 29100:
             GOTO 21015
21035 IF SF = 1
        THEN IF USER < 1 OR USER > 6
           THEN GOOF$ = "INVALID FIELD NUMBER. (P)":
                GOSUB 29100:
                GOTO 21015
21040 PRINT @ (17,0), ES$; "ENTER CHARACTERS TO MATCH : "; STRING$(A2(SF),95);:
      PRINT @ (17,28), ;:
      LINE INPUT MATCH$:
      PRINT @ (17,28), EL$; MATCH$
21045 IF MATCH$ = "" THEN 21125
21050 IF LEN(MATCH$) > A2(SF)
        THEN GOOF$ = "MAXUMUM LENGTH OF" + STR$(A2(SF)) + " CHARACTERS.":
             GOSUB 29100:
             GOTO 21040
21055 KY = 0
21060 PRINT @ (2,0), ES$; "record #   ";:
      IF SF = 2
        THEN PRINT D$(2); D$(3)
        ELSE PRINT D$(2); D$(SF)
21065 PRINT
21070 FOR K = 1 TO 15
21075    KY = KY + 1
21080    IF KY > LOF(1)
           THEN IF SW1
              THEN GOTO 21125
              ELSE GOOF$ = "NO MATCH FOUND.":
                   GOSUB 29100:
                   GOTO 21125
21085    GET 1, KY
21090    IF F1$(1) = "D" THEN 21075
21095    IF INSTR(F1$(SF),MATCH$) = 0 THEN 21075
21100    PRINT USING "###"; KY;:
         PRINT TAB(12); F1$(2); TAB(32);:
         IF SF = 2
          THEN PRINT F1$(3)
          ELSE PRINT F1$(SF)
21105    SW1 = -1
21110 NEXT K
21115 PRINT @ (20,0), ES$; "TYPE <F2> TO CONTINUE DISPLAY.";:
      PRINT @ (20,30), ;:
      LINE INPUT R$
21120 IF R$ = F.KEY$(2) THEN 21060
21125 PRINT @ (20,0), ES$; "TYPE <ENTER> TO RETURN.";:
      LINE INPUT R$
21130 RETURN
21200 '--------------
21201 ' FILE RECORD
21202 '--------------
21205 IF KR$ = "D"
        THEN B2$(1) = "D":
             AR = AR - 1
21210 FOR K = 1 TO NF
21215    LSET F1$(K) = B2$(K)
21220 NEXT K
21225 IF NEW.REC
        THEN KY = LOF(1)+1:
             AR = AR + 1
21230 PUT 1, KY
21235 IF NOT MOD.FLAG
        THEN MOD.FLAG = -1:
             MOD.DAT$ = DATE$
21240 KY$(KY) = B2$(2) + STRING$(A2(2)-LEN(B2$(2)),32)
21245 IF NEW.REC
        THEN KY = KY - 1:
             NEW.REC = 0
21250 SOUND 7,0
21255 RETURN
21300 '---------------------------------
21301 ' UPDATE MOD DATE IN FORMAT FILE
21302 '---------------------------------
21305 IF NOT MOD.FLAG THEN 21330
21310 FIELD 2, 14 AS F2$(1), 8 AS F2$(2)
21315 GET 2,1
21320 LSET F2$(2) = MOD.DAT$
21325 PUT 2,1
21330 CLOSE 2
21335 FS$(2) = ""
21340 RETURN
21500 '----------------------------
21501 ' SHORTCUT TO A NEW PROGRAM
21502 '----------------------------
21505 PN$ = RIGHT$(KR$,LEN(KR$)-1)
21510 PRINT @ (2,0), ES$
21515 PRINT @ (5,0), "CHAIN TO "; PN$; " ?";:
     PRINT TAB(21); "___";:
     PRINT @ (5,20), ;:
     LINE INPUT R$:
     PRINT @ (5,20), EL$; R$
21520 IF R$ <> "Y" AND R$ <> "YES" THEN 21560
21525 CLOSE 1
21530 FS$(1) = ""
21535 IF MOD.FLAG THEN GOSUB 21300
21536 CLOSE
21537 FS$(2) = "":
      FS$(3) = "":
      FS$(4) = "":
      FS$(5) = ""
21540 PRINT @ (20,0), ES$; "INSERT THE CORRECT PROGRAM DISK IN DRIVE 0, ";
        "THEN TYPE <ENTER> TO CONTINUE.";
21545 LINE INPUT R$
21550 CHAIN PN$ + "/BAS:0"
21555 STOP
21560 RETURN
24300 '-------------------
24301 ' FIELD STATEMENTS
24302 '-------------------
24310 FIELD 1,A2(1) AS F1$(1)
24315 RETURN
24320 FIELD 1,A2(1) AS F1$(1),A2(2) AS F1$(2)
24325 RETURN
24330 FIELD 1,A2(1) AS F1$(1),A2(2) AS F1$(2),A2(3) AS F1$(3)
24335 RETURN
24340 FIELD 1,A2(1) AS F1$(1),A2(2) AS F1$(2),A2(3) AS F1$(3),
        A2(4) AS F1$(4)
24345 RETURN
24350 FIELD 1,A2(1) AS F1$(1),A2(2) AS F1$(2),A2(3) AS F1$(3),
        A2(4) AS F1$(4),A2(5) AS F1$(5)
24355 RETURN
24360 FIELD 1,A2(1) AS F1$(1),A2(2) AS F1$(2),A2(3) AS F1$(3),
        A2(4) AS F1$(4),A2(5) AS F1$(5),A2(6) AS F1$(6)
24365 RETURN
24370 FIELD 1,A2(1) AS F1$(1),A2(2) AS F1$(2),A2(3) AS F1$(3),
        A2(4) AS F1$(4),A2(5) AS F1$(5),A2(6) AS F1$(6),
        A2(7) AS F1$(7)
24375 RETURN
24380 FIELD 1,A2(1) AS F1$(1),A2(2) AS F1$(2),A2(3) AS F1$(3),
        A2(4) AS F1$(4),A2(5) AS F1$(5),A2(6) AS F1$(6),
        A2(7) AS F1$(7),A2(8) AS F1$(8)
24385 RETURN
24390 FIELD 1,A2(1) AS F1$(1),A2(2) AS F1$(2),A2(3) AS F1$(3),
        A2(4) AS F1$(4),A2(5) AS F1$(5),A2(6) AS F1$(6),
        A2(7) AS F1$(7),A2(8) AS F1$(8),A2(9) AS F1$(9)
24395 RETURN
29000 '------------------------
29001 ' SYSTEM ERROR HANDLING
29002 '------------------------
29010 IF ERR = 9
        THEN GOOF$ = "KY$() MUST BE RE-DIMENSIONED AT LINE" + STR$(ERL) + ".":
             GOSUB 29100:
             STOP
29020 IF ERR = 10 AND ERL = 130 THEN RESUME NEXT
      ' not an error if KY$() is re-dimensioned for a new file
29030 IF ERR = 55 AND ERL = 205 THEN RESUME NEXT
      ' not an error if FMTFIL/DIR is already open from before BSORT
29090 PRINT @ (20,0), "Error"; ERR; "at line"; ERL
29099 STOP
29100 '-----------------------
29101 ' PRINT ERROR MESSAGES
29102 '-----------------------
29103 PRINT @ (20,0), ES$; GOOF$;
29104 SOUND 1,1
29105 LINE INPUT R$
29106 PRINT @ (20,0), ES$
29107 RETURN
29900 '------------------------------
29901 ' CLOSE FILES, RETURN TO MENU
29902 '------------------------------
29910 CLOSE
29920 CHAIN "MENU03/BAS:0"
32767 END
