	TITLE	'<CED - Comparing Line Editor>'
;for MODEL 4 with TRSDOS 6.2
;by Kerm. T. Frogouhlian
@KEY	EQU	1
@DSP	EQU	2
@KEYIN	EQU	9
@DSPLY	EQU	10
@PRINT	EQU	14
@VDCTL	EQU	15
@PARAM	EQU	17
@EXIT	EQU	22
@ERROR	EQU	26
@OPEN	EQU	59
@READ	EQU	67
@FSPEC	EQU	78
SVC	MACRO	#SVC
	LD	A,#SVC
	RST	28H
	ENDM
	ORG	2700H
PTAB	DB	80H		;begin parameter table
	DB	55H		;demand flag entry
	DB	'BASIC'		;default is off
	DB	0		;suppress line numbers
	DW	BASIC+1		;and set EOFM to 00
	DB	83H		;demand numeric entry
	DB	'EOF'		;to set EOFM
	DB	0		;default is 1AH
	DW	EOF+1
	DB	0
ENTRY	PUSH	HL		;search for possible
	LD	A,(HL)		;parameters first
	INC	HL
	CP	0DH
	JR	Z,NPARM
	CP	'('
	JR	NZ,ENTRY+1
	DEC	HL
	LD	DE,PTAB
	SVC	@PARAM
	JP	NZ,ERROR
NPARM	LD	HL,SCRNB	;blank out screen buffer
	LD	DE,SCRNB+1	;from 2C00 to 337F
	LD	BC,77FH
	LDIR
	POP	HL		;recover command line
	LD	A,(HL)		;and look for filespec 1
	CP	40H
	CALL	C,ENFIL1	;none given so request it
	LD	DE,MSGFS1	;move filespec to screen
	PUSH	HL		;and on return HL will
	CALL	MOVFN		;point to ':'
	LD	(DRV1),HL	;save till drive number known
	POP	HL
	LD	DE,FCB1		;open file 1 with
	SVC	@FSPEC		;input buffer 2600
	LD	A,13H		;to 26FF
	JR	NZ,ERJP
	PUSH	HL		;save command line
	LD	B,0
	LD	HL,2600H
	SVC	@OPEN
	JR	NZ,ERJP
	LD	A,(FCB1+6)	;get drive number found
	ADD	A,30H
	LD	HL,0
DRV1	EQU	$-2		;HL => ':' if present
	LD	(HL),':'	;if drive number was entered
	INC	HL		;on command line, this
	LD	(HL),A		;simply overwrites
	INC	HL		;with identical info
	LD	(HL),20H
	PUSH	DE
	POP	IX		;IX => FCB1
	POP	HL		;remaining command line
	LD	A,(HL)
	CP	40H
	CALL	C,ENFIL2	;similar to file 1
	LD	DE,MSGFS2
	PUSH	HL
	CALL	MOVFN
	LD	(DRV2),HL
	POP	HL
	LD	DE,FCB2		;open file 2 with
	SVC	@FSPEC		;input buffer 2700
	LD	A,13H		;to 27FF
	JR	NZ,ERJP
	LD	B,0
	LD	HL,2700H
	SVC	@OPEN
ERJP	JP	NZ,ERROR
	LD	A,(FCB2+6)
	ADD	A,30H
	LD	HL,0
DRV2	EQU	$-2
	LD	(HL),':'
	INC	HL
	LD	(HL),A
	INC	HL
	LD	(HL),20H
	PUSH	DE
	POP	IY		;IY => FCB2
	LD	C,14
	SVC	@DSP		;turn on cursor
	JP	START		;get above 27FF to use buffers
MOVFN	SVC	@FSPEC
	LD	H,D
	LD	L,E
MOV1	INC	HL
	LD	A,(HL)
	CP	3
	RET	Z		;if find 03, no drive given
	CP	':'
	RET	Z
	JR	MOV1
ENFIL2	LD	HL,TWO		;HL => prompt message
	LD	BC,MSGFS2	;BC => where to put it
	JR	ENFIL3
ENFIL1	LD	HL,ONE
	LD	BC,MSGFS1
ENFIL3	SVC	@DSPLY
	LD	H,B
	LD	L,C
	LD	BC,1F00H
	SVC	@KEYIN
	JP	C,EXIT		;<BREAK> to exit
	RET
FCB1	EQU	2800H
FCB2	EQU	2820H
	ORG	2840H
ERROR	OR	40H		;error causes exit
	LD	C,A
	SVC	@ERROR
EXIT	LD	BC,85FH		;replace cursor with
	SVC	@VDCTL		;underline
	LD	HL,0
	SVC	@EXIT
DECNUM	PUSH	DE
	LD	DE,DECTAB
DEC1	LD	A,(DE)
	LD	C,A
	INC	DE
	LD	A,(DE)
	LD	B,A
	INC	DE
	PUSH	DE
	LD	A,0AFH
DEC2	INC	A
	LD	D,H
	LD	E,L
	ADD	HL,BC
	JR	C,DEC2
	POP	HL
	EX	(SP),HL
	EX	DE,HL
	CALL	DSP
	EX	DE,HL
	EX	(SP),HL
	EX	DE,HL
	INC	C
	JR	NZ,DEC1
	POP	DE
	LD	A,20H
	JP	DSP
DECTAB	DW	-10000
	DW	-1000
	DW	-100
	DW	-10
	DW	-1
DSP	CP	9
	JR	Z,DTAB
	AND	7FH		;strip bit 7
DSP1	LD	(DE),A
	INC	DE
	PUSH	DE		;check for end of line
	PUSH	HL
	EX	DE,HL
	LD	DE,-SCRNB	;subtract beginning
	ADD	HL,DE		;of screen buffer
	LD	DE,50H
	XOR	A
	SBC	HL,DE
	JR	NC,$-2
	ADD	HL,DE		;HL = position in line
	LD	A,H
	OR	L		;zero if end of line
	POP	HL
	POP	DE
	RET
DTAB	LD	A,20H
	CALL	DSP1
	RET	Z
	LD	A,E		;tab to positions
	ADD	A,2		;(8 - 2) + 8 * N
	AND	7
	JR	NZ,DTAB
	LD	A,D
	OR	E
	RET
READ1	PUSH	DE
	LD	DE,FCB1
	LD	(IX+10),A	;position next record number
RD1	SVC	@READ
	POP	DE
	RET
READ2	PUSH	DE
	LD	DE,FCB2
	LD	(IY+10),A
	JR	RD1
GET	LD	A,D		;if DE < 3000 must be file 1
	CP	30H
	JR	NC,GET2
GET1	LD	HL,2600H	;current buffer position
BPOS1	EQU	$-2
	LD	A,(HL)
	INC	L
	LD	(BPOS1),HL	;update position
	JR	NZ,GETRN+1
	PUSH	AF		;if L is 00 need next sector
	LD	A,(IX+10)
	CALL	READ1		;read next sector
	JR	GETRN
GET2	LD	HL,2700H
BPOS2	EQU	$-2
	LD	A,(HL)
	INC	L
	LD	(BPOS2),HL
	JR	NZ,GETRN+1
	PUSH	AF
	LD	A,(IY+10)
	CALL	READ2
GETRN	POP	AF		;recover input byte
	CP	1AH		;default end of file for EDAS
EOFM	EQU	$-1		;change to 00 if BASIC
	JP	Z,EXIT		;or as desired by EOF parameter
	RET
BACK1	LD	HL,(BPOS1)
	DEC	L
	LD	(BPOS1),HL	;decrease buffer position
	LD	A,L		;when L goes from 00 to FF
	INC	A		;must get prior sector
	JR	NZ,BK11
	LD	A,(IX+10)
	DEC	A		;must decrease by 2
	DEC	A		;to get prior sector
	CALL	READ1
BK11	LD	A,(HL)		;get prior byte
	RET
BACK2	LD	HL,(BPOS2)
	DEC	L
	LD	(BPOS2),HL
	LD	A,L
	INC	A
	JR	NZ,BK21
	LD	A,(IY+10)
	DEC	A
	DEC	A
	CALL	READ2
BK21	LD	A,(HL)
	RET
START	XOR	A
	CALL	READ1		;read first sector
	LD	A,(2600H)	;checking bit 7 of
	RLCA			;first byte
	CCF
	SBC	A,A
	LD	(NQ1),A		;A = 0 if EDAS line numbered
	JR	NZ,STR1		;else A = FF
	LD	A,'#'		;'#' indicates line
	LD	(SCRNB+0),A	;numbers from file
STR1	XOR	A
	CALL	READ2
	LD	A,(2700H)	;check file 2
	RLCA
	CCF
	SBC	A,A
	LD	(NQ2),A
	JR	NZ,BASIC
	LD	A,'#'
	LD	(SCRNB+3C0H),A
BASIC	LD	BC,0
	LD	A,B
	OR	C
	JR	Z,EOF
	XOR	A		;supress line numbering
	LD	(NQ1),A
	LD	(NQ2),A
	LD	(COMP+1),A
	LD	(EOFM),A	;end of file is 00
EOF	LD	BC,-1
	LD	A,C		;if both BASIC and EOF are given
	INC	C		;the value of EOF wil override
	JR	Z,DSCRN		;the default value of
	LD	(EOFM),A	;EOFM is 1AH or 26 decimal
	JR	DSCRN		;provide 80 byte buffer
	ORG	START+50H	;for comment line
DSCRN	JR	$+2		;provide for jump to GETKS
	LD	B,5		;during auto reverse
	LD	HL,SCRNB
	SVC	@VDCTL		;display screen buffer
	LD	B,3
	LD	HL,0C1BH	;position blinking cursor
	SVC	@VDCTL		;in middle of screen
	LD	BC,820H		;make sure cursor
	SVC	@VDCTL		;character is 20h
SWCH	JR	GETKS		;allow jump over compare routine
;for single file commands (ADV1, ADV2, REV1, & REV2)
;set SWCH+1 = 00 so compare is done for
;NEXT, COMNT, & line prints (LN1 & LN2)
COMP	LD	B,6		;00 if BASIC parameter is used
	LD	A,B
	LD	DE,SCRNB+320H	;DE => last line of file 1
	ADD	A,E
	LD	E,A
	LD	A,B
	LD	HL,SCRNB+6E0H	;HL => last line of file 2
	ADD	A,L
	LD	L,A
	LD	A,80		;80 characters per line
	SUB	B		;don't compare EDAS line numbers
	LD	B,A
CLP	LD	A,(DE)
	CP	(HL)
	JR	NZ,DIF
	INC	HL
	INC	DE
	DJNZ	CLP
	LD	A,20H		;simulate <SPACE BAR>
SSWCH	JR	GETKS		;jump to GETKS+3 if SCAN is ON
DIF	LD	BC,82AH		;change cursor to '*'
	SVC	@VDCTL
	SVC	@KEY
	CP	20H
	JR	Z,DIF
	PUSH	AF		;save this keystroke
	LD	BC,820H		;change cursor to blank
	SVC	@VDCTL
	POP	AF		;recover keystroke
	JR	$+5
GETKS	CALL	KEY		;nedd a call instead of an SVC here
	LD	HL,TABL		;for AUTO to work
	LD	B,12
SRCH	CP	(HL)
	INC	HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)		;DE => command entry
	INC	HL
	JR	Z,FOUND		;jump if right
	DJNZ	SRCH
	JR	GETKS		;key pressed was no4t a command
FOUND	LD	HL,SWCH+1
	LD	(HL),0		;do compare if command is first 5
	LD	A,B		;NEXT, SCAN, LN1, LN2, COMNT
	CP	6		;jump over compare for last 4
	JR	NC,$+4		;ADV1, ADV2, REV1, REV2
	LD	(HL),GETKS-SWCH-2
	LD	HL,DSCRN
	PUSH	HL		;return address
	PUSH	DE		;command address
	RET
KEY	SVC	@KEY
	RET
TABL	DB	20H
	DW	NEXT
	DB	'S'
	DW	SCAN
	DB	's'
	DW	SCAN
	DB	'1'
	DW	LN1
	DB	'2'
	DW	LN2
	DB	'C'
	DW	COMNT
	DB	'c'
	DW	COMNT
	DB	80H
	DW	EXIT
	DB	0BH		;up arrow
	DW	ADV1
	DB	0AH		;down arrow
	DW	ADV2
	DB	08BH		;clear-up arrow
	DW	REV1
	DB	8AH		;clear-down arrow
	DW	REV2
SCAN	LD	HL,SSWCH+1
	LD	A,GETKS-SSWCH-2	;jump to GETKS
	LD	C,20H		;to blank out "S"
	CP	(HL)		;compare to current value
	JR	NZ,SCAN1	;and toggle to the other
	LD	A,GETKS-SSWCH+1	;jump to GETKS+3
;avoid the keyboard input at GETKS and force auto NEXT
	LD	C,'S'
SCAN1	LD	(HL),A		;alter jump as SSWCH
	LD	HL,SCRNB+3F0H
	LD	(HL),C		;put "S" or blank on screen
	RET
NEXT	LD	B,0AFH		;if A is non-zero both files
ADV1	EQU	$-1		;will advance
	PUSH	AF
	LD	DE,SCRNB+0A0H	;scroll 8 lines
	LD	HL,SCRNB+0F0H
	LD	BC,280H
	LDIR			;DE = SCRNB + 320h = beginning of line 9
	CALL	GET		;this makes LDLN loop easier
	EX	AF,AF'		;save first byte
	LD	A,0
NQ1	EQU	$-1
	OR	A		;generate line numbers from
	CALL	NZ,LNUMB1	;100 by 10's
	CALL	LDLN		;load and display one line
	LD	HL,0
LNCNT1	EQU	$-2		;real line counter
	INC	HL
	LD	(LNCNT1),HL
	LD	DE,SCRNB+20H
	CALL	DECNUM
	POP	AF
	OR	A
	RET	Z		;return if command was ADV1
ADV2	LD	DE,SCRNB+460H
	LD	HL,SCRNB+4B0H
	LD	BC,280H
	LDIR			;DE = SCRNB + 6E0h = beginning of line 9
	CALL	GET
	EX	AF,AF'
	LD	A,0
NQ2	EQU	$-1
	OR	A
	CALL	NZ,LNUMB2
	CALL	LDLN
	LD	HL,0
LNCNT2	EQU	$-2
	INC	HL
	LD	(LNCNT2),HL
	LD	DE,SCRNB+3E0H
	CALL	DECNUM
	RET
LDLN	EX	AF,AF'		;recover first byte
	CP	0DH		;check for empty line
	JR	Z,LDLN2
LDLN1	CALL	DSP
	JR	Z,WASTE		;Z if more than 80 characters
	CALL	GET
	CP	0DH		;end of line
	JR	Z,ERAS
	JR	LDLN1
LDLN2	LD	A,88H		;block graphic character
	LD	(DE),A
	INC	DE
ERAS	LD	A,20H		;erase to end of line
	CALL	DSP
	RET	Z
	JR	ERAS
WASTE	CALL	GET		;just read to next 0Dh
	CP	0DH
	JR	NZ,WASTE
	RET
LNUMB1	LD	BC,10		;generate EDAS type line
	LD	HL,90
LNMB1	EQU	$-2
	ADD	HL,BC
	LD	(LNMB1),HL
	JP	DECNUM
LNUMB2	LD	BC,10
	LD	HL,90
LNMB2	EQU	$-2
	ADD	HL,BC
	LD	(LNMB2),HL
	JP	DECNUM
REV1	CALL	BACK1		;go back one byte (0Dh)
	LD	B,10		;go back 10 lines
RV11	CALL	BACK1
	CP	0DH		;look for end of line
	JR	NZ,RV11
	LD	HL,(LNCNT1)
	DEC	HL		;decrease real line number
	LD	(LNCNT1),HL
	LD	DE,-10
	LD	HL,(LNMB1)	;decrease generated
	ADD	HL,DE		;line number
	LD	(LNMB1),HL
	DJNZ	RV11		;loop for 10 lines
	CALL	GET1		;get into forward gear again
	LD	A,0BH		;keystroke for ADV1
	JR	APREP
REV2	CALL	BACK2
	LD	B,10
RV21	CALL	BACK2
	CP	0DH
	JR	NZ,RV21
	LD	HL,(LNCNT2)
	DEC	HL
	LD	(LNCNT2),HL
	LD	DE,-10
	LD	HL,(LNMB2)
	ADD	HL,DE
	LD	(LNMB2),HL
	DJNZ	RV21
	CALL	GET2
	LD	A,0AH		;keystroke for ADV2
APREP	LD	HL,AUTO
	LD	(HL),9		;advance 9 lines
	INC	HL
	LD	(GETKS+1),HL	;call AUTO instead of KEY
	INC	HL
	LD	(HL),A		;pass proper keystroke to AUTO
	LD	HL,DSCRN+1	;jump over display
	LD	(HL),GETKS-DSCRN-2	;to keep screen from
RET				;flashing while lines are read
AUTO	DB	0		;counter
	LD	A,0		;contains key for ADV1 or ADV2
	LD	HL,AUTO
	DEC	(HL)		;decrease count
	JR	Z,DUN
	RET
DUN	LD	HL,KEY		;replace call to key
	LD	(GETKS+1),HL
	XOR	A
	LD	HL,DSCRN+1	;remove jump
	LD	(HL),A
	LD	A,(AUTO+2)	;advance last of 9 lines
	RET
CBKS	LD	B,4
	PUSH	HL
	SVC	@VDCTL		;get current cursor position
	LD	A,L		;look at column
	POP	HL
	OR	A		;don't backspace
	JR	Z,CINPT		;past beginning of line
	LD	C,8
	SVC	@DSP
	DEC	HL
	JR	CINPT
COMNT	LD	B,3
	LD	HL,1700H	;move cursor to beginning
	SVC	@VDCTL		;of line 23
	LD	BC,85FH		;and change it to
	SVC	@VDCTL		;underscore
	LD	HL,START
	PUSH	HL		;save for @PRINT
	LD	B,4FH		;79 characters
CINPT	SVC	@KEY
	CP	8
	JR	Z,CBKS
	CP	0DH
	JR	Z,CDUN
	CP	20H		;ASCII range
	JR	C,CINPT
	CP	80H
	JR	NC,CINPT
	LD	(HL),A
	INC	HL
	LD	C,A
	SVC	@DSP
	DJNZ	CINPT
CTRM	SVC	@KEY		;80th character must be 0Dh
	CP	0DH
	JR	NZ,CTRM
CDUN	LD	(HL),A		;an 0Dh
	POP	HL		;recover START
	SVC	@PRINT		;send line to printer
	RET
LN1	LD	HL,SCRNB+320H	;beginning of last line of file 1
	JR	$+5
LN2	LD	HL,SCRNB+6E0H	;beginning of last line of file 2
	PUSH	HL		;save for second @PRINT
	LD	DE,50H
	ADD	HL,DE		;get end of line
LSRCH	DEC	HL
	LD	A,(HL)
	CP	20H		;ignore all trailing spaces
	JR	Z,LSRCH
	INC	HL
	LD	(HL),0DH	;mark end of line with 0Dh
	EX	(SP),HL		;save the spot to stack
	PUSH	HL		;replace beginning spot
	LD	A,H
	CP	2FH
	LD	HL,TWO
	JR	NZ,$+5		;NZ means it was 32h and want TWO
	LD	HL,ONE
	SVC	@PRINT		;print file id message
	POP	HL		;recover beginning of line
	SVC	@PRINT		;print line
	POP	HL		;recover end spot and
	LD	(HL),20H	;remove the 0Dh
	RET			;before screen display
ONE	DB	'File 1:  ',3
TWO	DB	'File 2:  ',3
BOT	EQU	$
	ORG	2C00H
SCRNB	DB	20H
MSGFS1	EQU	SCRNB+2		;where to put filespecs
MSGFS2	EQU	SCRNB+3C2H	;on screen display
	END	ENTRY
