;option   bit 0, 1=block cls codes             0=block cls codes
;         bit 1, 1=output on                   0=output off
;         bit 2, 1=upper & lower               0=upper case only
;         bit 3, 1=CR only                     0=CR/LF
;         bit 4, 1=enable control messages     0=control messages off
;         bit 5, 1=enable control messages     0=control messages off
;         bit 6, 1=
;         bit 7, 1=
;status   bit 0, control command follows (1=control command follows)
;         bit 1, control value follows (1=follows, first byte)
;         bit 2, control character follows (1=follows, second byte)
;         bit 3, pause switch (1=in pause mode)
;         bit 4,
;         bit 5, carrier detect status bit (0=carrier on)
;         bit 6, cls block bit (second character)
;         bit 7
;rsstat   rs232 control register status (default=6FH)
;ctlval   control key value (new value)
;ihead    input buffer head
;itail    input buffer tail
;ohead    output buffer head
;otail    output buffer tail
;inpbuf   input buffer (256 bytes)
;outbuf   output buffer (2048 bytes)
;ctltbl   control key table
;
;
DELAY:	EQU	10800
USTAT:	EQU	0EAH
UCTRL:	EQU	0EAH
URSET:	EQU	0E8H
MSTAT:	EQU	0E8H
UDATA:	EQU	0EBH
UBAUD:	EQU	0E9H
INTENB:	EQU	0E0H
BR300:	EQU	55H
BR1200:	EQU	77H
BR2400:	EQU	0AAH
VIDCTL:	EQU	84H
FLAGS:	EQU	65H
HIGH:	EQU	64H
DSPLY:	EQU	0AH
;BBS/DVR  - bulletin board system communications driver
	ORG	3000H
INIT:	PUSH	DE
	POP	IX
	LD	(DCBPTR),DE
	LD	HL,CPYRHT
	PUSH	DE
	LD	A,DSPLY
	RST	28H
	POP	DE
	LD	A,FLAGS
	RST	28H
	BIT	3,(IY+2)
	JP	Z,MSG1
	BIT	0,(IY+2)
	JP	NZ,MSG2
	LD	HL,0
	LD	B,L
	LD	A,HIGH
	RST	28H
	LD	DE,0FFFFH
	XOR	A
	SBC	HL,DE
	JP	C,MSG2
	LD	HL,MAIN-1
	LD	A,HIGH
	LD	B,0
	RST	28H
	INC	HL
	LD	(IX+1),L
	LD	(IX+2),H
;
	LD	A,FLAGS
	RST	28H
	LD	A,(IY+28)
	LD	(ICNFG),A
	LD	L,(IY+29)
	LD	H,(IY+30)
	LD	(ICNFG+1),HL
	LD	HL,PWRUP
	LD	(IY+29),L
	LD	(IY+30),H
	LD	A,0C3H
	LD	(IY+28),A
	LD	BC,14
	ADD	IY,BC
	LD	(IX+00H),07H
	LD	(RETINT+1),IY
	LD	(FLAG1+1),IY
;
	LD	HL,(0038H+1)
	LD	(CONTIN+1),HL
	LD	A,(0038H)
	LD	(CONTIN),A
	LD	A,0C3H
	LD	HL,INTRPT
	DI
	LD	(0038H),A
	LD	(0038H+1),HL
	EI
	LD	A,FLAGS
	RST	28H
	LD	A,(IY+22)
	OR	20H
	LD	(IY+22),A
	OUT	(INTENB),A
;
;
	LD	A,01H
	OUT	(URSET),A
	LD	A,(RSSTAT)
	OUT	(UCTRL),A
	LD	A,BR300
	OUT	(UBAUD),A
;
	LD	HL,0000H
	RET
;
MSG2:	LD	HL,MEMMSG
	JR	MSG
MSG1:	LD	HL,SETMSG
MSG:	LD	A,DSPLY
	RST	28H
	LD	HL,0FFFFH
	RET
MEMMSG:	DEFM	'High memory not available, re-boot and try again.'
	DEFB	0DH
SETMSG:	DEFM	'This program must be installed using SET.'
	DEFB	0DH
CPYRHT:	DEFM	'BBS/DVR - Billboard Communications Driver now being installed.'
	DEFB	0DH
;
	ORG	0F300H
MAIN:	JR	PSTDCB
	DEFW	0FFFFH
	DEFB	DCBPTR-MAIN-5
	DEFM	'$BBS'
DCBPTR:	DEFW	0000H
	DEFW	0000H
PSTDCB:	JP	MAIN1
;
RETINT:	LD	A,(0000H)
	OUT	(VIDCTL),A
	POP	HL
	POP	BC
	POP	AF
	EI
	RETI
INTRPT:	PUSH	AF
	PUSH	BC
	PUSH	HL
FLAG1:	LD	A,(0000H)
	AND	8CH
	OR	03H
	OUT	(VIDCTL),A
	IN	A,(USTAT)
	RLA
	JR	NC,OUTCAR
	LD	HL,DELAY
	LD	(COUNTR),HL
	LD	HL,STATUS
	IN	A,(UDATA)
	CP	13H
	JR	NZ,TSTPAU
RESPAU:	LD	A,(HL)
	XOR	08H
	LD	(HL),A
	JP	CONINT
TSTPAU:	BIT	3,(HL)
	JR	NZ,RESPAU
	OR	A
	JR	Z,PUTCAR
	CP	0DH
	JR	Z,OFLUSH
	LD	HL,OPTION
	BIT	5,(HL)
	JR	Z,PUTCAR
	CP	1BH
	JR	NC,PUTCAR
	CP	08H
	JR	C,CONVRT
	CP	0BH
	JR	C,PUTCAR
	CP	18H
	JR	Z,PUTCAR
CONVRT:	ADD	A,'@'
	LD	(CTLLET),A
	LD	BC,CTLMSG
	JP	DMPSTR
CTLMSG:	DEFB	0DH
	DEFB	'!'
CTLLET:	DEFB	'A'
	DEFW	000DH
OFLUSH:	LD	HL,(OHEAD)
	LD	(OTAIL),HL
PUTCAR:	LD	HL,OPTION
	BIT	2,(HL)
	JR	NZ,GETBUF
	CP	'a'
	JR	C,GETBUF
	CP	7BH
	JR	NC,GETBUF
	SUB	20H
GETBUF:	LD	HL,(IHEAD)
	LD	(HL),A
	INC	L
	LD	A,(ITAIL)
	CP	L
	JR	NZ,WRIHED
	LD	A,(ITAIL+1)
	CP	H
	JP	Z,RETINT
WRIHED:	LD	(IHEAD),HL
	JP	RETINT
OUTCAR:	IN	A,(USTAT)
	AND	40H
	JR	Z,TESTCD
	LD	HL,(OTAIL)
	LD	A,(OHEAD)
	CP	L
	JR	NZ,OUTBYT
	LD	A,(OHEAD+1)
	CP	H
	JR	Z,TESTCD
OUTBYT:	LD	A,(HL)
	CP	13H
	LD	A,(STATUS)
	JR	NZ,OUTDAT
	OR	08H
	LD	(STATUS),A
	JR	SKPOUT
OUTDAT:	AND	08H
	JR	NZ,TESTCD
	LD	A,(HL)
	OUT	(UDATA),A
SKPOUT:	INC	HL
	LD	A,H
	OR	0F8H
	LD	H,A
	LD	(OTAIL),HL
CONINT:	POP	HL
	POP	BC
	POP	AF
CONTIN:	JP	0000H
TESTCD:	LD	A,(OPTION)
	AND	10H
	JP	Z,TIMER
	LD	HL,STATUS
	IN	A,(MSTAT)
	XOR	(HL)
	AND	20H
	JP	Z,TIMER
	AND	(HL)
	JR	NZ,DSPCON
	SET	5,(HL)
	LD	BC,CARSTR
DMPSTR:	LD	HL,(IHEAD)
	LD	(ITAIL),HL
DMPCAR:	LD	A,(BC)
	INC	BC
	LD	(HL),A
	INC	L
	OR	A
	JR	NZ,DMPCAR
	DEC	L
	LD	(IHEAD),HL
	JR	CONINT
DSPCON:	RES	5,(HL)
	LD	BC,CONSTR
	JR	DMPSTR
CONSTR:	DEFB	0DH
	DEFM	'Now connected to user.'
	DEFW	000DH
CARSTR:	DEFB	0DH
	DEFM	'Carrier signal terminated.'
	DEFW	000DH
TIMSTR:	DEFB	0DH
	DEFM	'Your time has run out. . .Logging off. . .'
	DEFW	000DH
TIMER:	IN	A,(MSTAT)
	AND	20H
	JR	NZ,CLRTIM
	LD	HL,COUNTR
	DEC	(HL)
	JP	NZ,CONINT
	INC	HL
	DEC	(HL)
	JP	NZ,CONINT
	LD	HL,3600
	LD	(COUNTR),HL
	LD	HL,STATUS
	RES	3,(HL)
	LD	BC,TIMSTR
	JP	DMPSTR
CLRTIM:	LD	HL,DELAY
	LD	(COUNTR),HL
	JP	CONINT
;
PWRUP:	LD	HL,(0038H+1)
	LD	(CONTIN+1),HL
	LD	A,(0038H)
	LD	(CONTIN),A
	LD	A,0C3H
	LD	HL,INTRPT
	DI
	LD	(0038H),A
	LD	(0038H+1),HL
	EI
	LD	A,FLAGS
	RST	28H
	LD	A,(IY+22)
	OR	20H
	LD	(IY+22),A
	OUT	(INTENB),A
;
	LD	A,01H
	OUT	(URSET),A
	LD	A,(RSSTAT)
	OUT	(UCTRL),A
	LD	A,(BR300)
	OUT	(UBAUD),A
ICNFG:	JP	0000H
MAIN1:	JP	C,INPUT
OUTPUT:	LD	A,C
	LD	HL,STATUS
	BIT	1,(HL)
	JR	NZ,CTLDAT
	BIT	2,(HL)
	JR	NZ,CTLCAR
	BIT	0,(HL)
	JP	NZ,CTLCMD
	BIT	6,(HL)
	JR	Z,MAIN2
	RES	6,(HL)
	CP	1FH
	JP	Z,OUTRET
	LD	A,1CH
	CALL	SAVCAR
MAIN2:	LD	A,(CTLTBL)
	CP	C
	JR	NZ,TSTCAR
	SET	0,(HL)
	RES	1,(HL)
	RES	2,(HL)
	JP	OUTRET
CTLDAT:	SUB	'@'
	JP	C,OUTRET
	CP	20H
	JP	NC,OUTRET
	LD	(CTLVAL),A
	RES	1,(HL)
	SET	2,(HL)
	JR	OUTRET
CTLCAR:	RES	2,(HL)
	SUB	'@'
	JR	C,OUTRET
	JR	Z,OUTRET
	CP	20H
	JR	NC,OUTRET
	LD	HL,CTLTBL
NXTCTL:	DEC	A
	JR	Z,SETCTL
	INC	HL
	JR	NXTCTL
SETCTL:	LD	A,(CTLVAL)
	LD	(HL),A
	JR	OUTRET
TSTCAR:	LD	HL,OPTION
	BIT	1,(HL)
	JR	Z,OUTRET
	LD	A,C
	OR	A
	JR	Z,SAVCAR
	CP	20H
	JR	C,TSTCTL
	BIT	2,(HL)
	JR	NZ,SAVCAR
	CP	'a'
	JR	C,SAVCAR
	CP	7BH
	JR	NC,SAVCAR
	SUB	20H
	JR	SAVCAR
TSTCTL:	CP	0DH
	JR	NZ,CTLIND
	BIT	3,(HL)
	JR	NZ,CTLIND
	CALL	SAVCAR
	LD	A,0AH
CTLIND:	LD	HL,CTLTBL
CTLNXT:	DEC	A
	JR	Z,GETCTL
	INC	HL
	JR	CTLNXT
GETCTL:	LD	A,(HL)
	OR	A
	JR	Z,OUTRET
	CP	1CH
	JR	NZ,SAVCAR
	LD	HL,OPTION
	BIT	0,(HL)
	JR	Z,SAVCAR
	LD	HL,STATUS
	SET	6,(HL)
	JR	OUTRET
SAVCAR:	LD	HL,(OHEAD)
	LD	(HL),A
	INC	HL
	LD	A,H
	OR	0F8H
	LD	H,A
BUFFUL:	LD	A,(OTAIL)
	CP	L
	JR	NZ,BUFEMP
	LD	A,(OTAIL+1)
	CP	H
	JR	Z,BUFFUL
BUFEMP:	LD	(OHEAD),HL
OUTRET:	LD	A,C
	CP	A
	RET
SETURT:	LD	A,(HL)
	OUT	(UCTRL),A
	JR	OUTRET
;
CTLCMD:	CP	0DH
	JR	NZ,BAUD3
	RES	0,(HL)
	JR	OUTRET
BAUD3:	SUB	'A'
	JR	C,OUTRET
	JR	NZ,BAUD12
	LD	A,BR300
	OUT	(UBAUD),A
	JR	OUTRET
BAUD12:	DEC	A
	JR	NZ,BAUD24
	LD	A,BR1200
	OUT	(UCTRL),A
	JR	OUTRET
BAUD24:	DEC	A
	JR	NZ,CTLCNG
	LD	A,BR2400
	OUT	(UCTRL),A
	JR	OUTRET
CTLCNG:	DEC	A
	JR	NZ,FPAUSE
	SET	1,(HL)
	JR	OUTRET
FPAUSE:	DEC	A
	JR	NZ,FLUSHI
	RES	3,(HL)
	JR	OUTRET
FLUSHI:	DEC	A
	JR	NZ,FLUSHO
	LD	HL,(IHEAD)
	LD	(ITAIL),HL
	JR	OUTRET
FLUSHO:	DEC	A
	JR	NZ,BLKCLS
	LD	HL,(OHEAD)
	LD	(OTAIL),HL
	LD	HL,STATUS
	RES	3,(HL)
	JR	OUTRET
BLKCLS:	LD	HL,OPTION
	DEC	A
	JR	NZ,UNBCLS
	SET	0,(HL)
	JR	OUTRET
UNBCLS:	DEC	A
	JR	NZ,OUTON
	RES	0,(HL)
	JR	OUTRET
OUTON:	DEC	A
	JR	NZ,OUTOFF
	SET	1,(HL)
	JR	OUTRET
OUTOFF:	DEC	A
	JR	NZ,CRONLY
	RES	1,(HL)
	JR	OUTRET
CRONLY:	DEC	A
	JR	NZ,CRLF
	SET	3,(HL)
	JR	OUTRET
CRLF:	DEC	A
	JR	NZ,ENBRNG
	RES	3,(HL)
	JP	OUTRET
ENBRNG:	DEC	A
	JR	NZ,DISRNG
	SET	4,(HL)
	JP	OUTRET
DISRNG:	DEC	A
	JR	NZ,ENBCTL
	RES	4,(HL)
	JP	OUTRET
ENBCTL:	DEC	A
	JR	NZ,DISCTL
	SET	5,(HL)
	JP	OUTRET
DISCTL:	DEC	A
	JR	NZ,UPONLY
	RES	5,(HL)
	JP	OUTRET
UPONLY:	DEC	A
	JR	NZ,UPLOWR
	RES	2,(HL)
	JP	OUTRET
UPLOWR:	DEC	A
	JR	NZ,DTRON
	SET	2,(HL)
	JP	OUTRET
DTRON:	LD	HL,RSSTAT
	DEC	A
	JR	NZ,DTROFF
	RES	1,(HL)
	RES	0,(HL)
	JP	SETURT
DTROFF:	DEC	A
	JR	NZ,WORD7
	SET	1,(HL)
	SET	0,(HL)
	JP	SETURT
WORD7:	DEC	A
	JR	NZ,WORD8
	RES	6,(HL)
	SET	5,(HL)
	JP	SETURT
WORD8:	DEC	A
	JR	NZ,STOP1
	SET	6,(HL)
	SET	5,(HL)
	JP	SETURT
STOP1:	DEC	A
	JR	NZ,STOP2
	RES	4,(HL)
	JP	SETURT
STOP2:	DEC	A
	JR	NZ,RESET
	SET	4,(HL)
	JP	SETURT
RESET:	DEC	A
	JP	NZ,OUTRET
	LD	(OPTION),A
	INC	A
	OUT	(URSET),A
	LD	(CTLTBL),A
	LD	A,(21H)
	LD	(STATUS),A
	LD	HL,INPBUF
	LD	(IHEAD),HL
	LD	(ITAIL),HL
	LD	HL,OUTBUF
	LD	(OHEAD),HL
	LD	(OTAIL),HL
	LD	A,BR300
	OUT	(UBAUD),A
	LD	A,0EFH
	LD	HL,RSSTAT
	LD	(HL),A
	JP	SETURT
INPUT:	LD	HL,(ITAIL)
	LD	A,(IHEAD)
	CP	L
	JR	NZ,INPCAR
	LD	A,(IHEAD+1)
	CP	H
	JR	Z,INPDON
INPCAR:	LD	A,(HL)
	INC	L
	CP	A
	RET
INPDON:	OR	1
	LD	A,0
	RET
;----------------- control key table -----------------
CTLTBL:	DEFB	1
	DEFB	02H
	DEFB	03H
	DEFB	04H
	DEFB	05H
	DEFB	06H
	DEFB	07H
	DEFB	08H
	DEFB	09H
	DEFB	0AH
	DEFB	0BH
	DEFB	0CH
	DEFB	0DH
	DEFB	0EH
	DEFB	0FH
	DEFB	10H
	DEFB	11H
	DEFB	12H
	DEFB	13H
	DEFB	14H
	DEFB	15H
	DEFB	16H
	DEFB	17H
	DEFB	18H
	DEFB	19H
	DEFB	1AH
	DEFB	1BH
	DEFB	1CH
	DEFB	1DH
	DEFB	1EH
	DEFB	1FH
RSSTAT:	DEFB	0EFH
CTLVAL:	DEFB	00H
OPTION:	DEFB	00H
STATUS:	DEFB	20H
COUNTR:	DEFW	DELAY
OHEAD:	DEFW	OUTBUF
OTAIL:	DEFW	OUTBUF
IHEAD:	DEFW	INPBUF
ITAIL:	DEFW	INPBUF
;
	ORG	0F700H
INPBUF:	DEFS	256
OUTBUF:	DEFS	0800H
;
	END	INIT
