/*	autoplot.h	*/

/*
 *	Author:		J.F.R. "Frank" Slinkman
 *				1511 Old Compton Road
 *				Richmond, VA  23233
 *		Copyright (c)1995.  All Rights Reserved!
 *	Compiler:	Pro-MC
 *	Libraries:	Slinkman Hi-Res Graphics library for Pro-MC
 *	Last Revision:	4 March 1995
 */

/*	This program the "line" as the smallest unit with which to build geometric
 *	objects.  The start and the end of each line are each defined by three
 *	coordinates:
 *
 *		"X" is the horizontal direction, with "right" positive.
 *		"Y" is the vertical direction, with "up" positive.
 *		"Z" is the direction which comes straight out of the screen, with
 *			"out" (toward the viewer) positive.
 */

#define	LINES	struct _line
#define POINTS	struct _point

/*	The members of struct _line and struct _point are signed chars, a data
 *	type not supported by Pro-MC.  Because only the low 8 bits of an int are
 *	used when converting an int to a char, no special code is needed to
 *	convert TO this type, but the value must be checked to make sure it's in
 *	the range -128 to +127.  This puts an absolute limit of 256 on both the
 *	height and width of COMBINATIONS of objects on one "plot."
 */

#define	uchr	char

LINES	{	uchr	x_beg;
			uchr	y_beg;
			uchr	z_beg;
			uchr	x_end;
			uchr	y_end;
			uchr	z_end;	};

POINTS	{	uchr	x;
			uchr	y;
			uchr	z;		};
