 	TITLE 	'<ASYNC TIMER TASK>'
	OPTION	NC,NE,WE,XR
; +---------------------------------------------------------------------------+
; |                                                                           |
; |     AA            SSSSSS        Y     Y       N      N                    |
; |    A  A          S      S        Y   Y        NN     N                    |
; |   A    A        S        S        Y Y         N N    N                    |
; |  A      A        SSSS              Y          N  N   N                    |
; |  AAAAAAAA            SSSS          Y          N   N  N      ======        |
; |  A      A       S        S         Y          N    N N                    |
; |  A      A        S      S          Y          N     NN                    |
; |  A      A         SSSSSS           Y          N      N                    |
; |                                                                           |
; |                                                                           |
; |                                                                           |
; |  TTTTTTTTTTT           AA               SSSSSS           K    K           |
; |       T               A  A             S      S          K   K            |
; |       T              A    A           S        S         K  K             |
; |       T             A      A           SSSS              KKK              |
; |       T             AAAAAAAA               SSSS          K  K             |
; |       T             A      A          S        S         K   K            |
; |       T             A      A           S      S          K    K           |
; |       T             A      A            SSSSSS           K     K          |
; |									      |
; +---------------------------------------------------------------------------+
; | Copyright (c) 1986  Scott Russell, All rights reserved		      |
; +---------------------------------------------------------------------------+
	SUBTTL	'<System Equates and Macros>'
*LIST OFF
_HIGH	EQU	0FFH
_ZERO	EQU	00H
_CR	EQU	0DH
_PARMER	EQU	2CH
$SVCTAB$ EQU	1AH
;			SVC EQUATES
@LOGER	EQU	0BH
@LOGOT	EQU	0CH
@TIME	EQU	13H
@EXIT	EQU	16H
@CKTSK	EQU	1CH
@ADTSK	EQU	1DH
@RMTSK	EQU	1EH
@HEX8	EQU	62H
@HEX16	EQU	63H
@HIGH$	EQU	64H
@FLAGS	EQU	65H
@TPOST	EQU	7FH

;			MACROS
SVC	MACRO	#REQ
	LD	A,#REQ		;LOAD SVC REQUEST
	RST	28H		;GO DO SVC
	ENDM
CPR	MACRO	#REGPAIR
	PUSH	HL
	XOR	A
	SBC	HL,#REGPAIR
	POP	HL
	ENDM
DT	MACRO	#DATA		;DEFINE #DATA WITH A ONE BYTE LENGTH TAG
	DB	%#DATA-2	;LENGTH OF PARAM MINUS THE QUOTES
	DB	#DATA
	ENDM
SAVE	MACRO	#RP1,#RP2,#RP3,#RP4,#RP5,#RP6
	IFLT	%%,1
	ERR	'SAVE macro must specify register pair(s) !'
	ENDIF
	PUSH	#RP1
	IFLT	%%,2
	EXITM
	ENDIF
	PUSH	#RP2
	IFLT	%%,3
	EXITM
	ENDIF
	PUSH	#RP3
	IFLT	%%,4
	EXITM
	ENDIF
	PUSH	#RP4
	IFLT	%%,5
	EXITM
	ENDIF
	PUSH	#RP5
	IFLT	%%,6
	EXITM
	ENDIF
	PUSH	#RP6
	ENDM
REST	MACRO	#RP1,#RP2,#RP3,#RP4,#RP5,#RP6
	IFLT	%%,1
	ERR	'REST macro must specify register pair(s) !'
	ENDIF
	POP 	#RP1
	IFLT	%%,2
	EXITM
	ENDIF
	POP 	#RP2
	IFLT	%%,3
	EXITM
	ENDIF
	POP 	#RP3
	IFLT	%%,4
	EXITM
	ENDIF
	POP	#RP4
	IFLT	%%,5
	EXITM
	ENDIF
	POP	#RP5
	IFLT	%%,6
	EXITM
	ENDIF
	POP	#RP6
	ENDM
*LIST ON
	ENTRY	ASYNTIME
       	CSEG
ASYNTIME
	JR	LETSDOIT
	DB	'Async Timer Task - Copyright (c) 1986 Scott Russell '
	DB	'CompuServe ID 76576,520 '
	DATE
	TIME
LETSDOIT
	LD	HL,DUMMY		;DUMMY TIME BUFFER
	SVC	@TIME			;GO GET TIME AND TIME POINTER
	LD	(SECPNTR),DE		;STASH IT INTO TIMER TASK
	SVC	@FLAGS			;GET FLAGS POINTER WE NEED SYSTEM INFO
	LD	HL,_ZERO		;GET HIGH$ POINTER
	LD	B,L
	SVC	@HIGH$
	LD	(TENDPTR),HL		;SAVE HIGH$ IN STANDARD HEADER
	LD	IX,RELTAB		;CHANGE RELOCATED ADDRESSES
	LD	DE,TIMEND-1		;CALC OFFSET OF
	XOR	A			;   LOAD AND RUN
	SBC	HL,DE			;   POINT
	PUSH	HL			;MOVE LENGTH TO BC
	POP	BC
RELOOP
	LD	L,(IX+0)		;GET NEXT RELO BYTE
	LD	H,(IX+1)
	LD	A,H			;END OF RELO TABLE ?
	OR	L
	JR	Z,DONEREL		;...YES, LEAVE LOOP
	LD	E,(HL)			;PICK UP @ TO RELO
	INC	HL
	LD	D,(HL)
	EX	DE,HL			;FLIP-FLOP RELO @ + TABLE -=>
	ADD	HL,BC			;ADD IN OFFSET
	EX	DE,HL			;FLIP-FLOP BACK
	LD	(HL),D			;STASH NEW @
	DEC	HL
	LD	(HL),E
	INC	IX			;BUMP TO IN RELO @
	INC	IX
	JR	RELOOP			;LOOP BACK
DONEREL
	LD	DE,(TENDPTR)		;-=> TO MOVE TO @
	LD	HL,TIMEND-1		;-=> TO END OF TASK
	LD	BC,TIMEND-TSTART	;LENGTH OF MOVE
	LDDR				;AND MOVE IT...BACK-ASS-WARDS
	EX	DE,HL			;AND NEW HIGH$
	SVC	@HIGH$			;SET IT
	INC	HL			;-=> TO SVC CODE
	LD	DE,MSG5CT1		;-=> TO MSG BUFFER
	EX	DE,HL
	SVC	@HEX16			;CONVERT INTO BUFFER
	LD	H,(IY+$SVCTAB$)		;INSTALL MY SVC FOR POSTING TIMERS
	LD	L,@TPOST*2		;I NEED SVC 127 FOR @TPOST (MINE)
	LD	(OSVC7FA),HL		;SAVE SVC 127 POINTER
RX1   	EQU	$-2
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	(OSVC7FV),DE		;SAVE SVC 127 VECTOR
RX2 	EQU	$-2
	LD	DE,(SVCVB) 		;POINT TO MY 127 SVC - @TPOST
RX3 	EQU	$-2
	LD	(HL),D			;...AND INSTALL INTO SVC TABLE
	DEC	HL
	LD	(HL),E			;SVC 127 NOW INSTALLED
	LD	HL,2600H		;NOW CHECK TO SEE IF WE CAN USE IT OR
	XOR	A			;                           RESTORE IT
	LD	DE,(OSVC7FV)
RX4	EQU	$-2
	SBC	HL,DE
	LD	HL,INTMSG2		;ASS-U-ME WE'LL HAVE AN ERROR
	JP	C,ABORT			;ANOTHER USER PROG HAS IT...ABORT
	LD	HL,INTMSG1		;POINT TO SUCCESSFUL MESSAGE
	SVC	@LOGER			;LOGIT
	LD	HL,TASKNUM		;SET AREAS FOR SELTASK
RX5	EQU	$-2
	LD	DE,TASKTCB
RX6 	EQU	$-2
	CALL	SELTASK			;START TASK
	LD	HL,INTMSG3		;-=> TO ERROR MSG JUST IN CASE
	JP	NZ,ABORT 		;ERROR IN STARTING TASK
	LD	A,(TASKNUM)		;GET TASK SELECTED
RX7 	EQU	$-2
	LD	C,A
	LD	HL,MSG4CNT		;-=> TO 2 BYTE BUFFER
	SVC	@HEX8			;CONVERT FOR DISPLAY
	LD	HL,INTMSG4		;DISPLAY SUCCESS MESSAGE
	SVC	@LOGER			;LOG IT
	LD	DE,TASKTCB		;-=> TO TIMER TCB
RX8	EQU	$-2
	LD	HL,MSG5CT2
	SVC	@HEX16
	LD	HL,INTMSG5
	SVC	@LOGER			;DISPLAY LOCATION INFO
	SVC	@EXIT			;TASK RELOCATED AND STARTED...OK TO END
	SUBTTL	'<Subroutines>'
; +---------------------------------------------------------------------------+
; | HL-=>TASK NUMBER SAVE AREA, DE-=>TASK CONTROL BLOCK                       |
; +---------------------------------------------------------------------------+
SELTASK
	LD	C,_HIGH			;SET TO START WITH TASK 0
TSKSEL
	INC	C			;TRY NEXT SLOT
	LD	A,C
	CP	0CH			;GREATER THEN SLOT 11
	JR	Z,SELERR		;...YES, RETURN WITH 'NZ'
	PUSH	HL			;SAVE TASK NUMBER SAVE AREA POINTER
	SVC	@CKTSK			;IS TASK SLOT IN USE ?
	POP	HL			;...RESTORE BUFFER POINTER
	JR	NZ,TSKSEL		;...YES, TRY ANOTHER
	LD	(HL),C			;SAVE TASK NUMBER FOR EXIT
	SVC	@ADTSK			;START ASYNC TASK - DE ALREADY SET
	XOR	A			;SET OK RET
	RET
SELERR
	OR	01H			;FORCE 'NZ' CONDITION
	RET
	SUBTTL	'<Install Quiesce>'
ABORT
	SVC	@LOGOT			;DISPLAY AND LOG ERROR
	LD	HL,_ZERO		;QUIESEC TIMER TASK
	SVC	@TPOST
	LD	L,_PARMER		;FORCE NON-ZERO ERROR
	LD	H,_ZERO
	CALL	RESTSVC			;RESTORE OLD SVC VECTOR
	SVC	@EXIT
	SUBTTL  '<Relocation Table>'
RELTAB
	IRP	Y,<1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17>
	DW	RXY
	ENDM
	DEFW	_ZERO			;END OF RELOCATION TABLE
INTMSG1 DB	'SVC 127 installed !',_CR
INTMSG2 DB	'SVC 127 in use...can not install timer !',_CR
INTMSG3	DB	'Can''t find task slot open for timer !',_CR
INTMSG4	DB	'Timer task selected and started...active in task slot: xx !'
MSG4CNT	EQU	$-4			;POINT BACK TO 'XX'
	DB	_CR
INTMSG5	DB	'SVC 127 @ X''xxxx'''
MSG5CT1 EQU	$-5
	DB	' - Timer TCB @ x''XXXX'''
MSG5CT2	EQU	$-5
	DB	_CR
DUMMY	DS	8			;DUMMY TIME BUFFER
	SUBTTL	'<SVC 127 Entry Point>'
; +---------------------------------------------------------------------------+
; |    									      |
; | TSTART is SVC 127'S entry point.  SVC 127 post values into STATSK'S timer |
; | table for him to use to time events. When the timer is elasped it XOR'S   |
; | the value saved into the address saved.                                   |
; |      							              |
; |   Upon entry from the @TPOST (127) SVC:				      |
; |								              |
; |     REG  B = seconds for timer to wait                                    |
; | 									      |
; |     REG  C = value to use for XOR of addr at timer elapse                 |
; |                            or                                             |
; |              zero will cause ASYNTASK to drive HL as async user exit      |
; |              							      |
; |     REG HL = addr for XOR at timer elapse                                 |
; |                            or					      |
; |              addr of async user exit to drive at timer elapse	      |
; |									      |
; |   A 'Z' condition code means that the timer was posted, A 'NZ' code       |
; | means that the timer tabel is full.  The caller can try later.            |
; |								              |
; +---------------------------------------------------------------------------+
TSTART
	JR	TIMEPOST
TENDPTR	DW	$-$
	DT	'$TIMER'
SVCVB	DW	TSTART				;USE DEC AS VECTOR BLOCK
RX9	EQU	$-2
     	DW	00H
TIMEPOST
	SAVE    BC,DE,HL,IY			;SAVE CALLERS REGISTERS
	LD	A,H				;CALL FOR QUIESCE ?
	OR	L
	JR	Z,KILLTASK			;...YES, GO KILL US
	LD	IX,TIMETBL-LTABENTRY		;ADDRESS TIMER TABLE
RX10	EQU	$-2
	PUSH	BC				;SAVE XOR DATA
	PUSH	DE				;SAVE COUNT
	EX	DE,HL				;PUT ADDRESS IN DE
	LD	BC,4				;SET UP TABLE INCREMENT
TPLOP						;SEE IF ALREADY TIMEING
	ADD	IX,BC
	LD	L,(IX+TABCNT1)			;SLOT IN USE ?
	LD	H,(IX+TABCNT2)
	LD	A,H
	AND	L
	INC	A				;FF->00 (END OF TABLE) ?
	JR	Z,ADDIT				;...YES, OK TO TRY ADD
	LD	A,H
	OR      L    				;0 (NOT USED) ?
	JR	Z,TPLOP				;...YES, LOOK AT NEXT
	LD	L,(IX+TABADR1)
	LD	H,(IX+TABADR2)
	CPR	DE				;IS THIS THE SAME TIMER ?
	JR	NZ,TPLOP			;...NO, TRY NEXT
	POP	DE				;RESET COUNTER
	POP	BC				;RESET TIMER
	LD	(IX+TABCNT1),E
	LD	(IX+TABCNT2),D
	LD	(IX+TABXOR),B
	JR	SVCRET				;GO RESTORE AND RETURN
ADDIT
	EX	DE,HL				;MOVE XOR ADDR BACK TO HL
	LD	IX,TIMETBL-LTABENTRY
RX11	EQU	$-2
	LD	DE,LTABENTRY
TPLOOP
	ADD	IX,DE				;POINT TO NEXT ENTRY
	LD	C,(IX+TABCNT1)			;SLOT IN USE ?
	LD	B,(IX+TABCNT2)
	LD	A,B
	AND	C
	INC	A				;FF->00 (END OF TABLE) ?
	JR	Z,ERRET				;...YES, OK TO TRY ADD
	LD	A,B
	OR      C    				;0 (NOT USED) ?
	JR	NZ,TPLOOP			;...YES, SLOT IN USE
	POP	DE
	POP	BC
	LD	(IX+TABXOR),C			;SAVE XOR VALUE
	LD	(IX+TABADR1),L			;SAVE XOR ADDRESS
	LD	(IX+TABADR2),H
	LD	(IX+TABCNT1),E			;SAVE TIMER COUNT
	LD	(IX+TABCNT2),D
SVCRET
	XOR	A				;SET 'Z' RETURN CODE
SVCRET2
	REST    IY,HL,DE,BC			;RESTORE CALLERS REGISTERS
	RET					;RETURN FROM SVC
ERRET
	POP	DE				;MAINTAIN STACK
	POP	BC
	LD	A,01H				;MAKE 'NZ'
	JR	SVCRET2
	SUBTTL	'<Timer Task Quiesce>'
KILLTASK
	LD	C,$-$			;GET TIMERS TASK NUMBER
TASKNUM	EQU	$-1
	SVC	@RMTSK			;AND REMOVE IT
RESTSVC
	LD	HL,$-$			;PICK UP OLD 127 SVC VECTOR
OSVC7FV	EQU	$-2
	LD	($-$),HL		;STASH IT
OSVC7FA	EQU	$-2
	LD	HL,_ZERO
	LD	B,_ZERO
	SVC	@HIGH$			;SEE IF WE CAN RECLAIM MEMORY
	LD	DE,TSTART-1		;DID HIGH$ CHANGE SINCE WE CHANGED IT
RX12	EQU	$-2
	XOR	A
	SBC	HL,DE
	JR	NZ,SVCRET		;IT'S CHANGED WE CAN'T RECLAIM
	LD	HL,TIMEND-1		;OK TO RECLAIM
RX13	EQU	$-2
	LD	B,_ZERO
	SVC	@HIGH$
  	JR	SVCRET			;GO RETURN
	SUBTTL	'<Task Data Areas>'
TASKTCB	DW	TIMER
RX14	EQU	$-2
OLDSEC	DB 	_ZERO			;FORCE NOT = FIRST TIME
; +---------------------------------------------------------------------------+
; |                                                                           |
; |    Timer Table layout:                                                    |
; |       1               2               3               4           5       |
; | +--------------+--------------+--------------+--------------+-----------+ |
; | |         Timer Count         |  XOR Value   |           XOR Address    | |
; | +--------------+--------------+--------------+--------------+-----------+ |
; |                                                                           |
; |  "Timer count" contains time to count from @TPOST SVC.  At timer elapse   |
; |  the "XOR value" is XOR'd with the data at "XOR Address".                 |
; |                                                                           |
; +---------------------------------------------------------------------------+
; | IX offset equates for timer table					      |
; +---------------------------------------------------------------------------+
TABCNT1	EQU	00H				;LSB of Timer count
TABCNT2	EQU	01H				;MSB of Timer count
TABXOR	EQU	02H				;XOR byte
TABADR1 EQU	03H				;LSB of XOR Address
TABADR2	EQU	04H				;MSB of XOR Address
LTABENTRY EQU	05H				;LENGTH OF TABLE ENTRY

TIMETBL
	DC  	LTABENTRY*5,00H			;5 TABLE ENTRIES
	DC  	2,_HIGH				;END OF TABLE MARKER
TIMER
	LD	HL,($-$)			;$TIME -> (SET FROM @TIME INIT)
SECPNTR	EQU  	$-2
	LD	C,(HL)
	LD	A,(OLDSEC)  			;GET OLD SECOND
RX15	EQU	$-2
	SUB	C				;HAS IT CHANGED ?
	RET	Z				;...NO, RETURN
	LD	A,C
	LD	(OLDSEC),A			;SAVE NEW SECOND
RX16	EQU	$-2
	LD 	IX,TIMETBL-LTABENTRY		;ADDRESS TIMER TABLE - 1 ENTRY
RX17	EQU	$-2
	LD	DE,LTABENTRY			;SET UP TABLE INCREMENT
TIMELOP
	ADD	IX,DE				;BUMP UP TABLE
	LD	C,(IX+TABCNT1)			;CHECK ON SLOT
	LD	B,(IX+TABCNT2)
	LD	A,B
	AND	C
	INC 	A				;FF->00 (END OF TABLE) ?
	RET	Z				;...YES, RETURN FROM TASK
	LD 	A,B				;0 (SLOT NOT USED) ?
	OR	C
	JR	Z,TIMELOP			;...YES, LOOK AT NEXT
	DEC	BC				;DECREMENT COUNTER
	LD	(IX+TABCNT1),C			;SAVE IT
	LD	(IX+TABCNT2),B
	LD	A,B
	OR	C
	JR	NZ,TIMELOP			;TIMER NOT ELASPED...DO NEXT
	LD	L,(IX+TABADR1)			;GET XOR/EXIT ADDRESS
	LD	H,(IX+TABADR2)
	LD	(IX+TABADR1),C			;ZERO OUT ADDRESS
	LD	(IX+TABADR2),C
	LD	A,(IX+TABXOR)			;GET XOR VALUE/EXIT INDICATOR
	OR	A				;DO THEY WANT TO DRIVE EXIT ?
	JR	Z,DRIVEXIT
	LD	C,(HL)
	XOR	C
	LD	(HL),A
	JR	TIMELOP				;GO CHECK NEXT
DRIVEXIT
	PUSH	IX				;SAVE IX IN CASE OF EXIT USE
	CALL	EXEXIT				;EXECUTE EXIT DRIVE
	POP	IX				;RETURN FROM EXIT RESTORE IX
	LD	DE,LTABENTRY			;RELOAD TABLE INDEX
	JR	TIMELOP				;CHECK OTHER ENTRIES
EXEXIT
	JP	(HL)				;DRIVE EXIT
TIMEND
LASYNTASK EQU	$-ASYNTIME			;LENGTH OF MODULE
	END	ASYNTIME
R