	TITLE	<RXGEN/CMD>
*GET	EQUATE63/ASM
;
	ORG	3000H
START	LD	HL,HELLO$		; greet world
	SVC	@DSPLY
	SVC	@FLAGS			; get flags pointer
	LD	A,(IY+'N'-'A')		; get NFLAG
	LD	(NFLAG+3),A		; save for exit
	SET	0,(IY+'N'-'A')		; flag file-open bit
	LD	A,(IY+27)		; get DOS version
	CP	63H			; gotta be LSDOS 6.3
	JP	C,DOSERR		; because of @HEXD call
	LD	HL,INPUT1$		; request source file
	LD	DE,FCB1			; to fcb
	CALL	INPUT
	LD	HL,BUFF1		; open source file
	LD	B,0
	SVC	@OPEN
	JP	NZ,ERROR
	LD	HL,INPUT2$		; request dest file
	LD	DE,FCB2			; to fcb
	CALL	INPUT
	LD	HL,BUFF2		; open dest file
	LD	B,0
	SVC	@INIT
	JP	NZ,ERROR
	JR	C,RUN
	LD	HL,EXISTS$		; warn dest file exists!
	SVC	@DSPLY
	SVC	@KEY			; await response
	RES	5,A			; insure u/c
	CP	'Y'			; use anyway?
	JR	NZ,BREAK
RUN	LD	HL,RUN$			; tell user we're running
	SVC	@DSPLY
	JR	READ			; start reading source
;
WRITE	CALL	PUT			; send byte to file
READ	LD	DE,FCB1			; read a byte
	SVC	@GET
	JR	NZ,EOF			; go if done
	CP	CR			; carriage return?
	JR	NZ,WRITE		; output either way
	CALL	PUT
	SVC	@GET			; get following byte
	JR	NZ,EOF
	CP	'#'			; got flag?
	JR	NZ,WRITE		; nope, loop next
	LD	HL,MSG1$		; send 'RXxx' instead
	CALL	BUMP			; bump the ascii value
	LD	(TOTAL+1),A		; save current total
	LD	DE,FCB2
	SVC	@MSG
	JR	READ			; continue
;
EOF	CP	28			; should find EOF error
	JR	NZ,ERROR		; anything else is wrong
	LD	HL,MSG2$		; set up message 2
TOTAL	LD	B,$-$			; p/u total RX count
TABLE	PUSH	BC			; save counter
	PUSH	HL			; save msg pointer
	CALL	BUMP			; bump the ascii msg
	LD	B,5			; 5 chars to send
TLOOP	LD	A,(HL)			; get char
	INC	HL			; bump pointer
	CALL	PUT			; output to file
	DJNZ	TLOOP			; do all five
	POP	HL			; recover msg pointer
	POP	BC			; recover counter
	DJNZ	TABLE			; loop till done
	LD	HL,DONE$		; dsply finish msg
	DB	0DDH
DOSERR	LD	HL,DOSERR$
	DB	0DDH
BREAK	LD	HL,BREAK$
	DB	0DDH
EXCEED	LD	HL,EXCEED$
	SVC	@DSPLY
	LD	HL,0			; flag no error
RETURN	LD	DE,FCB1			; close source
	CALL	CLOSE
	LD	DE,FCB2			; close destination
	CALL	CLOSE
NFLAG	LD	(IY+'N'-'A'),$-$	; restore NFLAG
	SVC	@EXIT			; fix stack, exit to DOS
;
ERROR	LD	H,0			; error into HL
	LD	L,A
	OR	0C0H			; set up error call
	LD	C,A
	SVC	@ERROR			; dsply error
	JR	RETURN			; abort to DOS
;
INPUT	PUSH	HL			; save prompt
	PUSH	DE			; save fcb pointer
	SVC	@DSPLY			; dsply prompt
	POP	HL			; use fcb for buffer
	LD	BC,24.SHL.8.OR.0	; get filespec
	SVC	@KEYIN
	JR	C,BREAK
	PUSH	HL			; fcb into DE
	POP	DE
	SVC	@FSPEC			; move spec to fcb
	POP	HL			; recover prompt
	JR	NZ,INPUT		; retry on failure
	LD	HL,ASM$			; append default extension
	SVC	@FEXT
	RET
;
PUT	PUSH	DE			; save source pointer
	LD	DE,FCB2			; output to dest
	LD	C,A
	SVC	@PUT
	POP	DE			; recover source
	JR	NZ,ERROR
	RET
;
;	HL points to MSG$
BUMP	PUSH	HL
	POP	IX
	LD	A,(IX+2)		; get 10's column
	SUB	'0'			; make binary
	LD	C,A			; mult x 10
	LD	E,10
	SVC	@MUL8			; C x E = A
	LD	C,A			; stuff 10's column to C
	LD	A,(IX+3)		; get 1's column
	SUB	'0'			; make binary
	ADD	A,C			; add 1's + 10's columns
	INC	A			; bump total value
MAX	CP	100			; past max value?
	JR	Z,EXCEED
	PUSH	AF			; save value
	LD	E,A			; divide by 10
	LD	C,10
	SVC	@DIV8			; E/C=A, remainder=E
	ADD	A,'0'			; make ASCII
	LD	(IX+2),A		; stuff new 10's column
	LD	A,E			; get remainder
	ADD	A,'0'			; make ASCII
	LD	(IX+3),A		; stuff new 1's column
	POP	AF			; recover count
	RET
;
CLOSE	EX	DE,HL
	BIT	7,(HL)
	EX	DE,HL
	RET	Z
	SVC	@CLOSE
	RET
;
;
HELLO$	DB	28,31,'RXGEN/CMD - Source File RX Generator - Version 1.0',LF
	DB	'(c) 1989 RAH Enterprises, Somerville, MA 02143',LF,CR
DOSERR$	DB	'Must run under LS-DOS 6.3 or later!',CR
INPUT1$	DB	'Source file?      ',3
INPUT2$	DB	'Destination file? ',3
EXISTS$	DB	LF,'Destination file already exists.  Use anyway (y/n)? ',3
RUN$	DB	LF,'Converting, please wait... ',3
EXCEED$	DB	LF,LF,'RX values exceeded 99, program terminated.',CR
DONE$	DB	LF,LF,'File successfully converted.',CR
BREAK$	DB	LF,LF,'Program aborted at user request.',CR
ASM$	DB	'ASM'
MSG1$	DB	'RX00',9,'EQU',9,'$-2',CR
MSG2$	DB	'RX00,'
KEYBUF	DS	24
FCB1	DS	32
FCB2	DS	32
BUFF1	DS	256
BUFF2	DS	256
	END	START
