	ORG 3000H
	TITLE	'<S242 project>'
START:
	LD HL,GREETING;Display Initial greeting message
	LD A,10;@DSPLY
	RST 28H;Go system
	LD HL,MESSAGE;'Enter algebraic...'
	LD B,40;40 characters max to be entered
	LD C,0;Has to be zero, since system insists on this
	LD A,9;@KEYIN
	RST 28H;Go system
	JR C,STARTEND;Carry flag set if <BREAK> pressed
	CALL CREATE;Go create
	JR Z,STL1;Ah ! No errors
	;Error string already loaded by routine that set NZ flag
	LD A,10;@DSPLY
	RST 28H;Go system
	JR START;Go and get another expression
STL1:
	CALL DOIT;Evaluate STACK, or, print a message if an error occurs
	JR START;Go and get another expression
STARTEND:
	LD A,22;@EXIT
	RST 28H;Back to system
GREETING:DB 10,'Algebraic to Reverse Polish Translator & Interpreter',10,10
	DB 'Enter an Algebric Expression, or <BREAK> to stop : ',3
BADTOK:DB 'Bad character(s) discovered in expression',10,13
BADNUM:DB 'Bad number has been entered',10,13
MESSAGE:DS 70
TEXTPR:DW 0;Pointer into MESSAGE


	SUBTTL	CREATE module. Creates STACK from entered expression


CREATE:;Creates a STACK which is taken from text @HL
	LD (TEXTPR),HL;Save address of text for NEXT_TOKEN
	LD HL,REVHH;Set REV stack up so that the 1st element is a dummy
	LD (REVSTA),HL
	LD HL,STACK;Set up STACK
	LD (STASTA),HL
CRL1:
	CALL NEXT_TOKEN
	RET NZ;Bad token/number discovered, set up for error routine
CRL2:
	LD A,(NEXTK);Get NEXT_TOKEN type
	CP 1;Is it a number ?
	JR NZ,CRL3;If not...
	CALL R1CRNK;Go and put it onto the STACK
	JR CRL1;Go get next token
CRL3:
	CP 2;Is it an operator ?
	JR NZ,CRL4;no...
	CALL R2CREA;See routine description !
	JR NZ,CRL6;If error has occurred
	JR CRL1;Go and get another token
CRL4:;If it is not an operator or a number
	; we must be at the end of the text string
	LD IY,(REVSTA);Get current address of REV stack
	LD A,(IY-1);Get symbol associated with top element
	CP '(';If it is one of these, the entered formula is incorrect
	JR Z,CRL6;Go and set up for error routine
	CP '&';Have all the operators been destacked?
	JR Z,CRL5;Yeap!
	CALL RMRVST;No, destack another one to STACK
	JR CRL4;Go and remove another if possible
CRL5:
	CALL R1CRNK;Finally 'seal' STACK with an end of formula token
	XOR A;Set Z flag for successful completion
	RET ; Go back to caller
CRL6:
	LD HL,BADEXP;Bad expression
CRL7:
	XOR A
	CP 1;Set NZ flag
	RET ; Go back to caller, unsuccessful


	PAGE


R1CRNK:;Copies direct from NEXTK to STACK
	LD HL,NEXTK
	JR R1CRL0
R1CREA:;COPIES FROM @HL TO STACK
R1CRL0:
	PUSH DE;Save DE & BC
	PUSH BC
	LD B,5;Five bytes to move
	LD DE,(STASTA);Get address of first free byte in STACK
R1CRL1:
	LD A,(HL);Get byte from NEXTK
	LD (DE),A;Put it on STACK
	INC HL
	INC DE
	DJNZ R1CRL1;Decrement B and Jump if B is Not Equal to Zero
	LD (STASTA),DE;Save updated value for STACK
	POP BC;Restore DE & BC
	POP DE
	RET


	PAGE


R2CREA:;This routine looks after operator placing
	LD A,(IX+0);GET SYMBOL
	CP ')';Check for end of a clause
	JR NZ,R2L3;if not...
R2L1:
	LD DE,(REVSTA)
	DEC DE
	LD A,(DE);Get symbol of operator on top of REV stack
	CP '&';Check if opening bracket missed - error if it is
	JR Z,R2L6;Go and signal error
	CP '('
	JR Z,R2L2;Good !,Unstack this operator token, 'cos there are no more
	; operators inside this clause
	CALL RMRVST;Remove an operator from REV stack to STACK
	JR R2L1;Do another
R2L2:
	DEC DE;Ignore '(' entry in REV stack
	DEC DE
	DEC DE
	DEC DE
	LD (REVSTA),DE;Update REV stack pointer
	JR R2L5;Go to end of routine
R2L3:
	LD IY,(REVSTA)
	LD A,(IY-1)
	CP '&';Check if there are no operator tokens on REV
	JR Z,R2L4;There are none...
	CP '(';Check if we have come to beginning of clause
	JR Z,R2L4;If so...
	LD E,(IY-3)
	LD D,(IY-2)
	PUSH DE
	POP IY
	LD A,(IY+1)
	CP (IX+2)
	JR C,R2L4
	CALL RMRVST
	JR R2L3;Try and do another !
R2L4:
	CALL R3CRNK;Now move token @NEXTK to REV stack
R2L5:
	XOR A;Set flags for successful routine
	RET
R2L6:;If beginning of REV stack if encountered early
	CP 1;Set flags for unsuccessful routine
	RET


	PAGE


R3CRNK:;This routine is like R1CRNK except that it copies to REV stack
	;Copies direct from NEXTK to REV stack
	PUSH BC
	LD HL,NEXTK
R3CREA:
	LD B,5
	LD DE,(REVSTA);Get first free byte in REV stack
R3CRL1:;Copy NEXTK to it
	LD A,(HL)
	LD (DE),A
	INC HL
	INC DE
	DJNZ R3CRL1
	LD (REVSTA),DE;Then update REV stack pointer
	POP BC
	RET


	PAGE


NORMHL:;This doesn't normalize a number, it gets the address of the
	; subroutine to execute a arithmetic function from the address of an
	; entry in SYMTAB
	PUSH IY;Save registers
	PUSH IX
	PUSH DE
	PUSH HL
	POP IY
	LD E,(IY+2);Get address of entry in SYMTAB
	LD D,(IY+3)
	PUSH DE
	POP IX
	LD A,(IX+4);Get LSB of address of Arithmetic subroutine
	LD (IY+2),A;And place in location of Operator token
	LD A,(IX+5);Do same for MSB
	LD (IY+3),A
	POP DE;Restore registers
	POP IX
	POP IY
	RET


	PAGE


RMRVST:;Removes top entry in REV stack and places it on STACK,
	; after calling NORMHL
	PUSH HL
	PUSH BC
	LD BC,5
	LD HL,(REVSTA);Get first free entry in REV stack
	OR A
	SBC HL,BC;Backup 5 bytes
	POP BC
	LD (REVSTA),HL;And save new value
RML1:
	CALL NORMHL;Normalise entry
	CALL R1CREA; & add it to STACK
	POP HL
	RET


	SPACE 3


RMNTST:;Removes operator token at NEXTK and places it on STACK,
	; after calling NORMHL
	PUSH HL
	LD HL,NEXTK;READY TO GO...
	JR RML1


	SUBTTL	NEXT_TOKEN module. Gets next token from within entered expression


NEXT_TOKEN:;This gets the next token & places it in NEXTK
	; The Data Structure for NEXTK is :-
	; Byte 0 :Token code. 1 for numbers, 2 for operators, & 3 for End of Text
	;          For Numbers          For Operators
	; Byte 1 :LSB of number         1 for Monadic,2 for Dyadic operator
	; Byte 2 :NLSB of number        LSB of entry in SYMTAB
	; Byte 3 :NLSB of number        MSB of entry in SYMTAB
	; Byte 4 :MSB of number         Symbol of operator
	LD HL,(TEXTPR);Get pointer to text
NXL0:
	LD A,(HL)
	CP 0
	JR Z,NXL0A
	CP 32
	JR NZ,NXL1
NXL0A:;Get past spaces and 0's
	INC HL
	JR NXL0
NXL1:;Check for numbers
	CP '0'
	JR C,NXL2
	CP '9'+1
	JR NC,NXL2
	CALL NUMBER
	JR Z,NXL4;If a good number is found
	RET
NXL2:
	CP 3
	JR Z,NXL
	CP 13
	JR NZ,NXL3
NXL:;If end of line found..
	LD HL,NEXTK
	LD (HL),3;Signal end of stack
	JR NXL4
NXL3:
	CALL OPERAT;Go and search for this operator
	RET NZ; Return early if error
NXL4:
	XOR A;Signal good return
	LD (TEXTPR),HL;Save pointer into message
	RET
NEXTK:DB 0,0,0,0,0


	PAGE


OPERAT:
	PUSH DE;Save registers
	PUSH BC
	INC HL;Get past 1st character in text, ready for return from routine
	PUSH HL;Save pointer into MESSAGE
	CALL SEARCH;Go search SYMTAB for operator in A
	JR Z,OPL1;Nope, A does not contain an operator
	POP HL;Discard pointer into MESSAGE
	LD HL,BADTOK
	JR OPL2
OPL1:
	PUSH HL;Save address in SYMTAB of operator
	LD HL,NEXTK
	LD (HL),2;Signal that token is an operator
	INC HL
	POP DE
	PUSH DE
	POP IX
	LD A,(IX+3);Get Monadic/Dyadic indicator
	LD (HL),A; and save in NEXTK
	INC HL;Copy across address of entry in SYMTAB
	LD (HL),E
	INC HL
	LD (HL),D
	INC HL;Now copy across the operator's symbol
	LD A,(IX+0)
	LD (HL),A
	XOR A;Signal good return
	POP HL
OPL2:
	POP BC
	POP DE
	RET


	PAGE


NUMBER:
	PUSH DE
	PUSH BC
	CALL TENSTR;Initiate ACCUM1 for number
NUL1:
	INC HL;Advance to next character in MESSAGE
	LD A,(HL);Check if it is a numeral
	CP ' '
	JR Z,NUL1
	CP '0'
	JR C,NUM2;It isn't
	CP '9'+1
	JR NC,NUM2;Nope, it's not
	CALL TENADD;'Add' digit to number
	JR Z,NUL1;Go look for another digit
	LD HL,BADNUM
	JR NUM3
NUM2:
	PUSH HL;Save 'cos calling routine wants HL at correct place
	LD HL,NEXTK
	LD (HL),1;Signal number
	INC HL
	EX DE,HL
	CALL CPA1DE;Copy number built up in ACCUM1 into NEXTK
	XOR A;Signal good return
	POP HL;Restore registers
NUM3:
	POP BC
	POP DE
	RET


	PAGE


SEARCH:;Goes thru' SYMTAB searching for a symbol (In A). NZ unsuccesful
	PUSH DE
	PUSH BC
	LD HL,SYMTAB;Start of SYMbol TABle for operators
	LD B,A;Save character we are searching for
SEL1:
	LD A,(HL)
	OR A
	JR Z,SEL2;Bad exit, no symbol found...
	CP B;Is symbol @HL same as ours
	JR Z,SEL3;Yes, so, symbol found
	INC HL;Advance to next symbol
	INC HL
	INC HL
	INC HL
	INC HL
	INC HL
	JR SEL1;Test next symbol
SEL2:
	XOR A;Signal symbol not found in SYMTAB
	CP 1
SEL3:
	POP BC;Restore registers
	POP DE
	RET
SYMTAB:
	;The data structure for SYMTAB is as follows :-
	; Byte  0   : Symbol for routine
	; Byte  1   : In stack priority
	; Byte  2   : In text priority
	; Byte  3   : 1 for Monadic operator, 2 if Dyadic
	; Bytes 4-5 : Address of arithmetic routine
	DB '(',0,9,0
	DW 0
	DB '!',8,7,1
	DW FACTOR
	DB '^',5,6,2
	DW EXPON
	DB '*',4,3,2
	DW MUA1A2
	DB '/',4,3,2
	DW DIVIDE
	DB '+',2,1,2
	DW ADA1A2
	DB '-',2,1,2
	DW SUA1A2
	DB ')',99,0,0
	DW 0
	DB 0


	PAGE


TENSTR:;Character in A initiates number
	PUSH HL;Save HL register
	PUSH AF;Save character during initial processing
	LD HL,ACCUM1;Clear ACCUM1
	CALL CLHL
	POP AF;Get character
	SUB '0'; & convert it into a number
	LD (ACCUM1),A;Save in LSB of ACCUM1
	POP HL;Restore HL register
	RET


	SPACE 3


TENADD:;Takes character in A & adds it to ACCUM1 after multiplying ACCUM1 by 10
	PUSH HL;Save registers
	PUSH DE
	PUSH BC
	PUSH AF;Save character during initial processing
	LD HL,TEMP2;Clear TEMP2
	CALL CLHL
	LD HL,TEN;TEN is found in the powers of ten table
	CALL CPHLA2;Move to ACCUM2
	POP AF;Restore
	SUB '0';Change character into number
	LD (TEMP2),A;Load into LSB of TEMP2
	CALL MUA1A2;Multiply ACCUM1 by 10
	JR NZ,TENL1
	LD DE,TEMP2
	CALL ADA1DE;Add TEMP2 to ACCUM1
	JR NZ,TENL1
	;Good return already signalled
TENL1:
	POP BC;Restore registers
	POP DE
	POP HL
	RET


	SUBTTL	Runtime module. Interprets STACK to produce an answer


	;Runtime Section of the program follows


	SPACE 3


DOIT:;This part of the program interprets the Reverse Polish string in STACK
	CALL CLACC1;Clear ACCUM1, &
	CALL CLACC2; ACCUM2
	XOR A;Zero A
	LD (OVERFLAG),A;Signal no overflow
	LD (STACNT),A;No. of elements on stack
	;The data structure for the RUN time stack is quite simple, as it is only
	; used to contain numbers. Each entry in it is 4 bytes long as a result
	LD HL,RUNACK;RUN time stack start point
	LD (RUNSTA),HL
	;The data structure for the STACK is like that of the REV stack, except that
	; it instead of containing the address of a symbols entry in SYMTAB, it
	; contains the address of the subroutine associated with the symbol
	LD HL,STACK;Start of Reverse Polish tokens
	PUSH HL;Save this
	JR DOITL1;No update 1st time around
DOITL0:
	POP HL;Get pointer into STACK
	LD BC,5
	ADD HL,BC;Update it, &
	PUSH HL;Save it
DOITL1:
	LD A,(HL);Get first byte of token
	INC HL;Increment pointer
	CP 1;Is it a number
	JR Z,DOITL3;yes
	CP 2;Is it an operator
	JR Z,DOITL4;yes
DOITL2:;Must be the end
	POP HL;Unstack pointer to RUN time stack
	CALL OUTSTA;Display Reverse Polish Stack
	LD HL,RECANS;'Interpreted Reverse Polish...'
	LD A,10;@DSPLY
	RST 28H;Call system
	LD A,0
OVERFLAG:EQU $-1;Signals if an overlow has taken place
	OR A
	LD HL,OVERTEXT;'Overflow..'
	JR NZ,DOERR1;Go and display it
	LD HL,RUNACK;Copy top element of Stack to ACCUM1 for printing
	CALL CPHLA1
	CALL DISPA1;Display ACCUM1
	LD HL,CRCR;Two carriage returns
DOERR1:;Display message @HL
	LD A,10;@DSPLY
	RST 28H;Call the system
	RET
DOITL3:;Adds a number to the RUN time stack
	LD DE,(RUNSTA);Get 1st free byte in RUN time stack
	CALL CPHLDE;CoPy @HL to @DE
	LD HL,4
	ADD HL,DE;Increment pointer of RUN time stack to next free byte
	LD (RUNSTA),HL;And save it
	LD A,(STACNT);Increment number of entries on RUN time stack
	INC A
	LD (STACNT),A
	JR DOITL0;Get another entry from STACK
DOITL4:;Operator
	CALL DESKA2;Get top element of RUN time stack and place in ACCUM2
	JR NZ,DOITL8;If there is no element...
DOITL5:
	LD A,(HL)
	CP 2;Is operator monadic or dyadic
	JR NZ,DOITL6;If Monadic
	CALL DESKA1;If dyadic, get another element of the RUN time stack
	JR NZ,DOITL8;But, if there is no element
	JR DOITM6;skip code for monadic operators
DOITL6:
	PUSH HL
	CALL CPA2A1;If monadic, copy ACCUM2 into ACCUM1
	POP HL
DOITM6:;Get address of arithmetic subroutine
	INC HL
	LD A,(HL);Get LSB of subroutine
	INC HL
	LD H,(HL);Get MSB of subroutine
	LD L,A
	PUSH HL;Push onto stack
	LD HL,DOITL7;Label to return to
	EX (SP),HL;Swop with current top of stack
	PUSH HL;Then push this onto stack
;Stack looks like this :-
;Top of stack (Next element to come off) :- Address of arithmetic subroutine
;                                           DOITL7
	RET ; Return to arithmetic subroutine
DOITL7:
	CALL RESKA1;Store result back onto RUN time stack
	JR Z,DOITL0;Go interrogate another token
	JR DOITL2;Unless an error has occured..
DOITL8:
	POP HL;Remove pointer into STACK
	LD HL,BADEXP
	JR DOERR1;Go display message & return to calling routine
BADEXP:DB 'A bad algebraic expression has been entered',10,13
RECANS:DB 'Evaluated Reverse Polish is : ',3
CRCR:DB 10,13
OVERTEXT:DB 'Overflow',10,13


	PAGE


DESKA1:;Gets entry at top of RUN time stack and puts it in ACCUM1
	PUSH DE
	LD DE,ACCUM1
	JR DESK
DESKA2:;Gets entry at top of RUN time stack and puts it in ACCUM2
	PUSH DE
	LD DE,ACCUM2
DESK:
	LD A,(STACNT);Is there an entry on the RUN time stack
	OR A
	JR NZ,DESKL1;If so...
	CP 1;Otherwise set NZ flag
	POP DE
	RET ; Return unsuccessful
DESKL1:
	DEC A;Decrement # entries in stack
	LD (STACNT),A;And save this value
	PUSH HL
	PUSH BC
	LD BC,4
	LD HL,(RUNSTA);Get old start of RUN time stack
	OR A
	SBC HL,BC;Decrement it by 4
	LD (RUNSTA),HL;And save it
	CALL CPHLDE;Copy 4 bytes over from RUN time stack to @DE
	POP BC
	POP HL
	POP DE
	XOR A;Signal success
	RET


	PAGE


RESKA1:;Gets number in ACCUM1 and places it at the top of RUN time stack
	PUSH AF
	LD HL,ACCUM1
	PUSH DE
	PUSH BC
	LD DE,(RUNSTA);Get address to move to
	CALL CPHLDE;Move it !
	LD HL,4
	ADD HL,DE
	LD (RUNSTA),HL;Update RUN time stack pointer
	POP BC
	POP DE
	LD A,(STACNT);Increment number of elements on stack
	INC A
	LD (STACNT),A
	POP AF
	RET


	PAGE


OUTSTA:;This routine outputs the contents of STACK
	PUSH HL;Save registers
	PUSH DE
	PUSH BC
	LD HL,OUTREV;Display 'Reverse Polish is' message
	LD A,10;@DSPLY
	RST 28H;Call system
	LD HL,STACK;Start address of Reverse Polish tokens
	PUSH HL;Save it
	JR OUTL1;Don't update value first time around
OUTL0:;Update pointer into STACK
	POP HL;Get pointer
	LD BC,5
	ADD HL,BC;Update to next entry
	PUSH HL;Save pointer
OUTL1:
	LD A,(HL);Get byte
	INC HL;Increment to next byte
	CP 1;Is it a number
	JR NZ,OUTL2;No..
	CALL CPHLA1;Copy the number to ACCUM1
	CALL DISPA1; & display it
	JR OUTL0;Go do another entry
OUTL2:
	CP 2;Is it an operator
	JR NZ,OUTL3;No...
	INC HL;Skip past address of subroutine
	INC HL;
	INC HL;Get symbol for operator
	LD C,(HL);Symbol
	LD A,2;@DSP
	RST 28H;Call system
	LD C,' ';Now display a space
	LD A,2;@DSP
	RST 28H;Call system
	JR OUTL0;Go, and do next entry in STACK
OUTL3:;Have	come to end
	POP HL;Get pointer, it is no longer needed
	LD C,13;Carriage Return
	LD A,2;@DSP
	RST 28H;Call system
	POP BC;Restore saved registers
	POP DE
	POP HL
	RET ; Return successfully to caller - always
OUTREV:DB 'Reverse Polish is : ',3


	PAGE


;'Registers' used in calculations by DOIT & OUTSTA
ACCUM1:
 DB 0,0,0,0
ACCUM2:
	DB 0,0,0,0
TEMP1:
	DB 0,0,0,0
TEMP2:
	DB 0,0,0,0
TEMP3:
	DB 0,0,0,0


	SUBTTL	Arithmetic subroutines
	PAGE


;Calculating subroutines follow


	SPACE 3


EXPON:;Raises ACCUM1 to the power of ACCUM2
	PUSH HL;Save registers
	PUSH DE
	PUSH BC
	LD DE,TEMP2
	CALL CPA1DE;Copy ACCUM1 to TEMP2
	LD DE,TEMP3
	CALL CPA2DE;Copy ACCUM2 to TEMP3
	LD HL,ACCUM1
	CALL CLHL;Clear ACCUM1
	LD (HL),1;Start value for result is 1, since X^0=1
EXPL1:
	LD HL,TEMP3
	CALL CEZEHL;Check to see if TEMP3 = 0
	JR Z,EXPL3;If so, we have finished
	LD HL,TEMP2;Otherwise, copy X to ACCUM2
	CALL CPHLA2
	CALL MUA1A2; & multiply answer by it !
	JR NZ,EXPL4;If error, OVERFLOW flag already set
EXPL2:
	LD HL,TEMP3;Decrement TEMP3 by 1
	CALL DEHL
	JR EXPL1;Do another loop
EXPL3:
	XOR A;Signal success
EXPL4:
	POP BC;Restore registers
	POP DE
	POP HL
	RET


	PAGE


FACTOR:;Returns Factorial of ACCUM1
	PUSH HL;Save registers
	PUSH DE
	PUSH BC
	LD DE,TEMP2;Copy ACCUM1 to TEMP2
	CALL CPA1DE
	LD HL,ACCUM1
	CALL CLHL;Clear ACCUM1
	LD (HL),1;Initialise it with 1, since 0!=1
FACL1:
	LD HL,TEMP2;Check if finished
	CALL CEZEHL
	JR Z,FACL3;Yes!, since TEMP2=0
	LD HL,TEMP2;Otherwise, copy TEMP2 to ACCUM2
	CALL CPHLA2
	CALL MUA1A2;And multiply running total by it
	JR NZ,FACL4;If error, flags set by called routine
FACL2:
	LD HL,TEMP2;Decrement TEMP2 by 1
	CALL DEHL
	JR FACL1;Go do another loop
FACL3:
	XOR A;Signal good return
FACL4:
	POP BC;Restore registers
	POP DE
	POP HL
	RET


	PAGE


DIVIDE:;Divides ACCUM2 into ACCUM1
	LD HL,TEMP1;Clear answer
	CALL CLHL
	PUSH BC
	LD B,32;32 bit division...
DIVD:
	CALL SHA1L1;Shift dividend/quotient(ACCUM1) left one bit
	LD HL,TEMP1;
	CALL SIHLL1;Shift (Carry flag/)dividend into TEMP1
	LD HL,TEMP1;Not need, but left for sake of clarity
	CALL CMHLA2;Compare TEMP1 againest ACCUM2
	JR C,NOSUB;No subtraction if TEMP1 < ACCUM2
	CALL SUHLA2;Subtract ACCUM2 from TEMP1. Answer in TEMP1
	LD HL,ACCUM1;Increment Quotient
	CALL INHL
NOSUB:
	DJNZ DIVD
	POP BC
	XOR A;Signal success
	RET


	PAGE


INHL:;Increment 4 bytes @HL by 1
	PUSH BC
	PUSH HL
	LD B,4
INL1:
	INC (HL)
	INC HL
	JR NZ,INL2;If next byte doesn't need incrementing
	DJNZ INL1
INL2:
	POP HL
	POP BC
	RET


	PAGE


DEHL:;Decrement 4 bytes @HL by 1
	PUSH BC
	PUSH HL
	LD B,4
DEL1:
	DEC (HL)
	INC HL
	JP P,DEL2;If next byte doesn't need decrementing
	DJNZ DEL1
DEL2:
	POP HL
	POP BC
	JP M,OVERFLOW
	RET


	PAGE


SUA2A1:;Subtract ACCUM2 from ACCUM1
	LD HL,ACCUM2
SUHLA1:;Subtract ACCUM1 from @HL
	LD DE,ACCUM1
	JR SUHLDE
SUA1A2:;Subtract ACCUM2 from ACCUM1
	LD HL,ACCUM1
SUHLA2:;Subtract ACCUM2 from @HL
	LD DE,ACCUM2
SUHLDE:;Subtract @DE from @HL
	PUSH BC;Save registers
	PUSH HL
	PUSH DE
	CALL CMHLDE;Can a subtraction be done?
	JR NC,SUL2;If so
	CALL OVERFLOW;Otherwise, set overflow flag
	JR SUL3
SUL2:
	LD B,4;Four bytes to cover
	XOR A;Clear C (Carry) flag
SUL1:
	LD A,(DE)
	LD C,A
	LD A,(HL)
	SBC A,C;Subtract C and Carry from A
	LD (HL),A;Save answer
	INC HL
	INC DE
	DJNZ SUL1
	XOR A;Signal good return
SUL3:
	POP DE;Restore registers
	POP HL
	POP BC
	RET


	PAGE


MUA1A2:;Multiply ACCUM1 by ACCUM2, answer in ACCUM1
	LD HL,TEMP1
	CALL CLHL;Clear tempory storage area
	PUSH BC
	LD B,32;No of bits to check in ACCUM2
MUL1:
	LD HL,TEMP1
	CALL SHHLL1;Shift answer along one 'place'
	JR C,MUL3;Go and set overflow flags
	CALL SHA2L1;Shift Multiplier along one place to get MSB bit into Carry flag
	JR NC,MUL2;No addition this time
	LD HL,TEMP1
	CALL ADHLA1
	JR NZ,MUL3;If overflow has occured
MUL2:
	DJNZ MUL1;Go and do some more if necessary
	LD HL,TEMP1
	CALL CPHLA1;Move answer to ACCUM1
	XOR A;Signal good return
	JR MUL4
MUL3:
	CALL OVERFLOW
MUL4:
	POP BC
	RET


	PAGE


ADA1DE:;ADd ACCUM1 to @DE
	LD HL,ACCUM1
	JR ADHLDE
ADA2A1:;ADd ACCUM2 to ACCUM1
	LD HL,ACCUM2
ADHLA1:;ADd @HL to ACCUM1
	LD DE,ACCUM1
	JR ADHLDE
ADA1A2:;ADd ACCUM1 to ACCUM2
	LD HL,ACCUM1
ADHLA2:;ADd @HL to ACCUM2
	LD DE,ACCUM2
ADHLDE:;ADd @HL to @DE
	PUSH BC;Save registers
	PUSH HL
	PUSH DE
	LD B,4
	XOR A;Clear Carry flag
ADL1:
	LD A,(DE)
	ADC A,(HL);Add @HL to @DE with carry flag
	LD (HL),A;Store result @DE
	INC HL
	INC DE
	DJNZ ADL1
	POP DE;Restore registers
	POP HL
	POP BC
	JP C,OVERFLOW;If overflow has occured
	XOR A;Signal good return
	RET


	PAGE


EXA2A1:;Exchange ACCUM2 with ACCUM1
	LD HL,ACCUM2
EXHLA1:;Exchange @HL with ACCUM1
	LD DE,ACCUM1
	JR EXHLDE
EXA1A2:;Exchange ACCUM1 with ACCUM2
	LD HL,ACCUM1
EXHLA2:;Exchange @HL with ACCUM2
	LD DE,ACCUM2
EXHLDE:;Exchange @HL with @DE
	PUSH BC
	LD B,4
EXL1:
	LD A,(HL);Get @HL
	PUSH AF;Save it
	LD A,(DE);Get @DE
	LD (HL),A;Put it @HL
	POP AF;Get old contents of @HL
	LD (DE),A; & put @DE
	INC HL
	INC DE
	DJNZ EXL1;Do this 4 times
	POP BC
	RET


	PAGE


CMHLA1:;CoMpare @HL with ACCUM1
	LD DE,ACCUM1
	JR CMHLDE
CMHLA2:;CoMpare @HL with ACCUM2
	LD DE,ACCUM2
CMHLDE:;CoMpare @HL with @DE
	EX DE,HL
	CALL CMDEHL
	EX DE,HL
	RET
CMA1A2:;CoMpare ACCUM1 with ACCUM2
	LD DE,ACCUM1
CMDEA2:;CoMpare @DE with ACCUM2
	LD HL,ACCUM2
	JR CMDEHL
CMDEA1:;CoMpare @DE with ACCUM1
	LD DE,ACCUM1
CMDEHL:;CoMpare @DE with @HL
	PUSH BC;Save registers
	PUSH HL
	PUSH DE
	LD BC,3;Start at MSB of numbers
	ADD HL,BC
	EX DE,HL
	ADD HL,BC
	EX DE,HL;Both @DE and @HL are at end
	LD B,4;Four bytes to compare
CML1:
	LD A,(DE);Get a byte
	CP (HL);Compare one
	DEC DE;Decrement pointers
	DEC HL
	JR NZ,CML2;If (DE)/=(HL), then flags set correctly
	DJNZ CML1;Otherwise, try again
CML2:
	POP DE;Restore registers
	POP HL
	POP BC
	RET


	PAGE


CEZEHL:;ChEck for ZEro @HL
	PUSH IY;Save IY
	PUSH HL;Copy HL to IY
	POP IY
	LD A,(HL)
	OR (IY+1);Or 4 bytes againest 0
	OR (IY+2); Z flag set if all bytes = zero
	OR (IY+3)
	POP IY
	RET


	PAGE


SHA1L1:;Shift ACCUM1 left 1 bit
	LD HL,ACCUM1
	JR SHHLL1
SHA2L1:;Shift ACCUM2 left 1 bit
	LD HL,ACCUM2
SHHLL1:;Shift @HL left 1 bit
	PUSH IY;Save IY in order to make routine easy to write!
	; Indexing being so much easier then incrementing!
	PUSH HL
	POP IY
	OR A
	SLA (IY+0);Move bits (0-7) to (1-7,Carry flag). Move 0 into bit 0
	RL (IY+1);Move bits (Carry flag,0-7) to (0-7,Carry Flag)
	RL (IY+2)
	RL (IY+3)
	POP IY;Restore IY
	RET


	PAGE


SIA1L1:;Shift ACCUM1 left 1 bit, moving Carry flag into bit 0
	LD HL,ACCUM1
	JR SIHLL1
SIA2L1:;Shift ACCUM2 left 1 bit, moving Carry flag into bit 0
	LD HL,ACCUM2
SIHLL1:;Shift @HL left 1 bit, moving Carry flag into bit 0
	PUSH IY
	PUSH HL
	POP IY
	RL (IY+0);Rotate (Carry flag,bits 0-7) to (bits 0-7,carry flag)
	RL (IY+1)
	RL (IY+2)
	RL (IY+3)
	POP IY
	RET


	PAGE


SHA1R1:;Rotate ACCUM1 right 1 bit
	LD HL,ACCUM2
	JR SHHLR1
SHA2R1:;Rotate ACCUM2 right 1 bit
	LD HL,ACCUM2
SHHLR1:;Rotate @HL right 1 bit
	PUSH IY
	PUSH HL
	POP IY
	OR A
	SRL (IY+3);Shift (0,bits 7-0) to (bits 7-0,carry flag)
	RR (IY+2);Rotate (carry flag,bits 7-0) to (bits 7-0,carry flag)
	RR (IY+1)
	RR (IY+0)
	POP IY
	RET


	PAGE


CPA2DE:;CoPy ACCUM2 to @DE
	LD HL,ACCUM2
	JR CPHLDE
CPA1DE:;CoPy ACCUM1 to @DE
	LD HL,ACCUM1
	JR CPHLDE
CPA2A1:;CoPy ACCUM2 to ACCUM1
	LD HL,ACCUM2
CPHLA1:;CoPy @HL to ACCUM1
	LD DE,ACCUM1
	JR CPHLDE
CPA1A2:;CoPy ACCUM1 to ACCUM2
	LD HL,ACCUM1
CPHLA2:;CoPy @HL to ACCUM2
	LD DE,ACCUM2
CPHLDE:;CoPy @HL to @DE
	PUSH BC;Save registers
	PUSH HL
	PUSH DE
	LD B,4;Four bytes to copy
CPL1:;Do...
	LD A,(HL)
	LD (DE),A
	INC HL
	INC DE
	DJNZ CPL1;.. until all four bytes copied
	POP DE;Restore Registers
	POP HL
	POP BC
	RET


	PAGE


CLACC1:;CLear ACCUM1
	LD HL,ACCUM1
	JR CLHL
CLACC2:;CLear ACCUM2
	LD HL,ACCUM2
CLHL:;CLear @HL
	PUSH HL
	PUSH BC
	LD B,4;Four bytes to clear
CLL1:
	LD (HL),0;Clear byte @HL
	INC HL
	DJNZ CLL1;repeat until 4 bytes done
	POP BC
	POP HL
	RET


	PAGE


DISPA1:;DISPlay	ACCUM1. Destroys contents of ACCUM1
	PUSH HL;Save registers
	PUSH DE
	PUSH BC
	XOR A
	LD (DISPL5),A;Signal no leading zeroes
	LD HL,DISPTB;Powers of Ten table
	LD B,10;Ten entries in table
DISPL1:
	CALL CPHLA2;Copy entry from table into ACCUM2
	PUSH HL;Save pointer into table
	PUSH BC;Save number of entries left in table
	LD B,0;Set up count for the number of times ACCUM2 can be subtracted
	; from ACCUM1
DISPA4:
	CALL CMA1A2;Compare ACCUM1 with ACCUM2
	JR C,DISPA3;ACCUM2 is bigger than ACCUM1...
DISPA2:
	CALL SUA1A2;Subtract ACCUM2 from ACCUM1
	INC B;Increment B
	JR DISPA4;Try for another subtraction
DISPA3:
	LD A,B
	OR A
	JR NZ,DISPL2;If not zero
	LD A,0
DISPL5:EQU $-1;Print zeroes flag
	OR A
	JR Z,DISPL4;If this zero is a leading zero
	XOR A
	JR DISPL3;otherwise..
DISPL2:;Signal	zeroes are to be printed from now on
	LD (DISPL5),A
DISPL3:
	ADD A,48;Add '0' to number in a to turn it into an ASCII character
	LD C,A;Character to print
	LD A,2;@DSP
	RST 28H;Call system
DISPL4:
	POP BC;Restore counter for table
	POP HL;Restore pointer into powers of ten table
	INC HL;Get to next entry in powers of ten table
	INC HL
	INC HL
	INC HL
	DJNZ DISPL1;Do another power of ten if necessary
	LD A,(DISPL5);Has anything been displayed?
	OR A
	JR NZ,DISPL6;Yes..
	LD C,'0';Display a zero
	LD A,2;@DSP
	RST 28H;Call system
DISPL6:
	LD C,' '
	LD A,2;@DSP
	RST 28H
	POP BC;Restore registers
	POP DE
	POP HL
	RET
DISPTB:;Powers of ten table
	; Remember the table is coded LSB,NLSB,NLSB,MSB
	DB 000H,0CAH,09AH,03BH; 1,000,000,000
	DB 000H,0E1H,0F5H,005H;   100,000,000
	DB 080H,096H,098H,000H;    10,000,000
	DB 040H,042H,00FH,000H;     1,000,000
	DB 0A0H,086H,001H,000H;       100,000
	DB 010H,027H,000H,000H;        10,000
	DB 0E8H,003H,000H,000H;         1,000
	DB 064H,000H,000H,000H;           100
TEN:;This is here for the TENADD routine used by NEXT_TOKEN
	DB 00AH,000H,000H,000H;            10
	DB 001H,000H,000H,000H;             1


	PAGE


OVERFLOW:;This sets the overflow flag
	LD A,1
	LD (OVERFLAG),A
	OR A
	RET ; Indicate a unsuccessful call to a routine


	SUBTTL	Storage areas for stacks used by program
	PAGE


RUNSTA:DW 0
STACNT:DB 0
STASTA:DW 0
REVSTA:DW 0
STACK:DW 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
REVACK:DB 2,2,0,0,'&'
RUNACK:;Shares same storage as REV stack
REVHH:DW 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
;
;
	END START;Program starts at label START


                                             