;
;	SPLIT -- Program to split large ASCII files into smaller files
;
;	USEAGE: SPLIT FILE D (parms)
;	where:  FILE is the name of the large file to split
;       	D is the drive for the split files to be put
;		parms are LINES=## where ## is the maximum number
;		of lines per file
;		and/or
;		COUNT=## where ## is the maximum number of kilobytes
;		per file
;
LF	EQU	0AH
ETX	EQU	03H
CR	EQU	0DH
EOF	EQU	1CH
;
@MUL16	EQU	5BH
@DSPLY	EQU	0AH
@PARAM	EQU	11H
@FSPEC	EQU	4EH
@OPEN	EQU	3BH
@INIT	EQU	3AH
@EXIT	EQU	16H
@ERROR	EQU	1AH
@CLOSE	EQU	3CH
@GET	EQU	03H
@PUT	EQU	04H
;
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	28H
	ENDM
;
	ORG	3000H
;
START:	PUSH	HL
	LD	HL,SIGNON
	SVC	@DSPLY
	POP	HL
	LD	DE,OUTPUT_FCB	;DE=>dest
MOVE_LP	LD	A,(HL)		;p/u file name char
	LD	(DE),A		;save char
	CP	' '+1
	JR	C,GET_DRIVE	;IF END OF FILE NAME GO
	INC	HL
	INC	DE
	JR	MOVE_LP		;and loop
GET_DRIVE:
	CP	' '
	JP	NZ,BAD_DRIVE	;IF NOT SPACE, GO USEAGE ERROR
	INC	HL		;BUMP PAST SPACE
	LD	A,(HL)		;P/U NEXT CHAR
	CP	':'
	JR	Z,GD1		;IF ':', GO NEXT IS DRIVE
	JR	GET_DRIVE	;ELSE SKIP TILL COLON
GD1	INC	HL		;bump past ':'
GD1B	LD	A,(HL)		;p/u drive #
	LD	(ADRIVE),A	;save ascII drive #
	CP	'0'
	JP	C,BAD_DRIVE	;go if less than 0
	CP	'7'+1
	JP	NC,BAD_DRIVE	;go if > 7
GD1A	INC	HL		;bump past drive #
	LD	A,(HL)		;p/u next char
	CP	' '
	JR	C,GD2		;END OF CMD LINE, GO PROCESS
	CP	' '
	JR	Z,GD1A		;ELSE SKIP SPACES
	LD	DE,PARM_TBL
	SVC	@PARAM		;else parse parameters
	JP	NZ,BAD_PARAM
GD2:	LD	A,(LIN_RESPB)
	LD	HL,CNT_RESPB
	OR	(HL)
	AND	80H
	JR	Z,GD3		;NO VALID PARAMETERS, USE DEFAULTS
	LD	HL,-1		;ELSE SET DEFAULTS EXTREMELY HIGH
	LD	(LINES1),HL
	LD	(COUNT1),HL	;AND THEN TEST FOR SET PARAMETERS
	AND	80H		;TEST FOR THE LINES PARMETER
	JR	NZ,GD4		;WAS NOT LINE, USE EXTREMELY HIGH IN HL
	LD	(LINES),HL
GD4:	LD	A,(CNT_RESPB)	;P/U RESPONSE BYTE FOR COUNT
	AND	80H		;TEST FOR NUMERIC RESPONSE
	JR	NZ,GD2A		;GO, EXTREMELY HIGH IN COUNT1, NO INPUT
	LD	HL,(COUNT1)
	LD	(COUNT),HL
GD2A:	LD	HL,(COUNT)	;P/U * OF K IN HL
	LD	C,L		;MOVE LSB TO C
	LD	HL,1024		;MULTIPLY BY 1 K
	SVC	@MUL16
	LD	H,L
	LD	L,A
	LD	(COUNT),HL
GD3:	LD	HL,(COUNT)	;SET COUNT OF CHAR FOR FIRST LOOP
	LD	(COUNT1),HL
	LD	HL,(LINES)	;set count for first loop
	LD	(LINES1),HL
	LD	HL,OUTPUT_FCB
	LD	DE,INPUT_FCB
	SVC	@FSPEC
	JP	NZ,BAD_FILE
	LD	HL,OUTPUT_FILE
	LD	DE,OUTPUT_FCB
	SVC	@FSPEC
	JP	NZ,BAD_FILE
	LD	B,0		;SET LRL=256
	LD	HL,INPUT_BUFFER
	LD	DE,INPUT_FCB
	SVC	@OPEN
	JR	Z,GD2B
	CP	42		;LRL FAULT ERROR, IGNORE
	JP	NZ,ERR_EXT	;ELSE QUIT WITH ERROR
GD2B:	LD	HL,OUTPUT_FILE_MSG
	SVC	@DSPLY
	LD	B,0		;SET LRL=256
	LD	HL,OUTPUT_BUFFER
	LD	DE,OUTPUT_FCB
	SVC	@INIT		;OPEN FILE FOR OUTPUT
	JP	NZ,FERR_EXT1
CUTLOOP1:
	LD	DE,INPUT_FCB
	SVC	@GET
	JR	Z,CUTLOOP1A
	OR	A
	JR	Z,CUTLOOP1
	CP	EOF
	JR	Z,CLOSFILES
	JP	FERR_EXT	;was error, go & quit
CUTLOOP1A:
	LD	DE,OUTPUT_FCB	;fcb to use for output
	LD	C,A
	SVC	@PUT
	JR	NZ,FERR_EXT
	LD	A,C
	CP	CR
	JR	NZ,CUTLOOP1B
	LD	HL,(LINES1)	;p/u count of lines
	DEC	HL		;dec count
	LD	(LINES1),HL	;save new count
	LD	A,H		;Test for new file
	OR	L
	JR	Z,CUTLOOP1C	;yes, go do new file
CUTLOOP1B:
	LD	HL,(COUNT1)	;p/u char count
	DEC	HL		;decrement
	LD	(COUNT1),HL	;save again
	LD	A,H		;test for max len of file
	OR	L
	JR	NZ,CUTLOOP1	;loop, not at max
CUTLOOP1C:
	CALL	CLOSE_OUTPUT
	LD	HL,(LINES)	;P/U lines per file
	LD	(LINES1),HL	;save count for next loop
	LD	HL,(COUNT)
	LD	(COUNT1),HL
	JP	CUTLOOP1	;and loop for next line
CLOSFILES:
	LD	DE,OUTPUT_FCB
	SVC	@CLOSE
	LD	DE,INPUT_FCB
	SVC	@CLOSE
	LD	HL,0		;SHOW NO ERROR
	SVC	@EXIT
;
;------------------------------------------------------
;	CLOSE_OUTPUT -- close output file & prepare
;	for next file to open by adding to last char
;	in the file name
;
;	ENTRY:	NONE
;
;	EXIT:	NONE
;
;	USES:	ALL
;
;------------------------------------------------------
CLOSE_OUTPUT:
*MOD
	LD	DE,OUTPUT_FCB
	SVC	@CLOSE		;CLOSE OUTPUT FILE & RESTORE NAME
	LD	HL,OUTPUT_CHAR
	LD	A,(HL)		;p/u char
	INC	A
	CP	'Z'+1
	JR	NC,ATEND2?	;Can't just bump GO ERROR
	LD	(HL),A		;save char
	LD	HL,OUTPUT_FILE_MSG
	SVC	@DSPLY
	LD	DE,OUTPUT_FCB
	LD	HL,OUTPUT_FILE
	SVC	@FSPEC
	LD	DE,OUTPUT_FCB
	LD	B,0
	LD	HL,OUTPUT_BUFFER
	SVC	@INIT
	RET			;and back to caller
;
ATEND2?	LD	DE,INPUT_FCB
	SVC	@CLOSE
	LD	HL,TOOMANY$
	SVC	@DSPLY
	LD	HL,-1
	SVC	@EXIT
;
FERR_EXT:
	PUSH	AF		;save error code in A
	LD	DE,OUTPUT_FCB
	SVC	@CLOSE
	POP	AF		;p/u error code
FERR_EXT1:
	PUSH	AF		;save error code in A
	LD	DE,INPUT_FCB
	SVC	@CLOSE
	POP	AF		;p/u error code
ERR_EXT:
	SET	6,A		;set short error message
	LD	C,A
	SVC	@ERROR		;exit program
;
BAD_PARAM:
	LD	HL,PARAM_BAD
	SVC	@DSPLY
	JR	USEAGE
;
BAD_FILE:
	LD	HL,FILE_BAD
	SVC	@DSPLY
	JR	USEAGE
;
BAD_DRIVE:
	LD	HL,DRIVE_BAD
	SVC	@DSPLY
USEAGE:
	LD	HL,USEAGE$
	SVC	@DSPLY
	LD	HL,-1
	SVC	@EXIT
;
USEERR:
	CP	'0'
	JR	C,BAD_DRIVE
	CP	7+1
	JR	NC,BAD_DRIVE
	JP	GD1B
;
SIGNON	DB	'SPLIT -- File spliting utility for ASCII files',LF
	DB	'by Aaron O''Neill, December 12, 1990',LF,CR
TOOMANY$ DB	'Too many files for SPLIT.  Operation aborted.',LF
	DB	'Increase lines per file using the C parameter.',CR
PARAM_BAD DB	'Bad parameter.',LF,CR
FILE_BAD DB	'Bad file name.',LF,CR
DRIVE_BAD DB	'Illegal drive number.',LF,CR
USEAGE$	DB	'Useage: SPLIT FILENAME :D [(L=#,C=#)]',LF
	DB	'Where:  FILENAME is the file to split.',LF
	DB	'        D is the Drive for output (0-7).',LF,LF
	DB	'Output files will have the name SPLIT#/TXT',LF
	DB	'where # varies for each split file.',LF
	DB	'SPLIT will make a maximum of 26 files.',LF
	DB	'The target drive must have enough free space for',LF
	DB	'the split files.',LF
	DB	'LINES is the parameter for the count of lines per file.',LF
	DB	'(For output files of approximately 24K with lines 32',LF
	DB	'characters long, use 750.  Default [100 line/file] is set'
	DB	'  for files with',LF
	DB	'lines 256 characters long).',LF
	DB	'COUNT is the parameter for the count of characters per file in kilobytes.',LF
	DB	'Default is set for 24K',CR
PARM_TBL:
	DB	80H
	DB	10010101B
	DB	'LINES'
LIN_RESPB: DB	0
	DW	LINES
	DB	10010101B
	DB	'COUNT'
CNT_RESPB: DB	0
	DW	COUNT
	DB	0		;MARK END OF PARAMETER TABLE
LINES	DW	100		;DEFAULT 100 LINES
LINES1	DW	$-$
COUNT 	DW	24*1024		;SET 24K DEFAULT FOR CHAR COUNT
COUNT1	DW	$-$
;
OUTPUT_FILE_MSG DB 'Writing to File: '
OUTPUT_FILE DB	'SPLIT'
OUTPUT_CHAR DB	'A/TXT:'
ADRIVE	DB	' ',CR
INPUT_FCB DS	32
OUTPUT_FCB DS	32
INPUT_BUFFER DS	256
OUTPUT_BUFFER DS 256
;
	END	START
