;	BSORT -- quick file sorter, uses bubble sort
@HIGH$	EQU	65H
@FSPEC	EQU	4EH
@OPEN	EQU	3BH
@GET	EQU	03H
@REW	EQU	44H
@DSPLY	EQU	0AH
@INIT	EQU	3AH
@PUT	EQU	04H
@CLOSE	EQU	3CH
@ERROR	EQU	1AH
@EXIT	EQU	16H
@PARAM	EQU	11H
;
SVC	MACRO	#NUM
	LD	A,#NUM
	RST	28H
	ENDM
;
CR	EQU	0DH
LF	EQU	0AH
ETX	EQU	03H
EOF	EQU	1CH
;
	ORG	3000H
;
START:	PUSH	HL		;SAVE CMD LINE PTR
	LD	HL,0		;get HIGH$
	LD	B,0
	SVC	@HIGH$
	DEC	HL		;HL==top of memory
	LD	(TOP_MEM),HL
	LD	DE,FCB
	POP	HL		;P/U CMD LINE PTR
	SVC	@FSPEC		;TEST FILE NAME & MOVE
	JP	NZ,FILE_ERR	;GO FILE NAME ERROR
	PUSH	HL		;SAVE CMD LINE PTR
	LD	DE,NAME_BUF	;SAVE FILE NAME FOR LATER
	LD	HL,FCB
	LD	BC,32
	LDIR
	POP	HL		;P/U CMD LINE PTR
	LD	DE,PARM_TBL	;DE==>PARAMETER TABLE
	SVC	@PARAM		;PARSE TABLE IF NEEDED
	JP	NZ,PARM_ERR
	LD	DE,0		;FLAG SET FOR ASCENDING SORT
D_SORT	EQU	$-2
	LD	A,D
	OR	E
	JR	Z,START1
	LD	A,38H		;JR C, OP CODE
	LD	(OP_STUF),A	;SET FOR DESCENDING SORT
;
START1:	LD	HL,(OFILE_NM)	;HL=>OUTPUT FILE NAME
START2:	LD	A,(HL)		;p/u char
	INC	HL		;bump ptr
	CP	' '		;is it a space or less?
	JR	Z,START3	;yes, mark end of file name
	JR	NC,START2	;is it < space, no, loop
START3:	DEC	HL		;HL=>SPACE OR LESS CHAR
	LD	(HL),CR		;mark end of file name
	LD	HL,(OFILE_NM)
	LD	DE,OFCB
	SVC	@FSPEC		;CK & SAVE FILE NAME
	JP	NZ,FILE_ERR
	LD	HL,F_BUF	;OPEN INPUT FILE
	LD	DE,FCB
	LD	B,0		;SET LRL=256
	SVC	@OPEN
	JP	NZ,DOS_ERR
	XOR	A
	LD	(MAX_LEN),A
	LD	HL,0
	LD	(LINE_CNT),HL
NXT_LINE:
	LD	C,0		;COUNT OF CHAR INPUT
NXT_CHAR:
	LD	DE,FCB
	SVC	@GET
	JP	NZ,REWIND
	INC	C		;BUMP COUNT OF CHAR
	CP	CR		;END OF LINE?
	JR	NZ,NXT_CHAR
	LD	HL,(LINE_CNT)	;BUMP LINE COUNT
	INC	HL
	LD	(LINE_CNT),HL
	LD	A,(MAX_LEN)	;ck for max len
	CP	C
	JR	NC,NXT_LINE	;shorter, so get next line
	LD	A,C		;else save new max len
	LD	(MAX_LEN),A
	JR	NXT_LINE	;and get next line
;
REWIND:
	CP	EOF		;was error end of file?
	JP	NZ,DOS_ERR	;no, go dos error
	LD	DE,FCB		;rewind file
	SVC	@REW
	LD	HL,LINES_BUF	;HL==>WHERE TO LOAD FILE
LOAD:
	LD	A,(MAX_LEN)	;P/U MAX LINE LEN
	LD	B,A		;MOVE COUNT TO B
LOAD_1:
	LD	DE,FCB
	SVC	@GET
	JP	NZ,LOAD_DONE	;GO, CK FOR EOF OR ERROR
	LD	(HL),A		;SAVE BYTE IN BUFFER
	INC	HL		;BUMP LINE BUFFER PTR
	CALL	MEM_CHECK	;CK FOR MEMORY OVER FLOW
	JP	Z,MEM_ERR	;OVER FLOWED, GO ERROR
	DEC	B		;REDUCE COUNT OF CHAR
	CP	CR		;END OF LINE?
	JR	NZ,LOAD_1	;NO, GET NEXT CHAR
	LD	A,B		;MOVE COUNT TO A
	OR	A		;TEST, LINE=MAX LEN?
	JR	Z,LOAD		;YES, GET NEXT LINE
LOAD_2:
	LD	(HL),0		;NOT MAX LEN, PAD WITH 0
	INC	HL		;BUMP MEM PTR
	CALL	MEM_CHECK	;CHECK FOR MORE SPACE
	JP	Z,MEM_ERR	;NO MORE SPACE, GO ERROR
	DJNZ	LOAD_2		;PAD REST OF LINE
	JR	LOAD		;AND LOAD NEXT LINE
;
LOAD_DONE:
	CP	EOF		;AT END OF FILE?
	JP	NZ,DOS_ERR	;NO, GO DOS ERROR EXIT
	LD	(HL),0FFH	;MARK END OF BUFFER
	LD	DE,FCB		;CLOSE INPUT FILE
	SVC	@CLOSE
	JP	NZ,DOS_ERR
;
	LD	HL,1		;START OF FIELD TO MERGE
F_START: EQU	$-2
	DEC	L		;OFFSET FROM 0
	LD	H,0
	LD	A,(MAX_LEN)	;COMPARE TO MAX LENGTH
	SUB	L		;COMPARE TO START 
	LD	A,L		;SAVE FIELD START
	LD	(F_START),A	;SAVE FIELD START, MAX OFFSET IS 256
	LD	HL,0
F_END:	EQU	$-2
	LD	H,A		;SAVE FIELD START
	LD	A,L		;A=FIELD END
	SUB	H		;A=FIELD end - field start, i.e, field len
	LD	L,A		;SAVE FIELD LEN
	LD	A,(MAX_LEN)
	SUB	H		;A=max len - start, ie max field len
	LD	H,A		;H=MAX FIELD LEN
	CP	L		;COMPARE TO FIELD LEN
	JR	C,FL_2		;IF MAX FIELD LEN < FIELD LEN, GO USE MAX
	LD	H,L		;ELSE SET FIELD LEN
FL_2:	LD	A,H
	LD	(F_LEN),A	;SAVE FIELD LEN
;
SORT_SET:
	CALL	SORT		;SORT FILE IN MEMORY
	LD	HL,OFCB		;COPY OUTPUT FILE NAME TO FCB
	LD	DE,FCB
	SVC	@FSPEC
	LD	HL,F_BUF
	LD	B,0
	SVC	@INIT
	JP	NZ,DOS_ERR
	LD	HL,LINES_BUF	;HL==>LINES IN MEMORY
SAVE_LINE:
	LD	A,(HL)		;P/U CHAR FROM BUFFER
	CP	0FFH		;END OF BUFFER MARKER?
	JR	Z,CLOSE		;YES, CLOSE
SAVE_1:
	LD	A,(HL)
	CP	0FFH		;END OF BUFFER?
	JR	Z,CLOSE		;YES, CLOSE
	OR	A		;PADDING CHAR?
	JR	NZ,PUTCHAR	;NO, SAVE CHAR
	INC	HL		;YES, BUMP PTR & LOOP
	JR	SAVE_1
;
PUTCHAR:
	LD	C,A		;CHAR TO SAVE TO C
	SVC	@PUT
	JP	NZ,DOS_ERR
	INC	HL		;BUMP BUFFER PTR
	JR	SAVE_LINE	;AND LOOP
;
CLOSE:
	LD	DE,FCB
	SVC	@CLOSE
	JP	EXIT
;
MEM_CHECK:
	PUSH	HL		;COPY LINE BUF PTR TO DE
	POP	DE
	PUSH	DE		;SAVE LINE BUF PTR
	LD	HL,(TOP_MEM)	;HL==HIGHEST MEM
	OR	A		;CLEAR CARRY
	SBC	HL,DE		;COMPARE LINE BUF TO TOP OF MEM
	POP	HL		;RESTORE LINE BUF PTR
	RET			;RETURN WITH RESULTS
;
PARM_ERR:
	LD	HL,PARM_ERR$
	DB	0DDH
MEM_ERR:
	LD	HL,MEM_ERR$
	DB	0DDH
FILE_ERR:
	LD	HL,FILE_ERR$
	SVC	@DSPLY
ABORT:	LD	HL,-1
	JR	EXIT1
;
DOS_ERR
	OR	0C0H		;SET SHORT BIT AND RETURN
	LD	C,A		;MOVE TO C
	SVC	@ERROR		;ABORT PROGRAM
	JR	ABORT
;
EXIT:	LD	HL,0		;SET NO ERROR EXIT
EXIT1:	SVC	@EXIT		;QUIT TO DOS
;
SORT:	LD	HL,LINES_BUF	;HL==>BUFFER TO SORT
	LD	BC,(LINE_CNT)	;BC==LINE COUNT
	DEC	BC		;BC==LINE COUNT - 1
	LD	A,0
	LD	(SWAP_FLG),A	;SET NO SWAPS
	LD	A,B		;QUIT IF COUNT=0
	OR	C
	JR	Z,SRT_3
SRT_1:	LD	A,(MAX_LEN)
	LD	E,A
	LD	D,0		;DE==LEN OF LINE IN BUF
	PUSH	HL		;SAVE PTR TO LINE 1
	ADD	HL,DE		;HL==>LINE 2
	EX	DE,HL		;DE==>LINE 2
	POP	HL		;HL==>LINE 1
	PUSH	DE		;SAVE PTR FOR NEXT PASS
	CALL	COMPARE		;COMPARE LINES
	JR	Z,SRT_2		;EQUAL, SKIP SWAP
	JR	NC,SRT_2	;NO NEED TO SWAP, SKIP
OP_STUF: EQU	$-2
	CALL	SWAP		;SWAP LINES
	LD	A,1		;SET SWAP FLAG TO TRUE
	LD	(SWAP_FLG),A
SRT_2:	POP	HL		;OLD LINE 2 PTR NOW LINE 1
	DEC	BC		;DEC LINE COUNT
	LD	A,C		;TEST OR END OF PASS
	OR	B
	JR	NZ,SRT_1	;NOT DONE YET, LOOP
SRT_3:	LD	A,(SWAP_FLG)	;TEST FOR NO SWAPS
	OR	A
	RET	Z		;NONE, SO DONE
	LD	HL,(LINE_CNT)	;P/U MAX NUM OF LINES
	DEC	HL		;LAST ELEMENT IS IN ORDER
	LD	(LINE_CNT),HL	;SO SAVE ONE LESS IN COUNT
	JR	SORT		;DO ANOTHER PASS
;
COMPARE:
	PUSH	BC		;SAVE COUNT
	PUSH	DE		;SAVE PTR TO LINE 2
	PUSH	HL		;SAVE PTR TO LINE 1
	LD	A,(F_START)
	LD	C,A		;P/U FIELD START
	LD	B,0		;BC=OFFSET TO FIELD START
	ADD	HL,BC		;HL==>FIELD IN LINE 1
	EX	DE,HL		;HL==>LINE 2
	ADD	HL,BC		;HL==>FIELD LINE 2
	EX	DE,HL		;DE==>LINE 2, HL ==>LINE 1
	LD	A,(F_LEN)
	LD	B,A		;P/U FIELD LEN
COMPARE_1:
	LD	A,(DE)		;P/U CHAR LINE 2
	CP	(HL)		;COMPARE LINE 2
	JR	Z,COMPARE_2	;EQUAL, SO LOOP
	JR	COMPARE_3	;ELSE NOT EQUAL, CK FOR RIGHT ORDER
COMPARE_2:
	INC	HL		;BUMP PTR LINE 1
	INC	DE		;BUMP PTR LINE 2
	DJNZ	COMPARE_1	;LOOP FOR FIELD
COMPARE_3:
	POP	HL		;RESTORE PTR TO LINE 1
	POP	DE		;RESTORE PTR TO LINE 2
	POP	BC		;RESTORE COUNT
	RET			;BACK WITH RESULTS OF COMPARISON
;
SWAP:	PUSH	BC		;SAVE COUNT
	PUSH	DE		;SAVE PTR TO LINE 2
	PUSH	HL		;SAVE PTR TO LINE 1
	PUSH	DE		;SAVE PTR LINE 2 AGAIN
	PUSH	HL		;SAVE PTR TO LINE 1 AGAIN
	LD	DE,F_BUF	;DE==>TEMP BUFFER
	LD	A,(MAX_LEN)
	LD	C,A		;P/U MAX LINE LEN
	LD	B,0		;BC = NUM CHAR TO MOVE
	PUSH	BC		;SAVE NUM CHAR TO MOVE
	LDIR			;MOVE LINE 1 TO TEMP STORAGE
	POP	BC		;P/U NUM CHAR TO MOVE
	POP	DE		;P/U WHERE TO MOVE TO LINE 1 PTR
	POP	HL		;P/U WHERE TO MOVE FROM LINE 2 PTR
	PUSH	HL		;SAVE WHERE TO MOVE FROM, LINE 2 PTR
	PUSH	DE		;SAVE WHERE TO MOVE TO LINE 1 PTR
	PUSH	BC		;SAVE NUMBER TO MOVE
	LDIR			;COPY LINE 2 TO LINE 1
	POP	BC		;P/U NUMBER OF BYTES TO MOVE
	POP	HL		;P/U WHERE TO MOVE FROM, LINE 1 PTR
	POP	DE		;P/U WHERE TO MOVE TO (I.E. LINE 2)
	LD	HL,F_BUF	;HL==>F_BUF, TEMP STOR WHERE LINE 1 IS
	LDIR
	POP	HL		;P/U PTR LINE 1
	POP	DE		;P/U PTR LINE 2
	POP	BC		;P/U COUNT OF LINES
	RET
;
F_LEN:	DB	0
MAX_LEN: DB	0
LINE_CNT: DW	$-$
TOP_MEM: DW	$-$
SWAP_FLG: DB	0
NAME_BUF: DS	32
;
OFCB:	DS	32
FCB:	DS	32
F_BUF:	DS	256
PARM_ERR$: DB	'Parameter error.',LF
USEAGE:	DB	'Useage: BSORT FILENAME [(START=##,END=##,FILE="filespec",DESCEND)]',LF
	DB	'Where: FILENAME is required',LF
	DB	'       START   is an optional parameter for the starting position of a field',LF
	DB	'               (default is 0, the beginning of the line).',LF
	DB	'       END     is an optional parameter for the ending position of',LF
	DB	'                the sort field (default is the end of the line).',LF
	DB	'       FILE     is an optional parameter for the output file name',LF
	DB	'               (default is the name of the file being sorted).',LF
	DB	'       DESCEND is an optional parameter for a descending sort',LF
	DB	'               (defualt is for an ascending sort).',LF
	DB	'Abbreviations are S for START, E for END, F for FILE, and D for DESCEND.',CR
;
MEM_ERR$ DB	'File is to large for sorting in memory!',CR
FILE_ERR$ DB	'Invalid file name!',CR
PARM_TBL:
	DB	80H		;MARK START OF PARAMETER TABLE
;
	DB	10010101B	;NUMERIC, ABRV, 5 CHAR LONG
	DB	'START'
	DB	0
	DW	F_START
;
	DB	10010011B	;NUMERIC, ABRV, 3 CHAR LONG
	DB	'END'
	DB	0
	DW	F_END
;
	DB	01010111B	;FLAG, ABRV, 7 CHAR LONG
	DB	'DESCEND'
	DB	0
	DW	D_SORT
;
	DB	00110100B	;Str parm, abbrv
	DB	'FILE'
	DB	0		;response byte
	DW	OFILE_NM	;VEC to receive parm
;
	DB	0		;MARK END OF TABLE
;
OFILE_NM: DW	NAME_BUF	;DEFAULT FILE NAME IS INPUT FILE NAME
;
LINES_BUF: EQU	$
;
	END	START
