*****************************
* OS9 DASM VERSION 1.0      *
* (C)1992 J.R.COLLYER       *
*****************************

         ifp1
         use  /dd/defs/os9defs
         endc
begin    mod  len,name,prgrm+objct,reent+1,entry,dsize
lf       equ  $0A
cr       equ  $0D
sp       equ  $20
mask     equ  $FF
on       equ  $FF
stacksz  equ  200
buffsiz  equ  24576
pagesiz  equ  8192
pagenum  equ  3
path     rmb  1
dpath    rmb  1
mode     rmb  1
pflag    rmb  1
bflag    rmb  1
count    rmb  1
errnum   rmb  1
listflg  rmb  1
linkcnt  rmb  1
address  rmb  2
saveadr  rmb  2
auxaddr  rmb  2
endaddr  rmb  2
moduloc  rmb  2
pointer  rmb  2
endbuff  rmb  2
counter  rmb  2
linkaddr rmb  2
curstack rmb  2
lststack rmb  2
firstack rmb  2
branchad rmb  2
offsopt  rmb  1
offsflg  rmb  1
gimicnt  rmb  1
gimidat  rmb  3
gimisys  rmb  5
xaddress rmb  2
pcaller  rmb  1
peflg    rmb  1
psflg    rmb  1
paddress rmb  2
pendaddr rmb  2
turn     rmb  1
status   rmb  4
eko      rmb  1
         rmb  27
linknam  rmb  stacksz
iobuff   rmb  stacksz
adrstack rmb  stacksz
buffer   rmb  buffsiz
         rmb  stacksz
         rmb  stacksz
dsize    equ  .
name     fcs  /Dasm/
         fcc   /(C)1992 J.R.COLLYER/
         fcb  1 
entry    decb               * any parameters
         beq  noparams      * no, skip ahead
         lbra params        * yes, process them
noparams incb               * stdout
         stb  path          * save to path
         leay copyr,pcr     * point to signon
         bsr  echo          * print it
         lbsr init          * initialize system
centry   leay prompt,pcr    * point to dasm prompt
         bsr  echo          * print it
         lbsr getsta        * get status
         clr  eko,u         * clear echo
         lbsr setsta        * set status
         clra               * stdin
         leax iobuff,u      * point to buffer
inkey    ldb  #1            * SS.READY
         os9  i$getstt      * data available
         bcs  inkey         * no, loop for some
         ldy  #1            * read 1 byte
         os9  i$read        * from stdin
         lbcs exit          * exit on error
         leay commands,pcr  * point to command table
         lda  ,x            * get command from buffer
         cmpa #'a           * is it upper case
         blo  cloop         * no, it is lower case skip ahead
         suba #sp           * yes, make it upper case
         sta  ,x            * put it in buffer
cloop    leay 3,y           * adjust command pointer
         lda  ,y            * get available command
         beq  errcom        * no match error
         cmpa ,x            * is it the one they want
         bne  cloop         * no, skip back check again
         ldd  1,y           * get command address offset
         leay begin,pcr     * point to module start
         jsr  d,y           * jump subroutine at offset
         bra  centry        * loop back for another command
errcom   bsr  comerr        * report no available command
         bra  centry        * loop back for another command
comerr   bsr  echoon        * turn on echo
         leay whatmsg,pcr   * WHAT??
         bsr  echo          * print it
         rts                * return
errmsg   stb  errnum        * save error number
         leay prompt,pcr    * point to dasm: prompt
         bsr  echo          * print it
         ldb  errnum        * get error number
         lda  #2            * stderr
         os9  f$perr        * print it
         rts                * return
crlf     lda  #cr           * save carriage return
         sta  ,x+           * in buffer
         clra               * and null character
         sta  ,x            * in buffer
         leay iobuff,u      * point to buffer
echo     pshs u             * save data
         tfr  y,x           * get buffer address
         tfr  y,u           * into u reg for count
         ldy  #0            * zero counter
outsize  ldb  ,u+           * get character
         beq  print         * if reached end
         leay 1,y           * else count it
         bra  outsize       * loop counting all them
print    lda  path          * get path
         os9  i$writln      * print it
         lbcs fatal         * restore system if error
         puls u             * get data back
         rts                * return
input    leax iobuff,u      * point to buffer
         ldy  #stacksz      * buffer size
         clra               * stdin
         os9  i$readln      * read line
         bcs  errmsg        * if error
         rts                * return
skip     lda  ,x+           * get character
         cmpa #sp           * if it a space character
         beq  skip          * skip it
         leax -1,x          * adjust buffer pointer
         rts                * return
commons  bsr  echoon        * turn on echo
         bsr  echo          * print it
         bsr  input         * read line stdin
         leax iobuff,u      * point to buffer
         bsr  skip          * skip spaces
         rts                * return
getsta   leax status,u      * point to status structure
         ldd  #0            * SS.OPT
         os9  i$getstt      * get status
         lbcs exit          * exit on error
         rts                * return
setsta   os9  i$setstt      * set status
         lbcs exit          * exit on error
         rts                * return
echoon   bsr  getsta        * get status
         inc  eko,u         * turn on echo
         bra  setsta        * set status
shell    leay shellmsg,pcr  * point to SHELL ?
         bsr  commons       * print and get input
         clra               * clear size
         clrb               * of parameter area
         pshs u             * save data pointer
         tfr  x,u           * get parameter area
         tfr  d,y           * size of parameter area
shell2   leay 1,y           * calculate size of parameter area
         lda  ,x+           * get parameter character
         cmpa #cr           * reached end?
         bne  shell2        * no, get next
         clra               * language
         leax rshell,pcr    * module name
         os9  f$fork        * create new process
         lbcs fatal         * restore system if error
         os9  f$wait        * wait for child to die
         lbcs fatal         * restore system if error
         puls u             * get our data back
sheout   rts                * return
link     leay linkmsg,pcr   * LINK ?
         bsr  commons       * print and get input
         cmpa #cr           * any input?
         beq  sheout        * no, return
         cmpa #'.           * LINK sub-command Module Start
         beq  setlinke      * set instruction pointer there
         cmpa #'@           * LINK sub-command Module Execution
         beq  setlinkx      * set instruction pointer there
pelink   clra               * language
         pshs x             * save buffer
         pshs u             * save our data
         os9  f$link        * link to module
         lbcs lfatal        * restore system if error
         tfr  u,x           * get module header
         ldd  2,x           * get module size
         subd #3            * sub off crc bytes
         puls u             * get our data back
         stx  moduloc,u     * save module start
         sty  address,u     * set instruction pointer
         sty  linkaddr,u    * module entry point
         leay d,x           * module end address
         sty  endaddr,u     * save module end
         puls x             * get buffer back
         pshs x,u           * save buffer and our data
         os9  f$prsnam      * scan os9 name
         puls x,u           * get buffer and our data
         lbcs errmsg        * report any error
         pshs x,u           * save buffer and our data
         leay linknam,u     * point to any current module name
         os9  f$cmpnam      * are they linking to current module
         puls x,u           * get buffer and our data
         bcs  savlnam       * no, new linked module
         lda  linkcnt,u     * yes, get link count
         cmpa #on           * is it 255 or greater
         bhs  lnkout        * yes, don't link anymore
         inc  linkcnt,u     * else increment link count
lnkout   rts                * return
savlnam  pshs x             * save buffer
         clr  linkcnt,u     * reset link count
         leay linknam,u     * point to link module name
putkinam lda  ,x+           * get link module name
         cmpa #cr           * done?
         beq  sitit         * yes, skip rest
         sta  ,y+           * no, save it
         bra  putkinam      * loop do all
sitit    leay -1,y          * point to last character
         lda  ,y            * get it
         ora  #$80          * set most significant bit
         sta  ,y            * save it
         puls x,pc          * restore buffer and return
setlinkx ldy  linkaddr,u    * get linked module execution address
         sty  address,u     * set instruction pointer with it
         rts                * return
setlinke ldy  moduloc,u     * get linked module start address
         sty  address,u     * set instruction pointer with it
         rts                * return
unlink   lbsr echoon        * turn on echo
         tst  linkcnt,u     * check link count
         beq  notlink       * not linked
         dec  linkcnt,u     * decrement link count
         leay ulinkmsg,pcr  * point to unlink message
         lbsr echo          * print it
         pshs u             * save our data
         exg  u,x           * use x for data
         ldu  moduloc,x     * get address of module header 
         os9  f$unlink      * unlink it
         bcs  fatal         * restore system if error
         puls u             * get our data back
         rts                * return
notlink  leay notlkmsg,pcr  * point to not linked message
         lbsr echo          * print it
         rts                * return
fatal    puls u             * restore our data pointer
         lbra errmsg        * report error
lfatal   puls u             * restore our data pointer
         puls x             * restore the buffer pointer
         lbra errmsg        * report error
quit     leay exitmsg,pcr   * really quit message
         lbsr commons       * print it and get input
         ora  #sp           * make input lower case
         cmpa #'y           * really quit?
         beq  exexit        * yes, exit
         rts                * no, return
exexit   clrb               * no error
exit     os9  f$exit        * exit
help     lbsr echoon        * turn on echo
         leay helpmsg,pcr   * point to help message
         lbsr echo          * print it
         rts                * return
jump     leay jumpmsg,pcr   * point to START ADDRESS?
         lbsr commons       * print it and get input
pjump    leay address,u     * get caller address loccation
         sty  auxaddr,u     * save it for subroutine
         bsr  ejaddr        * change start address
         tstb               * any error?
         bne  adrerr        * yes, report error
         ldd  address,u     * no, get new instruction pointer
         std  paddress,u    * and save it here too
         tst  offsopt,u     * offsets on?
         bne  pjump1        * yes, calculate offset
         bra  pjump2        * no, hard address
pjump1   pshs d             * save instruction pointer
         ldd  moduloc,u     * get module start address
         addd ,s++          * add start to instruction pointer
         std  address,u     * save instruction pointer
pjump2   clrb               * no error
         rts                * return
ejaddr   cmpa #cr           * any address given?
         beq  addrerr       * no, need some input
         ldd  ,y            * get old instruction pointer
         std  saveadr,u     * save old instruction pointer
         clr  count         * reset error tester
         clrb               * clear result
         bsr  hexcalc       * calculate hex char into binary
         tst  count         * hexcalc error
         beq  addrerr       * yes, report error
         clr  count         * no, reset error tester
         bsr  hexcalc       * calculate hex char into binary
         tst  count         * hexcalc error
         beq  addrerr       * yes, report error
         stb  ,y+           * save high byte of address
         clr  count         * reset error tester
         clrb               * clear result
         bsr  hexcalc       * calculate hex char into binary
         tst  count         * hexcalc error
         beq  addrerr       * yes, report error
         clr  count         * reset error tester
         bsr  hexcalc       * calculate hex char into binary
         tst  count         * hexcalc error
         beq  addrerr       * yes, report error
         stb  ,y            * save low byte of address
         clrb               * no errors
         rts                * return
hexcalc  lda  ,x            * get ascii character
         cmpa #'0           * is it in range
         blo  jout          * no, return
         cmpa #'9           * is it decimal
         bls  makebin       * yes, make binary
         anda #%11011111    * no, make upper case
         cmpa #'A           * is it in range
         blo  jout          * no, return
         cmpa #'F           * is it hexadecimal
         bhi  jout          * no, return
         suba #7            * prepare hex digit into $3A...$3F
makebin  suba #'0           * make it binary by subtracting $30
         pshs a             * save binary value on stack
         lda  #16           * multiply by number base
         mul                * last binary result * number base
         addb ,s+           * get new result and pop a reg
         leax 1,x           * point to next hex digit
         inc  count         * flag no error
jout     rts                * return
addrerr  ldd  saveadr,u     * get saved address
         ldy  auxaddr,u     * get caller location
         std  ,y            * restore the old address
bckcall  clrb               * make a
         decb               * error number
         rts                * return
adrerr   tst  pcaller,u     * parameter caller?
         bne  bckcall       * yes, get error number and return
         leay prompt,pcr    * dasm: prompt
         lbsr echo          * print it
         leay adrmsg,pcr    * use hex digits message
         lbsr echo          * print it
         rts                * return
chngend  leay endadmsg,pcr  * point to END ADRESS?
         lbsr commons       * print it and get input
pchgend  leay endaddr,u     * get caller address loccation
         sty  auxaddr,u     * save it for subroutine
         bsr  ejaddr        * change end address
         tstb               * any error
         bne  adrerr        * yes, report error
         ldd  endaddr,u     * no, get end address
         std  pendaddr,u    * save it here
         tst  offsopt,u     * offset option on
         bne  pchg1         * yes, calculate offset
pchg     clrb               * no, error
         rts                * return
pchg1    pshs d             * save for calculate function
         ldd  moduloc,u     * get module start
         addd ,s++          * add start to end
         std  endaddr,u     * save it
         bra  pchg          * return no error
setmode  leay getmode,pcr   * point to MODE ?
         lbsr commons       * print it and get input
         pshs u             * save our data
         leau mode,u        * set to mode for
         bsr  onoff         * on/off subroutine
         puls u             * restore data
tellmode leay prompt,pcr    * point to dasm: prompt
         lbsr echo          * print it
         tst  mode          * is automode on
         bmi  pmon          * yes, skip ahead
         leay modemsg2,pcr  * no, point to AUTO OFF
         bra  pmode         * skip ahead
pmon     leay modemsg1,pcr  * point to AUTO ON
pmode    lbsr echo          * print it
         rts                * return
printer  leay prtermsg,pcr  * point to PRINTER ?
         lbsr commons       * print it and get input
         pshs u             * save our data
         leau pflag,u       * set to printer for
         bsr  onoff         * on/off subroutine
         puls u             * restore data
tellprt  leay prompt,pcr    * point to dasm: prompt
         lbsr echo          * print it
         tst  pflag         * is printer mode on
         bmi  ponm          * yes, skip ahead
         leay scrmsg,pcr    * no, point to PRINTER OFF
         bra  pp            * skip ahead
ponm     leay prtmsg,pcr    * point to PRINTER ON
pp       lbsr echo          * print it
         rts                * return
onoff    cmpa #'+           * turn it on
         beq  iton          * yes, skip ahead
         cmpa #'-           * turn it off
         bne  exonoff       * no, skip ahead
         clr  ,u            * yes, turn caller off
         bra  exonoff       * skip ahead
iton     lda  #on           * get on
         sta  ,u            * turn caller on
exonoff  rts                * return
bcom     leay buffmsg,pcr   * point to BUFF ?
         lbsr commons       * print it and get input
         cmpa #cr           * any input
         beq  tellb         * no, tell BUFF +/-
         cmpa #'.           * BUFF sub-command module start
         beq  buffe         * yes, handle command
         cmpa #'@           * BUFF sub-command module execution
         beq  buffx         * yes, handle command
         tfr  a,b           * save BUFF sub-command character
         orb  #sp           * make it lower case
         cmpb #'c           * clear buffer
         beq  clsbuff       * yes, handle command
         cmpb #'l           * list buffer
         beq  list          * yes, handle command
         pshs u             * save our data
         leau bflag,u       * point to caller flag for on/off
         bsr  onoff         * turn buffer on or off
         puls u             * get our data back
tellb    leay prompt,pcr    * point dasm: prompt
         lbsr echo          * print it
         tst  bflag         * is buffer on
         bmi  bonm          * yes, report
         leay buff1,pcr     * no, point to BUFF OFF
         bra  bmexit        * skip ahead
bonm     leay buff2,pcr     * point to BUFF ON
bmexit   lbsr echo          * print it
         rts                * return
time     tst  listflg,u     * are we listing buffer
         beq  timeout       * no, return
         ldx  #$3FFF        * count value
timel    leax -1,x          * waste some
         bne  timel         * time
timeout  rts                * return
list     lda  #on           * get flag for listing buffer
         sta  listflg,u     * save it for time
         bsr  listbuff      * list text from buffer
         clr  listflg,u     * clear list flag
         rts                * return
buffe    leay buffer,u      * point to buffer start
         bra  buffex        * skip ahead
buffx    ldy  xaddress,u    * get buffer module execution address
buffex   sty  address,u     * save it as next instruction pointer
         rts                * return
clsbuff  leax buffer,u      * point to buffer start
         pshs x             * save it
clsloop  clr  ,x+           * clear byte of buffer
         cmpx pointer,u     * reached end of current buffer pointer
         blo  clsloop       * no, clear rest
         puls x             * get buffer pointer back
         stx  pointer,u     * save it as current buffer pointer
         clr  counter,u     * clear buffer line
         clr  1+counter,u   * counter
         clr  mode          * clear mode flag to off
         clr  bflag         * and buff flag to off
         rts                * return
listbuff ldx  counter,u     * get line counter
         cmpx #0            * any lines to list
         beq  listout       * no, return
         pshs x             * yes, save counter
         leay buffer,u      * point to buffer
         bra  lbl1          * skip ahead
lbloop   puls y             * get buffer pointer back
lbl0     lda  ,y+           * loop through looking for
         bne  lbl0          * next line
lbl1     pshs y             * save buffer pointer
         lbsr echo          * print current line
         bsr  time          * wait some
         ldx  counter,u     * get line counter
         leax -1,x          * decrement it
         stx  counter,u     * save it
         cmpx #0            * did all lines
         bne  lbloop        * no, do next line
         puls y             * reset stack
         puls x             * get line counter back
         stx  counter,u     * save it
listout  rts                * return
back     lbsr echoon        * turn on echo
         clr  mode          * clear mode flag to off
         leax iobuff,u      * point to buffer
         ldd  address,u     * get instruction pointer
         subd #1            * subtract 1 from it
         tfr  d,y           * put it in instruction pointer
         tst  offsopt,u     * is offsets on
         beq  back2         * no, skip ahead
         lbsr setoffs       * yes, turn on offset flag for outhex2
back2    lbsr outhex2       * output a address to buffer
         lbra next          * decide what to do with io buffer
ascii    lbsr echoon        * turn on echo
ascii2   clr  mode          * clear mode flag to off
         leax iobuff,u      * point to buffer
         ldd  address,u     * get instruction pointer address
         tfr  d,y           * put it in d register
         tst  offsopt,u     * are offsets on
         beq  ascii3        * no, skip ahead
         lbsr setoffs       * yes, turn on offset flag for outhex2
ascii3   lbsr outhex2       * output a address to buffer
         lbsr space1        * and a space character
         ldb  ,y+           * get byte at instruction pointer
         pshs b             * save it
         lbsr outhex1       * output hex value of byte
         lbsr space2        * and two space characters
         puls b             * get byte back
         cmpb #'z+1         * is it printable
         bhs  dot           * no, print a dot
         cmpb #sp           * is it still printable
         blo  dot           * no, print a dot
         stb  ,x+           * yes, save it in buffer
         lbra next          * decide what to do with io buffer
dot      ldb  #'.           * get a dot character
         stb  ,x+           * save it in buffer
         lbra next          * decide what to do with io buffer
read     leay fname,pcr     * point to FILENAME ?
         lbsr commons       * print it and get input
         cmpa #cr           * any input
         beq  readout       * no, return
         lda  #exec.+read.  * file mode
         os9  i$open        * open file
         lbcs errmsg        * report any error
         sta  dpath         * save path
         bsr  moduread      * read the module into buffer
         bsr  moduadrs      * set up module addresses
         clr  bflag         * clear buff flag to off
         clr  mode          * clear mode flag to off
readout  rts                * return
moduread leax buffer,u      * point to buffer
         ldy  #buffsiz      * get buffer size
         os9  i$read        * read module
         bcs  chkeof        * if error check eof
         lda  dpath         * get path
         os9  i$close       * close module
         rts                * return
chkeof   cmpb #e$eof        * is error a eof
         lbne errmsg        * no, report error
         lda  dpath         * yes, get path
         os9  i$close       * close module
         lbcs errmsg        * report any error
         rts                * return
moduadrs leax buffer,u      * point to buffer start
         stx  moduloc,u     * save it as module location
         ldd  2,x           * get module size
         subd #3            * subtract off crc bytes
         leay d,x           * find module end
         sty  endaddr,u     * save it
         ldd  9,x           * find module execution address offset
         leay d,x           * add it to module start
         sty  address,u     * save it as instruction pointer
         sty  xaddress,u    * save it here too
         rts                * return
write    leay fname,pcr     * point to FILENAME ?
         lbsr commons       * print it and get input
         lda  ,x            * get input character
         cmpa #cr           * any input
         beq  writout       * no, return
         cmpa #'*           * create a new file
         beq  makefile      * yes, skip ahead to makefile
         bra  openfile      * no,  skip ahead to openfile
makefile leax 1,x           * adjust filename pointer
         lbsr skip          * skip leading white space
         lda  ,x            * get a filename character
         cmpa #cr           * any pathlist
         beq  writout       * no, return
         lda  #updat.       * file mode
         ldb  #$0B          * attributes
         os9  i$create      * create file
         lbcs errmsg        * report any error
         sta  dpath         * save the path
         bsr  outdisk       * list buffer to path
outwrit  lda  dpath         * get path again
         os9  i$close       * close the file
         lbcs errmsg        * report any error
         clr  mode          * clear mode flag to off
         clr  bflag         * clear buff flag to off
writout  rts                * return
openfile lda  #updat.       * file mode
         os9  i$open        * open file
         lbcs errmsg        * report any error
         sta  dpath         * save the path
         bsr  seek          * seek to end of file
         bsr  outdisk       * list buffer to path
         bra  outwrit       * return
seek     pshs u             * save data
         lda  dpath         * get path
         ldb  #$02          * current file size
         os9  i$getstt      * get file size
         lbcs fatal         * restore system if error
         os9  i$seek        * seek to end of file
         lbcs fatal         * restore system if error
         puls u             * restore our data
         rts                * return
chkbuff  ldx  pointer,u     * get current buffer pointer
         cmpx endbuff,u     * has it reached the end of the buffer
         bhs  outb2         * yes, report error and return 
         leay iobuff,u      * no, point to the io buff
bufloop  lda  ,y+           * get a character from it
         sta  ,x+           * save it at the current buffer pointer
         beq  bnl           * moved them all so skip ahead
         bra  bufloop       * else continue getting characters
bnl      leay pointer,u     * point to pointer address
         stx  ,y            * save new current pointer there
         ldx  counter,u     * get line counter
         leax 1,x           * increment it
         stx  counter,u     * save it
         rts                * return
outb2    leay prompt,pcr    * point to dasm: prompt
         lbsr echo          * print it
         leay bfull,pcr     * point to BUFFER FULL
         lbsr echo          * print it
         clr  bflag         * clear buff flag to off
         clr  mode          * clear mode flag to off
         rts                * return
outdisk  lda  dpath         * get file path
         ldb  path          * get stdout path
         sta  path          * save file path
         stb  dpath         * save stdout path
         lbsr listbuff      * list the buffer
         lda  path          * get file path
         ldb  dpath         * get stdout path
         sta  dpath         * save file path
         stb  path          * save stdout path
         rts                * return
branch   lbsr echoon        * turn on echo
         ldx  curstack,u    * get the current stack pointer
         cmpx lststack,u    * have we reached the end of stack
         beq  nomove        * yes, push no more addresses
         ldy  address,u     * no, get instruction pointer
         sty  ,x++          * save it on the stack
         stx  curstack,u    * save current stack pointer
         ldx  branchad,u    * get the branch address
         stx  address,u     * make instruction pointer there
         lbra ddentry       * disassemble branch address and return
nomove   leay stackms1,pcr  * point to ADDRESS STACK FULL
nomove1  lbsr echo          * print it
         rts                * return
return   lbsr echoon        * turn on echo
         ldx  curstack,u    * get current stack pointer
         cmpx firstack,u    * is this stack top
         bhi  yesmove       * no, pop return address
         leay stackms2,pcr  * yes, point to ADDRESS STACK EMPTY
         bra  nomove1       * print it and return
yesmove  ldy  ,--x          * pop return address off stack
         stx  curstack,u    * save current stack pointer
         sty  address,u     * make return the current address
         lbra ddentry       * disassemble current address and return
         leay stackms2,pcr  * NOTE: you can safely delete this
         lbsr echo          * NOTE: and this instruction
         rts                * NOTE: this one too! I think?
offscom  leay offsmsg,pcr   * point to OFFSETS ?
         lbsr commons       * turn on echo print it and get input
         pshs u             * save our data pointer
         leau offsopt,u     * point to caller's flag for on/off
         lbsr onoff         * turn offsets on or off
         puls u             * get data pointer back
telloffs leay prompt,pcr    * point to dasm: prompt
         lbsr echo          * print it
         tst  offsopt,u     * test if offsets are on
         bmi  offson        * yes, skip ahead to offson
         leay offsmsg2,pcr  * no, point to OFFSETS OFF
         bra  offsmode      * skip ahead
offson   leay offsmsg1,pcr  * point to OFFSETS ON
offsmode lbsr echo          * print it
         rts                * return
gimicom  leay gimimsg,pcr   * point to GIMI ?
         lbsr commons       * turn on echo print it and get input
         clr  gimicnt,u     * clear gimi count
         leay gimidat,u     * point to gimi dat image
gimiloop lda  ,x+           * get input character
         cmpa #cr           * end of input
         beq  gimichk       * yes, check input
         cmpa #sp           * is it a space char
         beq  gimiloop      * yes, get next input char
         cmpa #',           * is it a coma char
         beq  gimiloop      * yes, get next input char
         leax -1,x          * must be a hex digit
         clr  count         * clear bad hex digit
         clrb               * binary result
         lbsr hexcalc       * make it binary
         tst  count         * hex digit ok
         beq  gimibad       * no, report bad
         clr  count         * clear bad hex digit
         lbsr hexcalc       * make it binary
         tst  count         * hex digit ok
         beq  gimibad       * no, report bad
         cmpb #mask         * result within range
         bls  nologic       * yes, skip ahead
         orb  #mask         * no, make result
         andb #mask         * stay in range
nologic  stb  ,y+           * put result into gimi dat image
         inc  gimicnt,u     * increment the gimi count
         ldb  #pagenum      * get total gimi pages allowed
         cmpb gimicnt,u     * have we reached number of pages allowed
         bne  gimiloop      * no, get another hex number input
gimichk  tst  gimicnt,u     * yes, did we successfuly program all the images
         beq  gimiprt       * yes, skip ahead to show gimi prompt and return
         clra               * no, clear the
         clrb               * memory size result
gimiloo  addd #pagesiz      * add a page size to result
         dec  gimicnt,u     * decrement the gimi count
         bne  gimiloo       * still get another image
         leay gimidat,u     * point to the gimi dat image
         exg  d,y           * d = dat image pointer y = byte count
         ldx  #0            * offset in block to begin copy
         pshs u             * save our data pointer
         leau buffer,u      * caller destination buffer
         swi2               * os9
         fcb  $1B           * F$CpyMem
         lbcs fatal         * restore system if error
         puls u             * get our data back
gimiprt  leay buffer,u      * get the instruction pointer
         sty  address,u     * save it
         leay prompt,pcr    * point to dasm: prompt
         lbsr echo          * print it
         lbra ascii2        * jump into ascii command
gimibad  leay prompt,pcr    * point to dasm: prompt
         lbsr echo          * print it
         ldb  turn,u        * get message turn
         eorb #on           * check who's turn
         stb  turn,u        * save it
         beq  nxturn        * skip ahead to my turn
         leay gimimsg1,pcr  * no my turn
gbadout  lbsr echo          * print it
         rts                * return
nxturn   leay gimimsg2,pcr  * my turn
         bra  gbadout       * print it and return
init     ldb  #100          * clear 100 bytes starting at dpath
         leax dpath,u       * point to dpath
initloop clr  ,x+           * clear byte adjust pointer
         decb               * decrement the count
         bne  initloop      * loop until counted all
         leax buffer,u      * get the buffer pointer
         stx  pointer,u     * save it as pointer
         ldd  #buffsiz      * get buffer size
         leay d,x           * calculate end of buffer
         sty  endbuff,u     * save it as endbuff
         ldd  #$FFEF        * get reasonable end address
         std  endaddr,u     * save it as endaddr
prgmdat  lda  #mask         * get top page allowed
         ldb  #8            * get 8 gimi dat registers
         leay gimidat,u     * point to gimi dat image
prgdatlp sta  ,y+           * save page in gimi dat image
         deca               * decrement top page allowed
         decb               * decrement dat registers count
         bne  prgdatlp      * program another gimi dat register
         lda  #on           * get on
         sta  turn,u        * save it in who's turn
         leay dasmmsg,pcr   * point to dasm
         leax linknam,u     * save it for link name
stuff1   lda  ,y+           * get dasm message char
         sta  ,x+           * save it at linknam
         bne  stuff1        * do the whole message
initstak leax adrstack,u    * get address stack top
         stx  curstack,u    * save it as current stack pointer
         stx  firstack,u    * and save it as first stack address
         ldd  #stacksz      * get the stack size
         leay d,x           * calculate end of stack
         sty  lststack,u    * save it as last stack address
         rts                * return
setoffs  pshs a             * save work reg
         lda  #on           * get on
         sta  offsflg,u     * save it in offset flag
         puls a             * restore reg
         rts                * return
dentry   lbsr echoon        * turn on echo
ddentry  ldy  address,u     * get the instruction pointer
         leax iobuff,u      * buffer to disassemble to
         pshs y             * save instruction pointer
         ldd  ,s            * get it into the d register
         tst  offsopt,u     * are offsets turn on
         beq  dentry2       * no, skip ahead
         bsr  setoffs       * set offset flag on 
dentry2  lbsr outhex2       * output the address
         lbsr space1        * output a space char
         puls y             * get instruction pointer
         ldb  ,y+           * get instruction opcode
         tfr  b,a           * put a copy in the a too
         bita #$80          * is this opcode $80-$FF
         lbmi grp80         * yes, jump to handle $80-$FF
         anda #$F0          * check for opcodes below $80
         lbeq grp0          * if opcode is $00-$0F jump there
         cmpa #$10          * is the opcode between $10-$1F
         lbeq grp10         * yes, jump there
         cmpa #$20          * is the opcode $20-$2F
         lbeq grp20         * yes, jump there
         cmpa #$30          * is the opcode $30-$3F
         lbeq grp30         * yes, jump there
         cmpa #$60          * is the opcode $60-$6F
         lbeq grp60         * yes, jump there
         cmpa #$70          * is the opcode $70-$7F
         lbeq grp70         * yes, jump there
         pshs b             * save the opcode which is inherent addressing
         pshs y             * save the instruction pointer
         andb #$0F          * else opcode is $4x-$5x find first part
         lbsr set           * of instruction $00-$0F and put in buffer
         puls y             * get instruction pointer back
         puls b             * and opcode which is inherent addressing
         andb #$F0          * only care about the $4x or $5x part
         cmpb #$50          * is the opcode $5x
         beq  grp50         * yes, skip ahead
         lda  #'a           * no, it is $4x which means the a register
         bra  save          * add it too the end of the first part
grp50    lda  #'b           * it is $5x which means the b register
save     sta  ,x+           * save it in the buffer
next     sty  address,u     * save instruction pointer
         lbsr crlf          * put a crlf in the buffer
options  tst  pflag         * should we print
         beq  chkdisk       * no, check disk
         bsr  hardprt       * yes, jump to hard print 
chkdisk  tst  bflag         * is the buffer flag on
         beq  chkauto       * no, skip ahead
         bsr  diskwrt       * yes, see if buffer full
chkauto  tst  mode          * is auto mode on
         bmi  automat       * yes, skip ahead
         rts                * no, return 
automat  ldd  address,u     * get current instruction pointer
         cmpd endaddr,u     * have we reached the end of the module
         lblo ddentry       * no, disassmble next address
         rts                * yes, return
hardprt  leax pmsg,pcr      * point to address of pathlist
         lda  #write.       * file mode
         os9  i$open        * open the printer
         bcc  hard          * if success skip ahead
         cmpb #246          * elseif device not ready
         beq  hardprt       * loop until device is ready
         lbra errmsg        * else report the error and return
hard     sta  dpath         * save printer path
hard1    lda  dpath         * get printer path
         leax iobuff,u      * point to io buffer
         ldy  #stacksz      * get buffer size
         os9  i$writln      * write the line to the printer
         bcc  hardout       * if success skip ahead
         cmpb #246          * if device not ready
         beq  hard1         * try again
         lbra errmsg        * else report error and return
hardout  lda  dpath         * get the printer path
         os9  i$close       * close the path
         lbcs errmsg        * report any error
         rts                * return
diskwrt  lbsr chkbuff       * put iobuff into buffer
         rts                * return
params   ldb  #1            * get stdout path
         stb  path          * save it
         pshs x             * save parameters
         lbsr init          * initialize system
         puls x             * get parameters back
         ldb  #on           * get on
         stb  mode          * turn mode on
         stb  pcaller,u     * let system know parameter caller
getparm  lbsr skip          * skip leading white space
         lda  ,x+           * get parameter character
         cmpa #'-           * option specified
         lbne syntax        * no, show useage and exit
         lbsr skip          * skip white space
         lda  ,x+           * get the option
         ora  #sp           * make it lower case
         cmpa #'o           * offsets
         bne  chkend        * no, see if something else 
         bsr  chksub        * yes, get on
         stb  offsopt,u     * turn on offsets
         bra  getparm       * get next parameter
chkend   cmpa #'e           * end address specified
         bne  chkstart      * no, see if something else
         lbsr skip          * skip white space
         lbsr pchgend       * change end address 
         tstb               * error while changing it
         lbne syntaxa       * yes, show usage, address usage and exit
         bsr  chksub        * no, get on
         stb  peflg,u       * flag parameter end address has changed
         bra  getparm       * get next parameter
chkstart cmpa #'s           * start address
         lbhi syntax        * no, show usage and exit
         bne  chkmem        * no, see if hard address
         lbsr skip          * yes, skip white space
         lbsr pjump         * change start address
         tstb               * error while changing it
         lbne syntaxa       * yes, show usage, address usage and exit
         bsr  chksub        * no, get on
         stb  psflg,u       * flag parameter start address has changed
         bra  getparm       * get next parameter
chksub   clrb               * clear the b reg
         decb               * turn the b reg on
         rts                * return
chkmem   cmpa #'m           * memory address
         bne  chkread       * no, see if read module
         bra  penter        * yes, enter system
chkread  cmpa #'r           * read module into buffer
         beq  inputr        * yes, handle it
         cmpa #'l           * link to module in memory
         lbne syntax        * no, show usage and exit
         lbsr skip          * skip white space
         bsr  psnam         * parse os9 name
         clra               * language
         pshs x,u           * save module name and data
         os9  f$link        * test link to module
         bcs  pfatal        * restore and exit on error
         puls x,u           * get module name and data
         bsr psnam          * parse os9 name
         lbsr pelink        * link to module
         bra  penter        * enter system
pfatal   puls x,u           * restore the system
         lbra pexit         * exit with no error
psnam    pshs x             * save module name pointer
         lda  #'/           * get path seperator
         cmpa ,x            * path specified
         beq  skip2         * yes, parse os9 name
         leax -1,x          * no, point 1 before module name
         sta  ,x            * save path seperator
skip2    os9  f$prsnam      * did we find module
         bcs  syntax        * no, show usage and exit
         lda  #cr           * yes, get carriage return
         sta  ,y            * mark end of module name
         puls x             * get module name pointer back
         rts                * return
inputr   lbsr skip          * skip leading white space
         lda  ,x            * get module name's first character
         cmpa #cr           * is it a carriage return
         beq  syntax        * yes, show usage and exit
         lda  #exec.+read.  * file mode
         os9  i$open        * open the file
         bcs  pexit         * exit if error
         sta  dpath         * save file path
         lbsr moduread      * read the module into the buffer
         lbsr moduadrs      * set up the modules addresses
penter   tst  psflg,u       * did they specify a start address
         beq  pent10        * yes, skip ahead
         tst  offsopt,u     * are offsets turned on
         bne  pent05        * yes, skip ahead to set offsets
         ldd  paddress,u    * get module execution start address
         std  address,u     * save it as current instruction pointer
         bra  pent10        * skip ahead to test for end address
pent05   ldd  paddress,u    * get module execution start address
         pshs d             * save it for calculation
         ldd  moduloc,u     * get the start of the module
         addd ,s++          * add module start and execution address
         std  address,u     * save it as current instruction pointer
         bra  pent10        * skip ahead
pent20   lbsr ddentry       * disassembly the module
         bra  pnoerr        * exit with no error
pent10   tst  peflg,u       * did they specify a end address
         beq  pent20        * no, disassemble the module
         tst  offsopt,u     * did they specify offsets
         bne  pent15        * yes, skip ahead
         ldd  pendaddr,u    * no, get specified end address
         std  endaddr,u     * save it as the end address
         bra  pent20        * disassemble the module
pent15   ldd  pendaddr,u    * get specified end address
         pshs d             * save it for calculation
         ldd  moduloc,u     * get module start address
         addd ,s++          * add start address to the end
         std  endaddr,u     * save it as the end address
         bra  pent20        * disassemble the module
syntax   leay usemsg,pcr    * point to usage message
syntax1  lbsr echo          * print it
         bra  pnoerr        * exit no error
syntaxa  leay usemsg,pcr    * point to usage message
         lbsr echo          * print it
         leay adrmsg,pcr    * point to USE [HEX DIGITS]
         bra  syntax1       * print it and exit no error
pexit    lda  #2            * get stderr path
         os9  f$perr        * print the error
pnoerr   clrb               * clear error
         os9  f$exit        * exit
grp0     pshs y             * save instruction pointer
         bsr  set           * get instruction and put in buffer
         bsr  space2        * put two space chars in buffer
g00      bsr  dsign         * put direct addressing sign in buffer
g01      puls y             * get instruction pointer
         ldb  ,y+           * get byte immediatialy following opcode
         lbsr outhex1       * make byte ascii and put it in buffer
         lbra next          * decide what to do with io buffer
grp20    bsr  sub20         * get the branch instruction into the buffer
g20      bsr  space2        * put two space chars in buffer
         ldb  ,y+           * get relative offset byte
         sex                * sign extend it into a word
         lbra sbr           * calculate offset address and return
sub20    pshs y             * save instruction pointer
         leay table2,pcr    * point to opcodes $20-$2F
         lda  #4            * 4 bytes in each table field
         bsr  match         * find the match
         deca               * 3 chars in the instruction
         bsr  put           * put instruction in the buffer
         puls y             * get instruction pointer
         rts                * return
grp70    andb #$0F          * opcodes are $00-$0F extended addressing
         pshs y             * save instruction pointer
         bsr  set           * get and save the instruction
         bsr  space2        * get and save two space chars
g70      bsr  esign         * get and save a extended addressing sign
g71      puls y             * get the instruction pointer back
         ldd  ,y++          * get the extended address
         bsr  outhex2       * make it ascii and put in the buffer
         lbra next          * decide what to do with io buffer
set      leay table1,pcr    * point to table1 opcodes $00-$0F
         lda  #4            * 4 bytes in a table1 field
         bsr  match         * find the match
         deca               * 3 characters in the instruction
         bsr  put           * put them in the buffer
         rts                * return
match    cmpb ,y            * is this a match
         beq  itis          * yes, it is
         leay a,y           * no, point to next field
         bra  match         * check for match again
itis     leay 1,y           * point to the instructions chars
         rts                * return
space2   ldd  #$2020        * get two space chars
         std  ,x++          * save them in the buffer
         rts                * return
space1   lda  #$20          * get one space char
         sta  ,x+           * save it in the buffer
         rts                * return
dsign    lda  #$3C          * get direct addressing sign '<
         sta  ,x+           * save it in the buffer
         rts                * return
esign    lda  #$3E          * get extended addressing sign '>
         sta  ,x+           * save it in the buffer
         rts                * return
minus    lda  #'-           * get a minus sign
         sta  ,x+           * save it in the buffer
         rts                * return
put      ldb  ,y+           * get char increment y reg
         stb  ,x+           * put char increment x reg
         deca               * decrement the count
         bne  put           * loop until count is zero
         rts                * return
coma     lda  #',           * get a coma sign
         sta  ,x+           * put it in the buffer
         rts                * return
outhex2  tst  offsflg,u     * are the offsets on
         beq  outhex3       * no, skip ahead
         clr  offsflg,u     * yes, clear the flag
         cmpd moduloc,u     * is address less then module start
         blo  outhex3       * yes, skip rest
         cmpd endaddr,u     * is address greater then end address
         bhi  outhex3       * yes, skip rest
         subd moduloc,u     * subtract the address from module start
outhex3  exg  a,b           * output high byte first
         bsr  outhex1       * make it ascii and put in buffer
         tfr  a,b           * output low byte next
outhex1  pshs b             * save address byte
         andb #$F0          * do high nibble first
         lsrb               * shift it
         lsrb               * shift it
         lsrb               * shift it
         lsrb               * to the lower nibble
         bsr  v1            * make digit ascii
         puls b             * get address byte back
         andb #$0F          * do low nibble next
v1       cmpb #9            * is it decimal
         bls  v2            * yes, skip next
         addb #7            * make it hex
v2       addb #$30          * make it ascii
         stb  ,x+           * save it in the buffer
         rts                * return
grp60    andb #$0F          * first part of instruction starts with $00-$0F
         pshs y             * save the instruction pointer
         lbsr set           * get and save the first part of instruction
         lbsr space2        * get and save two white space characters
         puls y             * get the instruction pointer back
         ldb  ,y+           * get the postop byte
         lbsr index         * go handle the index addressing mode
         lbra next          * decide what to do with io buffer
grp10    pshs y             * save the instruction pointer
         cmpb #$10          * does this instruction opcode is $10
         lbeq s10           * yes, jump there
         cmpb #$12          * is this instruction a nop
         lblo s11           * no, this instructions opcode is $11
         beq  grp12         * yes, jump there
         cmpb #$13          * is this a sync instruction
         beq  grp13         * yes, jump there
         cmpb #$19          * is this a daa instruction
         lblo grpsb         * no, check for a long branch instruction
         beq  grp19         * yes, jump there
         cmpb #$1D          * is this sex instruction
         blo  grpccr        * no, check condition code instruction
         beq  grpsex        * yes, jump there
         lda  #5            * else 5 chars in the instruction
         cmpb #$1F          * is it a tfr instruction?
         beq  grp1f         * yes, skip ahead
         leay rexg,pcr      * no, it is a exg instruction
n1e      lbsr put           * put instruction into buffer
         puls y             * get instruction pointer back
         ldb  ,y+           * get the register id byte
         pshs y             * save new instruction pointer
         pshs b             * save register id byte
         andb #$F0          * save upper nibble
         lsrb               * shift it
         lsrb               * shift it
         lsrb               * shift it
         lsrb               * into lower nibble
         bsr  readreg       * calculate the SSSS register
         lda  #',           * put a coma to seperate
         sta  ,x+           * into the buffer
         puls b             * get the register id back
         andb #$0F          * save lower nibble
         bsr  readreg       * calculate the DDDD register
         puls y             * get instruction pointer back
         lbra next          * decide what to do with io buffer
grp1f    leay rtfr,pcr      * tfr instruction
         bra  n1e           * decode SSSS,DDDD registers
readreg  tfr  x,y           * get buffer pointer into y
         leax rbyte,pcr     * point to rbyte structure
loop2    cmpb ,x            * found a register?
         beq  gotit         * yes, skip ahead
         leax 3,x           * no, adjust field pointer
         bra  loop2         * look again
gotit    ldb  1,x           * get offset to register
         tst  2,x           * should we get one or two?
         abx                * add offset to x register
         bmi  get2          * yes, get two bytes
         ldb  ,x            * no,  get one byte
         stb  ,y+           * save it in buffer
         bra  rout          * restore and return
get2     ldd  ,x            * save two bytes
         std  ,y++          * in buffer
rout     tfr  y,x           * update buffer pointer
         rts                * return
grp12    leay rnop,pcr      * point to nop instruction
         bra  out10a        * skip ahead
grp13    leay rsync,pcr     * point to sync instruction
         lda  #4            * 4 characters in instruction
         bra  out10b        * skip ahead
grp19    leay rdaa,pcr      * point to daa instruction
         bra  out10a        * skip ahead
grpsex   leay rsex,pcr      * point to sex instruction
out10a   lda  #3            * 3 characters in instruction
out10b   lbsr put           * put them in the buffer
         puls y             * get instruction pointer
         lbra next          * decide what to do with io buffer
grpccr   cmpb #$1A          * is this orcc instruction
         bne  grp1c         * no, skip ahead to andcc instruction
         leay rorcc,pcr     * point to orcc instruction
outccr   lda  #7            * 7 characters in instruction
         lbsr put           * put them in the buffer
         lbra g01           * handle immediate byte get next instruction
grp1c    leay randcc,pcr    * point to andcc instruction
         bra  outccr        * skip back into group logic
grpsb    cmpb #$16          * is this a lbra instruction
         bne  grp17         * no, must be a lbsr instruction  
         leay rlbra,pcr     * point to lbra instruction
sbout    lda  #5            * 5 characters in instruction
         lbsr put           * put them into the buffer
lbr      puls y             * get instruction pointer
         ldd  ,y++          * get 16 bit offset and adjust pointer
sbr      pshs y             * save the instruction pointer
         addd ,s            * add offset to the instruction pointer
         std  branchad,u    * save the branch address
         tst  offsopt,u     * are offsets on
         beq  srb2          * no, skip ahead
         lbsr setoffs       * yes, set offset flag on
srb2     lbsr outhex2       * make branch address ascii put in buffer
         puls y             * get instruction pointer back
         lbra next          * decide what to do with io buffer
grp17    leay rlbsr,pcr     * point to lbsr instruction
         bra  sbout         * skip back into group logic
grp30    pshs y             * save instruction pointer
         cmpb #$38          * is the opcode $39-$3F
         bhi  rest30        * yes, skip ahead to this group
         cmpb #$34          * is this a push or pull instruction
         lblo lea30         * no, must be a lea instruction
         tfr  b,a           * save instruction opcode byte
         lsrb               * is this a push instruction
         bcc  push          * yes, skip ahead to push
         leay  pull,pcr     * no, point to pull instruction
         bsr  puss          * add u or s register put them in buffer
         puls y             * get instruction pointer back
         ldb  ,y+           * get pull registers order adjust pointer
         pshs y             * save the adjusted instruction pointer
         leay order2,pcr    * point to pull register order table
         lda  #8            * 8 registers in the pull order
loop3    lsrb               * shift register bit into carry for pull
         bsr  tstbit        * put register and seperator in buffer
         deca               * decrement registers count
         bne  loop3         * check next register bit
         bra  out30         * get instruction pointer get next instruction
push     leay pshr,pcr      * point to push instruction
         bsr  puss          * add u or s register put them in buffer
         puls y             * get instruction pointer back
         ldb  ,y+           * get push registers order adjust pointer
         pshs y             * save instruction pointer
         leay order1,pcr    * point to push register order table
         lda  #8            * 8 registers in push order
loop4    lslb               * shift register bit into carry for push
         bsr  tstbit        * put register and seperator in buffer
         deca               * decrement registers count
         bne  loop4         * check next register
         bra  out30         * get instruction pointer get next instruction
tstbit   bcs  tst30         * this register bit is valid
         leay 2,y           * else skip to next field
         rts                * return
tst30    pshs d             * save work register
         ldd  ,y++          * get the field
         tsta               * is it a 1 char register name
         bmi  clrp          * yes, save the one ascii char
         std  ,x++          * no, save the two ascii chars
sep      lda  #',           * get a seperator ascii char
         sta  ,x+           * save it in the buffer
         puls d             * get work register back
         rts                * return
clrp     stb  ,x+           * save the on ascii register char
         bra  sep           * skip back to save a seperator
puss     pshs a             * save the instruction opcode
         lda  #3            * 3 characters in the instruction 
         lbsr put           * put them into the buffer
         puls b             * get the instruction opcode back
         bsr  usreg         * get u or s put them in buffer
         rts                * return
usreg    andb #$02          * is it the s register
         bne  rureg         * no, skip to u register
         lda  #'s           * get a 's
pit      sta  ,x+           * save it in buffer
         lda  #$20          * get a space char
         sta  ,x+           * save it in buffer
         rts                * return
rureg    lda  #'u           * get a 'u
         bra  pit           * skip into save it
out30    puls y             * get instruction pointer
         leax -1,x          * adjust the buffer pointer
         lbra next          * decide what to do with io buffer
rest30   cmpb #$3C          * is this a cwai instruction
         beq  ccwait        * yes, skip to it
         leay table3,pcr    * point to table of $39-$3F instructions
         lda  #4            * 4 bytes in each field 
         lbsr match         * find the instruction
         deca               * 3 characters in the instruction
         lbsr put           * put them in the buffer
         puls y             * get the instruction pointer back
         lbra next          * decide what to do with io buffer
ccwait   leay rccwai,pcr    * point to the cwai instruction
         lda  #6            * 6 characters in the instruction
         lbsr put           * put them in the buffer
         lbra g01           * handle immediate byte and get next instruction
lea30    leay rlea,pcr      * the load effective address instruction 
         lda  #3            * 3 characters in instruction
         pshs b             * save opcode byte
         lbsr put           * put instruction in the buffer
         puls a             * get the opcode back
         clrb               * clear register count
         anda #$0F          * only concerned with register
         pshs a             * save it on the stack
loop5    cmpb ,s            * is it this register
         beq  dpit          * yes, we found it and we are done
         incb               * no, point to next register
         bra  loop5         * continue looking for the register
dpit     pshs x             * got the correct register so save buffer
         leax lregr,pcr     * point to "xysu" lea registers
         abx                * add offset to one of "xysu"
         lda  ,x            * get the lea register, one of "xysu"
         puls x             * get the buffer pointer back
         sta  ,x+           * save the lea register, one of "xysu"
         lbsr space1        * put a space character in the buffer
         puls a             * fix the stack pointer
dpit1    puls y             * get the instruction pointer
         ldb  ,y+           * get the postop byte
         bsr  index         * calculate the index mode
         lbra next          * decide what to do with io buffer
index    pshs b             * save the postop byte
         tstb               * is this 5-bit constant offset
         bmi  not5          * no, skip ahead
bit5     bitb #$10          * yes, is this a negitive offset
         beq  posi          * no, it is positive offset
         orb  #$F0          * make offset into a negative number
         negb               * get the two's complement
         lbsr minus         * put a minus sign in the buffer
b5out    lbsr outhex1       * make the number ascii put in buffer
         lbsr coma          * put a coma sign in the buffer
         puls b             * get the postop byte back
         bsr  rr            * calculate the index register
         rts                * return
posi     andb #$0F          * make the offset into a positive number
         bra  b5out         * skip back into logic
not5     aslb               * ok not 5-bit, so shift
         aslb               * bit 4
         aslb               * into the
         aslb               * condition code register bit 3 = bit 7
         lbcs indirect      * if carry set it's indirect addressing
         beq  rplus1        * if b reg = 0 it's autoincrement by 1
         bmi  first         * if bit 7 is set skip ahead
         aslb               * shift bit 2 into bit 7
         bmi  second        * if bit 7 is set skip ahead
         aslb               * shift bit 1 into bit 7
         bmi  third         * if bit 7 is set skip ahead
         bra  rplus2        * else it is autoincrement by 2
first    aslb               * bit 2 = bit 7
         lbeq bit8r         * if b reg = 0 it's 8 bit constant offset
         bmi  rpcrl         * if bit 7 is set it's program counter relative
         aslb               * bit 1 = bit 7
         lbmi dr            * if bit 7 is set it's d register offset 
         aslb               * bit 0 = bit 7
         lbmi bit16r        * if bit 7 is set it's 16 bit constant offset
         lbra rqq           * else don't know what it is put '??' in buff 
second   aslb               * bit 1 = bit 7
         bmi  ar            * if bit 7 is set it's a register offset
         beq  zoro          * if b reg = 0 it's zerro constant offset
         aslb               * bit 0 = bit 7
         bmi  br            * if bit 7 is set it's b register offset
         lbra rqq           * else don't know what it is put '??' in buff
third    aslb               * bit 0 = bit 7
         bmi  minus2        * if bit 7 is set it's autodecrement by 2
         beq  minus1        * if b reg = 0 it's autodecrement by 1
         lbra rqq           * else don't know what it is put '??' in buff
rpcrl    aslb               * bit 1 = bit 7
         lbeq bit8pr        * if b reg = 0 it's 8 bit program counter
         lbra bit16p        * else it's 16 bit program counter relative
rr       pshs b             * save postop byte
         andb #$60          * is it the x register
         beq  xregr         * yes, skip ahead
         cmpb #$20          * is it the y register
         beq  yregr         * yes, skip ahead
         cmpb #$40          * is it the u register
         beq  uregr         * yes, skip ahead
         cmpb #$60          * is it the s register
         beq  sregr         * yes, skip ahead
         lbra rqq           * else don't know what it is put '??' in buff
xregr    lda  #'x           * get the x register
         bra  store         * save it in the buffer
yregr    lda  #'y           * get the y register
         bra  store         * save it in the buffer
uregr    lda  #'u           * get the u register
         bra  store         * save it in the buffer
sregr    lda  #'s           * get the s register
store    sta  ,x+           * save it in the buffer
         puls b             * get the postop byte back
         rts                * return
rplus1   puls b             * get postop byte back
         bsr  rplus3        * put a coma sign and the register in buffer
         lda  #'+           * get a plus sign
         sta  ,x+           * put it in the buffer
         rts                * return
rplus2   puls b             * get postop byte back
         bsr  rplus3        * put a coma sign and the register in buffer
         ldd  #$2B2B        * get two plus signs
         std  ,x++          * put them in the buffer
         rts                * return
rplus3   lbsr coma          * put a coma sign in the buffer
         bsr  rr            * put the register in the buffer
         rts                * return
minus1   lbsr coma          * put a coma sign in the buffer 
         lda  #'-           * get a minus sign
         sta  ,x+           * put it in the buffer
         puls b             * get postop byte back
         bra  rr            * calculate the register
minus2   lbsr coma          * put a coma sign in the buffer
         ldd  #$2D2D        * get two minus signs
         std  ,x++          * put them in the buffer
         puls b             * get postop byte back
         bra  rr            * calculate the register
zoro     puls b             * get postop byte back
         bra  rplus3        * put coma and the calculated register in buffer
ar       lda  #'a           * get the a register
         bra  abd           * skip ahead
br       lda  #'b           * get the b register
         bra  abd           * skip ahead
dr       lda  #'d           * get the d register
abd      sta  ,x+           * save it in the buffer
         puls b             * get postop byte back
         bra  rplus3        * put coma and the calculated register in buffer
bit8r    ldb  ,y+           * get the 8 bit offset
         tstb               * is it a negative offset
         bpl  plus8         * no, it's a positive offset
         negb               * yes, get the two's complement
         lbsr minus         * put a minus sign in the buffer
plus8    lbsr outhex1       * make offset into ascii and put in buffer
         puls b             * get postop byte back
         bra  rplus3        * put coma and the calculated register in buffer
bit16r   ldd  ,y++          * get the 16 bit offset
         tsta               * is it a negative offset
         bpl  plus16        * no, it's a positive offset
         coma               * make 16 bit offset
         comb               * into a negative number
         addd #1            * now make it into it's two's complement
         pshs a             * save work register
         lbsr minus         * put a minus sign in the buffer
         puls a             * get work register back
plus16   lbsr outhex2       * make offset into ascii and put it in buffer
         puls b             * get postop byte back
         bra  rplus3        * put coma and the calculated register in buffer
bit8pr   ldb  ,y+           * get the 8 bit ,pcr offset
         sex                * sign extend it
         pshs y             * save instruction pointer
         addd ,s            * add it to instruction pointer
         tst  offsopt,u     * are offsets turn on
         beq  bit8pr2       * no, skip ahead
         lbsr setoffs       * set offset flag on
bit8pr2  lbsr outhex2       * make 8 bit offset into ascii put in buffer
pcrn     lbsr coma          * put a coma sign in the buffer
         leay rpcr,pcr      * point to "pcr"
         lda  #3            * 3 characters in the instruction
         lbsr put           * put the instruction into the buffer
         puls y             * get the instruction pointer back
         puls b             * get the postop byte back
         rts                * return
bit16p   ldd  ,y++          * get the 16 bit ,pcr offset
         pshs y             * save instruction pointer
         addd ,s            * add 16 bit offset to instruction pointer
         tst  offsopt,u     * are offsets turn on
         beq  bit16p2       * no, skip ahead
         lbsr setoffs       * set offset flag on
bit16p2  lbsr outhex2       * make 16 bit offset into ascii put in buffer
         bra  pcrn          * skip back into logic
indirect puls b             * get the postop byte
         lda  #$5B          * get a square bracket sign '[
         sta  ,x+           * save it in the buffer
         cmpb #$9F          * is this extended indirect addressing
         beq  exdirect      * yes, jump to extended indirect addressing
         andb #$EF          * turn off bit 4 only positive address
         lbsr index         * calculate indexed indirect addressing
indirout lda  #$5D          * get a square bracket sign ']
         sta  ,x+           * save it in the buffer
         rts                * return
exdirect ldd  ,y++          * get the extended address
         lbsr outhex2       * make it into ascii and put in buffer
         bra  indirout      * skip back into logic
rqq      ldd  #$3F3F        * get a '??'
         std  ,x++          * save it in the buffer
         puls b             * get postop byte back
         rts                * return
s10      puls y             * get the instruction pointer
         ldb  ,y+           * get postop byte
         pshs y             * save instruction pointer
         cmpb #$30          * is this a long branch instruction
         blo  cbr           * yes, jump to handle long branch
         cmpb #$3F          * is this a os9 system command
         beq  os9           * yes, jump to handle os9 system command
         bhi  srest         * it is none of these check rest
x10      puls y             * get instruction pointer
         ldd  #$3F3F        * get two question marks
         std  ,x++          * save them in the buffer
         lbra next          * decide what to do with io buffer
cbr      cmpb #$20          * is this a valid long branch
         blo  x10           * no, show two question marks in the buffer
         lda  #'l           * yes, get 'l for long branch instruction
         sta  ,x+           * save it in the buffer
         lbsr sub20         * calculate branch type
         lbsr space1        * put a space char in the buffer
         lbra lbr           * go handle the ralative offset address 
os9      puls y             * get the instruction pointer
         ldb  ,y+           * get the os9 command byte
         pshs y             * save instruction pointer
         pshs b             * save os9 command byte
         leay ros9,pcr      * point to "os9  " 
         lda  #5            * 5 bytes in the instruction
         lbsr put           * put it in the buffer
         leay os9table,pcr  * point to the os9 system table
         puls b             * get os9 command byte back
os9loop  cmpb ,y+           * did we find the command
         bne  os9next       * no, skip ahead
         lda  ,y+           * get number of characters in command
         lbsr put           * put the command in the buffer
os9out   puls y             * get the instruction pointer
         lbra next          * decide what to do with io buffer
os9next  pshs b             * save os9 command byte
         ldb  ,y+           * get field size byte
         exg  x,y           * put it in x for add
         abx                * add field size to table pointer
         exg  x,y           * put it back
         puls b             * get os9 command byte back
         cmpy ros9end,pcr   * reached end of table
         beq  os9out        * yes, restore and return
         bra  os9loop       * no, check the next command
srest    tfr  b,a           * save postop byte in a reg
         rolb               * roll bit 6 into bit 7
         bmi  overc         * if bit 7 is set it's lds or sts instruction 
         pshs b             * push postop byte for pop, see pop below
         tfr  a,b           * get postop byte back
         leay tab1,pcr      * point to table
enter11  lda  #6            * 6 bytes in each field 
solve    andb #$0F          * instructions go from $00-$0F
         lbsr match         * look for a match
         deca               * 5 characters in each instruction
         lbsr put           * put the instruction in the buffer
         puls b             * get byte back, either opcode or postop
         rolb               * roll bit 5 into bit 7
         bmi  next10        * if bit 7 is set it's extended or index mode
         rolb               * roll bit 4 into bit 7
         lbmi g00           * if bit 7 is set it's direct addressing mode
         lda  #'#           * else it's immediate addressing mode
         sta  ,x+           * save immediate addressing sign in the buffer
         lbra g71           * get two immediate data bytes and return
next10   rolb               * roll bit 4 into bit 7
         lbmi g70           * if bit 7 set it's extended addressing mode
         lbra dpit1         * else go calculate the index addressing mode
overc    pshs b             * push postop byte for pop, see pop above
         tfr  a,b           * put postop byte into the b reg
         leay tab2,pcr      * point to table
         bra  enter11       * solve the table logic
s11      puls y             * get the instruction pointer
         ldb  ,y+           * get the postop byte
         pshs y             * save the instruction pointer
         cmpb #$3F          * is this a swi3 instruction
         lblo x10           * no it's lower, put "?? in the buffer
         bhi  rest11        * no it's higher, it's either cmpu or cmps
         leay rswi3,pcr     * yes, point to "swi3"
         lda  #4            * 4 characters in instruction
         lbsr put           * put it in the buffer
         puls y             * get instruction pointer back
         lbra next          * decide what to do with io buffer
rest11   tfr  b,a           * save postop byte in the a reg
         rolb               * roll bit 6 into bit 7, preperation
         pshs b             * push new postop byte for pop, see above
         tfr  a,b           * put the old postop byte back into b reg
         leay tab11,pcr     * point to table "lds" or "sts"
         bra  enter11       * go enter11
grp80    pshs y             * save instruction pointer
         pshs b             * save opcode byte on stack
         tfr  b,a           * and put a copy in the a reg
         andb #$F0          * don't care about lower nibble
         lslb               * check for opcode $80-$8F?
         beq  check1        * yes, skip ahead
         lslb               * check for opcode $C0-$CF
         beq  check2        * yes, skip ahead
rein80   puls b             * none of those get opcode byte back
         tfr  b,a           * put a copy in the a register
         rolb               * roll bit 6 into bit 7
         bmi  over8         * if bit 7 is set it's $D0-$FF
         leay tab80a,pcr    * else it's $90-$BF point to table
mm80     pshs b             * push opcode byte for pop, see above 
         tfr  a,b           * get opcode byte back into b reg
         bra  enter11       * go enter11
over8    leay tab80b,pcr    * point to table
         bra  mm80          * skip back into logic
check1   cmpa #$8D          * is this a bsr instruction
         beq  rbr           * yes, skip ahead
         leay tab80a,pcr    * no, point to table
check    anda #$0F          * instructions go from $00-$0F 
         cmpa #$0C          * if the instruction is $0C-$0F 
         bhs  rein80        * let enter11 handle addressing mode
         cmpa #$03          * if the instruction involes the d reg
         beq  rein80        * let enter11 handle addressing mode
         tfr  a,b           * else it's immediate addressing mode
         lda  #6            * 6 bytes in each table field
         lbsr match         * find the instruction
         deca               * 5 characters in the instruction
         lbsr put           * put the instruction in the buffer
         lda  #'#           * get immediate addressing sign
         sta  ,x+           * save it in the buffer
         puls b             * clean the stack
         lbra g01           * get the immediate byte and return
check2   leay tab80b,pcr    * point to table
         bra  check         * calculate addressing mode
rbr      puls b             * clean the stack pointer
         leay rbsr,pcr      * point to "bsr"
         lda  #3            * 3 characters in the instruction
         lbsr put           * put the instruction in the buffer
         puls y             * get instruction pointer back
         lbra g20           * go calculate the relative offset
rexg     fcc  /exg  /
rtfr     fcc  /tfr  /
********************************************
* rbyte structure = 10 fields 3 bytes each *
* 1st byte = register id byte              *
* 2nd byte = offset from x reg to register *
* 3rd byte = 0 or 128 1 or 2 bytes in name *
********************************************
rbyte    fcb  0,30,0,1,28,0,2,26,0,3,24,0,4,22,0,5,20,128
         fcb  8,19,0,9,17,0,10,15,128,11,14,128
         fcc  /dxyuspcabccdp/
rccwai   fcc  /cwai #/
rlea     fcc  /lea/
lregr    fcc  /xysu/
rpcr     fcc  /pcr/
rnop     fcc  /nop/
rsync    fcc  /sync/
rdaa     fcc  /daa/
rsex     fcc  /sex/
rorcc    fcc  /orcc  #/
randcc   fcc  /andcc #/
rlbra    fcc  /lbra /
rlbsr    fcc  /lbsr /
pull     fcc  /pul/
pshr     fcc  /psh/
****************************************************************************
* order1 structure are 2 bytes fields for the push instruction registers
* fields either contain two characters or a 128 and one character
****************************************************************************
order1   fcb  112,99,128,117,128,121,128,120,100,112,128,98,128,97,99,99
****************************************************************************
* order2 structure are 2 bytes fields for the pull instruction registers
* fields either contain two characters or a 128 and one character
****************************************************************************
order2   fcb  99,99,128,97,128,98,100,112,128,120,128,121,128,117,112,99
****************************************************************************
table3   fcb  $39
         fcc  /rts/
         fcb  $3a
         fcc  /abx/
         fcb  $3b
         fcc  /rti/
         fcb  $3d
         fcc  /mul/
         fcb  $3f
         fcc  /swi/
rbsr     fcc  /bsr/
table1   fcb  $0
         fcc  /neg/
         fcb  $01
         fcc  /?? /
         fcb  $02
         fcc  /?? /
         fcb  $03
         fcc  /com/
         fcb  $04
         fcc  /lsr/
         fcb  $05
         fcc  /?? /
         fcb  $06
         fcc  /ror/
         fcb  $07
         fcc  /asr/
         fcb  $08
         fcc  /asl/
         fcb  $09
         fcc  /rol/
         fcb  lf
         fcc  /dec/
         fcb  $0b
         fcc  /?? /
         fcb  $0c
         fcc  /inc/
         fcb  cr
         fcc  /tst/
         fcb  $0e
         fcc  /jmp/
         fcb  $0f
         fcc  /clr/
table2   fcb  $20
         fcc  /bra/
         fcb  $21
         fcc  /brn/
         fcb  $22
         fcc  /bhi/
         fcb  $23
         fcc  /bls/
         fcb  $24
         fcc  /bcc/
         fcb  $25
         fcc  /bcs/
         fcb  $26
         fcc  /bne/
         fcb  $27
         fcc  /beq/
         fcb  $28
         fcc  /bvc/
         fcb  $29
         fcc  /bvs/
         fcb  $2a
         fcc  /bpl/
         fcb  $2b
         fcc  /bmi/
         fcb  $2c
         fcc  /bge/
         fcb  $2d
         fcc  /blt/
         fcb  $2e
         fcc  /bgt/
         fcb  $2f
         fcc  /ble/
tab1     fcb  $03
         fcc  /cmpd /
         fcb  $0c
         fcc  /cmpy /
         fcb  $0e
         fcc  /ldy  /
         fcb  $0f
         fcc  /sty  /
tab2     fcb  $0e
         fcc  /lds  /
         fcb  $0f
         fcc  /sts  /
tab11    fcb  $03
         fcc  /cmpu /
         fcb  $0c
         fcc  /cmps /
tab80a   fcb  $00
         fcc  /suba /
         fcb  $01
         fcc  /cmpa /
         fcb  $02
         fcc  /sbca /
         fcb  $03
         fcc  /subd /
         fcb  $04
         fcc  /anda /
         fcb  $05
         fcc  /bita /
         fcb  $06
         fcc  /lda  /
         fcb  $07
         fcc  /sta  /
         fcb  $08
         fcc  /eora /
         fcb  $09
         fcc  /adca /
         fcb  lf
         fcc  /ora  /
         fcb  $0b
         fcc  /adda /
         fcb  $0c
         fcc  /cmpx /
         fcb  cr
         fcc  /jsr  /
         fcb  $0e
         fcc  /ldx  /
         fcb  $0f
         fcc  /stx  /
tab80b   fcb  $00
         fcc  /subb /
         fcb  $01
         fcc  /cmpb /
         fcb  $02
         fcc  /sbcb /
         fcb  $03
         fcc  /addd /
         fcb  $04
         fcc  /andb /
         fcb  $05
         fcc  /bitb /
         fcb  $06
         fcc  /ldb  /
         fcb  $07
         fcc  /stb  /
         fcb  $08
         fcc  /eorb /
         fcb  $09
         fcc  /adcb /
         fcb  lf
         fcc  /orb  /
         fcb  $0b
         fcc  /addb /
         fcb  $0c
         fcc  /ldd  /
         fcb  cr
         fcc  /std  /
         fcb  $0e
         fcc  /ldu  /
         fcb  $0f
         fcc  /stu  /
rswi3    fcc  /swi3/
rshell   fcc  /shell/
         fcb  cr
ros9     fcc  /os9  /
os9table fcb  $0,6
         fcc  /F$Link/
         fcb  $01,6
         fcc  /F$Load/
         fcb  $02,8
         fcc  /F$UnLink/
         fcb  $03,6
         fcc  /F$Fork/
         fcb  $04,6
         fcc  /F$Wait/
         fcb  $05,7
         fcc  /F$Chain/
         fcb  $06,6
         fcc  /F$Exit/
         fcb  $07,5
         fcc  /F$Mem/
         fcb  $08,6
         fcc  /F$Send/
         fcb  $09,6
         fcc  /F$Icpt/
         fcb  lf,7
         fcc  /F$Sleep/
         fcb  $0C,4
         fcc  /F$ID/
         fcb  cr,8
         fcc  /F$SPrior/
         fcb  $0E,6
         fcc  /F$SSWI/
         fcb  $0F,6
         fcc  /F$Perr/
         fcb  $10,8
         fcc  /F$PrsNam/
         fcb  $11,8
         fcc  /F$CmpNam/
         fcb  $12,8
         fcc  /F$SchBit/
         fcb  $13,8
         fcc  /F$AllBit/
         fcb  $14,8
         fcc  /F$DelBit/
         fcb  $15,6
         fcc  /F$Time/
         fcb  $16,7
         fcc  /F$STime/
         fcb  $17,5
         fcc  /F$CRC/
         fcb  $18,8
         fcc  /F$GPrDsc/
         fcb  $19,8
         fcc  /F$GBlkMp/
         fcb  $1A,8
         fcc  /F$GModDr/
         fcb  $1B,8
         fcc  /F$CpyMem/
         fcb  $1C,7
         fcc  /F$SUser/
         fcb  $1D,8
         fcc  /F$UnLoad/
         fcb  $1E,7
         fcc  /F$Alarm/
         fcb  $21,8
         fcc  /F$NMLink/
         fcb  $22,8
         fcc  /F$NMLoad/
         fcb  $27,6
         fcc  /F$VIRQ/
         fcb  $28,8
         fcc  /F$SRqMem/
         fcb  $29,8
         fcc  /F$SRtMem/
         fcb  $2A,5
         fcc  /F$IRQ/
         fcb  $2B,6
         fcc  /F$IOQu/
         fcb  $2C,7
         fcc  /F$AProc/
         fcb  $2D,7
         fcc  /F$NProc/
         fcb  $2E,8
         fcc  /F$VModul/
         fcb  $2F,8
         fcc  /F$Find64/
         fcb  $30,7
         fcc  /F$All64/
         fcb  $31,7
         fcc  /F$Ret64/
         fcb  $32,6
         fcc  /F$SSvc/
         fcb  $33,7
         fcc  /F$IODel/
         fcb  $34,7
         fcc  /F$SLink/
         fcb  $35,6
         fcc  /F$Boot/
         fcb  $36,7
         fcc  /F$BtMem/
         fcb  $37,8
         fcc  /F$GProcP/
         fcb  $38,6
         fcc  /F$Move/
         fcb  $39,8
         fcc  /F$AllRAM/
         fcb  $3A,8
         fcc  /F$AllImg/
         fcb  $3B,8
         fcc  /F$DelImg/
         fcb  $3C,8
         fcc  /F$SetImg/
         fcb  $3D,8
         fcc  /F$FreeLB/
         fcb  $3E,8
         fcc  /F$FreeHB/
         fcb  $3F,8
         fcc  /F$AllTsk/
         fcb  $40,8
         fcc  /F$DelTsk/
         fcb  $41,8
         fcc  /F$SetTsk/
         fcb  $42,8
         fcc  /F$ResTsk/
         fcb  $43,8
         fcc  /F$RelTsk/
         fcb  $44,8
         fcc  /F$DATLog/
         fcb  $46,7
         fcc  /F$LDAXY/
         fcb  $48,8
         fcc  /F$LDDDXY/
         fcb  $49,7
         fcc  /F$LDABX/
         fcb  $4A,7
         fcc  /F$STABX/
         fcb  $4B,8
         fcc  /F$AllPrc/
         fcb  $4C,8
         fcc  /F$DelPrc/
         fcb  $4D,7
         fcc  /F$ELink/
         fcb  $4E,8
         fcc  /F$FModul/
         fcb  $4F,8
         fcc  /F$MapBlk/
         fcb  $50,8
         fcc  /F$ClrBlk/
         fcb  $51,8
         fcc  /F$DelRAM/
         fcb  $52,8
         fcc  /F$GCMDir/
         fcb  $53,8
         fcc  /F$AlHRam/
         fcb  $80,8
         fcc  /I$Attach/
         fcb  $81,8
         fcc  /I$Detach/
         fcb  $82,5
         fcc  /I$Dup/
         fcb  $83,8
         fcc  /I$Create/
         fcb  $84,6
         fcc  /I$Open/
         fcb  $85,8
         fcc  /I$MakDir/
         fcb  $86,8
         fcc  /I$Chgdir/
         fcb  $87,8
         fcc  /I$Delete/
         fcb  $88,6
         fcc  /I$Seek/
         fcb  $89,6
         fcc  /I$Read/
         fcb  $8A,7
         fcc  /I$Write/
         fcb  $8B,8
         fcc  /I$ReadLn/
         fcb  $8C,8
         fcc  /I$WritLn/
         fcb  $8D,8
         fcc  /I$GetStt/
         fcb  $8E,8
         fcc  /I$SetStt/
         fcb  $8F,7
         fcc  /I$Close/
         fcb  $90,8
         fcc  /I$DeletX/
         fcb  0,0
ros9end  equ  *
copyr    fcb  $0C
         fcb  7
         fcc  "DASM (C) 1992"
         fcb  lf
         fcc  "J.R.COLLYER"
         fcb  lf
         fcb  cr
         fcb  0
prompt   fcc  "dasm: "
         fcb  0
whatmsg  fcc  "WHAT ??"
         fcb  cr
         fcb  0
adrmsg   fcc  "USE: [HEX DIGITS]"
         fcb  cr
         fcb  0
jumpmsg  fcc  "START ADDRESS ? "
         fcb  0
ulinkmsg fcc  "UNLINKED MODULE COUNT"
         fcb  cr
         fcb  0
notlkmsg fcc  "MODULE LINK COUNT IS ZERO"
         fcb  cr
         fcb  0
linkmsg  fcc  "LINK ? "
         fcb  0
dasmmsg  fcs  "dasm"
         fcb  0
shellmsg fcc  "SHELL ? "
         fcb  0
getmode  fcc  "AUTO ? "
         fcb  0
modemsg1 fcc  "AUTO ON"
         fcb  cr
         fcb  0
modemsg2 fcc  "AUTO OFF"
         fcb  cr
         fcb  0
prtermsg fcc  "PRINTER ? "
         fcb  0
prtmsg   fcc  "PRINTER  ON"
         fcb  cr
         fcb  0
scrmsg   fcc  "PRINTER  OFF"
         fcb  cr
         fcb  0
buffmsg  fcc  "BUFFER ? "
         fcb  0
buff1    fcc  "BUFFER OFF"
         fcb  cr
         fcb  0
buff2    fcc  "BUFFER ON"
         fcb  cr
         fcb  0
bfull    fcc  "BUFFER FULL"
         fcb  cr
         fcb  0
stackms1 fcc  "ADDRESS STACK IS FULL"
         fcb  cr
         fcb  0
stackms2 fcc  "ADDRESS STACK IS EMPTY"
         fcb  cr
         fcb  0
helpmsg  fcc  "USE: ARROW KEYS  $ ? A B E G L M O P Q R S U W"
         fcb  cr
         fcb  0
fname    fcc  "FILENAME ? "
         fcb  0
endadmsg fcc  "END ADDRESS ? "
         fcb  0
gimimsg  fcc  "GIMI ? "
         fcb  0
gimimsg1 fcc  "EXAMPLE: 3F,3E,3D [ENTER]"
         fcb  cr
         fcb  0
gimimsg2 fcc  "EXAMPLE: FF FE FD [ENTER]"
         fcb  cr
         fcb  0
offsmsg  fcc  "OFFSETS ? "
         fcb  0
offsmsg1 fcc  "OFFSETS ON"
         fcb  cr
         fcb  0
offsmsg2 fcc  "OFFSETS OFF"
         fcb  cr
         fcb  0
exitmsg  fcc  "QUIT ARE YOU SURE (y/n) ? "
         fcb  0
pmsg     fcc  "/p"
usemsg   fcb  7
         fcb  lf
         fcc  "*************************"
         fcb  lf
         fcc  "** OS9 DASM"
         fcb  lf
         fcc  "** (C)1992 J.R.COLLYER"
         fcb  lf
         fcc  "** usage: dasm <opts> [path] [module]"
         fcb  lf
         fcc  "** opts:     -o  use offset addresses"
         fcb  lf
         fcc  "**           -s  start address"
         fcb  lf
         fcc  "**           -e  end address"
         fcb  lf
         fcc  "**           -m  use hard addresses"
         fcb  lf
         fcc  "**           -l  link os9 module"
         fcb  lf
         fcc  "**           -r  read os9 module"
         fcb  lf
         fcc  "**           [ENTER] Interactive mode"
         fcb  lf
         fcb  cr
         fcb  0
commands fcb  00    
         fdb 0000   
         fcb  $08  left arrow
         fdb  return-begin
         fcb  $09  right arrow
         fdb  branch-begin
         fcb  lf    down arrow
         fdb  dentry-begin
         fcb  $0C    up arrow
         fdb  back-begin
         fcb  $24    shell command
         fdb  shell-begin
         fcb  $3F    help  command
         fdb  help-begin
         fcb  $41    ASCII command
         fdb  ascii-begin
         fcb  $42    buffer command
         fdb  bcom-begin
         fcb  $45    end address for auto mode
         fdb  chngend-begin
         fcb  $47    gimi
         fdb  gimicom-begin
         fcb  $4C    link  command
         fdb  link-begin
         fcb  $4D    mode  command
         fdb  setmode-begin
         fcb  $4F    offsets
         fdb  offscom-begin
         fcb  $50    printer command
         fdb  printer-begin
         fcb  $51    quit command
         fdb  quit-begin
         fcb  $52    read disk file command
         fdb  read-begin
         fcb  $53    start address
         fdb  jump-begin
         fcb  $55    unlink command
         fdb  unlink-begin
         fcb  $57    disk write
         fdb  write-begin
         fcb  0
         emod
len      equ  *
         end
