/*
 * Copyright (c) 2000-2001 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_DAKTARI_H
#define	_DAKTARI_H

#pragma ident	"@(#)daktari.h	1.3	02/01/24 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * daktari.h - Daktari common header file
 *
 * This header file contains the common definitions and macros for the
 * Daktari platform. We define them all here to avoid them being redefined
 * in numerous different drivers and daemons.
 */


#define	DAK_SBD_SLOTS		4
#define	DAK_CPUS_PER_BOARD	2
#define	DAK_MAX_CPUS		(DAK_SBD_SLOTS * DAK_CPUS_PER_BOARD)

/*
 * Daktari CPU numbering is...unusual:
 *   Slot SlotID  Agent ID
 *   ---- ------  --------
 *    0     0  <==>  0
 *    0     1  <==>  2
 *    1     0  <==>  1
 *    1     1  <==>  3
 *    2     0  <==>  4
 *    2     1  <==>  6
 *    3     0  <==>  5
 *    3     1  <==>  7
 */
#define	DAK_GETSLOT(AID)		(((AID&4)>>1)|(AID&1))
#define	DAK_GETSLOT_LABEL(AID)		('A' + DAK_GETSLOT(AID))
#define	DAK_GETSID(AID)			((AID&2)>>1)
#define	DAK_GETAID(SLOT, RELCPU)	(((SLOT&2)<<1)|(SLOT&1)|((RELCPU)<<1))

#define	DAK_GET_SBD_APID(BUF, SZ, SLOT)	(void) snprintf((BUF), (SZ), "SB%c", \
						'a'+(SLOT))
#define	DAK_SBD_APID_SZ			4

#define	DAK_GET_PCI_APID(BUF, SZ, INST, SLOT) (void) snprintf((BUF), \
						(SZ), "hpc%d_slot%d", \
						(INST), (SLOT))
#ifdef	__cplusplus
}
#endif

#endif /* _DAKTARI_H */
