/*
 * Copyright (c) 1999-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_ID_SPACE_H
#define	_ID_SPACE_H

#pragma ident	"@(#)id_space.h	1.1	00/02/14 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#include <sys/param.h>
#include <sys/types.h>
#include <sys/mutex.h>
#include <sys/vmem.h>

#define	ISP_NORMAL	0x0
#define	ISP_RESERVE	0x1

/*
 * id_space is composed of the semi-open interval [low, high).  The backing
 * support for the allocated ids is a vmem.
 */
typedef struct id_space {
	id_t	is_low;
	id_t	is_high;
	id_t	is_next;
	kmutex_t is_mutex;
	vmem_t	*is_vmem;
} id_space_t;

#ifdef _KERNEL

void id_space_init();
id_space_t *id_space_create(const char *, id_t, id_t);
void id_space_destroy(id_space_t *);
id_t id_alloc(id_space_t *);
void id_free(id_space_t *, id_t);

#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _ID_SPACE_H */
