/*
 * Copyright (c) 2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_SYS_SUNMDI_H
#define	_SYS_SUNMDI_H

#pragma ident	"@(#)sunmdi.h	1.1	00/12/11 SMI"

/*
 * Multiplexed I/O global include
 */

#include <sys/note.h>
#include <sys/esunddi.h>
#include <sys/sunddi.h>
#include <sys/ddipropdefs.h>

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * handle to mdi_pathinfo node
 */
typedef struct x_mdi_pathinfo *mdi_pathinfo_t;

/*
 * Path info node state definitions
 */
typedef enum {
	MDI_PATHINFO_STATE_INIT,
	MDI_PATHINFO_STATE_ONLINE,
	MDI_PATHINFO_STATE_STANDBY,
	MDI_PATHINFO_STATE_FAULT,
	MDI_PATHINFO_STATE_OFFLINE
} mdi_pathinfo_state_t;

#ifdef _KERNEL

/*
 * mpxio component definitions:  Every registered compoment of the mpxio system
 * has a "mpxio-component" property attached to it, identifying its function.
 */
#define	MDI_COMPONENT_NONE	0
#define	MDI_COMPONENT_VHCI	1
#define	MDI_COMPONENT_PHCI	2
#define	MDI_COMPONENT_CLIENT	3

/*
 * MDI operation vector structure definition
 */
#define	MDI_OPS_REV_1			1
#define	MDI_OPS_REV			MDI_OPS_REV_1

typedef struct mdi_ops {
	int	mdio_rev;		/* mdi hooks revision */
	/*
	 * device node online/offline notification from NDI framework
	 * for mpxio component hotplugging support
	 */
	int	(*mdio_devi_online)(dev_info_t *, uint_t);
	int	(*mdio_devi_offline)(dev_info_t *, uint_t);
	/*
	 * device instance attach/detach notification
	 */
	int	(*mdio_pre_attach)(dev_info_t *, ddi_attach_cmd_t);
	void	(*mdio_post_attach)(dev_info_t *, ddi_attach_cmd_t, int);
	int	(*mdio_pre_detach)(dev_info_t *, ddi_detach_cmd_t);
	void	(*mdio_post_detach)(dev_info_t *, ddi_detach_cmd_t, int);
	/*
	 * mdi_pathinfo node walker function. Caller should hold a READER lock
	 * on devinfo_tree_lock for a consistent snap shot
	 */
	void	(*mdio_get_next_path)(dev_info_t *, mdi_pathinfo_t *,
		    mdi_pathinfo_t **);
	/*
	 * mdi_pathinfo node member functions
	 */
	void	(*mdio_pi_lock)(mdi_pathinfo_t *);
	void	(*mdio_pi_unlock)(mdi_pathinfo_t *);
	dev_info_t *
		(*mdio_pi_get_client)(mdi_pathinfo_t *);
	dev_info_t *
		(*mdio_pi_get_phci)(mdi_pathinfo_t *);
	char *
		(*mdio_pi_get_addr)(mdi_pathinfo_t *);
	mdi_pathinfo_state_t
		(*mdio_pi_get_state)(mdi_pathinfo_t *);
	nvpair_t *
		(*mdio_pi_get_next_prop)(mdi_pathinfo_t *, nvpair_t *);
} mdi_ops_t;

/*
 * MDI ops vector register/unregister function definitions. There will be only
 * one mpxio misc module in the system registering these vectors.
 */
int
mdi_ops_register(mdi_ops_t *);
int
mdi_ops_unregister(mdi_ops_t *);

/*
 * MDI device hotplug notification
 */
int
mdi_devi_online(dev_info_t *, uint_t);
int
mdi_devi_offline(dev_info_t *, uint_t);

/*
 * MDI component device instance attach/detach notification
 */
int
mdi_pre_attach(dev_info_t *, ddi_attach_cmd_t);
void
mdi_post_attach(dev_info_t *, ddi_attach_cmd_t, int);
int
mdi_pre_detach(dev_info_t *, ddi_detach_cmd_t);
void
mdi_post_detach(dev_info_t *, ddi_detach_cmd_t, int);

/*
 * mdi_pathinfo node walker function.
 */
void
mdi_get_next_path(dev_info_t *, mdi_pathinfo_t *, mdi_pathinfo_t **);

/*
 * mdi_pathinfo node member functions
 */
void
mdi_pi_lock(mdi_pathinfo_t *);

void
mdi_pi_unlock(mdi_pathinfo_t *);

dev_info_t *
mdi_pi_get_client(mdi_pathinfo_t *);

dev_info_t *
mdi_pi_get_phci(mdi_pathinfo_t *);

char *
mdi_pi_get_addr(mdi_pathinfo_t *);

mdi_pathinfo_state_t
mdi_pi_get_state(mdi_pathinfo_t *);

nvpair_t *
mdi_pi_get_next_prop(mdi_pathinfo_t *, nvpair_t *);

#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_SUNMDI_H */
