/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _METAD_H_RPCGEN
#define	_METAD_H_RPCGEN

#include <rpc/rpc.h>
#ifndef _KERNEL
#ifdef _REENTRANT
#include <synch.h>
#endif	/* _REENTRANT */
#ifdef _REENTRANT
#include <thread.h>
#endif	/* _REENTRANT */
#endif /* !_KERNEL */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)metad.x	2.4	05/11/21 SMI"

#include <mdiox.h>
#include <meta_basic.h>
#include <sys/lvm/mdmn_commd.h>

extern	int	md_in_daemon;
/*
 * There are too many external factors that affect the timing of the
 * operations, so we set the timeout to a very large value, in this
 * case 1 day, which should handle HW timeouts, large configurations,
 * and other potential delays.
 */
#define	CL_LONG_TMO	86400L

/*
 * Structure Revisions
 */

enum mdrpc_metad_args_rev {
	MD_METAD_ARGS_REV_1 = 1
};
typedef enum mdrpc_metad_args_rev mdrpc_metad_args_rev;

/*
 *	device id
 */

struct mdrpc_devid_res {
	char *enc_devid;
	md_error_t status;
};
typedef struct mdrpc_devid_res mdrpc_devid_res;

/*
 * svm rpc version 2 device id arguments
 * (member union in mdrpc_devid_2_args)
 */

struct mdrpc_devid_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	mddrivename_t *drivenamep;
};
typedef struct mdrpc_devid_args mdrpc_devid_args;

/*
 * svm rpc version 2 device id arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_devid_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_devid_args rev1;
	} mdrpc_devid_2_args_u;
};
typedef struct mdrpc_devid_2_args mdrpc_devid_2_args;

/*
 * For getting the devinfo based upon devid
 */

struct mdrpc_devidstr_args {
	mdsetname_t *sp;
	char *enc_devid;
	md_error_t status;
};
typedef struct mdrpc_devidstr_args mdrpc_devidstr_args;

/*
 * For getting the devinfo based upon devid/devname
 */

struct mdrpc_devid_name_args {
	mdsetname_t *sp;
	char *orig_devname;
	char *enc_devid;
};
typedef struct mdrpc_devid_name_args mdrpc_devid_name_args;

/*
 * svm rpc version 2 devinfo based upon devid/devname
 * (union of all version 2 revisions)
 */

struct mdrpc_devid_name_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_devid_name_args rev1;
	} mdrpc_devid_name_2_args_u;
};
typedef struct mdrpc_devid_name_2_args mdrpc_devid_name_2_args;

/*
 * version 1 device info
 */

struct mdrpc_devinfo_res {
	dev_t dev;
	int vtime;
	md_error_t status;
};
typedef struct mdrpc_devinfo_res mdrpc_devinfo_res;

/*
 * version 2 device info. dev_t is always 64-bit
 */

struct mdrpc_devinfo_2_res {
	md_dev64_t dev;
	int vtime;
	char *enc_devid;
	char *devname;
	char *drivername;
	md_error_t status;
};
typedef struct mdrpc_devinfo_2_res mdrpc_devinfo_2_res;

/*
 * svm rpc version 1 device info arguments
 */

struct mdrpc_devinfo_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	o_mddrivename_t *drivenamep;
};
typedef struct mdrpc_devinfo_args mdrpc_devinfo_args;

/*
 * svm rpc version 2 (revision 1) device info arguments
 * (member of union in mdrpc_devinfo_2_args)
 */

struct mdrpc_devinfo_2_args_r1 {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	mddrivename_t *drivenamep;
	char *enc_devid;
};
typedef struct mdrpc_devinfo_2_args_r1 mdrpc_devinfo_2_args_r1;

/*
 * svm rpc version 2 device info arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_devinfo_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_devinfo_2_args_r1 rev1;
	} mdrpc_devinfo_2_args_u;
};
typedef struct mdrpc_devinfo_2_args mdrpc_devinfo_2_args;

struct mdrpc_hostname_res {
	char *hostname;
	md_error_t status;
};
typedef struct mdrpc_hostname_res mdrpc_hostname_res;

/*
 * svm rpc version 1 and version 2 (revision 1) getset arguments
 */

struct mdrpc_getset_args {
	char *setname;
	set_t setno;
};
typedef struct mdrpc_getset_args mdrpc_getset_args;

/*
 * svm rpc version 2 getset arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_getset_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_getset_args rev1;
	} mdrpc_getset_2_args_u;
};
typedef struct mdrpc_getset_2_args mdrpc_getset_2_args;

/* NOTE: if you add to this struct, then fix the clnt_getset() */
/*	  to prevent memory leaks */

struct mdrpc_getset_res {
	md_set_record *sr;
	md_error_t status;
};
typedef struct mdrpc_getset_res mdrpc_getset_res;

/* NOTE: if you add to this struct, then fix the clnt_mngetset() */
/*	  to prevent memory leaks */

struct mdrpc_mngetset_res {
	md_mnset_record *mnsr;
	md_error_t status;
};
typedef struct mdrpc_mngetset_res mdrpc_mngetset_res;

/* NOTE: if you add to this struct, then fix the clnt_getdrivedesc() */
/*	  to prevent memory leaks */

struct mdrpc_getdrivedesc_res {
	md_drive_desc *dd;
	md_error_t status;
};
typedef struct mdrpc_getdrivedesc_res mdrpc_getdrivedesc_res;
#ifndef STRINGARRAY

typedef char *stringarray;
#define STRINGARRAY
#endif

/*
 * svm rpc version 1 and version 2 (revision 1) createset arguments
 */

struct mdrpc_createset_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	md_node_nm_arr_t nodes;
	md_timeval32_t timestamp;
	u_long genid;
};
typedef struct mdrpc_createset_args mdrpc_createset_args;

/*
 * svm rpc version 2 createset arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_createset_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_createset_args rev1;
	} mdrpc_createset_2_args_u;
};
typedef struct mdrpc_createset_2_args mdrpc_createset_2_args;

struct mdrpc_mncreateset_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	md_mnnode_desc *nodelist;
	md_timeval32_t timestamp;
	u_long genid;
	md_node_nm_t master_nodenm;
	int master_nodeid;
};
typedef struct mdrpc_mncreateset_args mdrpc_mncreateset_args;

/*
 * svm rpc version 2 mncreateset arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_mncreateset_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_mncreateset_args rev1;
	} mdrpc_mncreateset_2_args_u;
};
typedef struct mdrpc_mncreateset_2_args mdrpc_mncreateset_2_args;

struct mdrpc_bool_res {
	int value;
	md_error_t status;
};
typedef struct mdrpc_bool_res mdrpc_bool_res;

/*
 * svm rpc version 1 drive arguments
 */

struct mdrpc_drives_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	o_md_drive_desc *drivedescs;
	md_timeval32_t timestamp;
	u_long genid;
};
typedef struct mdrpc_drives_args mdrpc_drives_args;

/*
 * svm rpc version 2 (revision 1) drive arguments
 * (member of union in mrpc_drives_2_args)
 */

struct mdrpc_drives_2_args_r1 {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	md_drive_desc *drivedescs;
	md_timeval32_t timestamp;
	u_long genid;
};
typedef struct mdrpc_drives_2_args_r1 mdrpc_drives_2_args_r1;

/*
 * svm rpc version 2 drive arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_drives_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_drives_2_args_r1 rev1;
	} mdrpc_drives_2_args_u;
};
typedef struct mdrpc_drives_2_args mdrpc_drives_2_args;

/*
 * svm rpc version 1 sidename arguments
 */

struct mdrpc_drv_sidenm_args {
	md_setkey_t *cl_sk;
	char *hostname;
	mdsetname_t *sp;
	o_md_set_desc *sd;
	struct {
		u_int node_v_len;
		stringarray *node_v_val;
	} node_v;
};
typedef struct mdrpc_drv_sidenm_args mdrpc_drv_sidenm_args;

/*
 * svm rpc version 2 (revision 1) sidename arguments
 * (member of union in mdrpc_drv_sidenm_2_args)
 */

struct mdrpc_drv_sidenm_2_args_r1 {
	md_setkey_t *cl_sk;
	char *hostname;
	mdsetname_t *sp;
	md_set_desc *sd;
	struct {
		u_int node_v_len;
		stringarray *node_v_val;
	} node_v;
};
typedef struct mdrpc_drv_sidenm_2_args_r1 mdrpc_drv_sidenm_2_args_r1;

/*
 * svm rpc version 2 sidename arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_drv_sidenm_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_drv_sidenm_2_args_r1 rev1;
	} mdrpc_drv_sidenm_2_args_u;
};
typedef struct mdrpc_drv_sidenm_2_args mdrpc_drv_sidenm_2_args;

/*
 * svm rpc version 1 drvused arguments
 */

struct mdrpc_drvused_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	o_mddrivename_t *drivenamep;
};
typedef struct mdrpc_drvused_args mdrpc_drvused_args;

/*
 * svm rpc version 2 (revision 1) drvused arguments
 * (member of union in mdrpc_drvused_2_args)
 */

struct mdrpc_drvused_2_args_r1 {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	mddrivename_t *drivenamep;
};
typedef struct mdrpc_drvused_2_args_r1 mdrpc_drvused_2_args_r1;

/*
 * svm rpc version 2 drvused arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_drvused_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_drvused_2_args_r1 rev1;
	} mdrpc_drvused_2_args_u;
};
typedef struct mdrpc_drvused_2_args mdrpc_drvused_2_args;

/*
 * svm rpc version 1 and version 2 (revision 1) host arguments
 */

struct mdrpc_host_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	struct {
		u_int hosts_len;
		stringarray *hosts_val;
	} hosts;
};
typedef struct mdrpc_host_args mdrpc_host_args;

/*
 * svm rpc version 2 host arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_host_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_host_args rev1;
	} mdrpc_host_2_args_u;
};
typedef struct mdrpc_host_2_args mdrpc_host_2_args;

struct mdrpc_gtimeout_res {
	md_error_t status;
	mhd_mhiargs_t *mhiargsp;
};
typedef struct mdrpc_gtimeout_res mdrpc_gtimeout_res;

/*
 * svm rpc version 1 and version 2 (revision 1) set timeout arguments
 */

struct mdrpc_stimeout_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	mhd_mhiargs_t *mhiargsp;
};
typedef struct mdrpc_stimeout_args mdrpc_stimeout_args;

/*
 * svm rpc version 2 set timeout arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_stimeout_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_stimeout_args rev1;
	} mdrpc_stimeout_2_args_u;
};
typedef struct mdrpc_stimeout_2_args mdrpc_stimeout_2_args;

/*
 * svm rpc version 1 arguments
 */

struct mdrpc_upd_dr_flags_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	o_md_drive_desc *drivedescs;
	u_int new_flags;
};
typedef struct mdrpc_upd_dr_flags_args mdrpc_upd_dr_flags_args;

/*
 * svm rpc version 2 (revision 1) arguments
 * (member of union in mdrpc_upd_dr_flags_2_args)
 */

struct mdrpc_upd_dr_flags_2_args_r1 {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	md_drive_desc *drivedescs;
	u_int new_flags;
};
typedef struct mdrpc_upd_dr_flags_2_args_r1 mdrpc_upd_dr_flags_2_args_r1;

/*
 * svm rpc version 2 arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_upd_dr_flags_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_upd_dr_flags_2_args_r1 rev1;
	} mdrpc_upd_dr_flags_2_args_u;
};
typedef struct mdrpc_upd_dr_flags_2_args mdrpc_upd_dr_flags_2_args;

/*
 * svm rpc version 1 and version 2 (revision 1) arguments
 */

struct mdrpc_upd_sr_flags_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	u_int new_flags;
};
typedef struct mdrpc_upd_sr_flags_args mdrpc_upd_sr_flags_args;

/*
 * svm rpc version 2 arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_upd_sr_flags_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_upd_sr_flags_args rev1;
	} mdrpc_upd_sr_flags_2_args_u;
};
typedef struct mdrpc_upd_sr_flags_2_args mdrpc_upd_sr_flags_2_args;

/*
 * svm rpc version 2 (revision 1) arguments
 */

struct mdrpc_upd_nr_flags_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	md_mnnode_desc *nodedescs;
	u_int flag_action;
	u_int flags;
};
typedef struct mdrpc_upd_nr_flags_args mdrpc_upd_nr_flags_args;

/*
 * svm rpc version 2 arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_upd_nr_flags_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_upd_nr_flags_args rev1;
	} mdrpc_upd_nr_flags_2_args_u;
};
typedef struct mdrpc_upd_nr_flags_2_args mdrpc_upd_nr_flags_2_args;

struct mdrpc_setlock_res {
	md_setkey_t *cl_sk;
	md_error_t status;
};
typedef struct mdrpc_setlock_res mdrpc_setlock_res;

struct mdrpc_generic_res {
	md_error_t status;
};
typedef struct mdrpc_generic_res mdrpc_generic_res;

/*
 * svm rpc version 1 and version 2 (revision 1) set arguments
 */

struct mdrpc_setno_args {
	md_setkey_t *cl_sk;
	set_t setno;
};
typedef struct mdrpc_setno_args mdrpc_setno_args;

/*
 * svm rpc version 2 set arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_setno_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_setno_args rev1;
	} mdrpc_setno_2_args_u;
};
typedef struct mdrpc_setno_2_args mdrpc_setno_2_args;

struct mdrpc_null_args {
	md_setkey_t *cl_sk;
};
typedef struct mdrpc_null_args mdrpc_null_args;

/*
 * svm rpc version 1 and version 2 (revision 1) arguments
 */

struct mdrpc_sp_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
};
typedef struct mdrpc_sp_args mdrpc_sp_args;

/*
 * svm rpc version 2 arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_sp_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_sp_args rev1;
	} mdrpc_sp_2_args_u;
};
typedef struct mdrpc_sp_2_args mdrpc_sp_2_args;

/*
 * svm rpc version 2 (revision 1) arguments
 */

struct mdrpc_sp_flags_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	int flags;
};
typedef struct mdrpc_sp_flags_args mdrpc_sp_flags_args;

/*
 * svm rpc version 2 arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_sp_flags_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_sp_flags_args rev1;
	} mdrpc_sp_flags_2_args_u;
};
typedef struct mdrpc_sp_flags_2_args mdrpc_sp_flags_2_args;

/*
 * svm rpc version 1 and version 2 (revision 1) arguments
 */

struct mdrpc_updmeds_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	md_h_arr_t meds;
};
typedef struct mdrpc_updmeds_args mdrpc_updmeds_args;

/*
 * svm rpc version 2 arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_updmeds_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_updmeds_args rev1;
	} mdrpc_updmeds_2_args_u;
};
typedef struct mdrpc_updmeds_2_args mdrpc_updmeds_2_args;

struct mdrpc_mnsetmaster_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	md_node_nm_t master_nodenm;
	int master_nodeid;
};
typedef struct mdrpc_mnsetmaster_args mdrpc_mnsetmaster_args;

/*
 * svm rpc version 2 arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_mnsetmaster_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_mnsetmaster_args rev1;
	} mdrpc_mnsetmaster_2_args_u;
};
typedef struct mdrpc_mnsetmaster_2_args mdrpc_mnsetmaster_2_args;
#define	COMMDCTL_SUSPEND	1
#define	COMMDCTL_RESUME		2
#define	COMMDCTL_REINIT		3

struct mdrpc_mdcommdctl_args {
	int flag_action;
	set_t setno;
	md_mn_msgclass_t class;
	int flags;
};
typedef struct mdrpc_mdcommdctl_args mdrpc_mdcommdctl_args;


/*
 * svm rpc version 2 arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_mdcommdctl_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_mdcommdctl_args rev1;
	} mdrpc_mdcommdctl_2_args_u;
};
typedef struct mdrpc_mdcommdctl_2_args mdrpc_mdcommdctl_2_args;

/*
 * svm rpc version 2 (revision 1) nodeid arguments
 */

struct mdrpc_nodeid_args {
	md_setkey_t *cl_sk;
	mdsetname_t *sp;
	struct {
		u_int nodeid_len;
		int *nodeid_val;
	} nodeid;
};
typedef struct mdrpc_nodeid_args mdrpc_nodeid_args;

/*
 * svm rpc version 2 nodeid arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_nodeid_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_nodeid_args rev1;
	} mdrpc_nodeid_2_args_u;
};
typedef struct mdrpc_nodeid_2_args mdrpc_nodeid_2_args;

/*
 * Defines and structures to support suspend and resume I/O
 * driven by a remote node.
 */
#define	MN_SUSP_IO	1
#define	MN_RES_IO	2

/*
 * svm rpc version 2 (revision 1) mn_susp_res_io arguments
 * setno of 0 represents all disksets.
 */

struct mdrpc_mn_susp_res_io_args {
	md_setkey_t *susp_res_l_sk;
	set_t susp_res_setno;
	int susp_res_cmd;
};
typedef struct mdrpc_mn_susp_res_io_args mdrpc_mn_susp_res_io_args;

/*
 * svm rpc version 2 nodeid arguments
 * (union of all version 2 revisions)
 */

struct mdrpc_mn_susp_res_io_2_args {
	mdrpc_metad_args_rev rev;
	union {
		mdrpc_mn_susp_res_io_args rev1;
	} mdrpc_mn_susp_res_io_2_args_u;
};
typedef struct mdrpc_mn_susp_res_io_2_args mdrpc_mn_susp_res_io_2_args;

/*
 *	authorization info
 */
#define	METAD_GID 14

/*
 *	services available
 */

extern	void	short_circuit_getset(mdrpc_getset_args *args,
		    mdrpc_getset_res *res);
extern	void	short_circuit_mngetset(mdrpc_getset_args *args,
		    mdrpc_mngetset_res *res);

#define	METAD	100229
#define	METAD_VERSION	1

#if defined(__STDC__) || defined(__cplusplus)
#define	mdrpc_nullproc	0
extern  enum clnt_stat mdrpc_nullproc_1(void *, md_error_t *, CLIENT *);
extern  bool_t mdrpc_nullproc_1_svc(void *, md_error_t *, struct svc_req *);
#define	mdrpc_hostname	1
extern  enum clnt_stat mdrpc_hostname_1(mdrpc_null_args *, mdrpc_hostname_res *, CLIENT *);
extern  bool_t mdrpc_hostname_1_svc(mdrpc_null_args *, mdrpc_hostname_res *, struct svc_req *);
#define	mdrpc_addhosts	2
extern  enum clnt_stat mdrpc_addhosts_1(mdrpc_host_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_addhosts_1_svc(mdrpc_host_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_delhosts	3
extern  enum clnt_stat mdrpc_delhosts_1(mdrpc_host_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_delhosts_1_svc(mdrpc_host_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_createset	4
extern  enum clnt_stat mdrpc_createset_1(mdrpc_createset_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_createset_1_svc(mdrpc_createset_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_delset	5
extern  enum clnt_stat mdrpc_delset_1(mdrpc_sp_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_delset_1_svc(mdrpc_sp_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_getset	6
extern  enum clnt_stat mdrpc_getset_1(mdrpc_getset_args *, mdrpc_getset_res *, CLIENT *);
extern  bool_t mdrpc_getset_1_svc(mdrpc_getset_args *, mdrpc_getset_res *, struct svc_req *);
#define	mdrpc_setnumbusy	7
extern  enum clnt_stat mdrpc_setnumbusy_1(mdrpc_setno_args *, mdrpc_bool_res *, CLIENT *);
extern  bool_t mdrpc_setnumbusy_1_svc(mdrpc_setno_args *, mdrpc_bool_res *, struct svc_req *);
#define	mdrpc_setnameok	8
extern  enum clnt_stat mdrpc_setnameok_1(mdrpc_sp_args *, mdrpc_bool_res *, CLIENT *);
extern  bool_t mdrpc_setnameok_1_svc(mdrpc_sp_args *, mdrpc_bool_res *, struct svc_req *);
#define	mdrpc_ownset	9
extern  enum clnt_stat mdrpc_ownset_1(mdrpc_sp_args *, mdrpc_bool_res *, CLIENT *);
extern  bool_t mdrpc_ownset_1_svc(mdrpc_sp_args *, mdrpc_bool_res *, struct svc_req *);
#define	mdrpc_adddrvs	10
extern  enum clnt_stat mdrpc_adddrvs_1(mdrpc_drives_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_adddrvs_1_svc(mdrpc_drives_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_deldrvs	11
extern  enum clnt_stat mdrpc_deldrvs_1(mdrpc_drives_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_deldrvs_1_svc(mdrpc_drives_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_upd_dr_dbinfo	12
extern  enum clnt_stat mdrpc_upd_dr_dbinfo_1(mdrpc_drives_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_upd_dr_dbinfo_1_svc(mdrpc_drives_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_devinfo	13
extern  enum clnt_stat mdrpc_devinfo_1(mdrpc_devinfo_args *, mdrpc_devinfo_res *, CLIENT *);
extern  bool_t mdrpc_devinfo_1_svc(mdrpc_devinfo_args *, mdrpc_devinfo_res *, struct svc_req *);
#define	mdrpc_drvused	14
extern  enum clnt_stat mdrpc_drvused_1(mdrpc_drvused_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_drvused_1_svc(mdrpc_drvused_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_add_drv_sidenms	15
extern  enum clnt_stat mdrpc_add_drv_sidenms_1(mdrpc_drv_sidenm_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_add_drv_sidenms_1_svc(mdrpc_drv_sidenm_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_del_drv_sidenms	16
extern  enum clnt_stat mdrpc_del_drv_sidenms_1(mdrpc_sp_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_del_drv_sidenms_1_svc(mdrpc_sp_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_gtimeout	17
extern  enum clnt_stat mdrpc_gtimeout_1(mdrpc_sp_args *, mdrpc_gtimeout_res *, CLIENT *);
extern  bool_t mdrpc_gtimeout_1_svc(mdrpc_sp_args *, mdrpc_gtimeout_res *, struct svc_req *);
#define	mdrpc_stimeout	18
extern  enum clnt_stat mdrpc_stimeout_1(mdrpc_stimeout_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_stimeout_1_svc(mdrpc_stimeout_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_upd_dr_flags	19
extern  enum clnt_stat mdrpc_upd_dr_flags_1(mdrpc_upd_dr_flags_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_upd_dr_flags_1_svc(mdrpc_upd_dr_flags_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_upd_sr_flags	20
extern  enum clnt_stat mdrpc_upd_sr_flags_1(mdrpc_upd_sr_flags_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_upd_sr_flags_1_svc(mdrpc_upd_sr_flags_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_unlock_set	21
extern  enum clnt_stat mdrpc_unlock_set_1(mdrpc_null_args *, mdrpc_setlock_res *, CLIENT *);
extern  bool_t mdrpc_unlock_set_1_svc(mdrpc_null_args *, mdrpc_setlock_res *, struct svc_req *);
#define	mdrpc_lock_set	22
extern  enum clnt_stat mdrpc_lock_set_1(mdrpc_null_args *, mdrpc_setlock_res *, CLIENT *);
extern  bool_t mdrpc_lock_set_1_svc(mdrpc_null_args *, mdrpc_setlock_res *, struct svc_req *);
#define	mdrpc_updmeds	23
extern  enum clnt_stat mdrpc_updmeds_1(mdrpc_updmeds_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_updmeds_1_svc(mdrpc_updmeds_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_flush_internal	24
extern  enum clnt_stat mdrpc_flush_internal_1(mdrpc_null_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_flush_internal_1_svc(mdrpc_null_args *, mdrpc_generic_res *, struct svc_req *);
extern int metad_1_freeresult(SVCXPRT *, xdrproc_t, caddr_t);

#else /* K&R C */
#define	mdrpc_nullproc	0
extern  enum clnt_stat mdrpc_nullproc_1();
extern  bool_t mdrpc_nullproc_1_svc();
#define	mdrpc_hostname	1
extern  enum clnt_stat mdrpc_hostname_1();
extern  bool_t mdrpc_hostname_1_svc();
#define	mdrpc_addhosts	2
extern  enum clnt_stat mdrpc_addhosts_1();
extern  bool_t mdrpc_addhosts_1_svc();
#define	mdrpc_delhosts	3
extern  enum clnt_stat mdrpc_delhosts_1();
extern  bool_t mdrpc_delhosts_1_svc();
#define	mdrpc_createset	4
extern  enum clnt_stat mdrpc_createset_1();
extern  bool_t mdrpc_createset_1_svc();
#define	mdrpc_delset	5
extern  enum clnt_stat mdrpc_delset_1();
extern  bool_t mdrpc_delset_1_svc();
#define	mdrpc_getset	6
extern  enum clnt_stat mdrpc_getset_1();
extern  bool_t mdrpc_getset_1_svc();
#define	mdrpc_setnumbusy	7
extern  enum clnt_stat mdrpc_setnumbusy_1();
extern  bool_t mdrpc_setnumbusy_1_svc();
#define	mdrpc_setnameok	8
extern  enum clnt_stat mdrpc_setnameok_1();
extern  bool_t mdrpc_setnameok_1_svc();
#define	mdrpc_ownset	9
extern  enum clnt_stat mdrpc_ownset_1();
extern  bool_t mdrpc_ownset_1_svc();
#define	mdrpc_adddrvs	10
extern  enum clnt_stat mdrpc_adddrvs_1();
extern  bool_t mdrpc_adddrvs_1_svc();
#define	mdrpc_deldrvs	11
extern  enum clnt_stat mdrpc_deldrvs_1();
extern  bool_t mdrpc_deldrvs_1_svc();
#define	mdrpc_upd_dr_dbinfo	12
extern  enum clnt_stat mdrpc_upd_dr_dbinfo_1();
extern  bool_t mdrpc_upd_dr_dbinfo_1_svc();
#define	mdrpc_devinfo	13
extern  enum clnt_stat mdrpc_devinfo_1();
extern  bool_t mdrpc_devinfo_1_svc();
#define	mdrpc_drvused	14
extern  enum clnt_stat mdrpc_drvused_1();
extern  bool_t mdrpc_drvused_1_svc();
#define	mdrpc_add_drv_sidenms	15
extern  enum clnt_stat mdrpc_add_drv_sidenms_1();
extern  bool_t mdrpc_add_drv_sidenms_1_svc();
#define	mdrpc_del_drv_sidenms	16
extern  enum clnt_stat mdrpc_del_drv_sidenms_1();
extern  bool_t mdrpc_del_drv_sidenms_1_svc();
#define	mdrpc_gtimeout	17
extern  enum clnt_stat mdrpc_gtimeout_1();
extern  bool_t mdrpc_gtimeout_1_svc();
#define	mdrpc_stimeout	18
extern  enum clnt_stat mdrpc_stimeout_1();
extern  bool_t mdrpc_stimeout_1_svc();
#define	mdrpc_upd_dr_flags	19
extern  enum clnt_stat mdrpc_upd_dr_flags_1();
extern  bool_t mdrpc_upd_dr_flags_1_svc();
#define	mdrpc_upd_sr_flags	20
extern  enum clnt_stat mdrpc_upd_sr_flags_1();
extern  bool_t mdrpc_upd_sr_flags_1_svc();
#define	mdrpc_unlock_set	21
extern  enum clnt_stat mdrpc_unlock_set_1();
extern  bool_t mdrpc_unlock_set_1_svc();
#define	mdrpc_lock_set	22
extern  enum clnt_stat mdrpc_lock_set_1();
extern  bool_t mdrpc_lock_set_1_svc();
#define	mdrpc_updmeds	23
extern  enum clnt_stat mdrpc_updmeds_1();
extern  bool_t mdrpc_updmeds_1_svc();
#define	mdrpc_flush_internal	24
extern  enum clnt_stat mdrpc_flush_internal_1();
extern  bool_t mdrpc_flush_internal_1_svc();
extern int metad_1_freeresult();
#endif /* K&R C */
#define	METAD_VERSION_DEVID	2

#if defined(__STDC__) || defined(__cplusplus)
extern  enum clnt_stat mdrpc_nullproc_2(void *, md_error_t *, CLIENT *);
extern  bool_t mdrpc_nullproc_2_svc(void *, md_error_t *, struct svc_req *);
extern  enum clnt_stat mdrpc_hostname_2(mdrpc_null_args *, mdrpc_hostname_res *, CLIENT *);
extern  bool_t mdrpc_hostname_2_svc(mdrpc_null_args *, mdrpc_hostname_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_addhosts_2(mdrpc_host_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_addhosts_2_svc(mdrpc_host_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_delhosts_2(mdrpc_host_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_delhosts_2_svc(mdrpc_host_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_createset_2(mdrpc_createset_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_createset_2_svc(mdrpc_createset_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_delset_2(mdrpc_sp_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_delset_2_svc(mdrpc_sp_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_getset_2(mdrpc_getset_2_args *, mdrpc_getset_res *, CLIENT *);
extern  bool_t mdrpc_getset_2_svc(mdrpc_getset_2_args *, mdrpc_getset_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_setnumbusy_2(mdrpc_setno_2_args *, mdrpc_bool_res *, CLIENT *);
extern  bool_t mdrpc_setnumbusy_2_svc(mdrpc_setno_2_args *, mdrpc_bool_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_setnameok_2(mdrpc_sp_2_args *, mdrpc_bool_res *, CLIENT *);
extern  bool_t mdrpc_setnameok_2_svc(mdrpc_sp_2_args *, mdrpc_bool_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_ownset_2(mdrpc_sp_2_args *, mdrpc_bool_res *, CLIENT *);
extern  bool_t mdrpc_ownset_2_svc(mdrpc_sp_2_args *, mdrpc_bool_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_adddrvs_2(mdrpc_drives_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_adddrvs_2_svc(mdrpc_drives_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_deldrvs_2(mdrpc_drives_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_deldrvs_2_svc(mdrpc_drives_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_upd_dr_dbinfo_2(mdrpc_drives_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_upd_dr_dbinfo_2_svc(mdrpc_drives_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_devinfo_2(mdrpc_devinfo_2_args *, mdrpc_devinfo_2_res *, CLIENT *);
extern  bool_t mdrpc_devinfo_2_svc(mdrpc_devinfo_2_args *, mdrpc_devinfo_2_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_drvused_2(mdrpc_drvused_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_drvused_2_svc(mdrpc_drvused_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_add_drv_sidenms_2(mdrpc_drv_sidenm_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_add_drv_sidenms_2_svc(mdrpc_drv_sidenm_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_del_drv_sidenms_2(mdrpc_sp_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_del_drv_sidenms_2_svc(mdrpc_sp_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_gtimeout_2(mdrpc_sp_2_args *, mdrpc_gtimeout_res *, CLIENT *);
extern  bool_t mdrpc_gtimeout_2_svc(mdrpc_sp_2_args *, mdrpc_gtimeout_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_stimeout_2(mdrpc_stimeout_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_stimeout_2_svc(mdrpc_stimeout_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_upd_dr_flags_2(mdrpc_upd_dr_flags_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_upd_dr_flags_2_svc(mdrpc_upd_dr_flags_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_upd_sr_flags_2(mdrpc_upd_sr_flags_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_upd_sr_flags_2_svc(mdrpc_upd_sr_flags_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_unlock_set_2(mdrpc_null_args *, mdrpc_setlock_res *, CLIENT *);
extern  bool_t mdrpc_unlock_set_2_svc(mdrpc_null_args *, mdrpc_setlock_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_lock_set_2(mdrpc_null_args *, mdrpc_setlock_res *, CLIENT *);
extern  bool_t mdrpc_lock_set_2_svc(mdrpc_null_args *, mdrpc_setlock_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_updmeds_2(mdrpc_updmeds_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_updmeds_2_svc(mdrpc_updmeds_2_args *, mdrpc_generic_res *, struct svc_req *);
extern  enum clnt_stat mdrpc_flush_internal_2(mdrpc_null_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_flush_internal_2_svc(mdrpc_null_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_devid	25
extern  enum clnt_stat mdrpc_devid_2(mdrpc_devid_2_args *, mdrpc_devid_res *, CLIENT *);
extern  bool_t mdrpc_devid_2_svc(mdrpc_devid_2_args *, mdrpc_devid_res *, struct svc_req *);
#define	mdrpc_devinfo_by_devid	26
extern  enum clnt_stat mdrpc_devinfo_by_devid_2(mdrpc_devidstr_args *, mdrpc_devinfo_2_res *, CLIENT *);
extern  bool_t mdrpc_devinfo_by_devid_2_svc(mdrpc_devidstr_args *, mdrpc_devinfo_2_res *, struct svc_req *);
#define	mdrpc_resnarf_set	27
extern  enum clnt_stat mdrpc_resnarf_set_2(mdrpc_setno_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_resnarf_set_2_svc(mdrpc_setno_2_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_mncreateset	28
extern  enum clnt_stat mdrpc_mncreateset_2(mdrpc_mncreateset_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_mncreateset_2_svc(mdrpc_mncreateset_2_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_mngetset	29
extern  enum clnt_stat mdrpc_mngetset_2(mdrpc_getset_2_args *, mdrpc_mngetset_res *, CLIENT *);
extern  bool_t mdrpc_mngetset_2_svc(mdrpc_getset_2_args *, mdrpc_mngetset_res *, struct svc_req *);
#define	mdrpc_mnsetmaster	30
extern  enum clnt_stat mdrpc_mnsetmaster_2(mdrpc_mnsetmaster_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_mnsetmaster_2_svc(mdrpc_mnsetmaster_2_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_joinset	31
extern  enum clnt_stat mdrpc_joinset_2(mdrpc_sp_flags_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_joinset_2_svc(mdrpc_sp_flags_2_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_withdrawset	32
extern  enum clnt_stat mdrpc_withdrawset_2(mdrpc_sp_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_withdrawset_2_svc(mdrpc_sp_2_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_upd_nr_flags	33
extern  enum clnt_stat mdrpc_upd_nr_flags_2(mdrpc_upd_nr_flags_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_upd_nr_flags_2_svc(mdrpc_upd_nr_flags_2_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_mn_is_stale	34
extern  enum clnt_stat mdrpc_mn_is_stale_2(mdrpc_setno_2_args *, mdrpc_bool_res *, CLIENT *);
extern  bool_t mdrpc_mn_is_stale_2_svc(mdrpc_setno_2_args *, mdrpc_bool_res *, struct svc_req *);
#define	mdrpc_mdcommdctl	35
extern  enum clnt_stat mdrpc_mdcommdctl_2(mdrpc_mdcommdctl_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_mdcommdctl_2_svc(mdrpc_mdcommdctl_2_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_clr_mnsetlock	36
extern  enum clnt_stat mdrpc_clr_mnsetlock_2(mdrpc_null_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_clr_mnsetlock_2_svc(mdrpc_null_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_getdrivedesc	37
extern  enum clnt_stat mdrpc_getdrivedesc_2(mdrpc_sp_2_args *, mdrpc_getdrivedesc_res *, CLIENT *);
extern  bool_t mdrpc_getdrivedesc_2_svc(mdrpc_sp_2_args *, mdrpc_getdrivedesc_res *, struct svc_req *);
#define	mdrpc_upd_dr_reconfig	38
extern  enum clnt_stat mdrpc_upd_dr_reconfig_2(mdrpc_upd_dr_flags_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_upd_dr_reconfig_2_svc(mdrpc_upd_dr_flags_2_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_reset_mirror_owner	39
extern  enum clnt_stat mdrpc_reset_mirror_owner_2(mdrpc_nodeid_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_reset_mirror_owner_2_svc(mdrpc_nodeid_2_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_mn_susp_res_io	40
extern  enum clnt_stat mdrpc_mn_susp_res_io_2(mdrpc_mn_susp_res_io_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_mn_susp_res_io_2_svc(mdrpc_mn_susp_res_io_2_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_mn_mirror_resync_all	41
extern  enum clnt_stat mdrpc_mn_mirror_resync_all_2(mdrpc_setno_2_args *, mdrpc_generic_res *, CLIENT *);
extern  bool_t mdrpc_mn_mirror_resync_all_2_svc(mdrpc_setno_2_args *, mdrpc_generic_res *, struct svc_req *);
#define	mdrpc_devinfo_by_devid_name	42
extern  enum clnt_stat mdrpc_devinfo_by_devid_name_2(mdrpc_devid_name_2_args *, mdrpc_devinfo_2_res *, CLIENT *);
extern  bool_t mdrpc_devinfo_by_devid_name_2_svc(mdrpc_devid_name_2_args *, mdrpc_devinfo_2_res *, struct svc_req *);
extern int metad_2_freeresult(SVCXPRT *, xdrproc_t, caddr_t);

#else /* K&R C */
extern  enum clnt_stat mdrpc_nullproc_2();
extern  bool_t mdrpc_nullproc_2_svc();
extern  enum clnt_stat mdrpc_hostname_2();
extern  bool_t mdrpc_hostname_2_svc();
extern  enum clnt_stat mdrpc_addhosts_2();
extern  bool_t mdrpc_addhosts_2_svc();
extern  enum clnt_stat mdrpc_delhosts_2();
extern  bool_t mdrpc_delhosts_2_svc();
extern  enum clnt_stat mdrpc_createset_2();
extern  bool_t mdrpc_createset_2_svc();
extern  enum clnt_stat mdrpc_delset_2();
extern  bool_t mdrpc_delset_2_svc();
extern  enum clnt_stat mdrpc_getset_2();
extern  bool_t mdrpc_getset_2_svc();
extern  enum clnt_stat mdrpc_setnumbusy_2();
extern  bool_t mdrpc_setnumbusy_2_svc();
extern  enum clnt_stat mdrpc_setnameok_2();
extern  bool_t mdrpc_setnameok_2_svc();
extern  enum clnt_stat mdrpc_ownset_2();
extern  bool_t mdrpc_ownset_2_svc();
extern  enum clnt_stat mdrpc_adddrvs_2();
extern  bool_t mdrpc_adddrvs_2_svc();
extern  enum clnt_stat mdrpc_deldrvs_2();
extern  bool_t mdrpc_deldrvs_2_svc();
extern  enum clnt_stat mdrpc_upd_dr_dbinfo_2();
extern  bool_t mdrpc_upd_dr_dbinfo_2_svc();
extern  enum clnt_stat mdrpc_devinfo_2();
extern  bool_t mdrpc_devinfo_2_svc();
extern  enum clnt_stat mdrpc_drvused_2();
extern  bool_t mdrpc_drvused_2_svc();
extern  enum clnt_stat mdrpc_add_drv_sidenms_2();
extern  bool_t mdrpc_add_drv_sidenms_2_svc();
extern  enum clnt_stat mdrpc_del_drv_sidenms_2();
extern  bool_t mdrpc_del_drv_sidenms_2_svc();
extern  enum clnt_stat mdrpc_gtimeout_2();
extern  bool_t mdrpc_gtimeout_2_svc();
extern  enum clnt_stat mdrpc_stimeout_2();
extern  bool_t mdrpc_stimeout_2_svc();
extern  enum clnt_stat mdrpc_upd_dr_flags_2();
extern  bool_t mdrpc_upd_dr_flags_2_svc();
extern  enum clnt_stat mdrpc_upd_sr_flags_2();
extern  bool_t mdrpc_upd_sr_flags_2_svc();
extern  enum clnt_stat mdrpc_unlock_set_2();
extern  bool_t mdrpc_unlock_set_2_svc();
extern  enum clnt_stat mdrpc_lock_set_2();
extern  bool_t mdrpc_lock_set_2_svc();
extern  enum clnt_stat mdrpc_updmeds_2();
extern  bool_t mdrpc_updmeds_2_svc();
extern  enum clnt_stat mdrpc_flush_internal_2();
extern  bool_t mdrpc_flush_internal_2_svc();
#define	mdrpc_devid	25
extern  enum clnt_stat mdrpc_devid_2();
extern  bool_t mdrpc_devid_2_svc();
#define	mdrpc_devinfo_by_devid	26
extern  enum clnt_stat mdrpc_devinfo_by_devid_2();
extern  bool_t mdrpc_devinfo_by_devid_2_svc();
#define	mdrpc_resnarf_set	27
extern  enum clnt_stat mdrpc_resnarf_set_2();
extern  bool_t mdrpc_resnarf_set_2_svc();
#define	mdrpc_mncreateset	28
extern  enum clnt_stat mdrpc_mncreateset_2();
extern  bool_t mdrpc_mncreateset_2_svc();
#define	mdrpc_mngetset	29
extern  enum clnt_stat mdrpc_mngetset_2();
extern  bool_t mdrpc_mngetset_2_svc();
#define	mdrpc_mnsetmaster	30
extern  enum clnt_stat mdrpc_mnsetmaster_2();
extern  bool_t mdrpc_mnsetmaster_2_svc();
#define	mdrpc_joinset	31
extern  enum clnt_stat mdrpc_joinset_2();
extern  bool_t mdrpc_joinset_2_svc();
#define	mdrpc_withdrawset	32
extern  enum clnt_stat mdrpc_withdrawset_2();
extern  bool_t mdrpc_withdrawset_2_svc();
#define	mdrpc_upd_nr_flags	33
extern  enum clnt_stat mdrpc_upd_nr_flags_2();
extern  bool_t mdrpc_upd_nr_flags_2_svc();
#define	mdrpc_mn_is_stale	34
extern  enum clnt_stat mdrpc_mn_is_stale_2();
extern  bool_t mdrpc_mn_is_stale_2_svc();
#define	mdrpc_mdcommdctl	35
extern  enum clnt_stat mdrpc_mdcommdctl_2();
extern  bool_t mdrpc_mdcommdctl_2_svc();
#define	mdrpc_clr_mnsetlock	36
extern  enum clnt_stat mdrpc_clr_mnsetlock_2();
extern  bool_t mdrpc_clr_mnsetlock_2_svc();
#define	mdrpc_getdrivedesc	37
extern  enum clnt_stat mdrpc_getdrivedesc_2();
extern  bool_t mdrpc_getdrivedesc_2_svc();
#define	mdrpc_upd_dr_reconfig	38
extern  enum clnt_stat mdrpc_upd_dr_reconfig_2();
extern  bool_t mdrpc_upd_dr_reconfig_2_svc();
#define	mdrpc_reset_mirror_owner	39
extern  enum clnt_stat mdrpc_reset_mirror_owner_2();
extern  bool_t mdrpc_reset_mirror_owner_2_svc();
#define	mdrpc_mn_susp_res_io	40
extern  enum clnt_stat mdrpc_mn_susp_res_io_2();
extern  bool_t mdrpc_mn_susp_res_io_2_svc();
#define	mdrpc_mn_mirror_resync_all	41
extern  enum clnt_stat mdrpc_mn_mirror_resync_all_2();
extern  bool_t mdrpc_mn_mirror_resync_all_2_svc();
#define	mdrpc_devinfo_by_devid_name	42
extern  enum clnt_stat mdrpc_devinfo_by_devid_name_2();
extern  bool_t mdrpc_devinfo_by_devid_name_2_svc();
extern int metad_2_freeresult();
#endif /* K&R C */

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_mdrpc_metad_args_rev(XDR *, mdrpc_metad_args_rev*);
extern  bool_t xdr_mdrpc_devid_res(XDR *, mdrpc_devid_res*);
extern  bool_t xdr_mdrpc_devid_args(XDR *, mdrpc_devid_args*);
extern  bool_t xdr_mdrpc_devid_2_args(XDR *, mdrpc_devid_2_args*);
extern  bool_t xdr_mdrpc_devidstr_args(XDR *, mdrpc_devidstr_args*);
extern  bool_t xdr_mdrpc_devid_name_args(XDR *, mdrpc_devid_name_args*);
extern  bool_t xdr_mdrpc_devid_name_2_args(XDR *, mdrpc_devid_name_2_args*);
extern  bool_t xdr_mdrpc_devinfo_res(XDR *, mdrpc_devinfo_res*);
extern  bool_t xdr_mdrpc_devinfo_2_res(XDR *, mdrpc_devinfo_2_res*);
extern  bool_t xdr_mdrpc_devinfo_args(XDR *, mdrpc_devinfo_args*);
extern  bool_t xdr_mdrpc_devinfo_2_args_r1(XDR *, mdrpc_devinfo_2_args_r1*);
extern  bool_t xdr_mdrpc_devinfo_2_args(XDR *, mdrpc_devinfo_2_args*);
extern  bool_t xdr_mdrpc_hostname_res(XDR *, mdrpc_hostname_res*);
extern  bool_t xdr_mdrpc_getset_args(XDR *, mdrpc_getset_args*);
extern  bool_t xdr_mdrpc_getset_2_args(XDR *, mdrpc_getset_2_args*);
extern  bool_t xdr_mdrpc_getset_res(XDR *, mdrpc_getset_res*);
extern  bool_t xdr_mdrpc_mngetset_res(XDR *, mdrpc_mngetset_res*);
extern  bool_t xdr_mdrpc_getdrivedesc_res(XDR *, mdrpc_getdrivedesc_res*);
extern  bool_t xdr_stringarray(XDR *, stringarray*);
extern  bool_t xdr_mdrpc_createset_args(XDR *, mdrpc_createset_args*);
extern  bool_t xdr_mdrpc_createset_2_args(XDR *, mdrpc_createset_2_args*);
extern  bool_t xdr_mdrpc_mncreateset_args(XDR *, mdrpc_mncreateset_args*);
extern  bool_t xdr_mdrpc_mncreateset_2_args(XDR *, mdrpc_mncreateset_2_args*);
extern  bool_t xdr_mdrpc_bool_res(XDR *, mdrpc_bool_res*);
extern  bool_t xdr_mdrpc_drives_args(XDR *, mdrpc_drives_args*);
extern  bool_t xdr_mdrpc_drives_2_args_r1(XDR *, mdrpc_drives_2_args_r1*);
extern  bool_t xdr_mdrpc_drives_2_args(XDR *, mdrpc_drives_2_args*);
extern  bool_t xdr_mdrpc_drv_sidenm_args(XDR *, mdrpc_drv_sidenm_args*);
extern  bool_t xdr_mdrpc_drv_sidenm_2_args_r1(XDR *, mdrpc_drv_sidenm_2_args_r1*);
extern  bool_t xdr_mdrpc_drv_sidenm_2_args(XDR *, mdrpc_drv_sidenm_2_args*);
extern  bool_t xdr_mdrpc_drvused_args(XDR *, mdrpc_drvused_args*);
extern  bool_t xdr_mdrpc_drvused_2_args_r1(XDR *, mdrpc_drvused_2_args_r1*);
extern  bool_t xdr_mdrpc_drvused_2_args(XDR *, mdrpc_drvused_2_args*);
extern  bool_t xdr_mdrpc_host_args(XDR *, mdrpc_host_args*);
extern  bool_t xdr_mdrpc_host_2_args(XDR *, mdrpc_host_2_args*);
extern  bool_t xdr_mdrpc_gtimeout_res(XDR *, mdrpc_gtimeout_res*);
extern  bool_t xdr_mdrpc_stimeout_args(XDR *, mdrpc_stimeout_args*);
extern  bool_t xdr_mdrpc_stimeout_2_args(XDR *, mdrpc_stimeout_2_args*);
extern  bool_t xdr_mdrpc_upd_dr_flags_args(XDR *, mdrpc_upd_dr_flags_args*);
extern  bool_t xdr_mdrpc_upd_dr_flags_2_args_r1(XDR *, mdrpc_upd_dr_flags_2_args_r1*);
extern  bool_t xdr_mdrpc_upd_dr_flags_2_args(XDR *, mdrpc_upd_dr_flags_2_args*);
extern  bool_t xdr_mdrpc_upd_sr_flags_args(XDR *, mdrpc_upd_sr_flags_args*);
extern  bool_t xdr_mdrpc_upd_sr_flags_2_args(XDR *, mdrpc_upd_sr_flags_2_args*);
extern  bool_t xdr_mdrpc_upd_nr_flags_args(XDR *, mdrpc_upd_nr_flags_args*);
extern  bool_t xdr_mdrpc_upd_nr_flags_2_args(XDR *, mdrpc_upd_nr_flags_2_args*);
extern  bool_t xdr_mdrpc_setlock_res(XDR *, mdrpc_setlock_res*);
extern  bool_t xdr_mdrpc_generic_res(XDR *, mdrpc_generic_res*);
extern  bool_t xdr_mdrpc_setno_args(XDR *, mdrpc_setno_args*);
extern  bool_t xdr_mdrpc_setno_2_args(XDR *, mdrpc_setno_2_args*);
extern  bool_t xdr_mdrpc_null_args(XDR *, mdrpc_null_args*);
extern  bool_t xdr_mdrpc_sp_args(XDR *, mdrpc_sp_args*);
extern  bool_t xdr_mdrpc_sp_2_args(XDR *, mdrpc_sp_2_args*);
extern  bool_t xdr_mdrpc_sp_flags_args(XDR *, mdrpc_sp_flags_args*);
extern  bool_t xdr_mdrpc_sp_flags_2_args(XDR *, mdrpc_sp_flags_2_args*);
extern  bool_t xdr_mdrpc_updmeds_args(XDR *, mdrpc_updmeds_args*);
extern  bool_t xdr_mdrpc_updmeds_2_args(XDR *, mdrpc_updmeds_2_args*);
extern  bool_t xdr_mdrpc_mnsetmaster_args(XDR *, mdrpc_mnsetmaster_args*);
extern  bool_t xdr_mdrpc_mnsetmaster_2_args(XDR *, mdrpc_mnsetmaster_2_args*);
extern  bool_t xdr_mdrpc_mdcommdctl_args(XDR *, mdrpc_mdcommdctl_args*);
extern  bool_t xdr_mdrpc_mdcommdctl_2_args(XDR *, mdrpc_mdcommdctl_2_args*);
extern  bool_t xdr_mdrpc_nodeid_args(XDR *, mdrpc_nodeid_args*);
extern  bool_t xdr_mdrpc_nodeid_2_args(XDR *, mdrpc_nodeid_2_args*);
extern  bool_t xdr_mdrpc_mn_susp_res_io_args(XDR *, mdrpc_mn_susp_res_io_args*);
extern  bool_t xdr_mdrpc_mn_susp_res_io_2_args(XDR *, mdrpc_mn_susp_res_io_2_args*);

#else /* K&R C */
extern bool_t xdr_mdrpc_metad_args_rev();
extern bool_t xdr_mdrpc_devid_res();
extern bool_t xdr_mdrpc_devid_args();
extern bool_t xdr_mdrpc_devid_2_args();
extern bool_t xdr_mdrpc_devidstr_args();
extern bool_t xdr_mdrpc_devid_name_args();
extern bool_t xdr_mdrpc_devid_name_2_args();
extern bool_t xdr_mdrpc_devinfo_res();
extern bool_t xdr_mdrpc_devinfo_2_res();
extern bool_t xdr_mdrpc_devinfo_args();
extern bool_t xdr_mdrpc_devinfo_2_args_r1();
extern bool_t xdr_mdrpc_devinfo_2_args();
extern bool_t xdr_mdrpc_hostname_res();
extern bool_t xdr_mdrpc_getset_args();
extern bool_t xdr_mdrpc_getset_2_args();
extern bool_t xdr_mdrpc_getset_res();
extern bool_t xdr_mdrpc_mngetset_res();
extern bool_t xdr_mdrpc_getdrivedesc_res();
extern bool_t xdr_stringarray();
extern bool_t xdr_mdrpc_createset_args();
extern bool_t xdr_mdrpc_createset_2_args();
extern bool_t xdr_mdrpc_mncreateset_args();
extern bool_t xdr_mdrpc_mncreateset_2_args();
extern bool_t xdr_mdrpc_bool_res();
extern bool_t xdr_mdrpc_drives_args();
extern bool_t xdr_mdrpc_drives_2_args_r1();
extern bool_t xdr_mdrpc_drives_2_args();
extern bool_t xdr_mdrpc_drv_sidenm_args();
extern bool_t xdr_mdrpc_drv_sidenm_2_args_r1();
extern bool_t xdr_mdrpc_drv_sidenm_2_args();
extern bool_t xdr_mdrpc_drvused_args();
extern bool_t xdr_mdrpc_drvused_2_args_r1();
extern bool_t xdr_mdrpc_drvused_2_args();
extern bool_t xdr_mdrpc_host_args();
extern bool_t xdr_mdrpc_host_2_args();
extern bool_t xdr_mdrpc_gtimeout_res();
extern bool_t xdr_mdrpc_stimeout_args();
extern bool_t xdr_mdrpc_stimeout_2_args();
extern bool_t xdr_mdrpc_upd_dr_flags_args();
extern bool_t xdr_mdrpc_upd_dr_flags_2_args_r1();
extern bool_t xdr_mdrpc_upd_dr_flags_2_args();
extern bool_t xdr_mdrpc_upd_sr_flags_args();
extern bool_t xdr_mdrpc_upd_sr_flags_2_args();
extern bool_t xdr_mdrpc_upd_nr_flags_args();
extern bool_t xdr_mdrpc_upd_nr_flags_2_args();
extern bool_t xdr_mdrpc_setlock_res();
extern bool_t xdr_mdrpc_generic_res();
extern bool_t xdr_mdrpc_setno_args();
extern bool_t xdr_mdrpc_setno_2_args();
extern bool_t xdr_mdrpc_null_args();
extern bool_t xdr_mdrpc_sp_args();
extern bool_t xdr_mdrpc_sp_2_args();
extern bool_t xdr_mdrpc_sp_flags_args();
extern bool_t xdr_mdrpc_sp_flags_2_args();
extern bool_t xdr_mdrpc_updmeds_args();
extern bool_t xdr_mdrpc_updmeds_2_args();
extern bool_t xdr_mdrpc_mnsetmaster_args();
extern bool_t xdr_mdrpc_mnsetmaster_2_args();
extern bool_t xdr_mdrpc_mdcommdctl_args();
extern bool_t xdr_mdrpc_mdcommdctl_2_args();
extern bool_t xdr_mdrpc_nodeid_args();
extern bool_t xdr_mdrpc_nodeid_2_args();
extern bool_t xdr_mdrpc_mn_susp_res_io_args();
extern bool_t xdr_mdrpc_mn_susp_res_io_2_args();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_METAD_H_RPCGEN */
