/* Copyright 1999-2004 The Apache Software Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <stdio.h>

/* generate a table of 256 values, where certain characters are
 * marked "interesting"... for the uri parsing process.
 */

int main(int argc, char *argv[])
{
    int i;
    char *value;

    printf("/* this file is automatically generated by "
	    "gen_uri_delims, do not edit */\n");
    printf("static const unsigned char uri_delims[256] = {");
    for (i = 0; i < 256; ++i) {
	if (i % 20 == 0)
	    printf("\n    ");
	switch (i) {
	case ':': 	value = "T_COLON";	break;
	case '/': 	value = "T_SLASH";	break;
	case '?': 	value = "T_QUESTION";	break;
	case '#': 	value = "T_HASH";	break;
	case '\0': 	value = "T_NUL";	break;
	default:	value = "0";		break;
	}
	printf("%s%c", value, (i < 255) ? ',' : ' ');
    }
    printf("\n};\n");

    return 0;
}
