/*
 * Copyright 1993-2002 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_VM_SPT_H
#define	_VM_SPT_H

#pragma ident	"@(#)seg_spt.h	1.18	02/03/26 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#ifndef _ASM

#include <sys/types.h>
#include <sys/t_lock.h>
#include <sys/lgrp.h>

/*
 * Passed data when creating spt segment.
 */
struct  segspt_crargs {
	struct	seg	*seg_spt;
	struct anon_map *amp;
	uint_t		prot;
	uint_t		flags;
};

typedef struct spt_data {
	struct vnode	*spt_vp;
	struct anon_map	*spt_amp;
	size_t 		spt_realsize;
	struct page	**spt_ppa;
	ushort_t	*spt_ppa_lckcnt;
	uint_t		spt_prot;
	kmutex_t 	spt_lock;
	size_t		spt_pcachecnt;	/* # of times in pcache */
	uint_t		spt_flags;	/* Dynamic ISM or regular ISM */
	/*
	 * Initial memory allocation policy
	 * used during pre-allocation done in shmat()
	 */
	lgrp_mem_policy_info_t	spt_policy_info;
} spt_data_t;

/*
 * Private data for spt_shm segment.
 */
typedef struct shm_data {
	struct as	*shm_sptas;
	struct anon_map *shm_amp;
	size_t		shm_softlockcnt; /* # outstanding lock operations */
	struct seg 	*shm_sptseg;	/* pointer to spt segment */
	char		*shm_vpage;	/* indicating locked pages */
	spgcnt_t	shm_lckpgs;	/* # of locked pages per attached seg */
	/*
	 * Memory allocation policy after shmat()
	 */
	lgrp_mem_policy_info_t	shm_policy_info;
} shm_data_t;

#define	DISM_PG_LOCKED		0x1	/* DISM page is locked */
#define	DISM_PPA_CHANGED	0x2	/* DISM new lock, need to rebuild ppa */
#define	DISM_LOCK_MAX		0xfffe	/* max number of locks per DISM page */

#endif

#ifdef _KERNEL

#ifndef _ASM

/*
 * Functions used in shm.c to call ISM.
 */
int	sptcreate(size_t size, struct seg **sptseg, struct anon_map *amp,
	    uint_t prot, uint_t flags);
void	sptdestroy(struct as *, struct anon_map *);
int	segspt_shmattach(struct seg *, caddr_t *);

#define	isspt(sp)	((sp)->shm_sptinfo ? (sp)->shm_sptinfo->sptas : NULL)
#define	spt_on(a)	(share_page_table || ((a) & SHM_SHARE_MMU))
#define	spt_pageable(a)	((a) & SHM_PAGEABLE)

/*
 * This can be applied to a segment with seg->s_ops == &segspt_shmops
 * to determine the real size of the ISM segment.
 */
#define	spt_realsize(seg) (((struct spt_data *)(((struct shm_data *)\
			((seg)->s_data))->shm_sptseg->s_data))->spt_realsize)

/*
 * For large page support
 */
extern int segvn_anypgsz;

#endif

/*
 * In a 64-bit address space, we'll try to put ISM segments between
 * PREDISM_BASE and PREDISM_BOUND.  The HAT may use these constants to
 * predict that a VA is contained by an ISM segment, which may optimize
 * translation.  The range must _only_ be treated as advisory; ISM segments
 * may fall outside of the range, and non-ISM segments may be contained
 * within the range.
 */
#define	PREDISM_BASESHIFT	33
#define	PREDISM_BASE		((uintptr_t)1 << PREDISM_BASESHIFT)
#define	PREDISM_BOUND		((uintptr_t)1 << 63)

#endif	/* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _VM_SPT_H */
