/*
 * Copyright (c) 1992-2003 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_INET_MI_H
#define	_INET_MI_H

#pragma ident	"@(#)mi.h	1.43	03/09/18 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef _KERNEL

#include <sys/varargs.h>

#define	MI_MIN_DEV		2	/* minimum minor device number */

#define	MI_COPY_IN		1
#define	MI_COPY_OUT		2
#define	MI_COPY_DIRECTION(mp)	(*(int *)&(mp)->b_cont->b_next)
#define	MI_COPY_COUNT(mp)	(*(int *)&(mp)->b_cont->b_prev)
#define	MI_COPY_CASE(dir, cnt)	(((cnt)<<2)|dir)
#define	MI_COPY_STATE(mp)	MI_COPY_CASE(MI_COPY_DIRECTION(mp), \
					MI_COPY_COUNT(mp))

#ifdef __lint
/* Lint complains about %p with field width specifiers. */
#define	MI_COL_PTRFMT_STR	"%p "
#define	MI_COL_HDRPAD_STR	""
#else
#ifdef _ILP32
#define	MI_COL_PTRFMT_STR	"%08p "
#define	MI_COL_HDRPAD_STR	""
#else
#define	MI_COL_PTRFMT_STR	"%16p "
#define	MI_COL_HDRPAD_STR	"        "
#endif
#endif

/*
 * Double linked list of type MI_O with a mi_head_t as the head.
 * Used for mi_open_comm etc.
 */
typedef struct mi_o_s {
	struct mi_o_s	*mi_o_next;
	struct mi_o_s	*mi_o_prev;
	boolean_t	mi_o_isdev;	/* Is this a device instance */
	dev_t		mi_o_dev;
} MI_O, *MI_OP;

/*
 * List head for MI_O doubly linked list.
 * The list contains unsorted driver, module and detached instances.
 *
 * Minor numbers are allocated from mh_arena which initially contains
 * [MI_MIN_DEV, mh_maxminor] numbers. When this arena is fully allocated, it is
 * extended to MAXMIN32.
 *
 * The module_dev is used to give almost unique numbers to module instances.
 * This is only needed for mi_strlog which uses the mi_o_dev field when
 * logging messages.
 */

typedef struct mi_head_s {
	struct mi_o_s	mh_o;	/* Contains head of doubly linked list */
	vmem_t *mh_arena;	/* Minor number arena */
	int	mh_module_dev;  /* Wraparound number for use when MODOPEN */
	minor_t mh_maxminor;	/* max minor number in the arena */
} mi_head_t;

extern void	*mi_alloc(size_t size, uint_t pri);
extern void	*mi_alloc_sleep(size_t size, uint_t pri);
extern void	mi_free(void *ptr);

extern int	mi_close_comm(void **mi_head, queue_t *q);
extern void	mi_close_free(IDP ptr);
extern void	mi_close_unlink(void **mi_head, IDP ptr);

extern void	mi_copy_dev(IDP, IDP);

extern void	mi_copyin(queue_t *q, MBLKP mp, char *uaddr, size_t len);
extern void	mi_copyout(queue_t *q, MBLKP mp);
extern MBLKP	mi_copyout_alloc(queue_t *q, MBLKP mp, char *uaddr, size_t len);
extern void	mi_copy_done(queue_t *q, MBLKP mp, int err);
extern int	mi_copy_state(queue_t *q, MBLKP mp, MBLKP *mpp);

/* PRINTFLIKE2 */
extern int	mi_mpprintf(MBLKP mp, char *fmt, ...);
/* PRINTFLIKE2 */
extern int	mi_mpprintf_nr(MBLKP mp, char *fmt, ...);
extern int	mi_mpprintf_putc(char *cookie, int ch);

extern IDP	mi_first_ptr(void **mi_head);
extern IDP	mi_first_dev_ptr(void **mi_head);
extern IDP	mi_next_ptr(void **mi_head, IDP ptr);
extern IDP	mi_next_dev_ptr(void **mi_head, IDP ptr);

extern IDP	mi_open_alloc(size_t size);
extern IDP	mi_open_alloc_sleep(size_t size);
extern int	mi_open_comm(void **mi_head, size_t size, queue_t *q,
		    dev_t *devp, int flag, int sflag, cred_t *credp);
extern int	mi_open_link(void **mi_head, IDP ptr, dev_t *devp, int flag,
		    int sflag, cred_t *credp);

extern uint8_t *mi_offset_param(mblk_t *mp, size_t offset, size_t len);
extern uint8_t *mi_offset_paramc(mblk_t *mp, size_t offset, size_t len);


extern boolean_t	mi_set_sth_hiwat(queue_t *q, size_t size);
extern boolean_t	mi_set_sth_lowat(queue_t *q, size_t size);
extern boolean_t	mi_set_sth_maxblk(queue_t *q, ssize_t size);
extern boolean_t	mi_set_sth_copyopt(queue_t *q, int copyopt);
extern boolean_t	mi_set_sth_wroff(queue_t *q, size_t size);

/* PRINTFLIKE2 */
extern int	mi_sprintf(char *buf, char *fmt, ...);
extern int	mi_sprintf_putc(char *cookie, int ch);

extern int	mi_strcmp(const char *cp1, const char *cp2);
extern size_t	mi_strlen(const char *str);

/* PRINTFLIKE4 */
extern int	mi_strlog(queue_t *q, char level, ushort_t flags,
		    char *fmt, ...);

extern long	mi_strtol(const char *str, char **ptr, int base);

extern void	mi_swap(IDP ptr1, IDP ptr2);

extern void	mi_timer(queue_t *q, MBLKP mp, clock_t tim);
extern MBLKP	mi_timer_alloc(size_t size);
extern void	mi_timer_free(MBLKP mp);
extern void	mi_timer_move(queue_t *, mblk_t *);
extern void	mi_timer_stop(mblk_t *);
extern boolean_t	mi_timer_valid(MBLKP mp);

extern MBLKP	mi_tpi_conn_con(MBLKP trailer_mp, char *src,
		    t_scalar_t src_length, char *opt, t_scalar_t opt_length);
extern MBLKP	mi_tpi_conn_ind(MBLKP trailer_mp, char *src,
		    t_scalar_t src_length, char *opt, t_scalar_t opt_length,
		    t_scalar_t seqnum);
extern MBLKP	mi_tpi_extconn_ind(MBLKP trailer_mp, char *src,
		    t_scalar_t src_length, char *opt, t_scalar_t opt_length,
		    char *dst, t_scalar_t dst_length, t_scalar_t seqnum);
extern MBLKP	mi_tpi_discon_ind(MBLKP trailer_mp, t_scalar_t reason,
		    t_scalar_t seqnum);
extern MBLKP	mi_tpi_err_ack_alloc(MBLKP mp, t_scalar_t tlierr, int unixerr);
extern MBLKP	mi_tpi_ok_ack_alloc(MBLKP mp);
extern MBLKP	mi_tpi_ok_ack_alloc_extra(MBLKP mp, int extra);
extern MBLKP	mi_tpi_ordrel_ind(void);
extern MBLKP	mi_tpi_uderror_ind(char *dest, t_scalar_t dest_length,
		    char *opt, t_scalar_t opt_length, t_scalar_t error);

extern IDP	mi_zalloc(size_t size);
extern IDP	mi_zalloc_sleep(size_t size);

#endif	/* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _INET_MI_H */
