/*
 * Copyright 1996-2002 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_MEMNODE_H
#define	_SYS_MEMNODE_H

#pragma ident	"@(#)memnode.h	1.12	02/06/18 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef	_KERNEL

/*
 * This file defines the mappings between physical addresses and memory
 * nodes. Memory nodes are defined so that the low-order bits are the
 * memory slice ID and the high-order bits are the SSM nodeid.
 */

#ifndef	MAX_MEM_NODES
#define	MAX_MEM_NODES	(1)
#endif	/* MAX_MEM_NODES */

#if	(MAX_MEM_NODES > 1)

#define	PFN_2_MEM_NODE(pfn)			\
		(plat_pfn_to_mem_node(pfn))

#define	LGRPHAND_2_MEM_NODE(lgrp_plat_hand)	\
		(plat_lgrphand_to_mem_node(lgrp_plat_hand))

#define	MEM_NODE_2_LGRPHAND(mnode)		\
		(plat_mem_node_to_lgrphand(mnode))

/*
 * Platmod hooks
 */

extern int plat_pfn_to_mem_node(pfn_t);
extern int plat_lgrphand_to_mem_node(void*);
extern void plat_assign_lgrphand_to_mem_node(void *, int);
extern void *plat_mem_node_to_lgrphand(int);
extern void plat_slice_add(pfn_t, pfn_t);
extern void plat_slice_del(pfn_t, pfn_t);

#pragma	weak plat_pfn_to_mem_node
#pragma	weak plat_lgrphand_to_mem_node
#pragma	weak plat_mem_node_to_lgrphand
#pragma	weak plat_slice_add
#pragma	weak plat_slice_del

#else	/* MAX_MEM_NODES == 1 */

#define	PFN_2_MEM_NODE(pfn)		(0)
#define	MEM_NODE_2_LGRPHAND(mnode)	((void*)(0))
#define	LGRPHAND_2_MEM_NODE(lgrp)	(0)

#endif	/* MAX_MEM_NODES > 1 */

struct	mem_node_conf {
	int	exists;		/* only try if set, list may still be empty */
	pfn_t	physbase;	/* lowest PFN in this memnode */
	pfn_t	physmax;	/* highest PFN in this memnode */
	size_t	cursize;	/* current number of PAGESIZE pages on lists */
};

struct memlist;

extern void startup_build_mem_nodes(u_longlong_t *, size_t);
extern void mem_node_add_slice(pfn_t, pfn_t);
extern void mem_node_pre_del_slice(pfn_t, pfn_t);
extern void mem_node_post_del_slice(pfn_t, pfn_t, int);
extern int mem_node_alloc(void);
extern int mem_node_choose(uint64_t *, int *, ulong_t);
extern pgcnt_t mem_node_memlist_pages(int, struct memlist *);


extern struct mem_node_conf	mem_node_config[];
extern uint64_t			mem_node_physalign;
extern int			mem_node_pfn_shift;

#endif	/* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_MEMNODE_H */
