/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.util.InteractiveSessionConsole;
import com.sun.patchpro.util.InteractiveSessionException;
import com.sun.patchpro.util.InteractiveSessionPrtl;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class TelnetSession
extends InteractiveSessionPrtl {
    private static final String COMMAND = "/usr/bin/telnet";
    private static final String PATTERN_LOGIN = "ogin:";
    private static final String PATTERN_LOGIN_INFO = "Sun Microsystems";
    private static final String PATTERN_PASSWORD = "Password";
    private static final int INPUTBUFFERSIZE = 32000;
    private Process process = null;
    private InteractiveSessionConsole interactiveSessionProcess = null;
    private Runtime runtime = null;
    String[] rmCmd = new String[3];
    private PatchProLog log = PatchProLog.getInstance();

    public void connect(String string, String string2, String string3) throws InteractiveSessionException {
        this.rmCmd[0] = COMMAND;
        this.rmCmd[1] = "-r";
        this.rmCmd[2] = string;
        this.log.println(this, 7, "Command: \"" + this.rmCmd[0] + "\", " + "Command options: \"" + this.rmCmd[1] + "\", " + "Host: \"" + this.rmCmd[2] + "\", " + "Username: \"" + string2 + "\", " + "Password: \"" + string3 + "\"");
        try {
            this.runtime = Runtime.getRuntime();
            this.process = this.runtime.exec(this.rmCmd);
            this.setStdInputReader(new BufferedReader(new InputStreamReader(this.process.getInputStream()), 32000));
            this.setStdErrorReader(new BufferedReader(new InputStreamReader(this.process.getErrorStream()), 32000));
            this.setOutPutStreamWriter(new OutputStreamWriter(this.process.getOutputStream()));
            this.setArrayOutputStream(new ByteArrayOutputStream());
            this.setSessionArrayOutputStream(new ByteArrayOutputStream());
            this.interactiveSessionProcess = new InteractiveSessionConsole(this);
            this.interactiveSessionProcess.start();
            if (!this.waitfor(PATTERN_LOGIN, 15000)) {
                throw new InteractiveSessionException("Cannot establish connection to \"" + string + "\". Verify that \"" + string + "\" is accessible within your network environment.");
            }
            if (!this.expectedResponse(string2 + "\r", PATTERN_PASSWORD, 15000)) {
                throw new InteractiveSessionException("Cannot establish connection to \"" + string + "\"" + " Was not prompted for password.");
            }
            this.send(string3 + "\r", 5000);
        }
        catch (Exception exception) {
            this.cleanup();
            throw new InteractiveSessionException(exception.getMessage());
        }
    }

    public void disconnect() throws InteractiveSessionException {
        this.waitfor(5000);
        this.send("exit\r");
        this.cleanup();
    }

    private void cleanup() {
        this.setTerminateStatus();
        if (this.interactiveSessionProcess != null) {
            try {
                this.interactiveSessionProcess.join(120000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.gc();
        this.setStdInputReader(null);
        this.setStdErrorReader(null);
        this.setOutPutStreamWriter(null);
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.runtime != null) {
            this.runtime.gc();
        }
    }
}

