/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.util.NumberOutOfRangeException;

public class Schedule
implements Cloneable {
    public static final int EACH = -1;
    public static final int IGNORE = -2;
    public static final int UNINITIALIZED = -3;
    public static final int NONE = 0;
    public static final int ONCE = 1;
    public static final int DAILY = 2;
    public static final int WEEKLY = 3;
    public static final int MONTHLY = 4;
    public static final int YEARLY = 5;
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    protected int frequency = -3;
    protected int onMinute = 0;
    protected int onHour = 0;
    protected int onDayOfWeek = -3;
    protected int onDayOfMonth = -3;
    protected int onMonth = -3;
    protected String command = "";
    protected PatchProLog log = PatchProLog.getInstance();
    private boolean frequencyIsSet = false;
    private boolean minuteIsSet = false;
    private boolean hourIsSet = false;
    private boolean dayIsSet = false;
    private boolean monthIsSet = false;
    private boolean commandIsSet = false;

    public Schedule() {
    }

    public Schedule(int n, int n2, int n3, int n4, int n5, int n6, String string) throws NumberOutOfRangeException {
        this();
        this.setCommand(string);
        this.setFrequency(n);
        switch (n) {
            case 0: {
                this.log.println(this, 7, "Frequency is NONE.");
                break;
            }
            case 5: {
                this.log.println(this, 7, "Frequency is YEARLY.");
                this.setMonth(n6);
            }
            case 4: {
                this.log.println(this, 7, "Frequency is MONTHLY.");
            }
            case 1: {
                this.log.println(this, 7, "Frequency is ONCE.");
                this.setDayOfMonth(n5);
            }
            case 2: {
                this.log.println(this, 7, "Frequency is DAILY.");
                this.setMinute(n2);
                this.setHour(n3);
                break;
            }
            case 3: {
                this.log.println(this, 7, "Frequency is WEEKLY.");
                this.setMinute(n2);
                this.setHour(n3);
                this.setDayOfWeek(n4);
            }
        }
    }

    protected void cloneSchedule(Schedule schedule) {
        try {
            schedule.setFrequency(this.frequency);
            if (this.onMinute != -3) {
                schedule.setMinute(this.onMinute);
            }
            if (this.onHour != -3) {
                schedule.setHour(this.onHour);
            }
            if (this.onDayOfWeek != -3) {
                schedule.setDayOfWeek(this.onDayOfWeek);
            }
            if (this.onDayOfMonth != -3) {
                schedule.setDayOfMonth(this.onDayOfMonth);
            }
            if (this.onMonth != -3) {
                schedule.setMonth(this.onMonth);
            }
            schedule.setCommand(this.command);
        }
        catch (Exception exception) {
            this.log.println(this, 7, "Could not clone schedule.");
        }
    }

    public Schedule cloneSchedule() {
        Schedule schedule = new Schedule();
        this.cloneSchedule(schedule);
        return schedule;
    }

    public void setFrequency(int n) throws NumberOutOfRangeException {
        if (n < 0 || n > 5) {
            throw new NumberOutOfRangeException("Frequency of " + n + " is invalid.");
        }
        this.frequency = n;
        this.frequencyIsSet = true;
    }

    public void setMinute(int n) throws NumberOutOfRangeException {
        if (n == -2) {
            return;
        }
        if ((n < 0 || n > 59) && n != -1) {
            throw new NumberOutOfRangeException("Minute of " + n + " is invalid.");
        }
        this.onMinute = n;
        this.minuteIsSet = true;
    }

    public void setHour(int n) throws NumberOutOfRangeException {
        if (n == -2) {
            return;
        }
        if ((n < 0 || n > 23) && n != -1) {
            throw new NumberOutOfRangeException("Hour of " + n + " is invalid.");
        }
        this.onHour = n;
        this.hourIsSet = true;
    }

    public void setDayOfWeek(int n) throws NumberOutOfRangeException {
        if (n == -2) {
            return;
        }
        if (n != -1 && this.onDayOfMonth != -3 && this.onDayOfMonth != -1) {
            throw new NumberOutOfRangeException("Day of month, " + this.onDayOfMonth + ", already set.");
        }
        if ((n < 0 || n > 6) && n != -1) {
            throw new NumberOutOfRangeException("Day of week of " + n + " is invalid.");
        }
        this.onDayOfWeek = n;
        this.dayIsSet = true;
    }

    public void setDayOfMonth(int n) throws NumberOutOfRangeException {
        if (n == -2) {
            return;
        }
        if (n != -1 && this.onDayOfWeek != -3 && this.onDayOfWeek != -1) {
            throw new NumberOutOfRangeException("Day of week, " + this.onDayOfWeek + ", already set.");
        }
        if ((n < 1 || n > 31) && n != -1) {
            throw new NumberOutOfRangeException("Day of month of " + n + " is invalid.");
        }
        this.onDayOfMonth = n;
        this.dayIsSet = true;
    }

    public void setMonth(int n) throws NumberOutOfRangeException {
        if (n == -2) {
            return;
        }
        if ((n < 1 || n > 12) && n != -1) {
            throw new NumberOutOfRangeException("Month of " + n + " is invalid.");
        }
        this.onMonth = n;
        this.monthIsSet = true;
    }

    public void setCommand(String string) {
        this.command = string;
        this.commandIsSet = true;
    }

    public boolean isComplete() {
        return this.frequency == 0 || (this.minuteIsSet || this.hourIsSet || this.dayIsSet || this.monthIsSet) && this.commandIsSet && this.frequencyIsSet;
    }

    public String getCommand() {
        return this.command;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getDayOfMonth() {
        return this.onDayOfMonth;
    }

    public int getDayOfWeek() {
        return this.onDayOfWeek;
    }

    public String getTime() {
        String string = null;
        String string2 = "00";
        String string3 = "00";
        if (this.onHour >= 0) {
            String string4 = Integer.toString(this.onHour);
            string2 = string4.length() == 1 ? "0" + string4 : string4;
            if (this.onMinute > 0) {
                String string5 = Integer.toString(this.onMinute);
                string3 = string5.length() == 1 ? "0" + string5 : string5;
            }
            string = string2 + ":" + string3;
        }
        return string;
    }

    public String toString() {
        String string;
        if (this.isComplete()) {
            switch (this.frequency) {
                case 0: {
                    string = "Schedule: none";
                    break;
                }
                case 1: {
                    string = "Schedule: " + this.command + " once at " + this.getTime();
                    break;
                }
                case 2: {
                    string = "Schedule: " + this.command + " daily at " + this.getTime();
                    break;
                }
                case 3: {
                    string = "Schedule: " + this.command + " weekly on " + this.getDayName() + " at " + this.getTime();
                    break;
                }
                case 4: {
                    string = "Schedule: " + this.command + " monthly on day " + this.onDayOfMonth + " at " + this.getTime();
                    break;
                }
                case 5: {
                    string = "Schedule: " + this.command + " yearly on month " + this.onMonth + " day " + this.onDayOfMonth + " at " + this.getTime();
                    break;
                }
                default: {
                    string = "Schedule: faulty";
                    break;
                }
            }
        } else {
            string = "Schedule: uninitialized";
        }
        return string;
    }

    private String getDayName() {
        String[] stringArray = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        if (this.onDayOfWeek > -1) {
            return stringArray[this.onDayOfWeek];
        }
        return "noDay";
    }
}

