/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.CannotConnectException;
import com.sun.patchpro.util.DownloadEvent;
import com.sun.patchpro.util.DownloadListener;
import com.sun.patchpro.util.Downloader;
import com.sun.patchpro.util.LocalizedMessages;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class CachingDownloader
extends Downloader
implements DownloadListener {
    private File cache;
    private File cacheTmp;
    private String objectName;
    private FileOutputStream cacheOutputStream;
    private Vector listeners = new Vector();
    private LocalizedMessages msgcat = null;
    private PatchProProperties properties = null;
    private boolean downloadOperationComplete = false;
    private boolean cacheIsOpen = false;
    private boolean cacheExists = false;
    private boolean cacheIsComplete = false;
    boolean cacheIsOld = true;
    boolean cacheIsDead = true;
    boolean readFromCache = false;
    boolean writeToCache = false;
    boolean forceRefresh = false;

    public CachingDownloader(String string, URL uRL, File file, long l, long l2, boolean bl) throws IOException, FileNotFoundException, CannotConnectException {
        super(uRL);
        this.forceRefresh = bl;
        this.properties = PatchProProperties.getInstance();
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        super.addListener(this);
        if (!file.isAbsolute()) {
            throw new IOException("Cache file must be absolute.");
        }
        this.objectName = string;
        this.setupCache(uRL, file, l, l2);
    }

    public CachingDownloader(String string, URL uRL, File file, long l, long l2) throws IOException, FileNotFoundException, CannotConnectException {
        this(string, uRL, file, l, l2, false);
    }

    public CachingDownloader(String string, URL uRL, String string2, boolean bl, String string3, String string4, File file, long l, long l2, boolean bl2) throws IOException, FileNotFoundException, CannotConnectException {
        super(uRL, string2, bl, string3, string4);
        this.forceRefresh = bl2;
        super.addListener(this);
        if (!file.isAbsolute()) {
            throw new IOException("Cache file must be absolute.");
        }
        this.objectName = string;
        this.setupCache(uRL, file, l, l2);
    }

    private void setupCache(URL uRL, File file, long l, long l2) throws IOException, FileNotFoundException, CannotConnectException {
        this.cache = file;
        this.assessCache(file, l, l2);
        this.cacheTmp = this.getTempCache(this.cache);
        this.setSourceURL(uRL, this.cache);
    }

    private File getTempCache(File file) throws IOException {
        if (file.getParent() == null) {
            throw new IOException("Cache may not be in the root directory.");
        }
        File file2 = new File(file.getParent());
        File file3 = File.createTempFile(file.getName(), "", file2);
        file3.deleteOnExit();
        return file3;
    }

    public static long hours(long l) {
        return l * 3600000L;
    }

    public static long days(long l) {
        return l * CachingDownloader.hours(24L);
    }

    private void assessCache(File file, long l, long l2) {
        this.cacheExists = file.exists();
        long l3 = System.currentTimeMillis() - file.lastModified();
        if (!this.cacheExists || l3 > l2) {
            this.cacheIsDead = true;
            this.cacheIsOld = true;
            this.readFromCache = false;
        } else if (l3 > l || !this.minimumCacheSize(1) || this.forceRefresh) {
            this.cacheIsDead = false;
            this.cacheIsOld = true;
            this.readFromCache = false;
        } else {
            this.cacheIsDead = false;
            this.cacheIsOld = false;
            this.readFromCache = true;
        }
    }

    private void setSourceURL(URL uRL, File file) throws IOException, FileNotFoundException, CannotConnectException {
        block7: {
            try {
                if (this.readFromCache) {
                    this.in = new BufferedInputStream(new FileInputStream(file));
                    break block7;
                }
                this.establishConnection(uRL, file);
                if (this.getResponseCode() == 200) {
                    this.in = this.in;
                    try {
                        this.cacheOutputStream = new FileOutputStream(this.cacheTmp);
                        this.cacheIsOpen = true;
                        this.cacheIsComplete = false;
                        this.writeToCache = true;
                    }
                    catch (Exception exception) {
                        this.writeToCache = false;
                        this.log.println(this, 4, "The specified cache, " + file.getName() + ", is inaccessible.");
                    }
                    break block7;
                }
                throw new IOException("Response code was " + this.getResponseCode());
            }
            catch (IOException iOException) {
                if (!this.cacheIsDead) {
                    this.in = new BufferedInputStream(new FileInputStream(file));
                    this.cacheIsOpen = false;
                    this.cacheIsComplete = false;
                    this.readFromCache = true;
                }
                throw iOException;
            }
        }
    }

    public void close() throws IOException {
        if (this.cacheIsOpen) {
            this.cacheOutputStream.close();
        }
        if (this.cacheTmp.exists()) {
            this.cacheTmp.delete();
        }
        super.close();
    }

    public File getValidCache() throws IOException {
        this.downloadOperationComplete = false;
        if (!this.readFromCache && this.writeToCache) {
            int n = 0;
            int n2 = super.getBufferLength();
            byte[] byArray = new byte[n2];
            this.resetProgress();
            n = this.read(byArray, 0, n2);
            while (n >= 0) {
                n = this.read(byArray, 0, n2);
            }
            if (!this.isCancelEnabled()) {
                this.log.println(this, 6, "Downloading done " + this.cache.getName());
                while (!this.downloadOperationComplete) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.close();
            } else {
                this.log.println(this, 6, "Cancel downloading done " + this.cache.getName());
                this.dispatchDoneEvent(new DownloadEvent(this));
                this.close();
            }
        } else {
            this.totalbytes = this.getContentLength();
            this.onePercent = (int)((long)this.totalbytes / 100L);
            this.updateProgress();
            this.dispatchDoneEvent(new DownloadEvent(this));
        }
        if (!this.cacheExists) {
            this.dispatchFailedEvent(new DownloadEvent(this));
            throw new IOException("CachingDownloader.getValidCache(): cache is inaccessible.");
        }
        return this.cache;
    }

    public boolean isCacheOld() {
        return this.cacheIsOld;
    }

    public boolean isCacheDead() {
        return this.cacheIsDead;
    }

    public boolean isSourceCache() {
        return this.readFromCache;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = -1;
        n3 = super.read(byArray, n, n2);
        if (n3 != -1) {
            this.downloadOperationComplete = false;
            if (this.writeToCache) {
                this.cacheOutputStream.write(byArray, n, n3);
                this.cacheOutputStream.flush();
            }
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        int n = -1;
        n = super.read();
        if (n != -1) {
            this.downloadOperationComplete = false;
            if (this.writeToCache) {
                this.cacheOutputStream.write(n);
                this.cacheOutputStream.flush();
            }
        }
        return n;
    }

    public long skip(long l) throws IOException {
        byte[] byArray = new byte[(int)l];
        return this.read(byArray);
    }

    public boolean markSupported() {
        return false;
    }

    public int getContentLength() {
        int n = 0;
        n = this.readFromCache ? (int)this.cache.length() : super.getContentLength();
        return n;
    }

    private void commitCache() throws IOException {
        if (!this.readFromCache) {
            if (this.cacheIsComplete) {
                this.cacheOutputStream.close();
                this.cacheIsOpen = false;
                this.cacheTmp.renameTo(this.cache);
                this.cacheExists = true;
                this.cacheTmp = this.getTempCache(this.cache);
                this.cacheOutputStream = new FileOutputStream(this.cacheTmp);
                this.cacheIsOpen = true;
            } else {
                this.cacheTmp.delete();
            }
            this.cacheIsComplete = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DownloadListener downloadListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DownloadListener downloadListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(downloadListener);
        }
    }

    public synchronized void downloadProgress(DownloadEvent downloadEvent) {
        this.dispatchProgressEvent(downloadEvent);
    }

    public synchronized void downloadDone(DownloadEvent downloadEvent) {
        this.cacheIsComplete = true;
        try {
            this.commitCache();
        }
        catch (IOException iOException) {
            this.log.println(this, 6, "CachingDownloader.downloadDone: Could not commit cache.");
            this.cacheIsComplete = false;
        }
        this.downloadOperationComplete = true;
        this.dispatchDoneEvent(downloadEvent);
    }

    public synchronized void downloadFailed(DownloadEvent downloadEvent) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            this.log.println(this, 6, "CachingDownloader.downloadFailed Could not close input stream.");
        }
        this.downloadOperationComplete = true;
        this.dispatchFailedEvent(downloadEvent);
    }

    public boolean minimumCacheSize(int n) {
        return !this.cache.exists() || this.cache.length() >= (long)n;
    }

    private void establishConnection(URL uRL, File file) throws IOException, FileNotFoundException, CannotConnectException {
        try {
            super.connectToURL();
        }
        catch (UnknownHostException unknownHostException) {
            throw new CannotConnectException("Unknown host (" + unknownHostException.getMessage() + ") connecting to " + uRL);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("File not found: " + uRL);
        }
        catch (IOException iOException) {
            if (file.exists()) {
                this.log.println(this, 4, "Cannot connect to retrieve " + this.objectName + ", using cached copy: " + iOException.getMessage());
                this.log.printStackTrace(this, 7, iOException);
            }
            throw new CannotConnectException("Cannot connect to retrieve " + this.objectName + ": " + iOException.getMessage(), iOException);
        }
    }

    private void dispatchProgressEvent(DownloadEvent downloadEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadListener downloadListener = (DownloadListener)enumeration.nextElement();
            downloadListener.downloadProgress(downloadEvent);
        }
    }

    private void dispatchDoneEvent(DownloadEvent downloadEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadListener downloadListener = (DownloadListener)enumeration.nextElement();
            downloadListener.downloadDone(downloadEvent);
        }
    }

    private void dispatchFailedEvent(DownloadEvent downloadEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadListener downloadListener = (DownloadListener)enumeration.nextElement();
            downloadListener.downloadFailed(downloadEvent);
        }
    }
}

