/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.net.ssl.HttpsURLConnection;
import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.patchpro.analysis.HostAnalyzer;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.BadHttpResponseException;
import com.sun.patchpro.model.DownloadPatchEvent;
import com.sun.patchpro.model.DownloadPatchListener;
import com.sun.patchpro.model.InvalidPatchDownloadDirectoryException;
import com.sun.patchpro.model.PatchDownloadDirectoryAccessException;
import com.sun.patchpro.model.PatchDownloadIOException;
import com.sun.patchpro.model.PatchDownloadResponseException;
import com.sun.patchpro.model.PatchNotAvailableException;
import com.sun.patchpro.model.PatchNotFoundException;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.PatchProRuntimeException;
import com.sun.patchpro.model.PatchSignatureValidationException;
import com.sun.patchpro.model.ServerConnectionException;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchBundleInfo;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.security.ManifestFileNotFoundException;
import com.sun.patchpro.security.NoKeystorePresentException;
import com.sun.patchpro.security.NoSigningCertException;
import com.sun.patchpro.security.NotSignedByKnownCertificateException;
import com.sun.patchpro.security.SSLTunnelSocketFactory;
import com.sun.patchpro.security.SignatureCheckFailedException;
import com.sun.patchpro.security.SignatureValidationException;
import com.sun.patchpro.security.SignatureValidationUtil;
import com.sun.patchpro.server.DownloadPatchDBException;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.DownloadRealizationException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServiceProvider;
import com.sun.patchpro.server.PatchServiceUtil;
import com.sun.patchpro.server.ServerPatchServiceProviderException;
import com.sun.patchpro.server.ServerProxyAuthenticator;
import com.sun.patchpro.util.CachingDownloader;
import com.sun.patchpro.util.ConfigException;
import com.sun.patchpro.util.Downloader;
import com.sun.patchpro.util.LocalizedMessages;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLSocketFactory;

public class ServerPatchServiceProvider
implements PatchServiceProvider {
    private LocalizedMessages msgcat;
    PatchInfoImpl genPatchInfo = null;
    boolean downloadAuthenticate = true;
    boolean isPatchServer = false;
    boolean updateSessionData = true;
    boolean useCache = true;
    PatchProProperties properties = PatchProProperties.getInstance();
    PatchProLog log = PatchProLog.getInstance();
    SignatureValidationUtil validationUtil;
    ServerProxyAuthenticator serverProxyAuthenticator = null;
    String keystoreLocation;
    String patchBundlePrefix = "";
    String serverURLString;
    String signingCertAlias;
    String sunSolvePasswd = "";
    String sunSolveUser = "";
    String proxyUser = "";
    String proxyPasswd = "";
    String proxySvrCliHost = "";
    String proxySvrCliPort = "";
    String targetLocation;
    URL serverURL;
    Vector listeners = new Vector();
    static final int SEGMENTED_PATCHLIST_SIZE = 10;
    static final String AUTHENTICATION_FAILED = "ServicePatchServiceProvider.AUTHENTICATION_FAILED";
    static final String DOWNLOAD_DIR_NOT_EXIST = "Patch download directory does not exist.";
    static final String DOWNLOAD_DIR_NOT_WRITABLE = "Patch download directory is not writable.";
    static final String FAILED_TO_CREATE_DOWNLOADER = "Failed to create a downloader to download patches.";
    static final String FAILED_TO_CREATE_VALIDATION_UTIL = "Failed to create the signature valiation utility.";
    public static final String FAILED_TO_VALIDATE_SIGNATURE = "Failed to validate the digital signature(s).";
    static final String HTTP_PARTIAL_CONTENT = "Status code 206 returned.  The client's request was only partially fulfilled.";
    static final String HTTP_BAD_REQUEST = "Status code 400 returned. The server could not understand the request, probably due to a syntax error in the HTTP request.";
    static final String HTTP_UNAUTHORIZED = "Status code 401 returned. The request lacked proper authorization.";
    static final String HTTP_FORBIDDEN = "Status code 403 returned. The request was understood, but the server is not willing to fulfill it.";
    static final String HTTP_NOT_FOUND = "Status code 404 returned. The requested resource was not found or is not available.";
    static final String HTTP_INTERNAL_SERVER_ERROR = "Status code 500 returned. An unexpected error occurred inside the server that prevented it from fulfilling the request.";
    static final String HTTP_NOT_IMPLEMENTED = "Status code 501 returned. The server does not support the functionality needed to fulfill the request.";
    static final String HTTP_UNKNOWN_ERROR = "Unknown HTTP status code returned.";
    static final String PATCH_NOT_FOUND = "Patch cannot be found by server.";
    static final String PATCH_NOT_ON_DISK = "Patch could not be found locally.";
    static final String INCORRECT_URL = "Incorrect downloading URL specified.";
    static final String INVALID_DESTINATION_TYPE = "Download destination is not a String object that indicates  the download location.";
    static final String INVALID_FILE_PERMISSION = "The write permission is not set.";
    static final String INVALID_PATCH_BUNDLE_FILE_NAME = "Invalid patch bundle file name.";
    static final String KEYSTORE_LOCATION_NOT_SPECIFIED = "patchpro.security.kslocation is not specified.";
    static final String NOT_ABLE_TO_DETERMINE_SIGNING_CERT_SN = "Cannot determine signing certificate serial number.";
    static final String PATCH_DOWNLOAD_DONE = "Patch download is done.";
    static final String SERVER_NOT_SSL_ENABLED = "This server is not SSL-enabled. ";
    static final String SERVER_SSL_ENABLED = "This server is SSL-enabled. ";
    static final String SERVER_NOT_SPECIFIED = "patchpro.patch.source is not specified.";
    static final String SIGNING_CERT_REVOKED = "Signing certificate has been revoked.";
    static final String UNKNOWN_CONTENT_TYPE = "Unknown content-type returned from the server.";

    public ServerPatchServiceProvider() throws ServerPatchServiceProviderException, PatchProException {
        String string;
        this.configure(this.properties);
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
        this.downloadAuthenticate = this.properties.downloadAuthenticationRequired();
        if (this.downloadAuthenticate) {
            try {
                this.validationUtil = SignatureValidationUtil.getValidationUtility(this.properties, this.validationUtil);
                this.keystoreLocation = this.validationUtil.getKeystoreLocation();
                this.signingCertAlias = this.validationUtil.getCertificateAlias();
            }
            catch (NoKeystorePresentException noKeystorePresentException) {
                String string2 = "Failed to create the signature valiation utility. " + noKeystorePresentException.getMessage();
                this.log.printStackTrace(this, 2, noKeystorePresentException);
                this.log.println(this, 3, string2);
                this.dispatchFailedEvent(PatchProLog.createMessage(2, FAILED_TO_CREATE_VALIDATION_UTIL));
                throw new ServerPatchServiceProviderException(2);
            }
            catch (NoSigningCertException noSigningCertException) {
                String string3 = "Failed to create the signature valiation utility. " + noSigningCertException.getMessage();
                this.log.printStackTrace(this, 2, noSigningCertException);
                this.log.println(this, 3, string3);
                this.dispatchFailedEvent(PatchProLog.createMessage(2, FAILED_TO_CREATE_VALIDATION_UTIL));
                throw new ServerPatchServiceProviderException(2);
            }
        }
        this.isPatchServer = this.properties.getProperty("patchpro.ispatchserver").equals("true");
        if (this.isPatchServer) {
            string = "patchsvr.source.0.url";
            this.useCache = this.properties.getProperty("patchsvr.use.cache").equals("true");
        } else {
            string = "patchpro.patch.source";
        }
        this.serverURLString = this.properties.getProperty(string);
        this.log.println(this, 7, "patchsvr.source.0.url: " + this.serverURLString);
        this.log.println(this, 7, "serverURLString: " + this.serverURLString);
        this.log.println(this, 7, "isPatchServer: " + this.isPatchServer);
        if (this.serverURLString == null) {
            this.log.println(this, 2, SERVER_NOT_SPECIFIED);
            throw new ServerPatchServiceProviderException(3);
        }
        this.serverURL = null;
        if (!this.downloadAuthenticate) {
            try {
                this.serverURL = new URL("file:" + File.separator);
            }
            catch (MalformedURLException malformedURLException) {
                this.log.printStackTrace(this, 2, malformedURLException);
            }
        } else {
            if (this.serverURLString.indexOf("https") == 0) {
                this.log.println(this, 7, "This server is SSL-enabled.  " + this.serverURLString);
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Security.addProvider((java.security.Provider)new Provider());
                System.setProperty("javax.net.ssl.trustStore", this.keystoreLocation);
            } else if (this.serverURLString.indexOf("http") == 0) {
                this.log.println(this, 7, "This server is not SSL-enabled.  " + this.serverURLString);
            }
            try {
                this.serverURL = new URL(this.serverURLString);
            }
            catch (MalformedURLException malformedURLException) {
                this.log.printStackTrace(this, 2, malformedURLException);
                throw new ServerPatchServiceProviderException(8);
            }
        }
        if (this.proxyUser != null && this.proxyUser.compareTo("") != 0 && this.proxyPasswd != null && this.proxyPasswd.compareTo("") != 0) {
            this.serverProxyAuthenticator = new ServerProxyAuthenticator(this.proxyUser, this.proxyPasswd);
            Authenticator.setDefault(this.serverProxyAuthenticator);
        }
        if (!this.proxySvrCliHost.equals("") && !this.proxySvrCliPort.equals("")) {
            System.setProperty("https.proxyHost", this.proxySvrCliHost);
            System.setProperty("https.proxyPort", this.proxySvrCliPort);
            System.setProperty("http.proxyHost", this.proxySvrCliHost);
            System.setProperty("http.proxyPort", this.proxySvrCliPort);
        }
        this.genPatchInfo = new PatchInfoImpl();
        this.genPatchInfo.setProperties(new PatchProperties(""));
    }

    public String getPatchBundlePrefix() {
        return this.patchBundlePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(downloadPatchListener);
        }
    }

    public void configure(PatchProProperties patchProProperties) {
        this.sunSolveUser = patchProProperties.getProperty("patchpro.sun.user", "");
        this.sunSolvePasswd = patchProProperties.getProperty("patchpro.sun.passwd", "");
        this.proxyUser = patchProProperties.getProperty("patchpro.proxy.user", "");
        this.proxyPasswd = patchProProperties.getProperty("patchpro.proxy.passwd", "");
        this.proxySvrCliHost = patchProProperties.getProperty("patchpro.proxy.host", "");
        this.proxySvrCliPort = patchProProperties.getProperty("patchpro.proxy.port", "");
        this.log.println(this, 7, "SunSolve user: " + this.sunSolveUser + "\tpasswd: " + this.sunSolvePasswd);
        this.log.println(this, 7, "Proxy user: " + this.proxyUser + "\tproxyPasswd: " + this.proxyPasswd);
        this.log.println(this, 7, "Proxy host for LPS and Client is: " + this.proxySvrCliHost);
        this.log.println(this, 7, "Proxy port for LPS and client is: " + this.proxySvrCliPort);
    }

    public File downloadPatchDB(String string) throws DownloadPatchDBException, NotSupportedException, PatchProException {
        if (string == null || string.equals("")) {
            string = "patchprodb";
        }
        File file = this.getCacheFile(string, "database");
        this.downloadFile(string, file, "downloadPatchDB", "database");
        return file;
    }

    public File getDetectorCacheFile(String string) throws ConfigException {
        return this.getCacheFile(string, "detectors");
    }

    public File downloadRealizationDetectors(String string) throws DownloadRealizationException, NotSupportedException, PatchProException {
        File file;
        if (string == null || string.equals("")) {
            string = "pprodetectors";
        }
        if (!HostAnalyzer.isDetectorCacheValid(file = this.getCacheFile(string, "detectors"))) {
            file.delete();
        }
        this.downloadFile(string, file, "downloadRealizationDetectors", "detectors");
        return file;
    }

    private File getCacheFile(String string, String string2) throws ConfigException {
        String string3 = this.properties.getProperty("patchpro.cache." + string2 + ".tail");
        File file = this.isPatchServer ? new File(this.properties.getProperty("patchsvr.cache.location"), "Misc") : new File(this.properties.getProperty("patchpro.cache.directory"));
        if (!file.isAbsolute()) {
            throw new ConfigException(file + " is not an absolute path");
        }
        File file2 = new File(file, URLEncoder.encode(this.serverURL + "/" + string + string3));
        this.log.println(this, 7, "cacheFile is: " + file2);
        return file2;
    }

    private void downloadFile(String string, File file, String string2, String string3) throws PatchProException {
        file.getParentFile().mkdirs();
        if (this.useCache) {
            CachingDownloader cachingDownloader;
            int n;
            int n2;
            if (this.isPatchServer) {
                n2 = Integer.parseInt(this.properties.getProperty("patchsvr." + string3 + ".cache.old.age"));
                n = Integer.parseInt(this.properties.getProperty("patchsvr." + string3 + ".cache.dead.age"));
            } else {
                n2 = Integer.parseInt(this.properties.getProperty("patchpro.cache.old.age.days." + string3));
                n = Integer.parseInt(this.properties.getProperty("patchpro.cache.dead.age.days." + string3));
            }
            String string4 = "action=" + string2 + "&name=" + URLEncoder.encode(string) + "&version=2.1";
            this.log.println(this, 7, "POST String: " + string4);
            boolean bl = false;
            String string5 = "";
            String string6 = "";
            try {
                cachingDownloader = new CachingDownloader(string, this.serverURL, string4, bl, string5, string6, file, CachingDownloader.days(n2), CachingDownloader.days(n), false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new PatchProException(new FileNotFoundException(string + ": not found at " + this.serverURL));
            }
            catch (IOException iOException) {
                this.log.println(this, 3, "ServerPatchServiceProvider.downloadFile: Unable to create cache downloader.");
                this.log.printStackTrace(this, 3, iOException);
                throw new PatchProException(iOException);
            }
            try {
                cachingDownloader.getValidCache();
            }
            catch (IOException iOException) {
                this.log.println(this, 3, "ServerPatchServiceProvider.downloadFile: Unable to download to " + file.getPath() + ".");
                throw new PatchProException(iOException);
            }
        }
    }

    public PatchBundleInfo[] getDownloadedPatchBundlesInfo(PatchList patchList) throws PatchProException {
        String string = null;
        string = this.isPatchServer ? this.properties.getProperty("patchsvr.cache.location") + File.separator + "Patches" : this.properties.getProperty("patchpro.download.directory");
        if (this.useCache) {
            try {
                this.downloadPatches(patchList, string);
            }
            catch (DownloadPatchException downloadPatchException) {
            }
            catch (NotSupportedException notSupportedException) {
                // empty catch block
            }
        }
        long l = 0L;
        PatchBundleInfo[] patchBundleInfoArray = new PatchBundleInfo[patchList.size()];
        Vector<PatchBundleInfo> vector = new Vector<PatchBundleInfo>(patchList.size());
        int n = 0;
        while (n < patchList.size()) {
            block10: {
                Patch patch;
                try {
                    patch = patchList.getPatchAt(n);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                    break block10;
                }
                String string2 = patch.getPatchID().getPatchID();
                l = this.patchExists(string, string2);
                if (l > 0L) {
                    vector.addElement(new PatchBundleInfo(string2, string2 + ".jar", l));
                } else {
                    vector.addElement(new PatchBundleInfo(string2, string2 + ".jar", -1L));
                }
            }
            ++n;
        }
        Object[] objectArray = vector.toArray();
        PatchBundleInfo[] patchBundleInfoArray2 = new PatchBundleInfo[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            patchBundleInfoArray2[n2] = (PatchBundleInfo)objectArray[n2];
            ++n2;
        }
        return patchBundleInfoArray2;
    }

    public Object getDownloadDestination() {
        return this.getPatchBundlePrefix();
    }

    public boolean isCertificateRevoked(String string) throws NotSupportedException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("action=isCertificateRevoked");
        stringBuffer2.append("&serialNumber=").append(URLEncoder.encode(string));
        this.log.println(this, 7, "CRL checking post string: " + stringBuffer2);
        URLConnection uRLConnection = null;
        try {
            Object object;
            uRLConnection = this.serverURL.openConnection();
            if (uRLConnection instanceof HttpsURLConnection) {
                object = System.getProperty("https.proxyHost");
                string2 = System.getProperty("https.proxyPort");
                if (object != null && string2 != null && ((String)object).length() > 0 && string2.length() > 0) {
                    ((HttpsURLConnection)uRLConnection).setSSLSocketFactory((SSLSocketFactory)new SSLTunnelSocketFactory((String)object, string2));
                }
            }
            uRLConnection.setDoOutput(true);
            object = new PrintWriter(uRLConnection.getOutputStream());
            ((PrintWriter)object).print(stringBuffer2);
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
            return false;
        }
        int n = -1;
        try {
            n = ((HttpURLConnection)uRLConnection).getResponseCode();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
        }
        if (n != 200) {
            string2 = this.httpResponseCode2Str(n);
            this.log.println(this, 2, string2);
            return true;
        }
        int n2 = uRLConnection.getHeaderFieldInt("patchproServiceCompletionCode", 200);
        return n2 == 200;
    }

    public void downloadPatches(PatchList patchList, Object object) throws DownloadPatchException, NotSupportedException, PatchProException {
        this.updateSessionData = false;
        this.downloadPatches(patchList, object, null);
    }

    public void downloadPatches(PatchList patchList, Object object, SessionData sessionData) throws DownloadPatchException, NotSupportedException, PatchProException {
        if (patchList == null || patchList.size() <= 0) {
            this.dispatchDoneEvent(PatchProLog.createMessage(7, PATCH_DOWNLOAD_DONE));
            return;
        }
        this.properties = sessionData != null ? sessionData.getProperties() : PatchProProperties.getInstance();
        boolean bl = false;
        if (this.connectingServer()) {
            this.log.println(this, 7, "Network connected.");
            String string = this.getCertSerialNumber(this.keystoreLocation, this.signingCertAlias);
            if (string == null) {
                throw new DownloadPatchException(5);
            }
            try {
                if (this.isCertificateRevoked(string)) {
                    this.log.println(this, 2, "Signing certificate has been revoked.: " + string);
                    throw new DownloadPatchException(6);
                }
            }
            catch (NotSupportedException notSupportedException) {
                this.log.printStackTrace(this, 2, notSupportedException);
                throw notSupportedException;
            }
            bl = true;
        } else {
            this.log.println(this, 7, "Network not connected.");
            System.out.println("... " + this.msgcat.getMessage("using_local_data", "Trying to use local data to service request.") + "\n");
        }
        boolean bl2 = false;
        String string = null;
        if (object instanceof OutputStream) {
            this.log.println(this, 7, "Detected output stream...");
            string = this.isPatchServer ? this.properties.getProperty("patchsvr.cache.location", "/var/tmp") + File.separator + "Patches" : this.properties.getProperty("patchpro.download.directory", "/var/tmp");
            bl2 = true;
            this.log.println(this, 7, "What is downloadDir: " + string);
        } else if (object instanceof String) {
            string = (String)object;
        } else {
            this.dispatchFailedEvent(PatchProLog.createMessage(2, INVALID_DESTINATION_TYPE));
            this.log.println(this, 2, INVALID_DESTINATION_TYPE);
            if (this.updateSessionData) {
                InvalidPatchDownloadDirectoryException invalidPatchDownloadDirectoryException = new InvalidPatchDownloadDirectoryException("InvalidPatchDownloadDirectoryException", "InvalidPatchDownloadDirectoryException.MESSAGE", "InvalidPatchDownloadDirectoryException.REMEDY", 2);
                sessionData.addPatchProException(invalidPatchDownloadDirectoryException);
            }
            throw new DownloadPatchException(INVALID_DESTINATION_TYPE);
        }
        if (string.indexOf("%") != -1) {
            this.setPatchBundlePrefix(PatchServiceUtil.generateTimeStampedString(string) + File.separator);
        } else {
            this.setPatchBundlePrefix(string + File.separator);
        }
        if (bl) {
            this.log.println(this, 7, "Invoking performDownloadPatches.");
            this.performDownloadPatches(patchList, sessionData);
        } else {
            this.log.println(this, 7, "Invoking performValidationOnDownloadedPatches.");
            this.performValidationOnDownloadedPatches(patchList, sessionData);
        }
        if (bl2) {
            int n = 102400;
            byte[] byArray = new byte[n];
            int n2 = 0;
            FileInputStream fileInputStream = null;
            String string2 = null;
            String string3 = null;
            int n3 = 0;
            while (n3 < patchList.size()) {
                block24: {
                    try {
                        Patch patch = patchList.getPatchAt(n3);
                        string2 = patch.getPatchID().getPatchID();
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        this.log.println(this, 2, "Should never receive NoSuchPatchException here.");
                        this.log.printStackTrace(this, 2, noSuchPatchException);
                        break block24;
                    }
                    string3 = string + File.separator + string2 + ".jar";
                    this.log.println(this, 7, "Requested patch file name: " + string3);
                    try {
                        fileInputStream = new FileInputStream(string3);
                        while ((n2 = fileInputStream.read(byArray)) != -1) {
                            ((OutputStream)object).write(byArray, 0, n2);
                        }
                        fileInputStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ++n3;
            }
        }
    }

    private void setPatchBundlePrefix(String string) {
        this.patchBundlePrefix = string;
    }

    private String httpResponseCode2Str(int n) {
        String string = "";
        switch (n) {
            case 206: {
                string = HTTP_PARTIAL_CONTENT;
                break;
            }
            case 400: {
                string = HTTP_BAD_REQUEST;
                break;
            }
            case 401: {
                string = HTTP_UNAUTHORIZED;
                break;
            }
            case 403: {
                string = HTTP_FORBIDDEN;
                break;
            }
            case 404: {
                string = HTTP_NOT_FOUND;
                break;
            }
            case 500: {
                string = HTTP_INTERNAL_SERVER_ERROR;
                break;
            }
            case 501: {
                string = HTTP_NOT_IMPLEMENTED;
                break;
            }
            default: {
                string = HTTP_UNKNOWN_ERROR;
            }
        }
        return string;
    }

    private void performDownloadPatches(PatchList patchList, SessionData sessionData) throws DownloadPatchException, NotSupportedException, PatchProException {
        File file = new File(this.getPatchBundlePrefix());
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.canWrite()) {
            this.dispatchFailedEvent(PatchProLog.createMessage(2, DOWNLOAD_DIR_NOT_WRITABLE));
            this.log.println(this, 2, DOWNLOAD_DIR_NOT_WRITABLE);
            if (this.updateSessionData) {
                PatchDownloadDirectoryAccessException patchDownloadDirectoryAccessException = new PatchDownloadDirectoryAccessException("PatchDownloadDirectoryAccessException", "PatchDownloadDirectoryAccessException.MESSAGE", "PatchDownloadDirectoryAccessException.REMEDY", 2);
                sessionData.addPatchProException(patchDownloadDirectoryAccessException);
            }
            throw new DownloadPatchException(DOWNLOAD_DIR_NOT_WRITABLE);
        }
        int n = patchList.size();
        Vector<PatchListImpl> vector = new Vector<PatchListImpl>();
        PatchListImpl patchListImpl = new PatchListImpl();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            try {
                IPatch iPatch = new IPatch(patchList.getPatchAt(n3));
                if (new File(file, iPatch.getPatchID().getPatchID() + ".jar").exists()) {
                    if (this.updateSessionData) {
                        sessionData.addPatchAlreadyPresent(iPatch);
                    }
                } else if (this.useCache) {
                    patchListImpl.addIPatch(iPatch);
                    patchListImpl.setSelectionStatus(n2, patchList.getSelectionStatus(n3));
                    ++n2;
                }
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 3, noSuchPatchException);
            }
            if ((n3 + 1) % 10 == 0 && patchListImpl.size() != 0) {
                vector.addElement(patchListImpl);
                patchListImpl = new PatchListImpl();
                n2 = 0;
            }
            ++n3;
        }
        if (n % 10 != 0 && patchListImpl.size() != 0) {
            vector.addElement(patchListImpl);
        }
        int n4 = 0;
        while (n4 < vector.size()) {
            try {
                if (this.proxyUser != null && this.proxyUser.compareTo("") != 0 && this.proxyPasswd != null && this.proxyPasswd.compareTo("") != 0) {
                    this.serverProxyAuthenticator.resetRetryAttempts();
                }
                this.requestDownload((PatchList)vector.elementAt(n4), sessionData);
            }
            catch (DownloadPatchException downloadPatchException) {
                this.log.printStackTrace(this, 4, downloadPatchException);
            }
            ++n4;
        }
        this.dispatchDoneEvent(PatchProLog.createMessage(7, PATCH_DOWNLOAD_DONE));
        if (this.updateSessionData) {
            this.createDownloadSummaryFile(sessionData, patchList, this.getPatchBundlePrefix());
        }
    }

    private void performValidationOnDownloadedPatches(PatchList patchList, SessionData sessionData) throws DownloadPatchException, NotSupportedException, PatchProException {
        File file = new File(this.getPatchBundlePrefix());
        if (!file.exists()) {
            this.log.println(this, 2, DOWNLOAD_DIR_NOT_EXIST);
            if (this.updateSessionData) {
                PatchDownloadDirectoryAccessException patchDownloadDirectoryAccessException = new PatchDownloadDirectoryAccessException("PatchDownloadDirectoryAccessException", "PatchDownloadDirectoryAccessException.MESSAGE", "PatchDownloadDirectoryAccessException.REMEDY", 2);
                sessionData.addPatchProException(patchDownloadDirectoryAccessException);
            }
            throw new DownloadPatchException(DOWNLOAD_DIR_NOT_EXIST);
        }
        int n = patchList.size();
        boolean bl = false;
        String string = "";
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            block24: {
                Serializable serializable;
                IPatch iPatch;
                Patch patch;
                try {
                    Patch patch2 = patchList.getPatchAt(n2);
                    string = patch2.getPatchID().getPatchID();
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 3, noSuchPatchException);
                    break block24;
                }
                string2 = this.getPatchBundlePrefix() + File.separator + string + ".jar";
                if (!new File(string2).exists()) {
                    try {
                        patch = patchList.getPatchByPatchID(new PatchID(string));
                        iPatch = new IPatch(patch);
                        iPatch.setError(PATCH_NOT_ON_DISK);
                        if (this.updateSessionData) {
                            sessionData.addPatchUnavailable(iPatch);
                        }
                        this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the problem list. ErrString: " + PATCH_NOT_ON_DISK);
                        if (this.updateSessionData) {
                            serializable = new PatchNotAvailableException("PatchNotAvailableException", "PatchNotAvailableException.MESSAGE", "PatchNotAvailableException.REMEDY", 3);
                            sessionData.addPatchProException((Throwable)serializable);
                        }
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        this.log.println(this, 2, "There exists no patch failing signaturevalidation");
                        this.log.printStackTrace(this, 3, noSuchPatchException);
                    }
                    catch (MalformedPatchException malformedPatchException) {
                        this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                        this.log.printStackTrace(this, 3, malformedPatchException);
                    }
                } else {
                    bl = false;
                    if (this.downloadAuthenticate) {
                        bl = this.validatePatchBundle(string, string2);
                        this.log.println(this, 7, "Validation of local patch " + string2 + " is done");
                    }
                    if (bl) {
                        if (this.updateSessionData) {
                            try {
                                serializable = new PatchID(string);
                                PatchImpl patchImpl = new PatchImpl(this.genPatchInfo, (PatchID)serializable);
                                sessionData.addPatchAlreadyPresent(patchImpl);
                            }
                            catch (Exception exception) {
                                this.log.printStackTrace(this, 3, exception);
                            }
                        }
                        this.log.println(this, 7, "The patch " + string2 + " has been validated");
                    } else {
                        try {
                            patch = patchList.getPatchByPatchID(new PatchID(string));
                            iPatch = new IPatch(patch);
                            iPatch.setError(FAILED_TO_VALIDATE_SIGNATURE);
                            if (this.updateSessionData) {
                                sessionData.addPatchCorruptOnDownload(iPatch);
                            }
                            this.log.println(this, 7, "Added patch " + patch.getPatchID().getPatchID() + " to the list. ErrString: " + FAILED_TO_VALIDATE_SIGNATURE);
                            if (this.updateSessionData) {
                                serializable = new PatchSignatureValidationException("PatchSignatureValidationException", "PatchSignatureValidationException.MESSAGE", "PatchSignatureValidationException.REMEDY", 2);
                                sessionData.addPatchProException((Throwable)serializable);
                            }
                        }
                        catch (NoSuchPatchException noSuchPatchException) {
                            this.log.println(this, 2, "There exists no patch failing signaturevalidation");
                            this.log.printStackTrace(this, 3, noSuchPatchException);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                            this.log.printStackTrace(this, 3, malformedPatchException);
                        }
                    }
                }
            }
            ++n2;
        }
        this.dispatchDoneEvent(PatchProLog.createMessage(7, PATCH_DOWNLOAD_DONE));
        if (this.updateSessionData) {
            this.createDownloadSummaryFile(sessionData, patchList, file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void requestDownload(PatchList patchList, SessionData sessionData) throws DownloadPatchException, NotSupportedException {
        Object object;
        Object object2;
        String string;
        Serializable serializable;
        Object object3;
        int n;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("action=patchDownload&version=2.1");
        Patch patch = null;
        int n2 = patchList.size();
        int n3 = 0;
        while (n3 < n2) {
            try {
                if (patchList.getSelectionStatus(n3)) {
                    patch = patchList.getPatchAt(n3);
                    String string3 = patch.getPatchID().getPatchID();
                    this.log.println(this, 7, "Adding " + string3 + " to the POST list...");
                    stringBuffer.append(string3).append(" ");
                    stringBuffer2.append('&');
                    stringBuffer2.append("patchId=").append(URLEncoder.encode(string3));
                }
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
            }
            ++n3;
        }
        this.log.println(this, 7, "Post String: " + stringBuffer2);
        int n4 = -1;
        Downloader downloader = null;
        try {
            downloader = this.sendPatchDownloadPostRequest(this.serverURL, stringBuffer2.toString(), this.sunSolveUser, this.sunSolvePasswd, sessionData);
            n4 = downloader.getResponseCode();
        }
        catch (DownloadPatchException downloadPatchException) {
            if (downloadPatchException.getReasonCode() == 4) {
                n4 = 500;
            }
            if (this.updateSessionData) {
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
            }
            throw downloadPatchException;
        }
        if (n4 == 401) {
            this.dispatchFailedEvent(PatchProLog.createMessage(4, this.msgcat.getMessage(AUTHENTICATION_FAILED, "The patch server failed to authenticate the request based on the current SunSolve user/password setting. Only public (non-contract) patches will be downloaded.")));
            this.log.println(this, 4, "Current SunSolve credential setting caused 401 response.");
            n4 = -1;
            try {
                downloader = this.sendPatchDownloadPostRequest(this.serverURL, stringBuffer2.toString(), "", "", sessionData);
                n4 = downloader.getResponseCode();
            }
            catch (DownloadPatchException downloadPatchException) {
                if (downloadPatchException.getReasonCode() == 4) {
                    n4 = 500;
                }
                if (this.updateSessionData) {
                    sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
                }
                throw downloadPatchException;
            }
        }
        this.log.println(this, 7, "HTTP response code: " + n4);
        if (n4 != 200 && n4 != 206) {
            string2 = this.httpResponseCode2Str(n4);
            this.log.println(this, 4, string2);
            if (this.updateSessionData) {
                BadHttpResponseException badHttpResponseException = new BadHttpResponseException("BadHttpResponseException", BadHttpResponseException.getBadHttpResponseExceptionMessage(n4), BadHttpResponseException.getBadHttpResponseExceptionRemedy(n4), 2);
                sessionData.addPatchProException(badHttpResponseException);
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
            }
            throw new DownloadPatchException(string2);
        }
        string2 = downloader.getHeaderField("patchFiles");
        String string4 = downloader.getHeaderField("rejects");
        String string5 = downloader.getHeaderField("requiredSize");
        this.log.println(this, 7, "Patches returned: " + string2);
        this.log.println(this, 7, "Patches rejected: " + string4);
        this.log.println(this, 7, "Patches required sizes: " + string5);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(downloader);
        if (string2 == null) {
            this.log.println(this, 4, "patchFiles is null.");
            string2 = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        int n5 = stringTokenizer.countTokens();
        String[] stringArray = new String[n5];
        String[] stringArray2 = new String[n5];
        String[] stringArray3 = new String[n5];
        int[] nArray = new int[n5];
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object7 = stringTokenizer.nextToken();
            object6 = new StringTokenizer((String)object7, "&");
            object5 = ((StringTokenizer)object6).nextToken();
            stringArray[n6] = ((String)object5).substring(0, ((String)object5).indexOf(".jar"));
            stringArray2[n6] = this.patchBundlePrefix + (String)object5;
            stringArray3[n6] = object5;
            nArray[n6] = Integer.parseInt(((StringTokenizer)object6).nextToken());
            ++n6;
        }
        stringTokenizer = null;
        Properties properties = new Properties();
        if (string4 != null && !string4.equals("")) {
            object7 = new StringTokenizer(string4, "|");
            while (((StringTokenizer)object7).hasMoreTokens()) {
                object6 = ((StringTokenizer)object7).nextToken();
                object5 = new StringTokenizer((String)object6, "&");
                object4 = ((StringTokenizer)object5).nextToken();
                properties.setProperty((String)object4, ((StringTokenizer)object5).nextToken());
            }
        }
        this.log.println(this, 7, "Number of patches returned: " + n5);
        int n7 = 0;
        while (n7 < n5) {
            this.log.println(this, 7, "PatchID: " + stringArray2[n7] + "\tSize: " + nArray[n7]);
            this.log.println(this, 7, "The patch returned by server is PatchID: " + stringArray2[n7] + "\tSize: " + nArray[n7]);
            ++n7;
        }
        if (n5 == 0) {
            object6 = null;
            object5 = null;
            object4 = null;
            int n8 = 0;
            while (n8 < n2) {
                try {
                    object6 = patchList.getPatchAt(n8);
                    object5 = new IPatch((Patch)object6);
                    object4 = ((PatchImpl)object5).getPatchID().getPatchID();
                    String string6 = this.getErrorMessageKey(properties.getProperty((String)object4));
                    ((IPatch)object5).setError(this.msgcat.getMessage(string6, new String[]{object4}, PATCH_NOT_FOUND));
                    if (this.updateSessionData) {
                        sessionData.addPatchUnavailable((IPatch)object5);
                    }
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                }
                ++n8;
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
            }
            return;
        }
        object6 = null;
        int n9 = 0;
        while (n9 < n2) {
            block70: {
                try {
                    object6 = patchList.getPatchAt(n9);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                    break block70;
                }
                object4 = object6.getPatchID().getPatchID();
                String string7 = (String)object4 + ".jar";
                n = 0;
                while (n < n5) {
                    if (string7.equals(stringArray3[n])) {
                        if (!this.updateSessionData) break;
                        try {
                            sessionData.addPatchDownloaded((String)object4);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println(this, 3, "Malformed patch string " + (String)object4);
                        }
                        break;
                    }
                    if (n + 1 == n5) {
                        object3 = null;
                        String string8 = "";
                        try {
                            object3 = patchList.getPatchByPatchID(new PatchID((String)object4));
                            serializable = new IPatch((Patch)object3);
                            string = properties.getProperty((String)object4);
                            object2 = this.getErrorMessageKey(properties.getProperty((String)object4));
                            string8 = this.msgcat.getMessage((String)object2, new String[]{object4}, PATCH_NOT_FOUND);
                            ((IPatch)serializable).setError(string8);
                            if (this.updateSessionData) {
                                sessionData.addPatchUnavailable((IPatch)serializable);
                                object = new PatchNotFoundException("PatchNotFoundException", string8, "PatchNotFoundException.REMEDY", 2);
                                sessionData.addPatchProException((Throwable)object);
                            }
                            this.log.println(this, 3, string8);
                        }
                        catch (NoSuchPatchException noSuchPatchException) {
                            this.log.println(this, 3, "There exists no patch in the patch listto be downloaded.");
                            this.log.println(this, 3, noSuchPatchException.getMessage());
                            this.log.printStackTrace(this, 3, noSuchPatchException);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println(this, 4, "ServerPatchServiceProvider.requestDownload(): Malformed patch ID on appliedPatch. " + malformedPatchException.getMessage());
                            this.log.printStackTrace(this, 4, malformedPatchException);
                        }
                    }
                    ++n;
                }
            }
            ++n9;
        }
        if (downloader.getContentType().compareTo("application/octet-stream") == 0) {
            int n10 = 0;
            int n11 = 0;
            n = downloader.getBufferLength();
            if (n <= 0) {
                n = 8192;
            }
            object3 = new byte[n];
            serializable = new File(this.patchBundlePrefix);
            if (!((File)serializable).exists()) {
                ((File)serializable).mkdirs();
            }
            serializable = null;
            int n12 = 0;
            while (n12 < n5) {
                block72: {
                    Object var40_67;
                    Serializable serializable2;
                    Serializable serializable3;
                    string = stringArray2[n12] + ".tmp";
                    this.log.println(this, 7, string);
                    serializable = new File(string);
                    try {
                        block71: {
                            ((File)serializable).delete();
                            ((File)serializable).createNewFile();
                            this.log.println(this, 7, "Created " + string);
                            object2 = new FileOutputStream((File)serializable);
                            n11 = 0;
                            n10 = 0;
                            int n13 = nArray[n12] - n11;
                            while (n13 >= n) {
                                n10 = bufferedInputStream.read((byte[])object3, 0, n);
                                if (n10 == -1) break;
                                n13 = nArray[n12] - (n11 += n10);
                                ((FileOutputStream)object2).write((byte[])object3, 0, n10);
                            }
                            if (n13 > 0) {
                                n10 = bufferedInputStream.read((byte[])object3, 0, n13);
                                ((FileOutputStream)object2).write((byte[])object3, 0, n10);
                            }
                            ((FileOutputStream)object2).close();
                            boolean bl = true;
                            if (this.downloadAuthenticate) {
                                bl = this.validatePatchBundle(stringArray[n12], string);
                                this.log.println(this, 7, "The downloader validation is done");
                            }
                            serializable3 = null;
                            if (bl) {
                                this.log.println(this, 7, "The patch bundle is validated");
                                serializable2 = new File(stringArray2[n12]);
                                ((File)serializable2).delete();
                                ((File)serializable).renameTo((File)serializable2);
                            } else {
                                try {
                                    serializable3 = patchList.getPatchByPatchID(new PatchID(stringArray[n12]));
                                    serializable2 = new IPatch((Patch)serializable3);
                                    ((IPatch)serializable2).setError(FAILED_TO_VALIDATE_SIGNATURE);
                                    if (this.updateSessionData) {
                                        sessionData.addPatchCorruptOnDownload((IPatch)serializable2);
                                    }
                                    this.log.println(this, 7, "Added patch " + serializable3.getPatchID().getPatchID() + " to the list. ErrString: " + FAILED_TO_VALIDATE_SIGNATURE);
                                    File file = new File(stringArray2[n12]);
                                    file.delete();
                                    file = null;
                                    this.log.println(this, 3, FAILED_TO_VALIDATE_SIGNATURE);
                                    if (this.updateSessionData) {
                                        PatchSignatureValidationException patchSignatureValidationException = new PatchSignatureValidationException("PatchSignatureValidationException", "PatchSignatureValidationException.MESSAGE", "PatchSignatureValidationException.REMEDY", 2);
                                        sessionData.addPatchProException(patchSignatureValidationException);
                                    }
                                }
                                catch (NoSuchPatchException noSuchPatchException) {
                                    this.log.println(this, 2, "There exists no patch failing signaturevalidation");
                                    this.log.printStackTrace(this, 3, noSuchPatchException);
                                }
                                catch (MalformedPatchException malformedPatchException) {
                                    this.log.println(this, 4, "PatchProModel.evaluatePatchListExpression(): Malformed patch ID on applied Patch. " + malformedPatchException.getMessage());
                                    this.log.printStackTrace(this, 3, malformedPatchException);
                                }
                            }
                            if (!downloader.isCancelEnabled()) {
                                this.log.println(this, 6, "Downloading done.");
                                break block71;
                            }
                            this.log.println(this, 6, "Downloading canceled.");
                        }
                        var40_67 = null;
                        ((File)serializable).delete();
                    }
                    catch (Throwable throwable) {
                        var40_67 = null;
                        ((File)serializable).delete();
                        throw throwable;
                    }
                    {
                        break block72;
                        catch (FileNotFoundException fileNotFoundException) {
                            object = "Invalid patch bundle file name.: " + string;
                            this.log.printStackTrace(this, 3, fileNotFoundException);
                            this.log.println(this, 3, (String)object);
                            this.dispatchFailedEvent(PatchProLog.createMessage(3, INVALID_PATCH_BUNDLE_FILE_NAME));
                            var40_67 = null;
                            ((File)serializable).delete();
                            break block72;
                        }
                        catch (SecurityException securityException) {
                            String string9 = "The write permission is not set.: " + string;
                            this.log.printStackTrace(this, 3, securityException);
                            this.log.println(this, 3, string9);
                            this.dispatchFailedEvent(PatchProLog.createMessage(3, INVALID_FILE_PERMISSION));
                            securityException.printStackTrace();
                            var40_67 = null;
                            ((File)serializable).delete();
                            break block72;
                        }
                        catch (IOException iOException) {
                            this.log.printStackTrace(this, 3, iOException);
                            if (this.updateSessionData) {
                                serializable3 = new PatchDownloadIOException("PatchDownloadIOException", "PatchDownloadIOException.MESSAGE", "PatchDownloadIOException.REMEDY", 2);
                                sessionData.addPatchProException((Throwable)serializable3);
                            }
                            throw new DownloadPatchException("I/O error: " + iOException.getMessage());
                        }
                        catch (Exception exception) {
                            this.log.printStackTrace(this, 3, exception);
                            if (this.updateSessionData) {
                                serializable2 = new PatchDownloadIOException("PatchDownloadIOException", "PatchDownloadIOException.MESSAGE", "PatchDownloadIOException.REMEDY", 2);
                                sessionData.addPatchProException((Throwable)serializable2);
                            }
                            this.dispatchFailedEvent(PatchProLog.createMessage(3, "PatchDownloadIOException.MESSAGE\nPatchDownloadIOException.REMEDY"));
                            var40_67 = null;
                            ((File)serializable).delete();
                        }
                    }
                }
                ++n12;
            }
        } else {
            this.log.println(this, 4, UNKNOWN_CONTENT_TYPE);
            this.dispatchFailedEvent(PatchProLog.createMessage(4, UNKNOWN_CONTENT_TYPE));
            if (this.updateSessionData) {
                object4 = new PatchDownloadResponseException("PatchDownloadResponseException", "PatchDownloadResponseException.MESSAGE", "PatchDownloadResponseException.REMEDY", 2);
                sessionData.addPatchProException((Throwable)object4);
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
            }
            if (this.updateSessionData) {
                sessionData.addPatchesUnavailable(patchList, this.msgcat.getMessage(HTTP_UNKNOWN_ERROR, HTTP_UNKNOWN_ERROR));
            }
        }
        try {
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
        }
    }

    private String getErrorMessageKey(String string) {
        String string2;
        int n = string == null ? 0 : Integer.parseInt(string);
        switch (n) {
            case 1: {
                string2 = "download.unexpected.error";
                break;
            }
            case 2: {
                string2 = "download.patch.not.exist";
                break;
            }
            case 3: {
                string2 = "download.contract.patch";
                break;
            }
            case 4: {
                string2 = "download.duplicate.patch";
                break;
            }
            default: {
                string2 = "download.unidentified.error";
            }
        }
        return string2;
    }

    private void createDownloadSummaryFile(SessionData sessionData, PatchList patchList, String string) throws PatchProException {
        FileOutputStream fileOutputStream;
        File file = null;
        File file2 = null;
        file2 = new File(string);
        String string2 = !file2.canWrite() ? "/var/tmp/" : string;
        file = new File(string2 + File.separator + PatchServiceUtil.generateTimeStampedString("patchpro_dnld_'%Y.%m.%d@%T:%Z'") + "." + "txt");
        this.log.println(this, 7, "Dnld summary file: " + file.getPath());
        if (file.exists()) {
            file.delete();
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PatchProException("Can't create " + fileNotFoundException.getMessage());
        }
        PrintStream printStream = new PrintStream(fileOutputStream);
        PatchList patchList2 = sessionData.getPatchesNotDownloaded();
        if (patchList2.size() == 0) {
            printStream.println(this.msgcat.getMessage("readmeHeader", "This patch bundle was generated by PatchPro.\n\nPlease refer to the README file for each patch for installation\ninstructions.  To properly patch your system, the following patches\nshould be installed in the listed order:\n\n"));
            this.printDownloadedPatches(printStream, patchList);
        } else {
            printStream.println(this.msgcat.getMessage("readmeFailedHeader", "This collection of patches is incomplete due to problems in downloading.\nIt is advisable to retry the download later and see if the\nremaining patches can be downloaded. If they can, then the new download\nsummary file will show the patches required and the order in which to\ninstall them. The patches failing to install are listed here:\n\n"));
            this.printProblemPatches(printStream, patchList2);
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new PatchProRuntimeException(iOException);
        }
        printStream.close();
    }

    private boolean validatePatchBundle(String string, String string2) {
        boolean bl = true;
        this.log.println(this, 7, "Entered downloader validatePatchBundle()");
        if (this.validationUtil == null) {
            String string3 = FAILED_TO_CREATE_VALIDATION_UTIL;
            this.log.println(this, 3, string3);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_CREATE_VALIDATION_UTIL));
            return false;
        }
        try {
            this.validationUtil.validateJarFile(string2);
        }
        catch (ManifestFileNotFoundException manifestFileNotFoundException) {
            bl = false;
            String string4 = "Failed to validate the digital signature(s). for: " + string2 + ": " + manifestFileNotFoundException.getMessage();
            this.log.printStackTrace(this, 3, manifestFileNotFoundException);
            this.log.println(this, 3, string4);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        catch (SignatureCheckFailedException signatureCheckFailedException) {
            bl = false;
            String string5 = "Failed to validate the digital signature(s). for: " + string2 + ": " + signatureCheckFailedException.getMessage();
            this.log.printStackTrace(this, 3, signatureCheckFailedException);
            this.log.println(this, 3, string5);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        catch (NotSignedByKnownCertificateException notSignedByKnownCertificateException) {
            bl = false;
            String string6 = "Failed to validate the digital signature(s). for: " + string2 + ": " + notSignedByKnownCertificateException.getMessage();
            this.log.printStackTrace(this, 3, notSignedByKnownCertificateException);
            this.log.println(this, 3, string6);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        catch (SignatureValidationException signatureValidationException) {
            bl = false;
            String string7 = "Failed to validate the digital signature(s). for: " + string2 + ": " + signatureValidationException.getMessage();
            this.log.printStackTrace(this, 3, signatureValidationException);
            this.log.println(this, 3, string7);
            this.dispatchFailedEvent(PatchProLog.createMessage(3, FAILED_TO_VALIDATE_SIGNATURE));
        }
        System.out.println("");
        if (bl) {
            System.out.println(string + " has been validated.");
        } else {
            System.out.println(string + " cannot be validated.");
            System.out.print("\n\n");
        }
        return bl;
    }

    private void printDownloadedPatches(PrintStream printStream, PatchList patchList) {
        int n = 0;
        int n2 = patchList.size();
        int n3 = 0;
        while (n3 < n2) {
            try {
                if (patchList.getSelectionStatus(n3)) {
                    Patch patch = patchList.getPatchAt(n3);
                    String string = patch.getPatchID().getPatchID();
                    this.log.println(this, 7, "Checking if " + string + " is available...");
                    PatchProperties patchProperties = patch.getPatchInfo().getProperties();
                    ++n;
                    if (patchProperties.isNonstandard() || patchProperties.isInteractive()) {
                        printStream.println(n + ") " + string + " " + this.msgcat.getMessage("seeReadmeWarning", "!!! SEE README !!!"));
                    } else if (patchProperties.isRebootimmediate() || patchProperties.isReconfigimmediate()) {
                        printStream.println(n + ") " + string + " " + this.msgcat.getMessage("immediateRebootWarning", "!!! IMMEDIATE REBOOT !!!"));
                    } else if (patchProperties.isRebootafter() || patchProperties.isReconfigafter()) {
                        printStream.println(n + ") " + string + " " + this.msgcat.getMessage("rebootWarning", "!!! REBOOT !!!"));
                    } else if (patchProperties.isSingleuser()) {
                        printStream.println(n + ") " + string + " " + this.msgcat.getMessage("singleUserWarning", "!!! SINGLE USER !!!"));
                    } else {
                        printStream.println(n + ") " + string);
                    }
                }
            }
            catch (NoSuchPatchException noSuchPatchException) {
                this.log.printStackTrace(this, 2, noSuchPatchException);
            }
            ++n3;
        }
    }

    private void printProblemPatches(PrintStream printStream, PatchList patchList) {
        int n = patchList.size();
        String string = "";
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            block3: {
                IPatch iPatch;
                try {
                    iPatch = patchList.getIPatchAt(n2);
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    this.log.printStackTrace(this, 2, noSuchPatchException);
                    break block3;
                }
                string = iPatch.getPatchID().getPatchID();
                string2 = iPatch.hasError() ? iPatch.getError() : "";
                this.log.println(this, 7, "Listing " + string + " w/ " + string2);
                printStream.println(string + " " + string2);
            }
            ++n2;
        }
    }

    private String getCertSerialNumber(String string, String string2) {
        String string3 = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            KeyStore keyStore = KeyStore.getInstance("JKS", "SUN");
            keyStore.load(fileInputStream, null);
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string2);
            PublicKey publicKey = x509Certificate.getPublicKey();
            string3 = String.valueOf(x509Certificate.getSerialNumber());
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 3, exception);
        }
        return string3;
    }

    private boolean connectingServer() {
        URLConnection uRLConnection = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object[] objectArray = new String[]{this.serverURL.toString()};
        try {
            Object object;
            uRLConnection = this.serverURL.openConnection();
            uRLConnection.setAllowUserInteraction(true);
            if (uRLConnection instanceof HttpsURLConnection) {
                object = System.getProperty("https.proxyHost");
                String string = System.getProperty("https.proxyPort");
                if (object != null && string != null && ((String)object).length() > 0 && string.length() > 0) {
                    ((HttpsURLConnection)uRLConnection).setSSLSocketFactory((SSLSocketFactory)new SSLTunnelSocketFactory((String)object, string));
                }
            }
            uRLConnection.setDoOutput(true);
            object = new PrintWriter(uRLConnection.getOutputStream());
            ((PrintWriter)object).print("");
            ((PrintWriter)object).flush();
            if (((PrintWriter)object).checkError()) {
                this.log.println(this, 4, "PrinterWriter error!");
            }
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 2, iOException);
            System.out.println(this.msgcat.getMessage("not_connected", objectArray, "Cannot establish a network connection with the patch server."));
            this.dispatchFailedEvent(PatchProLog.createMessage(3, this.msgcat.getMessage("not_connected", objectArray, "Cannot establish a network connection with the patch server.")));
            return false;
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            System.out.println(this.msgcat.getMessage("not_connected", objectArray, "Cannot establish a network connection with the patch server."));
            return false;
        }
        return true;
    }

    private Downloader sendPatchDownloadPostRequest(URL uRL, String string, String string2, String string3, SessionData sessionData) throws DownloadPatchException {
        Downloader downloader;
        block5: {
            downloader = null;
            boolean bl = false;
            if (string2 != null && string2.compareTo("") != 0 && string3 != null && string3.compareTo("") != 0) {
                bl = true;
            }
            String string4 = "";
            String string5 = "";
            if (bl) {
                string4 = string2;
                string5 = string3;
            }
            this.log.println(this, 7, "Password authentication: " + bl);
            try {
                downloader = new Downloader(uRL, string, bl, string4, string5);
                downloader.connectToURL();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log.println(this, 2, "It's possible that " + this.serverURLString + " does not have \"/\" at the end.");
                this.log.println(this, 2, "Returning HTTP response code is > 400. Assume 500.");
                this.log.printStackTrace(this, 2, fileNotFoundException);
                throw new DownloadPatchException(4);
            }
            catch (IOException iOException) {
                this.log.printStackTrace(this, 2, iOException);
                if (downloader != null) break block5;
                this.dispatchFailedEvent(PatchProLog.createMessage(2, FAILED_TO_CREATE_DOWNLOADER));
                ServerConnectionException serverConnectionException = new ServerConnectionException("ServerConnectionException", "ServerConnectionException.MESSAGE", "ServerConnectionException.REMEDY", 2);
                sessionData.addPatchProException(serverConnectionException);
                throw new DownloadPatchException(FAILED_TO_CREATE_DOWNLOADER);
            }
        }
        return downloader;
    }

    private long patchExists(String string, String string2) {
        String string3 = string + File.separator + string2 + ".jar";
        File file = new File(string3);
        return file.length();
    }

    private void dispatchProgressEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchProgress(new DownloadPatchEvent(this, string));
        }
    }

    private void dispatchDoneEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchDone(new DownloadPatchEvent(this, string));
        }
    }

    private void dispatchFailedEvent(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchFailed(new DownloadPatchEvent(this, string));
        }
    }
}

