/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.security;

import com.sun.patchpro.model.PatchProProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sun.misc.BASE64Encoder;
import sun.net.www.protocol.http.HttpURLConnection;

public class SSLTunnelSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory dfactory;
    private String tunnelHost;
    private String proxyUser;
    private String proxyPasswd;
    private int tunnelPort;
    private PatchProProperties properties;

    public SSLTunnelSocketFactory(String string, String string2) {
        this.tunnelHost = string;
        this.tunnelPort = Integer.parseInt(string2);
        this.properties = PatchProProperties.getInstance();
        this.proxyUser = this.properties.getProperty("patchpro.proxy.user", "");
        this.proxyPasswd = this.properties.getProperty("patchpro.proxy.passwd", "");
        this.dfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.createSocket(null, string, n, true);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.createSocket(null, string, n, true);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.createSocket(null, inetAddress.getHostName(), n, true);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        return this.createSocket(null, inetAddress.getHostName(), n, true);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        Socket socket2 = new Socket(this.tunnelHost, this.tunnelPort);
        this.doTunnelHandshake(socket2, string, n);
        SSLSocket sSLSocket = (SSLSocket)this.dfactory.createSocket(socket2, string, n, bl);
        return sSLSocket;
    }

    private void doTunnelHandshake(Socket socket, String string, int n) throws IOException {
        String string2;
        String string3;
        Object object;
        OutputStream outputStream = socket.getOutputStream();
        if (this.proxyUser != null && this.proxyUser.compareTo("") != 0 && this.proxyPasswd != null && this.proxyPasswd.compareTo("") != 0) {
            object = this.proxyUser + ":" + this.proxyPasswd;
            string3 = "CONNECT " + string + ":" + n + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\n" + "Proxy-Authorization:Basic " + new BASE64Encoder().encode(((String)object).getBytes()) + "\r\n\r\n";
        } else {
            string3 = "CONNECT " + string + ":" + n + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
        }
        try {
            object = string3.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = string3.getBytes();
        }
        outputStream.write((byte[])object);
        outputStream.flush();
        byte[] byArray = new byte[200];
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        InputStream inputStream = socket.getInputStream();
        boolean bl2 = false;
        while (n3 < 2) {
            int n4 = inputStream.read();
            if (n4 < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (n4 == 10) {
                bl = true;
                ++n3;
                continue;
            }
            if (n4 == 13) continue;
            n3 = 0;
            if (bl || n2 >= byArray.length) continue;
            byArray[n2++] = (byte)n4;
        }
        try {
            string2 = new String(byArray, 0, n2, "ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(byArray, 0, n2);
        }
        if (string2.toLowerCase().indexOf("200") == -1) {
            throw new IOException("Unable to tunnel through " + this.tunnelHost + ":" + this.tunnelPort + ".  Proxy returns \"" + string2 + "\"");
        }
    }

    public String[] getDefaultCipherSuites() {
        return this.dfactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.dfactory.getSupportedCipherSuites();
    }
}

