/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.manipulators.PatchInstallFailedException;
import com.sun.patchpro.manipulators.SunOSInstaller;
import com.sun.patchpro.manipulators.SunOSSunPatchManipulator;
import com.sun.patchpro.model.PatchProProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class SunOSSunPatchInstaller
extends SunOSInstaller {
    private static final String RECONFIGURE_FILE = "/reconfigure";
    Process patchInstallProcess = null;
    private boolean installSucceeded = true;

    public SunOSSunPatchInstaller(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
    }

    public void install() {
        File file;
        this.initializeProgress(0.0, 4.0);
        try {
            file = this.extractPatch();
        }
        catch (Exception exception) {
            this.log.printStackTrace(this, 2, exception);
            this.issueFail(new PatchInstallFailedException(57));
            return;
        }
        this.incrementProgress(1.0);
        Runtime runtime = Runtime.getRuntime();
        Vector<String> vector = new Vector<String>();
        vector.add(this.properties.getProperty("SunOS.command.install.patch", "/usr/sbin/patchadd"));
        if (this.backoutDirectory != null) {
            vector.add("-B");
            vector.add(this.backoutDirectory.getPath());
        }
        vector.add(file.getPath() + File.separator + this.activePatch.getPatchID().getPatchID());
        if (this.debug) {
            System.out.println("Install command string: " + vector);
            this.incrementProgress(2.0);
        } else {
            String[] stringArray = vector.toArray(new String[0]);
            try {
                this.patchInstallProcess = runtime.exec(stringArray);
                this.incrementProgress(1.0);
            }
            catch (IOException iOException) {
                this.log.println(this, 2, "Recieved java.io.IOException while installing a patch");
                this.log.printStackTrace(this, 2, iOException);
                this.issueFail(new PatchInstallFailedException(56));
            }
            try {
                this.incrementProgress(1.0);
                StringBuffer stringBuffer = new StringBuffer("");
                StringBuffer stringBuffer2 = new StringBuffer("");
                InputStream inputStream = null;
                InputStream inputStream2 = null;
                inputStream = this.patchInstallProcess.getInputStream();
                inputStream2 = this.patchInstallProcess.getErrorStream();
                StreamReader streamReader = new StreamReader(inputStream, stringBuffer);
                StreamReader streamReader2 = new StreamReader(inputStream2, stringBuffer2);
                streamReader.start();
                streamReader2.start();
                int n = this.patchInstallProcess.waitFor();
                streamReader.join(5000L);
                streamReader2.join(5000L);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n == 0 && ((SunOSSunPatchManipulator)this.manipulator).isReconfigureRequired()) {
                    File file2 = new File(RECONFIGURE_FILE);
                    try {
                        file2.createNewFile();
                    }
                    catch (IOException iOException) {
                        this.log.println(this, 7, "Failed to create /reconfigure file.");
                    }
                }
                if (n != 0) {
                    this.installSucceeded = false;
                    this.log.println(this, 7, "Patch install (patchadd) returned: " + n);
                    int n2 = n;
                    switch (n) {
                        case 0: {
                            n2 = 0;
                            break;
                        }
                        case 1: {
                            n2 = 1;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                        case 3: {
                            n2 = 3;
                            break;
                        }
                        case 4: {
                            n2 = 4;
                            break;
                        }
                        case 5: {
                            n2 = 5;
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 7: {
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 9: {
                            n2 = 9;
                            break;
                        }
                        case 10: {
                            break;
                        }
                        case 11: {
                            break;
                        }
                        case 12: {
                            break;
                        }
                        case 13: {
                            break;
                        }
                        case 14: {
                            break;
                        }
                        case 15: {
                            break;
                        }
                        case 16: {
                            break;
                        }
                        case 17: {
                            break;
                        }
                        case 18: {
                            n2 = 18;
                            break;
                        }
                        case 19: {
                            break;
                        }
                        case 20: {
                            break;
                        }
                        case 21: {
                            break;
                        }
                        case 22: {
                            break;
                        }
                        case 23: {
                            break;
                        }
                        case 24: {
                            break;
                        }
                        case 25: {
                            break;
                        }
                        case 26: {
                            break;
                        }
                        case 27: {
                            break;
                        }
                        case 28: {
                            break;
                        }
                        case 29: {
                            break;
                        }
                        case 30: {
                            break;
                        }
                        case 31: {
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 33: {
                            break;
                        }
                        case 34: {
                            break;
                        }
                    }
                    this.issueFail(new PatchInstallFailedException(n2, stringBuffer.toString() + " " + stringBuffer2.toString()));
                }
            }
            catch (InterruptedException interruptedException) {
                this.log.printStackTrace(this, 2, interruptedException);
                this.issueFail(new PatchInstallFailedException(57));
            }
        }
        this.incrementProgress(1.0);
    }

    public void postInstall() {
        if (this.installSucceeded) {
            super.postInstall();
        }
    }

    class StreamReader
    extends Thread {
        BufferedReader r;
        StringBuffer output;

        public StreamReader(InputStream inputStream, StringBuffer stringBuffer) {
            this.r = new BufferedReader(new InputStreamReader(inputStream));
            this.output = stringBuffer;
        }

        public void run() {
            try {
                String string;
                while ((string = this.r.readLine()) != null) {
                    this.output.append(string);
                }
            }
            catch (Throwable throwable) {
                SunOSSunPatchInstaller.this.log.printStackTrace(this, 7, throwable);
            }
        }
    }
}

