/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.manipulators;

import com.sun.patchpro.manipulators.InstallFailedException;
import com.sun.patchpro.manipulators.Installer;
import com.sun.patchpro.manipulators.Manipulator;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.InstallationParameters;
import java.io.File;
import java.io.IOException;

public abstract class SunOSInstaller
extends Installer {
    protected InstallationParameters instParms = InstallationParameters.getInstance();

    public SunOSInstaller(Manipulator manipulator, PatchProProperties patchProProperties) throws InstallFailedException {
        super(manipulator, patchProProperties);
    }

    protected void postInstall() {
        if (!this.properties.getProperty("patchpro.retain.patch", "false").equals("true")) {
            try {
                this.manipulator.delete();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.postInstall();
    }

    protected boolean purgeFile(File file) {
        Process process;
        boolean bl = true;
        if (file == null) {
            return false;
        }
        String[] stringArray = new String[]{"/usr/bin/rm", "-rf", file.getPath()};
        Runtime runtime = Runtime.getRuntime();
        try {
            process = runtime.exec(stringArray);
        }
        catch (IOException iOException) {
            this.log.printStackTrace(this, 4, iOException);
            return false;
        }
        try {
            int n = process.waitFor();
            if (n != 0) {
                if (this.debug) {
                    System.out.println("DEBUG: Remove failed - cc: " + n);
                }
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.printStackTrace(this, 4, interruptedException);
            return false;
        }
        return true;
    }
}

