/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.log;

import com.sun.patchpro.host.Host;
import com.sun.patchpro.log.Log;
import com.sun.patchpro.log.LogEverything;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.util.InstallationParameters;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ApplicationLog
implements Log {
    private Log OSSystemLogger = null;
    private PatchProProperties properties;
    private int logSize;
    private int logLevel;
    private boolean wrap;
    private boolean writeToStdOut;
    private File file;
    private RandomAccessFile raFile;
    private InstallationParameters instParms = null;
    private static final String DEFAULTLOGSIZE = "50000";
    private static final String TRACEOFF = "0";
    private static final String TRACEON = "1";
    private static final int LINES_PER_RECORD = 5;

    public ApplicationLog(String string) {
        this.file = string != null ? new File(string) : null;
        this.instParms = InstallationParameters.getInstance();
        try {
            if (this.file == null || this.file.getPath().equals("system") || this.file.getPath().equals("")) {
                String string2 = Host.getOSName() + "SystemLogger";
                String string3 = "com.sun.patchpro.log." + string2;
                Class<?> clazz = Class.forName(string3);
                this.OSSystemLogger = (Log)clazz.newInstance();
            } else {
                this.properties = PatchProProperties.getInstance();
                this.file = this.file;
                File file = this.file.getParentFile();
                if (!file.exists()) {
                    file.mkdirs();
                }
                this.file.createNewFile();
                if (this.file.canWrite()) {
                    this.raFile = new RandomAccessFile(this.file, "rw");
                    this.logSize = new Integer(this.properties.getProperty("patchpro.log.size", DEFAULTLOGSIZE));
                    this.wrap = false;
                    this.writeToStdOut = false;
                } else {
                    System.out.println("WARNING: Cannot access patchpro log facilities. Messages shall be redirected to stdout.");
                    this.writeToStdOut = true;
                }
                this.logLevel = new Integer(this.properties.getProperty("patchpro.log.level", TRACEOFF));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                PatchProLog patchProLog = PatchProLog.getInstance();
                patchProLog.setLogger(new LogEverything(System.out));
                patchProLog.printStackTrace(this, 3, fileNotFoundException);
            }
            catch (Exception exception) {
                System.err.println("ERROR: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        catch (IOException iOException) {
            try {
                PatchProLog patchProLog = PatchProLog.getInstance();
                patchProLog.setLogger(new LogEverything(System.out));
                patchProLog.printStackTrace(this, 3, iOException);
            }
            catch (Exception exception) {
                System.err.println("ERROR: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            try {
                PatchProLog patchProLog = PatchProLog.getInstance();
                patchProLog.setLogger(new LogEverything(System.out));
                patchProLog.printStackTrace(this, 3, exception);
            }
            catch (Exception exception2) {
                System.err.println("ERROR: " + exception2.getMessage());
                exception2.printStackTrace();
            }
        }
    }

    private String[] breakUp(String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n2 = stringTokenizer.countTokens();
        if (n <= 0 || n2 <= n) {
            return new String[]{string};
        }
        int n3 = n2 % n == 0 ? n2 / n : n2 / n + 1;
        String[] stringArray = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            if (n2 >= n) {
                stringArray[n4] = "";
                n5 = 0;
                while (n5 < n) {
                    int n6 = n4;
                    stringArray[n6] = stringArray[n6] + (String)stringTokenizer.nextElement() + "\n";
                    ++n5;
                    --n2;
                }
            } else {
                n5 = 0;
                while (n5 < n2) {
                    int n7 = n4;
                    stringArray[n7] = stringArray[n7] + (String)stringTokenizer.nextElement() + "\n";
                    ++n5;
                }
            }
            ++n4;
        }
        return stringArray;
    }

    public synchronized void print(Object object, int n, String string) {
        block28: {
            String[] stringArray;
            block27: {
                stringArray = this.breakUp(string, 5);
                if (this.OSSystemLogger != null) break block27;
                String string2 = "<unknown>";
                switch (n) {
                    case 0: {
                        string2 = "EMERGENCY";
                        break;
                    }
                    case 1: {
                        string2 = "ALERT";
                        break;
                    }
                    case 2: {
                        string2 = "CRITICAL";
                        break;
                    }
                    case 3: {
                        string2 = "ERROR";
                        break;
                    }
                    case 4: {
                        string2 = "WARNING";
                        break;
                    }
                    case 5: {
                        string2 = "NOTICE";
                        break;
                    }
                    case 6: {
                        string2 = "INFO";
                        break;
                    }
                    case 7: {
                        string2 = "DEBUG";
                    }
                }
                if (n > this.logLevel) break block28;
                if (this.writeToStdOut) {
                    String string3 = new Date().toString() + "(" + string2 + ")=> " + object.toString() + " <=" + string;
                    System.out.println(string3);
                } else {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        block26: {
                            String string4 = new Date().toString() + "(" + string2 + ")=> " + object.toString() + " <=" + stringArray[n2];
                            try {
                                long l = this.raFile.length();
                                if (!this.wrap && l + (long)string4.length() > (long)this.logSize) {
                                    this.wrap = true;
                                }
                                if (this.wrap) {
                                    File file = null;
                                    RandomAccessFile randomAccessFile = null;
                                    String string5 = null;
                                    String string6 = this.file.getAbsolutePath();
                                    StringTokenizer stringTokenizer = new StringTokenizer(string4, "\n");
                                    int n3 = 0;
                                    int n4 = 0;
                                    try {
                                        while (stringTokenizer.hasMoreElements()) {
                                            stringTokenizer.nextElement();
                                            ++n3;
                                        }
                                    }
                                    catch (NoSuchElementException noSuchElementException) {
                                        System.err.println("ERROR: " + noSuchElementException.getMessage());
                                        noSuchElementException.printStackTrace();
                                    }
                                    this.raFile.seek(0L);
                                    int n5 = 0;
                                    while (n5 < n3) {
                                        string5 = this.raFile.readLine();
                                        if (string5 != null) {
                                            n4 += string5.length() + 1;
                                        }
                                        this.raFile.seek(n4);
                                        byte[] byArray = new byte[(int)l - n4];
                                        file = new File(string6 + ".tmp");
                                        file.createNewFile();
                                        randomAccessFile = new RandomAccessFile(file, "rw");
                                        this.raFile.readFully(byArray);
                                        randomAccessFile.write(byArray, 0, byArray.length);
                                        randomAccessFile.writeBytes(string4);
                                        randomAccessFile.close();
                                        this.raFile.close();
                                        file.renameTo(new File(string6));
                                        this.file = new File(string6);
                                        if (!this.file.exists()) {
                                            this.file.createNewFile();
                                        }
                                        this.raFile = new RandomAccessFile(this.file, "rw");
                                        file = null;
                                        randomAccessFile = null;
                                        ++n5;
                                    }
                                    break block26;
                                }
                                this.raFile.seek(this.raFile.length());
                                this.raFile.writeBytes(string4);
                            }
                            catch (IOException iOException) {
                                try {
                                    PatchProLog patchProLog = PatchProLog.getInstance();
                                    patchProLog.setLogger(new LogEverything(System.out));
                                    patchProLog.printStackTrace(this, 3, iOException);
                                }
                                catch (Exception exception) {
                                    System.err.println("ERROR: " + exception.getMessage());
                                    exception.printStackTrace();
                                }
                            }
                        }
                        ++n2;
                    }
                }
                break block28;
            }
            int n6 = 0;
            while (n6 < stringArray.length) {
                this.OSSystemLogger.print(object, n, stringArray[n6]);
                ++n6;
            }
        }
    }
}

