/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.host;

import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.util.InvalidVersionException;
import com.sun.patchpro.util.Version;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Realization
implements Serializable {
    private transient PatchProLog log = PatchProLog.getInstance();
    private String basename;
    private Version version;
    private Vector hardwareComponentRepository = new Vector();

    private void validateRealization(String string) throws NoSuchRealizationException {
        try {
            if (string == null) {
                throw new NoSuchRealizationException("Realization string is a null object");
            }
            if (string.trim().equals("")) {
                throw new NoSuchRealizationException("Realization string is a null string");
            }
            if ('-' == string.charAt(0)) {
                throw new NoSuchRealizationException("No leading '-' allowed in string");
            }
            if (string.indexOf(45) == -1) {
                throw new NoSuchRealizationException("A realization requires a dash delimiter");
            }
            if (string.indexOf(45) != string.lastIndexOf(45)) {
                throw new NoSuchRealizationException("A realization may contain only one dash delimiter");
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            if (stringTokenizer.countTokens() < 2) {
                throw new NoSuchRealizationException("Poorly formed realization: " + string);
            }
            this.basename = stringTokenizer.nextToken();
            if (this.basename == null || this.basename.compareTo("") == 0) {
                throw new NoSuchRealizationException("No basename in realization: " + string);
            }
            try {
                this.version = new Version(stringTokenizer.nextToken());
            }
            catch (InvalidVersionException invalidVersionException) {
                throw new NoSuchRealizationException("Poorly formed realization version string: " + string);
            }
            if (this.version == null) {
                throw new NoSuchRealizationException("No version in realization: " + string);
            }
        }
        catch (Exception exception) {
            this.log.println(this, 4, "Unexpected exception in Realization: " + exception.getMessage());
            this.log.printStackTrace(this, 4, exception);
            throw new NoSuchRealizationException("Poorly formed realization: " + string);
        }
    }

    private void validateBasename(String string) throws NoSuchRealizationException {
        if (string == null) {
            throw new NoSuchRealizationException("Realization basename string is a null object");
        }
        if (string.equals("")) {
            throw new NoSuchRealizationException("Realization basename string is a null string");
        }
        if (string.indexOf(45) != -1) {
            throw new NoSuchRealizationException("A realization basename can not have a dash delimiter");
        }
    }

    public Realization(String string) throws NoSuchRealizationException {
        this.validateRealization(string);
    }

    public Realization() {
    }

    public static Enumeration createRealizationList(String string) throws NoSuchRealizationException {
        Vector<Realization> vector = new Vector<Realization>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(new Realization(stringTokenizer.nextToken()));
            }
        }
        catch (Exception exception) {
            throw new NoSuchRealizationException("Failed to create Realization list. " + exception.getMessage());
        }
        return vector.elements();
    }

    public Realization(String string, Version version) throws NoSuchRealizationException {
        if (string == null && version == null) {
            throw new NoSuchRealizationException("basename and version are null objects");
        }
        if (string == null) {
            throw new NoSuchRealizationException("basename is a null object");
        }
        if (version == null) {
            throw new NoSuchRealizationException("version is a null object");
        }
        this.validateBasename(string);
        this.basename = string;
        this.version = version;
    }

    public boolean equals(Realization realization) {
        return this.basename.equals(realization.getBasename()) && this.version.compareTo(realization.getVersion()) == 0;
    }

    public String getRealizationString() {
        return this.basename + "-" + this.version.getVersion();
    }

    public String getBasename() {
        return this.basename;
    }

    public Version getVersion() {
        return this.version;
    }

    public void addHardwareComponent(HardwareComponent hardwareComponent) {
        if (!this.hardwareComponentRepository.contains(hardwareComponent)) {
            this.hardwareComponentRepository.addElement(hardwareComponent);
        }
    }

    public Enumeration getHardwareComponents() {
        return this.hardwareComponentRepository.elements();
    }
}

