/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.analysis;

import com.sun.patchpro.analysis.DetectorFailedException;
import com.sun.patchpro.analysis.InteractiveDetectorPrtl;
import com.sun.patchpro.analysis.NoninteractiveException;
import com.sun.patchpro.host.Host;
import com.sun.patchpro.host.NoSuchRealizationException;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.util.Interaction;
import com.sun.patchpro.util.InteractionSet;
import com.sun.patchpro.util.QuestionList;
import java.util.NoSuchElementException;

public class TapeSubsystemInteractiveDetector
extends InteractiveDetectorPrtl {
    private Host targetHost;
    private int interactionType = 1;
    private String[] choiceString = new String[]{"DDS3", "ETL41000", "ETL41800", "ETL43500", "L11000", "L1800", "L3500", "L1000", "L700", "L400", "L280"};
    private Interaction[] interactionList = new Interaction[]{new QuestionList("Please select the attached tape storage subsystems.", this.choiceString)};
    private String[] realizationList = new String[]{"TapeStorageSystem.SunDDS3-1.0", "TapeStorageSystem.SunETL41000-1.0", "TapeStorageSystem.SunETL41800-1.0", "TapeStorageSystem.SunETL43500-1.0", "TapeStorageSystem.SunL11000-1.0", "TapeStorageSystem.SunL1800-1.0", "TapeStorageSystem.SunL3500-1.0", "TapeStorageSystem.SunL1000-1.0", "TapeStorageSystem.SunL700-1.0", "TapeStorageSystem.SunL400-1.0", "TapeStorageSystem.SunL280-1.0"};

    public TapeSubsystemInteractiveDetector() {
        try {
            this.initialize(this.realizationList);
            this.statusMessage = new String("Looking for tape subsystems...");
            this.interactionSet = this.constructInteractionSet(this.interactionList, this.interactionType);
        }
        catch (DetectorFailedException detectorFailedException) {
            throw new Error("Detector couldn't even start.");
        }
    }

    public InteractionSet analyze(Host host) throws NoninteractiveException, DetectorFailedException {
        this.targetHost = host;
        return this.interactionSet;
    }

    public void setInteractionSet(InteractionSet interactionSet) throws DetectorFailedException {
        this.interactionSet = interactionSet;
        boolean bl = false;
        interactionSet.reset();
        try {
            while (interactionSet.hasMoreInteractions()) {
                QuestionList questionList = (QuestionList)interactionSet.nextInteraction();
                String[] stringArray = questionList.getChoices();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    bl = questionList.getSelection(n2) != 0;
                    this.targetHost.verifyRealization(new Realization(this.realizationList[n2]), bl);
                    ++n2;
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DetectorFailedException("Recieved empty interaction set.");
        }
        catch (NoSuchRealizationException noSuchRealizationException) {
            throw new DetectorFailedException("Unrecognized realization.");
        }
    }
}

