/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat4;

import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Logger;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.tomcat4.CoyoteConnector;
import org.apache.coyote.tomcat4.CoyotePrincipal;
import org.apache.coyote.tomcat4.CoyoteRequest;
import org.apache.coyote.tomcat4.CoyoteResponse;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.ServerCookie;

final class CoyoteAdapter
implements Adapter {
    public static final int ADAPTER_NOTES = 1;
    private CoyoteConnector connector = null;
    private int debug = 0;
    private static final String match = ";jsessionid=";
    private static final char[] SESSION_ID;
    protected StringManager sm = StringManager.getManager((String)"org.apache.coyote.tomcat4");

    public CoyoteAdapter(CoyoteConnector connector) {
        this.connector = connector;
        this.debug = connector.getDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request req, Response res) throws Exception {
        block6: {
            CoyoteRequest request = (CoyoteRequest)req.getNote(1);
            CoyoteResponse response = (CoyoteResponse)res.getNote(1);
            if (request == null) {
                request = (CoyoteRequest)this.connector.createRequest();
                request.setCoyoteRequest(req);
                response = (CoyoteResponse)this.connector.createResponse();
                response.setCoyoteResponse(res);
                request.setResponse((org.apache.catalina.Response)response);
                response.setRequest((org.apache.catalina.Request)request);
                req.setNote(1, request);
                res.setNote(1, response);
            }
            try {
                try {
                    this.postParseRequest(req, request, res, response);
                    this.connector.getContainer().invoke((org.apache.catalina.Request)request, (org.apache.catalina.Response)response);
                    response.finishResponse();
                    req.action(ActionCode.ACTION_POST_REQUEST, null);
                }
                catch (IOException e) {
                    Object var8_6 = null;
                    request.recycle();
                    response.recycle();
                    break block6;
                }
                catch (Throwable t) {
                    this.log(this.sm.getString("coyoteAdapter.service"), t);
                    Object var8_7 = null;
                    request.recycle();
                    response.recycle();
                }
                Object var8_5 = null;
                request.recycle();
                response.recycle();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                request.recycle();
                response.recycle();
                throw throwable;
            }
        }
    }

    protected void postParseRequest(Request req, CoyoteRequest request, Response res, CoyoteResponse response) throws IOException {
        request.setSecure(this.connector.getSecure());
        req.scheme().setString(this.connector.getScheme());
        request.setAuthorization(req.getHeader("authorization"));
        if (req.getServerPort() == 80 && this.connector.getScheme().equals("https")) {
            req.setServerPort(443);
        }
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            request.setServerPort(proxyPort);
            req.setServerPort(proxyPort);
        } else {
            request.setServerPort(req.getServerPort());
        }
        if (proxyName != null) {
            request.setServerName(proxyName);
            req.serverName().setString(proxyName);
        } else {
            request.setServerName(req.serverName().toString());
        }
        req.decodedURI().duplicate(req.requestURI());
        req.getURLDecoder().convert(req.decodedURI(), true);
        req.decodedURI().setEncoding("UTF-8");
        if (!CoyoteAdapter.normalize(req.decodedURI())) {
            res.setStatus(400);
            res.setMessage("Invalid URI");
            throw new IOException("Invalid URI");
        }
        this.parseSessionId(req, request);
        if (this.connector.getUseURIValidationHack()) {
            String uri = CoyoteAdapter.validate(request.getRequestURI());
            if (uri == null) {
                res.setStatus(400);
                res.setMessage("Invalid URI");
                throw new IOException("Invalid URI");
            }
            req.requestURI().setString(uri);
            req.decodedURI().duplicate(req.requestURI());
            req.getURLDecoder().convert(req.decodedURI(), true);
        }
        this.parseCookies(req, request);
        res.action(ActionCode.ACTION_REQ_SSL_ATTRIBUTE, request.getRequest());
        String principal = req.getRemoteUser().toString();
        if (principal != null) {
            request.setUserPrincipal(new CoyotePrincipal(principal));
        }
    }

    protected void parseSessionId(Request req, CoyoteRequest request) {
        ByteChunk uriBC = req.decodedURI().getByteChunk();
        int semicolon = uriBC.indexOf(match, 0, match.length(), 0);
        if (semicolon > 0) {
            String uri = uriBC.toString();
            String rest = uri.substring(semicolon + match.length());
            int semicolon2 = rest.indexOf(59);
            if (semicolon2 >= 0) {
                request.setRequestedSessionId(rest.substring(0, semicolon2));
                rest = rest.substring(semicolon2);
            } else {
                request.setRequestedSessionId(rest);
                rest = "";
            }
            request.setRequestedSessionURL(true);
            req.decodedURI().setString(uri.substring(0, semicolon) + rest);
            uri = req.requestURI().toString();
            semicolon = uri.indexOf(match);
            if (semicolon > 0) {
                rest = uri.substring(semicolon + match.length());
                semicolon2 = rest.indexOf(59);
                rest = semicolon2 >= 0 ? rest.substring(semicolon2) : "";
                req.requestURI().setString(uri.substring(0, semicolon) + rest);
            }
        } else {
            request.setRequestedSessionId(null);
            request.setRequestedSessionURL(false);
        }
    }

    protected void parseCookies(Request req, CoyoteRequest request) {
        Cookies serverCookies = req.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        Cookie[] cookies = new Cookie[count];
        int i = 0;
        while (i < count) {
            Cookie cookie;
            ServerCookie scookie = serverCookies.getCookie(i);
            if (scookie.getName().equals("JSESSIONID") && !request.isRequestedSessionIdFromCookie()) {
                request.setRequestedSessionId(scookie.getValue().toString());
                request.setRequestedSessionCookie(true);
                request.setRequestedSessionURL(false);
                if (this.debug >= 1) {
                    this.log(" Requested cookie session id is " + ((HttpServletRequest)request.getRequest()).getRequestedSessionId());
                }
            }
            cookies[i] = cookie = new Cookie(scookie.getName().toString(), scookie.getValue().toString());
            ++i;
        }
        request.setCookies(cookies);
    }

    protected static String validate(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.startsWith("/%7E") || normalized.startsWith("/%7e")) {
            normalized = "/~" + normalized.substring(4);
        }
        if (normalized.indexOf("%25") >= 0 || normalized.indexOf("%2F") >= 0 || normalized.indexOf("%2E") >= 0 || normalized.indexOf("%5C") >= 0 || normalized.indexOf("%2f") >= 0 || normalized.indexOf("%2e") >= 0 || normalized.indexOf("%5c") >= 0) {
            return null;
        }
        if (normalized.equals("/.")) {
            return "/";
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        if (normalized.indexOf("/...") >= 0) {
            return null;
        }
        return normalized;
    }

    public static boolean normalize(MessageBytes uriMB) {
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        int end = uriBC.getEnd();
        int pos = 0;
        int index = 0;
        pos = start;
        while (pos < end) {
            if (b[pos] == 92) {
                b[pos] = 47;
            }
            if (b[pos] == 0) {
                return false;
            }
            ++pos;
        }
        pos = start;
        while (pos < end - 1) {
            if (b[pos] == 47 && b[pos + 1] == 47) {
                CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                --end;
            }
            ++pos;
        }
        if (end - start > 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            pos = start + index - 1;
            while (pos >= 0 && index2 < 0) {
                if (b[pos] == 47) {
                    index2 = pos;
                }
                --pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        int pos = 0;
        while (pos < len) {
            b[pos + dest] = b[pos + src];
            ++pos;
        }
    }

    protected void log(String message) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log("CoyoteAdapter " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log("CoyoteAdapter " + message, throwable);
        }
    }

    static {
        ADAPTER_NOTES = 1;
        match = match;
        SESSION_ID = match.toCharArray();
    }
}

