/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.SecretKeyFacade;

public class JCASymKeyGen {
    static final String MOZ_PROVIDER_NAME = "Mozilla-JSS";
    byte[] plainText16Bytes = "Firefox   rules!".getBytes();
    byte[] plainText18Bytes = "Thunderbird rules!".getBytes();

    public JCASymKeyGen(String string) {
        try {
            CryptoManager.initialize(string);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalCryptoToken();
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            alreadyInitializedException.printStackTrace();
            System.exit(1);
        }
        catch (CertDatabaseException certDatabaseException) {
            certDatabaseException.printStackTrace();
            System.exit(1);
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            notInitializedException.printStackTrace();
            System.exit(1);
        }
        catch (GeneralSecurityException generalSecurityException) {
            generalSecurityException.printStackTrace();
            System.exit(1);
        }
        catch (KeyDatabaseException keyDatabaseException) {
            keyDatabaseException.printStackTrace();
            System.exit(1);
        }
    }

    public SecretKey genSecretKey(String string, String string2) {
        SecretKey secretKey = null;
        KeyGenerator keyGenerator = null;
        try {
            keyGenerator = KeyGenerator.getInstance(string, string2);
            if (string.equals("AES") || string.equals("RC2")) {
                keyGenerator.init(128);
            }
            System.out.println("Key " + string + " generation done by " + keyGenerator.getProvider().toString());
            secretKey = keyGenerator.generateKey();
            if (!this.checkAlgorithm(secretKey, string)) {
                throw new Exception("Error: " + secretKey.getAlgorithm() + "  algorithm");
            }
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return secretKey;
    }

    public SecretKey genPBESecretKey(String string, String string2) {
        SecretKeyFacade secretKeyFacade = null;
        SecretKeyFactory secretKeyFactory = null;
        try {
            char[] cArray = "thunderbird".toCharArray();
            byte[] byArray = new byte[8];
            SecureRandom secureRandom = SecureRandom.getInstance("pkcs11prng", MOZ_PROVIDER_NAME);
            secureRandom.nextBytes(byArray);
            int n = 2;
            secretKeyFactory = SecretKeyFactory.getInstance(string, string2);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, byArray, n);
            secretKeyFacade = (SecretKeyFacade)secretKeyFactory.generateSecret(pBEKeySpec);
            System.out.println("Key " + string + " generation done by " + secretKeyFactory.getProvider().toString());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return secretKeyFacade;
    }

    public void testCipher(SecretKey secretKey, String string, String string2, String string3, String string4) throws Exception {
        try {
            Object object;
            byte[] byArray;
            byte[] byArray2 = this.plainText16Bytes;
            if (string2.endsWith("PKCS5Padding")) {
                byArray2 = this.plainText18Bytes;
            }
            Cipher cipher = Cipher.getInstance(string2, string3);
            AlgorithmParameters algorithmParameters = null;
            byte[] byArray3 = null;
            RC2ParameterSpec rC2ParameterSpec = null;
            if (string.compareToIgnoreCase("RC2") == 0) {
                byArray = new byte[8];
                object = SecureRandom.getInstance("pkcs11prng", MOZ_PROVIDER_NAME);
                ((SecureRandom)object).nextBytes(byArray);
                rC2ParameterSpec = new RC2ParameterSpec(128, byArray);
                cipher.init(1, (Key)secretKey, rC2ParameterSpec);
            } else {
                cipher.init(1, secretKey);
                algorithmParameters = cipher.getParameters();
                if (algorithmParameters != null) {
                    byArray3 = algorithmParameters.getEncoded();
                }
            }
            byArray = cipher.doFinal(byArray2);
            cipher = Cipher.getInstance(string2, string4);
            if (byArray3 == null) {
                if (rC2ParameterSpec != null) {
                    cipher.init(2, (Key)secretKey, rC2ParameterSpec);
                } else {
                    cipher.init(2, secretKey);
                }
            } else {
                object = AlgorithmParameters.getInstance(string);
                ((AlgorithmParameters)object).init(byArray3);
                cipher.init(2, (Key)secretKey, (AlgorithmParameters)object);
            }
            object = cipher.doFinal(byArray);
            if (!Arrays.equals(byArray2, (byte[])object)) {
                throw new Exception("ERROR: " + string3 + " and " + string4 + " failed for " + string2);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        catch (BadPaddingException badPaddingException) {
            badPaddingException.printStackTrace();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            noSuchPaddingException.printStackTrace();
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            illegalBlockSizeException.printStackTrace();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        String string = ".";
        String[][] stringArrayArray = new String[][]{{"DES", "DES/ECB/NoPadding", "DES/CBC/PKCS5Padding", "DES/CBC/NoPadding"}, {"DESede", "DESede/ECB/NoPadding", "DESede/CBC/PKCS5Padding", "DESede/CBC/NoPadding"}, {"AES", "AES/ECB/NoPadding", "AES/CBC/NoPadding", "AES/CBC/PKCS5Padding"}, {"RC2", "RC2/CBC/NoPadding", "RC2/CBC/PKCS5Padding"}, {"PBEWithMD5AndDES", "DES/ECB/NoPadding"}, {"PBEWithSHA1AndDES"}, {"PBEWithSHA1AndDESede", "DESede/ECB/NoPadding"}};
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            System.out.println("USAGE: java org.mozilla.jss.tests.JCASymKeyGen <certDbPath> ");
            System.exit(1);
        }
        String string2 = new String("IBMJCE");
        Provider provider = null;
        provider = Security.getProvider(string2);
        if (provider == null && (provider = Security.getProvider(string2 = new String("SunJCE"))) == null) {
            System.out.println("unable to find IBMJCE or SunJCE providers");
            System.exit(1);
        }
        JCASymKeyGen jCASymKeyGen = new JCASymKeyGen(string);
        System.out.println(string2 + ": " + provider.getInfo());
        provider = Security.getProvider(MOZ_PROVIDER_NAME);
        System.out.println("Mozilla-JSS: " + provider.getInfo());
        SecretKey secretKey = null;
        try {
            int n = 0;
            while (n < stringArrayArray.length) {
                try {
                    secretKey = stringArrayArray[n][0].startsWith("PBE") ? jCASymKeyGen.genPBESecretKey(stringArrayArray[n][0], MOZ_PROVIDER_NAME) : jCASymKeyGen.genSecretKey(stringArrayArray[n][0], MOZ_PROVIDER_NAME);
                }
                catch (Exception exception) {
                    System.out.println("unable to generate key: " + stringArrayArray[n][0] + " " + exception.getMessage());
                }
                int n2 = 1;
                while (n2 < stringArrayArray[n].length) {
                    block11: {
                        jCASymKeyGen.testCipher(secretKey, stringArrayArray[n][0], stringArrayArray[n][n2], MOZ_PROVIDER_NAME, MOZ_PROVIDER_NAME);
                        try {
                            Cipher cipher = Cipher.getInstance(stringArrayArray[n][n2], string2);
                        }
                        catch (Exception exception) {
                            System.out.println("Mozilla-JSS only supports " + stringArrayArray[n][n2]);
                            break block11;
                        }
                        jCASymKeyGen.testCipher(secretKey, stringArrayArray[n][0], stringArrayArray[n][n2], MOZ_PROVIDER_NAME, string2);
                        jCASymKeyGen.testCipher(secretKey, stringArrayArray[n][0], stringArrayArray[n][n2], string2, MOZ_PROVIDER_NAME);
                        System.out.println("Mozilla-JSS and  " + string2 + " tested " + stringArrayArray[n][n2]);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private boolean checkAlgorithm(SecretKey secretKey, String string) {
        boolean bl = false;
        if (secretKey.getAlgorithm().equals(string)) {
            bl = true;
        }
        return bl;
    }

    private boolean checkKeyLength(SecretKey secretKey, int n) {
        boolean bl = false;
        byte[] byArray = secretKey.getEncoded();
        if (byArray.length == n) {
            bl = true;
        }
        return bl;
    }

    private String asHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            if ((byArray[n] & 0xFF) < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Long.toString(byArray[n] & 0xFF, 16));
            ++n;
        }
        return stringBuffer.toString();
    }
}

