/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.javax.crypto;

import java.io.CharConversionException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;

class JSSKeyGeneratorSpi
extends KeyGeneratorSpi {
    private KeyGenerator keyGenerator = null;

    private JSSKeyGeneratorSpi() {
    }

    protected JSSKeyGeneratorSpi(KeyGenAlgorithm keyGenAlgorithm) {
        try {
            CryptoToken cryptoToken = TokenSupplierManager.getTokenSupplier().getThreadToken();
            this.keyGenerator = cryptoToken.getKeyGenerator(keyGenAlgorithm);
        }
        catch (TokenException tokenException) {
            throw new TokenRuntimeException(tokenException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new TokenRuntimeException(noSuchAlgorithmException.getMessage());
        }
    }

    protected void engineInit(int n, SecureRandom secureRandom) throws InvalidParameterException {
        try {
            this.keyGenerator.initialize(n);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
        }
    }

    protected void engineInit(SecureRandom secureRandom) throws InvalidParameterException {
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.keyGenerator.initialize(algorithmParameterSpec);
    }

    protected SecretKey engineGenerateKey() {
        try {
            return new SecretKeyFacade(this.keyGenerator.generate());
        }
        catch (IllegalStateException illegalStateException) {
            throw new TokenRuntimeException("IllegalStateException: " + illegalStateException.getMessage());
        }
        catch (TokenException tokenException) {
            throw new TokenRuntimeException(tokenException.getMessage());
        }
        catch (CharConversionException charConversionException) {
            throw new TokenRuntimeException("CharConversionException: " + charConversionException.getMessage());
        }
    }

    public static class PBAHmacSHA1
    extends JSSKeyGeneratorSpi {
        public PBAHmacSHA1() {
            super(KeyGenAlgorithm.PBA_SHA1_HMAC);
        }
    }

    public static class HmacSHA1
    extends JSSKeyGeneratorSpi {
        public HmacSHA1() {
            super(KeyGenAlgorithm.PBA_SHA1_HMAC);
        }
    }

    public static class RC2
    extends JSSKeyGeneratorSpi {
        public RC2() {
            super(KeyGenAlgorithm.RC2);
        }
    }

    public static class RC4
    extends JSSKeyGeneratorSpi {
        public RC4() {
            super(KeyGenAlgorithm.RC4);
        }
    }

    public static class AES
    extends JSSKeyGeneratorSpi {
        public AES() {
            super(KeyGenAlgorithm.AES);
        }
    }

    public static class DESede
    extends JSSKeyGeneratorSpi {
        public DESede() {
            super(KeyGenAlgorithm.DESede);
        }
    }

    public static class DES
    extends JSSKeyGeneratorSpi {
        public DES() {
            super(KeyGenAlgorithm.DES);
        }
    }
}

