/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs11;

import java.math.BigInteger;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkcs11.CertProxy;
import org.mozilla.jss.pkcs11.TokenProxy;
import org.mozilla.jss.util.Assert;

public class PK11Cert
implements X509Certificate {
    protected CertProxy certProxy;
    protected TokenProxy tokenProxy;
    protected String nickname;

    public native byte[] getEncoded() throws CertificateEncodingException;

    public String getNickname() {
        return this.nickname;
    }

    public Principal getSubjectDN() {
        return new StringPrincipal(this.getSubjectDNString());
    }

    public Principal getIssuerDN() {
        return new StringPrincipal(this.getIssuerDNString());
    }

    public BigInteger getSerialNumber() {
        return new BigInteger(this.getSerialNumberByteArray());
    }

    protected native byte[] getSerialNumberByteArray();

    protected native String getSubjectDNString();

    protected native String getIssuerDNString();

    public native PublicKey getPublicKey();

    public native int getVersion();

    protected native byte[] getUniqueID();

    protected native CryptoToken getOwningToken();

    protected native void setTrust(int var1, int var2);

    protected native int getTrust(int var1);

    PK11Cert(byte[] byArray, byte[] byArray2, String string) {
        Assert._assert(byArray != null);
        Assert._assert(byArray2 != null);
        this.certProxy = new CertProxy(byArray);
        this.tokenProxy = new TokenProxy(byArray2);
        this.nickname = string;
    }

    protected static class StringPrincipal
    implements Principal {
        protected String str;

        public StringPrincipal(String string) {
            this.str = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof StringPrincipal)) {
                return false;
            }
            return this.getName().equals(((StringPrincipal)object).getName());
        }

        public String getName() {
            return this.str;
        }

        public int hashCode() {
            return this.str.hashCode();
        }

        public String toString() {
            return this.str;
        }
    }
}

