/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs10;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InvalidKeyFormatException;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.Signature;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs10.CertificationRequestInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;

public class CertificationRequest
implements ASN1Value {
    private CertificationRequestInfo info;
    private byte[] infoEncoding;
    private byte[] signature;
    private AlgorithmIdentifier algId;
    SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private CertificationRequest() {
    }

    CertificationRequest(CertificationRequestInfo certificationRequestInfo, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws IOException {
        this.info = certificationRequestInfo;
        this.algId = algorithmIdentifier;
        this.signature = byArray;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(certificationRequestInfo);
        this.sequence.addElement(algorithmIdentifier);
        this.sequence.addElement(new BIT_STRING(byArray, 0));
    }

    public CertificationRequest(CertificationRequestInfo certificationRequestInfo, PrivateKey privateKey, SignatureAlgorithm signatureAlgorithm) throws IOException, CryptoManager.NotInitializedException, TokenException, NoSuchAlgorithmException, CertificateException, InvalidKeyException, SignatureException {
        if (!(privateKey instanceof org.mozilla.jss.crypto.PrivateKey)) {
            throw new InvalidKeyException("Private Key is does not belong to this provider");
        }
        org.mozilla.jss.crypto.PrivateKey privateKey2 = (org.mozilla.jss.crypto.PrivateKey)privateKey;
        this.algId = signatureAlgorithm.getSigningAlg() == SignatureAlgorithm.RSASignature ? new AlgorithmIdentifier(signatureAlgorithm.toOID(), null) : new AlgorithmIdentifier(signatureAlgorithm.toOID());
        this.info = certificationRequestInfo;
        this.infoEncoding = ASN1Util.encode(certificationRequestInfo);
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken cryptoToken = privateKey2.getOwningToken();
        Signature signature = cryptoToken.getSignatureContext(signatureAlgorithm);
        signature.initSign(privateKey2);
        signature.update(this.infoEncoding);
        this.signature = signature.sign();
        this.sequence = new SEQUENCE();
        this.sequence.addElement(certificationRequestInfo);
        this.sequence.addElement(this.algId);
        this.sequence.addElement(new BIT_STRING(this.signature, 0));
    }

    public void verify() throws InvalidKeyException, CryptoManager.NotInitializedException, NoSuchAlgorithmException, CertificateException, TokenException, SignatureException, InvalidKeyFormatException {
        this.verify(this.info.getSubjectPublicKeyInfo().toPublicKey());
    }

    public void verify(PublicKey publicKey) throws InvalidKeyException, CryptoManager.NotInitializedException, NoSuchAlgorithmException, CertificateException, TokenException, SignatureException {
        CryptoManager cryptoManager = CryptoManager.getInstance();
        this.verify(publicKey, cryptoManager.getInternalCryptoToken());
    }

    public void verify(PublicKey publicKey, CryptoToken cryptoToken) throws NoSuchAlgorithmException, CertificateException, TokenException, SignatureException, InvalidKeyException {
        Signature signature = cryptoToken.getSignatureContext(SignatureAlgorithm.fromOID(this.algId.getOID()));
        signature.initVerify(publicKey);
        signature.update(this.infoEncoding);
        if (!signature.verify(this.signature)) {
            throw new CertificateException("Signature is invalid");
        }
    }

    public CertificationRequestInfo getInfo() {
        return this.info;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 2 || stringArray.length < 1) {
                System.out.println("Usage: CertificationRequest <dbdir> [<certfile>]");
                System.exit(0);
            }
            CryptoManager.initialize(stringArray[0]);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(stringArray[1]));
            CertificationRequest certificationRequest = (CertificationRequest)CertificationRequest.getTemplate().decode(bufferedInputStream);
            CertificationRequestInfo certificationRequestInfo = certificationRequest.getInfo();
            certificationRequestInfo.print(System.out);
            certificationRequest.verify();
            System.out.println("verified");
            FileOutputStream fileOutputStream = new FileOutputStream("certinfo.der");
            certificationRequestInfo.encode(fileOutputStream);
            fileOutputStream.close();
            CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
            KeyPairGenerator keyPairGenerator = cryptoToken.getKeyPairGenerator(KeyPairAlgorithm.RSA);
            keyPairGenerator.initialize(512);
            System.out.println("Generating a new key pair...");
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            System.out.println("Generated key pair");
            certificationRequestInfo.setSubjectPublicKeyInfo(keyPair.getPublic());
            Name name = new Name();
            name.addCommonName("asldkj");
            name.addCountryName("US");
            name.addOrganizationName("Some Corp");
            name.addOrganizationalUnitName("Some Org Unit");
            name.addLocalityName("Silicon Valley");
            name.addStateOrProvinceName("California");
            certificationRequestInfo.setSubject(name);
            System.out.println("About to create a new cert request...");
            CertificationRequest certificationRequest2 = new CertificationRequest(certificationRequestInfo, keyPair.getPrivate(), SignatureAlgorithm.RSASignatureWithMD5Digest);
            System.out.println("Created new cert request");
            certificationRequest2.verify();
            System.out.println("Cert verifies!");
            fileOutputStream = new FileOutputStream("gencert.der");
            certificationRequest2.encode(fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(CertificationRequestInfo.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(BIT_STRING.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            CertificationRequestInfo certificationRequestInfo = (CertificationRequestInfo)sEQUENCE.elementAt(0);
            BIT_STRING bIT_STRING = (BIT_STRING)sEQUENCE.elementAt(2);
            if (bIT_STRING.getPadCount() != 0) {
                throw new InvalidBERException("signature does not fall into an integral number of bytes");
            }
            byte[] byArray = bIT_STRING.getBits();
            return new CertificationRequest(certificationRequestInfo, (AlgorithmIdentifier)sEQUENCE.elementAt(1), byArray);
        }
    }
}

