/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class OBJECT_IDENTIFIER
implements ASN1Value {
    public static final OBJECT_IDENTIFIER RSADSI = new OBJECT_IDENTIFIER(new long[]{1L, 2L, 840L, 113549L});
    public static final OBJECT_IDENTIFIER PKCS = RSADSI.subBranch(1L);
    public static final OBJECT_IDENTIFIER PKCS1 = PKCS.subBranch(1L);
    public static final OBJECT_IDENTIFIER PKCS2 = PKCS.subBranch(2L);
    public static final OBJECT_IDENTIFIER RSA_DIGEST = RSADSI.subBranch(2L);
    public static final OBJECT_IDENTIFIER PKCS5 = PKCS.subBranch(5L);
    public static final OBJECT_IDENTIFIER PKCS9 = PKCS.subBranch(9L);
    public static final OBJECT_IDENTIFIER PKCS12 = PKCS.subBranch(12L);
    public static final OBJECT_IDENTIFIER RSA_CIPHER = RSADSI.subBranch(3L);
    public static final OBJECT_IDENTIFIER ALGORITHM = new OBJECT_IDENTIFIER(new long[]{1L, 3L, 14L, 3L, 2L});
    public static final OBJECT_IDENTIFIER HASH_ALGORITHM = new OBJECT_IDENTIFIER(new long[]{2L, 16L, 840L, 1L, 101L, 3L, 4L});
    public static final OBJECT_IDENTIFIER PKIX = new OBJECT_IDENTIFIER(new long[]{1L, 3L, 6L, 1L, 5L, 5L, 7L});
    public static final OBJECT_IDENTIFIER id_cmc = PKIX.subBranch(7L);
    public static final OBJECT_IDENTIFIER id_cmc_cMCStatusInfo = id_cmc.subBranch(1L);
    public static final OBJECT_IDENTIFIER id_cmc_identification = id_cmc.subBranch(2L);
    public static final OBJECT_IDENTIFIER id_cmc_identityProof = id_cmc.subBranch(3L);
    public static final OBJECT_IDENTIFIER id_cmc_dataReturn = id_cmc.subBranch(4L);
    public static final OBJECT_IDENTIFIER id_cmc_transactionId = id_cmc.subBranch(5L);
    public static final OBJECT_IDENTIFIER id_cmc_senderNonce = id_cmc.subBranch(6L);
    public static final OBJECT_IDENTIFIER id_cmc_recipientNonce = id_cmc.subBranch(7L);
    public static final OBJECT_IDENTIFIER id_cmc_addExtensions = id_cmc.subBranch(8L);
    public static final OBJECT_IDENTIFIER id_cmc_encryptedPOP = id_cmc.subBranch(9L);
    public static final OBJECT_IDENTIFIER id_cmc_decryptedPOP = id_cmc.subBranch(10L);
    public static final OBJECT_IDENTIFIER id_cmc_lraPOPWitness = id_cmc.subBranch(11L);
    public static final OBJECT_IDENTIFIER id_cmc_getCert = id_cmc.subBranch(15L);
    public static final OBJECT_IDENTIFIER id_cmc_getCRL = id_cmc.subBranch(16L);
    public static final OBJECT_IDENTIFIER id_cmc_revokeRequest = id_cmc.subBranch(17L);
    public static final OBJECT_IDENTIFIER id_cmc_regInfo = id_cmc.subBranch(18L);
    public static final OBJECT_IDENTIFIER id_cmc_responseInfo = id_cmc.subBranch(19L);
    public static final OBJECT_IDENTIFIER id_cmc_QueryPending = id_cmc.subBranch(21L);
    public static final OBJECT_IDENTIFIER id_cmc_idPOPLinkRandom = id_cmc.subBranch(22L);
    public static final OBJECT_IDENTIFIER id_cmc_idPOPLinkWitness = id_cmc.subBranch(23L);
    public static final OBJECT_IDENTIFIER id_cmc_idConfirmCertAcceptance = id_cmc.subBranch(24L);
    public static final OBJECT_IDENTIFIER id_cct = PKIX.subBranch(12L);
    public static final OBJECT_IDENTIFIER id_cct_PKIData = id_cct.subBranch(2L);
    public static final OBJECT_IDENTIFIER id_cct_PKIResponse = id_cct.subBranch(3L);
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 6L);
    public static final Form FORM = Form.PRIMITIVE;
    private long[] numbers;
    private byte[] encodedContents = null;
    byte[] cachedEncoding = null;
    Tag tagForCache = null;
    private static final Template templateInstance = new Template();

    public Tag getTag() {
        return TAG;
    }

    public OBJECT_IDENTIFIER(long[] lArray) {
        OBJECT_IDENTIFIER.checkLongArray(lArray);
        this.numbers = lArray;
    }

    private static void checkLongArray(long[] lArray) {
        Assert._assert(lArray != null);
        if (lArray == null) {
            throw new NullPointerException();
        }
        Assert._assert(lArray.length >= 2);
        Assert._assert(lArray[0] == 0L || lArray[0] == 1L || lArray[0] == 2L);
    }

    public OBJECT_IDENTIFIER(String string) throws NumberFormatException {
        if (string == null || string.length() == 0) {
            throw new NumberFormatException("OID string is zero-length");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        this.numbers = new long[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            this.numbers[n++] = Long.parseLong(stringTokenizer.nextToken());
        }
        Assert._assert(n == this.numbers.length);
        OBJECT_IDENTIFIER.checkLongArray(this.numbers);
    }

    public long[] getNumbers() {
        return this.numbers;
    }

    public int hashCode() {
        int n = 1;
        int n2 = 0;
        while (n2 < this.numbers.length) {
            n = (int)((long)n + this.numbers[n2]) * 10;
            ++n2;
        }
        return n;
    }

    public OBJECT_IDENTIFIER subBranch(long l) {
        long[] lArray = new long[this.numbers.length + 1];
        System.arraycopy(this.numbers, 0, lArray, 0, this.numbers.length);
        lArray[this.numbers.length] = l;
        return new OBJECT_IDENTIFIER(lArray);
    }

    public OBJECT_IDENTIFIER subBranch(long[] lArray) {
        long[] lArray2 = new long[this.numbers.length + lArray.length];
        System.arraycopy(this.numbers, 0, lArray2, 0, this.numbers.length);
        System.arraycopy(lArray, 0, lArray2, this.numbers.length, lArray.length);
        return new OBJECT_IDENTIFIER(lArray2);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof OBJECT_IDENTIFIER)) {
            return false;
        }
        long[] lArray = ((OBJECT_IDENTIFIER)object).numbers;
        if (lArray.length != this.numbers.length) {
            return false;
        }
        int n = 0;
        while (n < lArray.length) {
            if (lArray[n] != this.numbers[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        String string = "{" + String.valueOf(this.numbers[0]);
        int n = 1;
        while (n < this.numbers.length) {
            string = string + " " + this.numbers[n];
            ++n;
        }
        string = string + "}";
        return string;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    private byte[] getEncodedContents() {
        if (this.encodedContents == null) {
            this.encodedContents = this.computeEncodedContents();
        }
        return this.encodedContents;
    }

    private byte[] getEncoding(Tag tag) {
        if (!tag.equals(this.tagForCache)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1Header aSN1Header = this.getHeader(tag);
            try {
                aSN1Header.encode(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                Assert.notReached("exception while encoding ASN.1 header");
            }
            byteArrayOutputStream.write(this.getEncodedContents(), 0, this.getEncodedContents().length);
            this.tagForCache = tag;
            this.cachedEncoding = byteArrayOutputStream.toByteArray();
        }
        return this.cachedEncoding;
    }

    private ASN1Header getHeader(Tag tag) {
        return new ASN1Header(tag, FORM, this.getEncodedContents().length);
    }

    private byte[] computeEncodedContents() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Assert._assert(this.numbers.length >= 2);
        long l = this.numbers[0];
        Assert._assert(l == 0L || l == 1L || l == 2L);
        long l2 = this.numbers[0] * 40L + this.numbers[1];
        Assert._assert((long)((byte)l2) == l2);
        byteArrayOutputStream.write((byte)l2);
        int n = 2;
        while (n < this.numbers.length) {
            l = this.numbers[n];
            Assert._assert(l >= 0L);
            byte[] byArray = new byte[10];
            int n2 = 0;
            do {
                byArray[n2++] = (byte)(l % 128L);
            } while ((l /= 128L) > 0L);
            --n2;
            while (n2 > 0) {
                byteArrayOutputStream.write(byArray[n2--] | 0x80);
            }
            Assert._assert(n2 == 0);
            byteArrayOutputStream.write(byArray[0]);
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoding(tag));
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }

        public Form getForm() {
            return FORM;
        }

        public boolean formMatch(Form form) {
            return form == FORM;
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                ASN1Header aSN1Header = new ASN1Header(inputStream);
                long l = aSN1Header.getContentLength();
                if (!aSN1Header.getTag().equals(tag)) {
                    throw new InvalidBERException("Incorrect tag for OBJECT IDENTIFIER: " + aSN1Header.getTag());
                }
                if (aSN1Header.getForm() != this.getForm()) {
                    throw new InvalidBERException("Incorrect form for OBJECT IDENTIFIER");
                }
                if (l < 1L) {
                    throw new InvalidBERException("Invalid 0 length for OBJECT IDENTIFIER");
                }
                Vector<Long> vector = new Vector<Long>();
                byte by = Template.readByte(inputStream);
                --l;
                long l2 = by % 40;
                vector.addElement(new Long(by % 40));
                vector.insertElementAt(new Long(by / 40), 0);
                while (l > 0L) {
                    l2 = 0L;
                    int n = 0;
                    do {
                        if ((n += 7) > 63) {
                            throw new InvalidBERException("OBJECT IDENTIFIER element too long; max is 63 bits");
                        }
                        by = Template.readByte(inputStream);
                        --l;
                        l2 <<= 7;
                        l2 |= (long)(by & 0x7F);
                    } while ((by & 0x80) != 0);
                    vector.addElement(new Long(l2));
                }
                long[] lArray = new long[vector.size()];
                int n = 0;
                while (n < lArray.length) {
                    lArray[n] = (Long)vector.elementAt(n);
                    ++n;
                }
                return new OBJECT_IDENTIFIER(lArray);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "OBJECT IDENTIFIER");
            }
        }

        private static byte readByte(InputStream inputStream) throws InvalidBERException, IOException {
            int n = inputStream.read();
            if (n == -1) {
                throw new InvalidBERException("End-of-file reached while decoding OBJECT IDENTIFIER");
            }
            Assert._assert((n & 0xFF) == n);
            return (byte)n;
        }
    }
}

