/*
 * Decompiled with CFR 0.152.
 */
package smr.JavaDeps;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import smr.JavaDeps.TargetNode;
import smr.util.DirectedGraph;

public class DepTable {
    private String packageName;
    private TargetNode sourceNode;
    private String className;
    private TargetNode classNode;
    private Hashtable imports;
    private Vector wildImports;
    private Hashtable symbols = new Hashtable();
    DirectedGraph g = new DirectedGraph();
    private String destDir;
    private String lineSeparator;

    public DepTable(String string) {
        this.destDir = string;
        this.lineSeparator = System.getProperty("line.separator");
    }

    private String canonizePackageSymbol(String string) {
        if (this.packageName == null || string.indexOf(46) >= 0) {
            return string;
        }
        return String.valueOf(this.packageName) + "." + string;
    }

    private String canonizeImportSymbol(String string) {
        if (string.indexOf(46) >= 0) {
            return string;
        }
        return (String)this.imports.get(string);
    }

    private String canonizeClassFile(String string, String string2) {
        if (this.destDir == null) {
            int n = string2.lastIndexOf(46);
            String string3 = String.valueOf(string2.substring(n + 1)) + ".class";
            String string4 = new File(string).getParent();
            if (string4 == null) {
                return string3;
            }
            return String.valueOf(string4) + File.separator + string3;
        }
        return String.valueOf(this.destDir) + File.separator + string2.replace('.', File.separatorChar) + ".class";
    }

    private TargetNode lookupSymbol(String string) {
        return (TargetNode)this.symbols.get(string);
    }

    private TargetNode lookupSymbol(String string, int n) {
        TargetNode targetNode = this.lookupSymbol(string);
        if (targetNode != null && targetNode.type == n) {
            return targetNode;
        }
        return null;
    }

    private TargetNode newTarget(String string) {
        TargetNode targetNode = new TargetNode(string);
        this.g.addNode(targetNode);
        return targetNode;
    }

    private TargetNode findSymbol(String string, int n) {
        TargetNode targetNode = this.lookupSymbol(string);
        if (targetNode == null) {
            targetNode = this.newTarget(null);
            targetNode.type = n;
            this.symbols.put(string, targetNode);
        }
        return targetNode;
    }

    public void startFile(String string) {
        this.sourceNode = this.newTarget(string);
        this.sourceNode.type = 2;
        this.packageName = null;
        this.imports = new Hashtable();
        this.wildImports = new Vector();
    }

    public void startPackage(String string) {
        this.packageName = string;
    }

    public void addImport(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (string3.equals("*")) {
            this.wildImports.addElement(string2);
            return;
        }
        this.imports.put(string3, string);
    }

    public void startDefinition(String string) {
        this.className = this.canonizePackageSymbol(string);
        this.classNode = this.findSymbol(this.className, 3);
        this.classNode.targetName = this.canonizeClassFile(this.sourceNode.targetName, this.className);
        this.classNode.type = 3;
        this.classNode.linkTo(this.sourceNode);
    }

    public void addTypeReference(String string) {
        String string2 = this.canonizePackageSymbol(string);
        String string3 = this.canonizeImportSymbol(string);
        TargetNode targetNode = this.lookupSymbol(string2, 3);
        if (targetNode != null) {
            this.classNode.linkTo(targetNode);
            return;
        }
        if (string3 != null) {
            this.classNode.linkTo(this.findSymbol(string3, 1));
            return;
        }
        this.classNode.linkTo(this.findSymbol(string2, 1));
        Enumeration enumeration = this.wildImports.elements();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            this.classNode.linkTo(this.findSymbol(String.valueOf(string4) + "." + string, 1));
        }
    }

    public void addTypeReference(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addTypeReference((String)enumeration.nextElement());
        }
    }

    public void addMemberReference(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            this.addTypeReference(string.substring(0, n));
        }
    }

    public void hasNative() {
        TargetNode targetNode = this.newTarget(String.valueOf(this.className.replace('.', '_')) + ".h");
        targetNode.type = 4;
        targetNode.linkTo(this.classNode);
        targetNode = this.newTarget(String.valueOf(this.className.replace('.', '_')) + ".c");
        targetNode.type = 5;
        targetNode.linkTo(this.classNode);
    }
}

