/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.cli.group;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.CommandLineOption;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.UserException;
import com.sun.admin.usermgr.common.UserMgrCliArgParsingException;
import com.sun.admin.usermgr.common.UserMgrCliHelpException;
import com.sun.admin.usermgr.common.cli.UMgrCliTool;
import com.sun.management.viper.util.CommandOption;
import com.sun.management.viper.util.CommandParser;
import com.sun.management.viper.util.ResourceManager;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class UserMgrGroupCli
extends UMgrCliTool {
    private Vector vObjs;
    private boolean bListAll = false;
    private Vector vXArgs;
    private String strOldGroupName = null;
    private CommandLineOption coGroupName;
    private CommandLineOption coGroupID;
    private CommandLineOption coHelp;
    private CommandLineOption coTaskFile;
    private CommandLineOption coMembersToAdd;
    private CommandLineOption coOldID;
    private CommandLineOption coNewName;
    private ResourceBundle bundle = null;

    public UserMgrGroupCli() {
        try {
            this.bundle = ResourceManager.getBundle((String)"com.sun.admin.usermgr.cli.group.resources.Resources", ((Object)((Object)this)).getClass());
            this.setResourceBundle(this.bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.bundle = null;
        }
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com.sun.admin.usermgr.cli.group.resources.Resources", Locale.getDefault(), ((Object)((Object)this)).getClass().getClassLoader());
            this.setResourceBundle(this.bundle);
        }
        if (this.bundle == null) {
            this.giveNoBundleMessage();
            System.exit(2);
        }
        this.vXArgs = new Vector();
        this.vObjs = new Vector();
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        String[] stringArray2 = new String[]{};
        try {
            this.trace("calling initCommandLineOptions");
            this.initCommandLineOptions();
            this.trace("calling doFirstArgPass");
            this.doFirstArgPass(stringArray);
            this.initCommandLineOptions();
            this.trace("calling parseAndValidateArgs");
            this.parseAndValidateArgs(stringArray);
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            return 0;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            String string = userMgrCliArgParsingException.getLocalizedMessage();
            this.handleErrors(string);
            return 1;
        }
        catch (Exception exception) {
            String string = exception.getLocalizedMessage();
            this.handleErrors(string);
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            return 2;
        }
        try {
            this.doOperation();
        }
        catch (UserException userException) {
            this.trace("runCommandLine, UserException:  " + userException.getLocalizedMessage());
            this.handleErrors(userException.getLocalizedMessage());
            n = 2;
        }
        catch (AdminException adminException) {
            this.trace("runCommandLine, AdminException:  " + adminException.getLocalizedMessage());
            this.handleErrors(adminException.getLocalizedMessage());
            n = 2;
        }
        catch (Exception exception) {
            this.trace("runCommandLine, Exception:  " + exception.getLocalizedMessage());
            this.handleErrors(exception.getLocalizedMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            n = 2;
        }
        return n;
    }

    private void doFirstArgPass(String[] stringArray) throws Exception {
        block7: {
            GroupObj groupObj = new GroupObj();
            CommandParser commandParser = new CommandParser("UserMgrGroupCli", "main tool for users related cli's", true, null, null);
            try {
                commandParser.addOption((CommandOption)this.coTaskFile);
                commandParser.addOption((CommandOption)this.coHelp);
                if (commandParser.parseArgs(stringArray)) {
                    if (this.coTaskFile.wasSet()) {
                        String string = (String)this.coTaskFile.getValue();
                        this.setTaskOperation(string.charAt(0));
                    }
                    if (this.coHelp.wasSet()) {
                        // empty if block
                    }
                } else {
                    this.trace("Error parsing args");
                    throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
                }
                if (this.getOperation() == -1) {
                    this.trace("Error:  iOperation == -1");
                    throw new UserException("EXM_CLI_NO_TASK");
                }
            }
            catch (Throwable throwable) {
                this.trace("Throwable type-of-exception");
                if (!this.getDebugStatus()) break block7;
                throwable.printStackTrace();
            }
        }
    }

    private void parseAndValidateArgs(String[] stringArray) throws Exception {
        boolean bl = false;
        switch (this.getOperation()) {
            case 0: {
                this.checkForAddOptions(stringArray);
                break;
            }
            case 1: {
                this.checkForDeleteOptions(stringArray);
                break;
            }
            case 2: {
                this.checkForModifyOptions(stringArray);
                break;
            }
            case 3: {
                this.checkForViewOptions(stringArray);
                break;
            }
            default: {
                this.trace("should never be here:  xxxx");
                this.trace("couldn't recognize switch:  " + this.getOperation());
                break;
            }
        }
    }

    private void checkForDeleteOptions(String[] stringArray) throws Exception {
        GroupObj groupObj = new GroupObj();
        if (this.getDebugStatus()) {
            this.trace("parseGroupArgs-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smgroupdel_name");
        String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smgrpdel_desc");
        CommandParser commandParser = new CommandParser(string, string2, true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coGroupName);
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coGroupName.wasSet()) {
                    stringArray2 = (String[])this.coGroupName.getValue();
                    groupObj.setGroupName((String)stringArray2);
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception - while parsing args.");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
        this.vObjs.addElement(groupObj);
    }

    private void checkForViewOptions(String[] stringArray) throws Exception {
        GroupObj groupObj = new GroupObj();
        boolean bl = false;
        if (this.getDebugStatus()) {
            this.trace("parseGroupArgs-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        CommandLineOption commandLineOption = new CommandLineOption("group_name", "name(s) to add/del/list", "n", 1, true, true, null, true);
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smgroupls_name");
        String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smgrpls_desc");
        CommandParser commandParser = new CommandParser(string, string2, true, null, null);
        try {
            String[] stringArray2;
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)commandLineOption);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (commandLineOption.wasSet()) {
                    stringArray2 = (String[])commandLineOption.getValue();
                    groupObj.setGroupName((String)stringArray2);
                    bl = true;
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            stringArray2 = commandParser.getUnmatchedOptions();
            if (stringArray2.length >= 1) {
                int n = 0;
                while (n < stringArray2.length) {
                    this.trace("unrecognized option:  " + stringArray2[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray2[0]);
            }
            if (bl) {
                this.vObjs.addElement(groupObj);
            } else if (this.getOperation() == 3) {
                this.bListAll = true;
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception - while parsing args.");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
    }

    private void checkForAddOptions(String[] stringArray) throws Exception {
        GroupObj groupObj = new GroupObj();
        if (this.getDebugStatus()) {
            this.trace("parseGroupArgs-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smgroupadd_name");
        String string2 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smgrpadd_desc");
        CommandParser commandParser = new CommandParser(string, string2, true, null, null);
        try {
            Object object;
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coGroupName);
            commandParser.addOption((CommandOption)this.coGroupID);
            commandParser.addOption((CommandOption)this.coMembersToAdd);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coGroupName.wasSet()) {
                    object = (String)this.coGroupName.getValue();
                    if (CheckSyntax.isNameOK((String)object)) {
                        groupObj.setGroupName((String)object);
                    } else {
                        throw new UserException("EXM_CLI_INVALID_USERNAME");
                    }
                }
                if (this.coGroupID.wasSet()) {
                    object = (String)this.coGroupID.getValue();
                    this.verifyGroupID((String)object);
                    groupObj.setGroupID((String)object);
                } else {
                    object = this.getUserMgr().getNextAvailableGID();
                    groupObj.setGroupID((String)object);
                }
                if (this.coMembersToAdd.wasSet()) {
                    object = this.coMembersToAdd.getValues();
                    String[] stringArray2 = null;
                    if (object != null) {
                        stringArray2 = new String[object.size()];
                        int n = 0;
                        Enumeration enumeration = object.elements();
                        while (enumeration.hasMoreElements()) {
                            stringArray2[n++] = (String)enumeration.nextElement();
                        }
                    }
                    groupObj.setGroupUsers(stringArray2);
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            object = commandParser.getUnmatchedOptions();
            if (((String[])object).length >= 1) {
                int n = 0;
                while (n < ((String[])object).length) {
                    this.trace("unrecognized option:  " + object[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", object[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception - while parsing args.");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_USERNAME");
        }
        try {
            if (this.vXArgs.size() > 0) {
                groupObj = this.parseXOptions(this.vXArgs, groupObj);
            }
        }
        catch (Exception exception) {
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_GENERIC_XARG_ERR");
        }
        this.vObjs.addElement(groupObj);
    }

    private void checkForModifyOptions(String[] stringArray) throws Exception {
        GroupObj groupObj = new GroupObj();
        String string = null;
        String string2 = null;
        Object var5_5 = null;
        String[] stringArray2 = null;
        if (this.getDebugStatus()) {
            this.trace("parseGroupArgs-> args.length = " + stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.trace("args[" + n + "] = " + stringArray[n]);
                ++n;
            }
        }
        String string3 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smgroupmod_name");
        String string4 = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"smgrpmod_desc");
        CommandParser commandParser = new CommandParser(string3, string4, true, null, null);
        try {
            int n;
            String[] stringArray3;
            commandParser.addOption((CommandOption)this.coTaskFile);
            commandParser.addOption((CommandOption)this.coGroupName);
            commandParser.addOption((CommandOption)this.coNewName);
            commandParser.addOption((CommandOption)this.coMembersToAdd);
            commandParser.addOption((CommandOption)this.coHelp);
            if (commandParser.parseArgs(stringArray)) {
                if (this.coGroupName.wasSet()) {
                    string2 = (String)this.coGroupName.getValue();
                    this.setOldGroupName(string2);
                }
                if (this.coNewName.wasSet()) {
                    string = (String)this.coNewName.getValue();
                    this.trace("Old Name = " + string);
                }
                if (this.coMembersToAdd.wasSet() && (stringArray3 = this.coMembersToAdd.getValues()) != null) {
                    stringArray2 = new String[stringArray3.size()];
                    n = 0;
                    Enumeration enumeration = stringArray3.elements();
                    while (enumeration.hasMoreElements()) {
                        stringArray2[n++] = (String)enumeration.nextElement();
                    }
                }
                if (this.coHelp.wasSet()) {
                    this.trace("read in help");
                    commandParser.printUsage(null);
                    throw new UserMgrCliHelpException(null);
                }
            } else {
                this.trace("Error parsing args");
                throw new UserMgrCliArgParsingException("EXM_CLI_MISSING_ARG");
            }
            stringArray3 = commandParser.getUnmatchedOptions();
            if (stringArray3.length >= 1) {
                n = 0;
                while (n < stringArray3.length) {
                    this.trace("unrecognized option:  " + stringArray3[n]);
                    ++n;
                }
                commandParser.printUsage(null);
                throw new UserMgrCliArgParsingException("EXM_CLI_INVALID_ARG", stringArray3[0]);
            }
        }
        catch (UserMgrCliHelpException userMgrCliHelpException) {
            throw userMgrCliHelpException;
        }
        catch (UserMgrCliArgParsingException userMgrCliArgParsingException) {
            throw userMgrCliArgParsingException;
        }
        catch (Throwable throwable) {
            this.trace("Throwable type-of-exception - while parsing args.");
            if (this.getDebugStatus()) {
                throwable.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_CLI_GENERIC_ERROR");
        }
        groupObj = this.getObjectProps(string2);
        if (string != null) {
            if (CheckSyntax.isNameOK((String)string)) {
                groupObj.setGroupName(string);
            } else {
                throw new UserException("EXM_CLI_INVALID_USERNAME");
            }
        }
        groupObj.setGroupUsers(stringArray2);
        try {
            if (this.vXArgs.size() > 0) {
                groupObj = this.parseXOptions(this.vXArgs, groupObj);
            }
        }
        catch (Exception exception) {
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw new UserMgrCliArgParsingException("EXM_GENERIC_XARG_ERR");
        }
        this.vObjs.addElement(groupObj);
    }

    private GroupObj getObjectProps(String string) throws Exception {
        GroupObj groupObj = new GroupObj(string);
        try {
            if (this.getUserMgr() == null) {
                this.trace("in getObjectProps:  usermgr svc wrapper` is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            groupObj = this.getUserMgr().getGroupAttributes(groupObj);
        }
        catch (Exception exception) {
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
        return groupObj;
    }

    private GroupObj parseXOptions(Vector vector, GroupObj groupObj) throws Exception {
        boolean bl = false;
        int n = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string = string.trim();
            n = string.indexOf("=");
            string3 = string.substring(n + 1, string.length());
            string3 = string3.trim();
            string = string.substring(0, n);
            this.trace("Parsed out x property:  " + string);
            this.trace("Parsed out x property value:  " + string3);
            if (0 != string.compareTo(ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"xprop_members"))) continue;
            String[] stringArray = this.parseMembersOut(string3);
            groupObj.setGroupUsers(stringArray);
        }
        return groupObj;
    }

    private String[] parseMembersOut(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        String string2 = ",";
        String string3 = "";
        String string4 = string;
        while (string4 != null) {
            n = string4.indexOf(string2);
            string3 = string4.substring(0, n);
            string4 = string4.substring(n + 1);
            string3.trim();
            vector.addElement(string3);
        }
        String[] stringArray = (String[])AdminCommonTools.CMN_VectorToArray(vector);
        return stringArray;
    }

    public void deleteObject() throws Exception {
        this.trace("in UserMgrGroupCli->deleteObject()");
        try {
            Enumeration enumeration = this.vObjs.elements();
            while (enumeration.hasMoreElements()) {
                GroupObj groupObj = (GroupObj)enumeration.nextElement();
                if (groupObj.getGroupID() == null) {
                    groupObj = this.getUserMgr().getGroupAttributes(groupObj);
                } else if (groupObj.getGroupID().equals("")) {
                    groupObj = this.getUserMgr().getGroupAttributes(groupObj);
                }
                this.trace("groupname = " + groupObj.getGroupName());
                this.trace("groupID = " + groupObj.getGroupID());
                if (this.getUserMgr() == null) {
                    this.trace("Error.  Could not connect to backend.");
                    throw new UserException("EXM_CLI_NO_SERVICE");
                }
                this.trace("deleteObject: calling getUserMgr().deleteGroup()");
                this.getUserMgr().deleteGroup(groupObj);
            }
        }
        catch (Exception exception) {
            this.trace("exception in deleteObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public void modifyObject() throws Exception {
        try {
            String string = this.getOldGroupName();
            GroupObj groupObj = new GroupObj(string);
            groupObj = this.getUserMgr().getGroupAttributes(groupObj);
            GroupObj groupObj2 = null;
            groupObj2 = this.getNewModObject(groupObj, groupObj2);
            this.trace("old groupname = " + groupObj.getGroupName());
            this.trace("new groupname = " + groupObj2.getGroupName());
            this.trace("old groupID = " + groupObj.getGroupID());
            this.trace("new groupID = " + groupObj2.getGroupID());
            if (this.getUserMgr() == null) {
                this.trace("Error.  Could not connect to backend.");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            this.trace("in modifyObject:  calling getUserMgr().modifyGroup()");
            this.getUserMgr().modifyGroup(groupObj2, groupObj);
        }
        catch (Exception exception) {
            this.trace("exception in modifyObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    private GroupObj getNewModObject(GroupObj groupObj, GroupObj groupObj2) throws Exception {
        GroupObj groupObj3;
        String string;
        if (groupObj2 == null) {
            groupObj2 = (GroupObj)groupObj.clone();
        }
        if ((string = (groupObj3 = (GroupObj)this.vObjs.elementAt(0)).getGroupName()) != null && !string.equals("")) {
            groupObj2.setGroupName(groupObj3.getGroupName());
        }
        if (groupObj3.getGroupUsers() != null) {
            groupObj2.setGroupUsers(groupObj3.getGroupUsers());
        }
        return groupObj2;
    }

    public void addObject() throws Exception {
        try {
            GroupObj groupObj = (GroupObj)this.vObjs.elementAt(0);
            if (this.getUserMgr() == null) {
                this.trace("in addObject:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            this.trace("in addObject:  calling getUserMgr().addGroup()");
            this.getUserMgr().addGroup(groupObj);
        }
        catch (Exception exception) {
            this.trace("exception in addObject(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public void viewObjectProps() throws Exception {
        try {
            GroupObj groupObj = null;
            if (this.getUserMgr() == null) {
                this.trace("in viewObjectProps:  usermgr is null!");
                throw new UserException("EXM_CLI_NO_SERVICE");
            }
            if (this.bListAll) {
                this.trace("in viewObjectProps:  calling getAllGroups()");
                this.vObjs = this.getUserMgr().getAllGroups();
                if (this.vObjs == null || this.vObjs.isEmpty()) {
                    this.trace("There are no groups");
                    String string = ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"no_group_accounts");
                    System.out.println(string);
                    return;
                }
                Enumeration enumeration = this.vObjs.elements();
                while (enumeration.hasMoreElements()) {
                    groupObj = (GroupObj)enumeration.nextElement();
                    groupObj = this.getUserMgr().getGroupAttributes(groupObj);
                    this.viewUserOutput(groupObj);
                }
            } else if (this.vObjs != null) {
                this.trace("in viewObjectProps:  calling getEmailAliasAttributes()");
                groupObj = (GroupObj)this.vObjs.elementAt(0);
                groupObj = this.getUserMgr().getGroupAttributes(groupObj);
                this.viewUserOutput(groupObj);
            }
        }
        catch (Exception exception) {
            this.trace("exception in viewObjectProps(): " + exception.getMessage());
            if (this.getDebugStatus()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    public void viewUserOutput(GroupObj groupObj) {
        if (groupObj == null) {
            this.trace("Error displaying Group info.  Group object was null.");
            return;
        }
        String[] stringArray = groupObj.getGroupUsers();
        String string = "";
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (!string.equals("")) {
                    string = string + ", ";
                }
                string = string + stringArray[n];
                ++n;
            }
        }
        System.out.println(groupObj.getGroupName() + " : " + groupObj.getGroupID() + " : " + string);
    }

    public void setOldGroupName(String string) {
        this.strOldGroupName = string;
    }

    public String getOldGroupName() {
        return this.strOldGroupName;
    }

    public boolean isNameSpecialCase(String string) {
        return string.equals("root") || string.equals("other") || string.equals("bin") || string.equals("sys") || string.equals("adm");
    }

    private void initCommandLineOptions() {
        this.coTaskFile = new CommandLineOption("task", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_task_desc"), "K", 1, true, false, (Object)"V", true, true);
        this.coGroupName = new CommandLineOption("group_name", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_groupname_desc"), "n", 1, false, false, null, true);
        this.coNewName = new CommandLineOption("new_group_name", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_oldname_desc"), "N", 1, true, false, null, true);
        this.coGroupID = new CommandLineOption("gid", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_groupid_desc"), "g", 1, true, false, null, true);
        this.coMembersToAdd = new CommandLineOption("group_members", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_members_desc"), "m", 1, true, true, (Object)"", true);
        this.coHelp = new CommandLineOption("", ResourceStrings.getString((ResourceBundle)this.bundle, (String)"arg_help_desc"), "h", 0, true, false, (Object)"", false);
        this.coHelp.setPriority(true);
    }

    private boolean verifyGroupID(String string) throws UserMgrCliArgParsingException {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new UserMgrCliArgParsingException("EXM_GID_NON_INT");
        }
        if (n < 100) {
            throw new UserMgrCliArgParsingException("EXM_GID_NON_INT");
        }
        return true;
    }
}

