/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.io.IOException;
import sun.awt.im.iiimp.IIIMPInputStream;
import sun.awt.im.iiimp.IIIMPOutputStream;
import sun.awt.im.iiimp.Manager;

class ProtocolHeader {
    int packet_size;
    int opCode;
    int packetLength;

    ProtocolHeader() {
        this.packet_size = 0;
        this.opCode = 0;
        this.packetLength = 0;
    }

    ProtocolHeader(int n, int n2, int n3) {
        this.packet_size = n;
        this.opCode = n2;
        this.packetLength = n3;
    }

    void setPacketSize(int n) {
        this.packet_size = n;
    }

    int getPacketSize() {
        return this.packet_size;
    }

    void setOpCode(int n) {
        this.opCode = n;
    }

    int getOpCode() {
        return this.opCode;
    }

    void setPacketLength(int n) {
        this.packetLength = n;
    }

    int getPacketLength() {
        return this.packetLength;
    }

    public void read(IIIMPInputStream iIIMPInputStream) {
        try {
            int n;
            int n2 = iIIMPInputStream.read();
            int n3 = n2 >>> 7 & 0xFF;
            if (n3 == 0) {
                this.packet_size = 0;
            } else if (n3 == 1) {
                this.packet_size = 1;
            }
            this.opCode = n2 & 0x7F;
            int n4 = 0;
            if (this.packet_size == 0) {
                n4 = 4;
            } else if (this.packet_size == 1) {
                n4 = 8;
            }
            int[] nArray = new int[n4];
            nArray[0] = 0;
            nArray[1] = iIIMPInputStream.read();
            if (nArray[1] == -1) {
                this.packetLength = 0;
                return;
            }
            for (n = 2; n < n4; ++n) {
                nArray[n] = iIIMPInputStream.read();
            }
            for (n = 0; n < n4; ++n) {
                this.packetLength += nArray[n] << (n4 - n - 1) * 8;
            }
            this.packetLength <<= 2;
        }
        catch (IOException iOException) {
            this.debug("e = " + iOException);
        }
    }

    void write(IIIMPOutputStream iIIMPOutputStream) {
        try {
            int n = this.packetLength / 4 & 0xFFFFFF;
            iIIMPOutputStream.write(this.opCode & 0x7F);
            iIIMPOutputStream.write(n >>> 16 & 0xFF);
            iIIMPOutputStream.write(n >>> 8 & 0xFF);
            iIIMPOutputStream.write(n >>> 0 & 0xFF);
        }
        catch (IOException iOException) {
            this.debug("e = " + iOException);
        }
    }

    private void debug(String string) {
        if (Manager.DEBUG) {
            System.err.println(string);
        }
    }
}

