/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMActionEvent;
import com.sun.iiim.IIIMCommittedEvent;
import com.sun.iiim.IIIMEvent;
import com.sun.iiim.IIIMPreeditEvent;
import com.sun.iiim.LWE;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.awt.im.iiimp.IIIMKeyEvent;
import sun.awt.im.iiimp.InvalidSyntaxException;
import sun.awt.im.iiimp.LWESyntax;
import sun.awt.im.iiimp.Manager;

public class PCE
extends LWE {
    private Stack syntaxStack = new Stack();
    private Hashtable icTable = new Hashtable();
    private LWESyntax syntax;
    private static final String defaultTrigger = "key<Control+P>";
    private static IIIMEvent[] triggerOns;
    private static IIIMEvent[] triggerOffs;
    private static boolean initTrigger;

    public void dispatchEvent(IIIMEvent iIIMEvent) {
        IIIMEvent[] iIIMEventArray;
        block17: {
            SyntaxOnOff syntaxOnOff = null;
            InputContext inputContext = this.getInputContext();
            if (inputContext == null) {
                return;
            }
            if (this.icTable.size() == 0) {
                this.syntax = (LWESyntax)this.syntaxStack.peek();
                if (this.syntax == null) {
                    return;
                }
                syntaxOnOff = new SyntaxOnOff(this.syntax);
                this.icTable.put(inputContext, syntaxOnOff);
            } else if (this.icTable.containsKey(inputContext)) {
                syntaxOnOff = (SyntaxOnOff)this.icTable.get(inputContext);
            } else {
                this.syntax = this.syntax.getCopy();
                syntaxOnOff = new SyntaxOnOff(this.syntax);
                this.icTable.put(inputContext, syntaxOnOff);
            }
            if (!syntaxOnOff.willProcess(iIIMEvent)) {
                return;
            }
            if (iIIMEvent.isConsumed()) {
                return;
            }
            iIIMEventArray = null;
            try {
                iIIMEventArray = this.syntax.getEventList(iIIMEvent);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                if (!Manager.DEBUG) break block17;
                invalidSyntaxException.printStackTrace();
            }
        }
        iIIMEvent.consume();
        if (iIIMEventArray != null) {
            block7: for (int i = 0; i < iIIMEventArray.length; ++i) {
                this.markProcessedUpperListener(iIIMEventArray[i], this);
                int n = iIIMEventArray[i].getID();
                switch (n) {
                    case 1: {
                        this.debug(" action = " + ((IIIMActionEvent)iIIMEventArray[i]).getAction());
                        this.dispatchActionEvent((IIIMActionEvent)iIIMEventArray[i]);
                        continue block7;
                    }
                    case 3: {
                        this.dispatchCommittedEvent((IIIMCommittedEvent)iIIMEventArray[i]);
                        continue block7;
                    }
                    case 2: {
                        this.dispatchPreeditEvent((IIIMPreeditEvent)iIIMEventArray[i]);
                        continue block7;
                    }
                    default: {
                        this.debug(" LWESyntax procudes unknown event...");
                    }
                }
            }
        }
    }

    public String getName() {
        return "PCE";
    }

    public IIIMEvent[] getTriggerEvent() {
        return triggerOns;
    }

    public IIIMEvent[] getTriggerOffEvent() {
        return triggerOffs;
    }

    public String[] getEngineSctipt() {
        return new String[]{"Japanese", "Chinese"};
    }

    public PCE() {
        if (!initTrigger) {
            PCE.setupTriggerEvents();
        }
    }

    public void pushSyntax(LWESyntax lWESyntax) {
        this.syntaxStack.push(lWESyntax);
        this.icTable.clear();
    }

    public LWESyntax popSyntax() {
        LWESyntax lWESyntax = (LWESyntax)this.syntaxStack.pop();
        return lWESyntax;
    }

    private static void setupTriggerEvents() {
        initTrigger = true;
        String string = Manager.getProperty("iiimf.pce.trigger", defaultTrigger);
        String string2 = Manager.getProperty("iiimf.pce.trigger.on", defaultTrigger);
        String string3 = Manager.getProperty("iiimf.pce.trigger.off", defaultTrigger);
        String string4 = string.equals(string2) ? string : string + "," + string2;
        triggerOns = PCE.makeIIIMEvents(string4);
        if (string2.equals(string3)) {
            triggerOffs = triggerOns;
        } else {
            String string5 = string.equals(string3) ? string : string + "," + string3;
            triggerOffs = PCE.makeIIIMEvents(string5);
        }
    }

    private static IIIMEvent[] makeIIIMEvents(String string) {
        int n;
        IIIMEvent[] iIIMEventArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",:");
        Vector<IIIMEvent> vector = new Vector<IIIMEvent>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            iIIMEventArray = stringTokenizer.nextToken();
            n = iIIMEventArray.lastIndexOf(62);
            if (n < 4) continue;
            if (iIIMEventArray.startsWith("key<")) {
                string2 = iIIMEventArray.substring(4, n);
                vector.add(new IIIMKeyEvent(string2));
                continue;
            }
            if (!iIIMEventArray.startsWith("action<") || n <= 7) continue;
            string2 = iIIMEventArray.substring(7, n);
            vector.add(new IIIMActionEvent(string2));
        }
        iIIMEventArray = new IIIMEvent[vector.size()];
        for (n = 0; n < iIIMEventArray.length; ++n) {
            iIIMEventArray[n] = (IIIMEvent)vector.elementAt(n);
        }
        return iIIMEventArray;
    }

    public Locale[] getSupportLocales() {
        return null;
    }

    private void debug(String string) {
        if (Manager.DEBUG) {
            System.err.println(string);
        }
    }

    static {
        initTrigger = false;
    }

    class SyntaxOnOff {
        private LWESyntax syntax;
        private boolean on = false;
        private boolean controlDown = false;

        SyntaxOnOff(LWESyntax lWESyntax) {
            this.syntax = lWESyntax;
            this.on = false;
        }

        LWESyntax getSyntax() {
            return this.syntax;
        }

        boolean willProcess(IIIMEvent iIIMEvent) {
            if (this.on) {
                return this.checkTrigger(iIIMEvent, triggerOffs);
            }
            return this.checkTrigger(iIIMEvent, triggerOns);
        }

        boolean checkTrigger(IIIMEvent iIIMEvent, IIIMEvent[] iIIMEventArray) {
            AWTEvent aWTEvent = iIIMEvent.getAWTEvent();
            if (aWTEvent != null && aWTEvent instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                int n = keyEvent.getID();
                for (int i = 0; i < iIIMEventArray.length; ++i) {
                    if (!(iIIMEventArray[i] instanceof IIIMKeyEvent) || !((IIIMKeyEvent)iIIMEventArray[i]).match(keyEvent)) continue;
                    iIIMEvent.consume();
                    if (n != 402) break;
                    this.on = !this.on;
                    break;
                }
            }
            return this.on;
        }
    }
}

