/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMActionEvent;
import com.sun.iiim.IIIMLookupEvent;
import com.sun.iiim.IIIMLookupListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import sun.awt.im.iiimp.EventWindow;
import sun.awt.im.iiimp.IIIMWindow;
import sun.awt.im.iiimp.LookupPane;
import sun.awt.im.iiimp.Manager;

class LookupWindow
extends IIIMWindow
implements IIIMLookupListener {
    private static final int LocateX;
    private static final int LocateY;
    private LookupPane pane;
    private String style = Manager.getProperty("iiimf.preedit.style");
    private int offset = 24;
    int columHeight;
    int columWidth;
    FontMetrics fm;

    public LookupWindow() {
        if (this.style == null) {
            this.style = "ROOTWINDOW";
        }
        this.init();
    }

    void init() {
        this.window = new EventWindow(this);
        Font font = new Font("Monospaced", 0, 12);
        this.fm = this.window.getFontMetrics(font);
        int n = this.fm.getHeight();
        int n2 = this.fm.getMaxAdvance();
        int n3 = this.fm.getAscent();
        this.columWidth = n2;
        this.columHeight = n + 2;
        this.window.setFont(font);
        this.pane = new LookupPane();
        this.pane.setFont(font);
        this.window.add(this.pane);
        this.window.pack();
    }

    protected void dispatchActionEvent(IIIMActionEvent iIIMActionEvent) {
        super.dispatchActionEvent(iIIMActionEvent);
    }

    public void lookupStart(IIIMLookupEvent iIIMLookupEvent) {
        if (this.pane == null) {
            this.init();
        }
        this.pane.setTarget(this.getClientComponent());
        this.pane.setLookupWindow(this);
        this.pane.handleEvent(iIIMLookupEvent);
    }

    public void lookupDone(IIIMLookupEvent iIIMLookupEvent) {
        this.pane.handleEvent(iIIMLookupEvent);
        this.window.setVisible(false);
    }

    public void lookupDraw(IIIMLookupEvent iIIMLookupEvent) {
        this.pane.handleEvent(iIIMLookupEvent);
        this.setTitle(iIIMLookupEvent.getTitle());
        this.window.setSize(this.window.getPreferredSize());
        this.calculatePosition();
        this.window.setVisible(true);
    }

    public void lookupProcess(IIIMLookupEvent iIIMLookupEvent) {
        this.pane.handleEvent(iIIMLookupEvent);
    }

    public void setStyle(String string) {
        this.style = string;
    }

    public String getStyle() {
        return this.style;
    }

    void setLocation(int n, int n2) {
        this.window.setLocation(n, n2);
    }

    void calculatePosition() {
        Cloneable cloneable;
        Cloneable cloneable2;
        Component component;
        Component component2 = component = this.getClientComponent();
        Insets insets = this.window.getInsets();
        while (!(component2 instanceof Frame) && !(component2 instanceof Dialog)) {
            component2 = component2.getParent();
        }
        if (this.style.equals("BELOWSPOT") && component instanceof InputMethodRequests) {
            cloneable2 = ((InputMethodRequests)((Object)component)).getTextLocation(TextHitInfo.leading(0));
            cloneable = new Point();
            ((Point)cloneable).x = ((Rectangle)cloneable2).x;
            ((Point)cloneable).y = ((Rectangle)cloneable2).y + (int)((Rectangle)cloneable2).getHeight() + this.offset;
            ((Point)cloneable).y += insets.top + insets.bottom + this.fm.getHeight();
            this.window.setLocation((Point)cloneable);
        } else {
            cloneable2 = component2.getLocation();
            cloneable = component2.getSize();
            double d = ((Point)cloneable2).getX();
            double d2 = ((Point)cloneable2).getY() + cloneable.getHeight() + (double)insets.top + (double)insets.bottom + (double)this.fm.getHeight();
            this.window.setLocation((int)d, (int)d2);
        }
        cloneable2 = this.window.getLocation();
        double d = ((Point)cloneable2).getX();
        double d3 = ((Point)cloneable2).getY();
        Dimension dimension = this.window.getSize();
        if (d + dimension.getWidth() > (double)screenWidth) {
            d = (double)screenWidth - dimension.getWidth();
        }
        if (d3 + dimension.getHeight() > (double)screenHeight) {
            d3 = (double)screenHeight - dimension.getHeight();
        }
        this.window.setLocation((int)d, (int)d3);
    }

    synchronized void show() {
        if (this.window == null) {
            this.init();
        }
        this.window.setVisible(true);
    }

    private void setTitle(String string) {
        ((Dialog)this.window).setTitle(string);
    }

    static {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        LocateX = dimension.width * 8 / 9;
        LocateY = dimension.height * 8 / 9;
    }
}

