/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMActionEvent;
import com.sun.iiim.IIIMLookupEvent;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import sun.awt.im.iiimp.FocusLabel;
import sun.awt.im.iiimp.LookupWindow;
import sun.awt.im.iiimp.Manager;

class LookupPane
extends Panel {
    private int master;
    private int choicePerWindow;
    private Dimension rowColumn;
    private int direction;
    private int labelOwner;
    private int firstCandidate;
    private int lastCandidate;
    private int currentCandidate;
    private String[] candidates;
    private String[] labelList;
    private int processType;
    private int indexPage;
    private String title;
    private FocusLabel[] awtLabels = new FocusLabel[this.cacheSize];
    private int cacheSize = 32;
    private static final int CANDIDATE_GAP = 5;
    private int oldCandidate;
    private String[] oldCandidates;
    private AttributedCharacterIterator[] candidateIterator;
    private AttributedCharacterIterator[] labelIterator;
    private AttributedCharacterIterator[] oldCandidateIterator;
    private Component target;
    private LookupWindow window;

    public LookupPane() {
        for (int i = 0; i < this.awtLabels.length; ++i) {
            this.awtLabels[i] = new FocusLabel();
        }
        this.enableInputMethods(false);
    }

    private void checkCache(int n) {
        if (n > this.cacheSize) {
            FocusLabel[] focusLabelArray = new FocusLabel[n];
            System.arraycopy(this.awtLabels, 0, focusLabelArray, 0, this.cacheSize);
            for (int i = this.cacheSize; i < n; ++i) {
                focusLabelArray[i] = new FocusLabel();
            }
            this.awtLabels = focusLabelArray;
            this.cacheSize = n;
        }
    }

    private boolean same(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null || stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean same(CharacterIterator[] characterIteratorArray, CharacterIterator[] characterIteratorArray2) {
        if (characterIteratorArray == null || characterIteratorArray2 == null || characterIteratorArray.length != characterIteratorArray2.length) {
            return false;
        }
        for (int i = 0; i < characterIteratorArray.length; ++i) {
            char c = characterIteratorArray[i].first();
            char c2 = characterIteratorArray2[i].first();
            while (c != '\uffff') {
                if (c != c2) {
                    return false;
                }
                c = characterIteratorArray[i].next();
                c2 = characterIteratorArray2[i].next();
            }
        }
        return true;
    }

    void handleEvent(IIIMLookupEvent iIIMLookupEvent) {
        switch (iIIMLookupEvent.getType()) {
            case 0: {
                this.start(iIIMLookupEvent);
                break;
            }
            case 2: {
                if (Manager.COLOR_SUPPORT) {
                    this.draw2(iIIMLookupEvent);
                    break;
                }
                this.draw(iIIMLookupEvent);
                break;
            }
            case 3: {
                this.process(iIIMLookupEvent);
                break;
            }
        }
    }

    private void start(IIIMLookupEvent iIIMLookupEvent) {
        this.master = 1;
        this.choicePerWindow = iIIMLookupEvent.getChoicePerWindow();
        this.rowColumn = iIIMLookupEvent.getRowColum();
        this.direction = iIIMLookupEvent.getDirection();
        this.labelOwner = iIIMLookupEvent.getLabelOwner();
        this.oldCandidates = null;
        this.oldCandidate = -1;
        GridLayout gridLayout = new GridLayout(this.rowColumn.width, this.rowColumn.height);
        gridLayout.setHgap(5);
        this.setLayout(gridLayout);
    }

    private void draw(IIIMLookupEvent iIIMLookupEvent) {
        block5: {
            block3: {
                block4: {
                    this.currentCandidate = iIIMLookupEvent.getCurrentCandidate();
                    this.candidates = iIIMLookupEvent.getCandidates();
                    this.labelList = iIIMLookupEvent.getLabelList();
                    if (this.candidates.length != this.labelList.length) {
                        throw new IllegalArgumentException(" Lookup Error.");
                    }
                    if (this.master != 1) break block3;
                    if (this.same(this.candidates, this.oldCandidates)) break block4;
                    this.removeAll();
                    this.checkCache(this.candidates.length);
                    for (int i = 0; i < this.candidates.length; ++i) {
                        FocusLabel focusLabel = this.awtLabels[i];
                        focusLabel.setText(this.labelList[i] + " : " + this.candidates[i]);
                        this.add(focusLabel);
                        focusLabel.setTarget(this, i);
                        if (i != this.currentCandidate) continue;
                        focusLabel.setFocus(true);
                    }
                    this.repaint();
                    this.awtLabels[this.currentCandidate].requestFocus();
                    break block5;
                }
                if (this.currentCandidate == this.oldCandidate) break block5;
                this.awtLabels[this.currentCandidate].setFocus(true);
                this.awtLabels[this.currentCandidate].repaint();
                if (this.oldCandidate < 0) break block5;
                this.awtLabels[this.oldCandidate].setFocus(false);
                this.awtLabels[this.oldCandidate].repaint();
                break block5;
            }
            this.firstCandidate = iIIMLookupEvent.getFirstCandidate();
            this.lastCandidate = iIIMLookupEvent.getLastCandidate();
            this.checkCache(this.lastCandidate - this.firstCandidate);
            for (int i = this.firstCandidate; i < this.lastCandidate; ++i) {
                this.awtLabels[i - this.firstCandidate].setText(this.labelList[i] + " : " + this.candidates[i]);
                this.add(this.awtLabels[i - this.firstCandidate]);
                this.awtLabels[i - this.firstCandidate].setTarget(this, i);
            }
        }
        this.oldCandidate = this.currentCandidate;
        this.oldCandidates = this.candidates;
    }

    private void draw2(IIIMLookupEvent iIIMLookupEvent) {
        this.candidateIterator = iIIMLookupEvent.getCandidateIterator();
        this.labelIterator = iIIMLookupEvent.getLabelIterator();
        if (this.candidateIterator.length != this.labelIterator.length || this.master != 1) {
            throw new IllegalArgumentException(" Lookup Error.");
        }
        if (!this.same(this.candidateIterator, this.oldCandidateIterator)) {
            this.checkCache(this.candidateIterator.length);
            for (int i = 0; i < this.candidateIterator.length; ++i) {
                FocusLabel focusLabel = this.awtLabels[i];
                focusLabel.setIterator(this.labelIterator[i], this.candidateIterator[i]);
                this.add(focusLabel);
                focusLabel.setTarget(this, i);
                if (i == this.currentCandidate) {
                    focusLabel.setFocus(true);
                }
                this.repaint();
                this.awtLabels[this.currentCandidate].requestFocus();
            }
        } else {
            this.awtLabels[this.currentCandidate].setFocus(true);
            this.awtLabels[this.currentCandidate].repaint();
            if (this.oldCandidate >= 0) {
                this.awtLabels[this.oldCandidate].setFocus(false);
                this.awtLabels[this.oldCandidate].repaint();
            }
        }
        this.oldCandidate = this.currentCandidate;
        this.oldCandidateIterator = this.candidateIterator;
    }

    private void process(IIIMLookupEvent iIIMLookupEvent) {
        this.processType = iIIMLookupEvent.getProcessType();
        this.indexPage = iIIMLookupEvent.getProcessIndexPage();
        this.repaint();
    }

    void forwardEvent(AWTEvent aWTEvent) {
        this.target.dispatchEvent(aWTEvent);
    }

    void changeFocus(int n) {
        if (this.currentCandidate != n) {
            this.awtLabels[this.currentCandidate].setFocus(false);
            this.awtLabels[this.currentCandidate].repaint();
            this.currentCandidate = n;
        }
    }

    void clicked(int n) {
        IIIMActionEvent iIIMActionEvent = new IIIMActionEvent(2, (Object)this.awtLabels[n].getText());
        this.window.dispatchActionEvent(iIIMActionEvent);
    }

    void setTarget(Component component) {
        this.target = component;
    }

    void setLookupWindow(LookupWindow lookupWindow) {
        this.window = lookupWindow;
    }
}

