/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import com.sun.iiim.IIIMCommittedEvent;
import com.sun.iiim.IIIMEvent;
import com.sun.iiim.IIIMListener;
import com.sun.iiim.IIIMLookupListener;
import com.sun.iiim.IIIMPreeditEvent;
import com.sun.iiim.IIIMPreeditListener;
import com.sun.iiim.IIIMStatusListener;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.font.TextHitInfo;
import java.awt.im.spi.InputMethodContext;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Locale;
import sun.awt.im.InputMethodAdapter;
import sun.awt.im.iiimp.IIIMCommittedListener;
import sun.awt.im.iiimp.LookupWindow;
import sun.awt.im.iiimp.Manager;
import sun.awt.im.iiimp.StatusWindow;

public class IIIMFAdapter
extends InputMethodAdapter
implements IIIMListener,
IIIMPreeditListener,
IIIMCommittedListener {
    private static Manager manager;
    private Component currentClient;
    private InputMethodContext inputMethodContext;
    private Locale locale;
    private IIIMPreeditListener preeditListener;
    private static IIIMStatusListener statusListener;
    private IIIMLookupListener lookupListener;

    public IIIMFAdapter() {
        manager = Manager.getInstance();
        this.locale = Locale.getDefault();
    }

    public void activate() {
        this.currentClient = super.getClientComponent();
        manager.setIIIMFAdapter(this);
        manager.setIIIMCommittedListener(this);
        if (this.preeditListener == null) {
            this.setPreeditListener(this);
        }
        if (statusListener == null) {
            this.setStatusListener(new StatusWindow());
        }
        if (this.lookupListener == null) {
            this.setLookupListener(new LookupWindow());
        }
        manager.setIIIMPreeditListener(this.preeditListener);
        manager.setIIIMStatusListener(statusListener);
        manager.setIIIMLookupListener(this.lookupListener);
        manager.activate();
    }

    public void deactivate(boolean bl) {
        manager.deactivate(bl);
    }

    public synchronized void dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof KeyEvent) {
            IIIMEvent iIIMEvent = new IIIMEvent(aWTEvent);
            manager.dispatchEvent(iIIMEvent);
        }
    }

    public void dispose() {
        manager.dispose();
    }

    public void endComposition() {
        manager.endComposition();
    }

    public Object getControlObject() {
        return manager.getControlObject();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void hideWindows() {
    }

    public void removeNotify() {
        manager.removeNotify();
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
        manager.setCharacterSubsets(subsetArray);
    }

    public void setInputMethodContext(InputMethodContext inputMethodContext) {
        this.inputMethodContext = inputMethodContext;
    }

    public boolean setLocale(Locale locale) {
        boolean bl = manager.setLocale(locale);
        if (bl) {
            this.locale = locale;
        }
        return bl;
    }

    public void setCompositionEnabled(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public boolean isCompositionEnabled() {
        throw new UnsupportedOperationException();
    }

    protected Component getClientComponent() {
        return this.currentClient;
    }

    void setPreeditListener(IIIMPreeditListener iIIMPreeditListener) {
        this.preeditListener = iIIMPreeditListener;
    }

    void setStatusListener(IIIMStatusListener iIIMStatusListener) {
        statusListener = iIIMStatusListener;
    }

    void setLookupListener(IIIMLookupListener iIIMLookupListener) {
        this.lookupListener = iIIMLookupListener;
    }

    public void dispatchEvent(IIIMEvent iIIMEvent) {
    }

    public void preeditStart(IIIMPreeditEvent iIIMPreeditEvent) {
    }

    public void preeditDone(IIIMPreeditEvent iIIMPreeditEvent) {
    }

    public synchronized void preeditDraw(IIIMPreeditEvent iIIMPreeditEvent) {
        AttributedCharacterIterator attributedCharacterIterator = iIIMPreeditEvent.getIterator();
        int n = attributedCharacterIterator.getEndIndex();
        this.inputMethodContext.dispatchInputMethodEvent(1100, attributedCharacterIterator, 0, TextHitInfo.leading(n), null);
    }

    public void committedPerformed(IIIMCommittedEvent iIIMCommittedEvent) {
        String string = iIIMCommittedEvent.getCommittedString();
        AttributedCharacterIterator attributedCharacterIterator = new AttributedString(string).getIterator();
        this.inputMethodContext.dispatchInputMethodEvent(1100, attributedCharacterIterator, string.length(), null, null);
    }
}

