/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.services.authentication;

import com.sun.management.viper.services.AuthenticationException;
import com.sun.management.viper.services.AuthenticationFlavor;

public class DigestAuthFlavor
extends AuthenticationFlavor {
    static final long serialVersionUID = -2978787611373832107L;
    public static final String AUTH_DIGEST_PROP_PREFIX = "auth.digest.";
    public static final String AUTH_DIGEST_PROVIDER_PROP = "auth.digest.provider";
    public static final String AUTH_DIGEST_PROVIDER_DFLT = "SUN";
    public static final String AUTH_DIGEST_DIGEST_ALGO_PROP = "auth.digest.digest.algo";
    public static final String AUTH_DIGEST_DIGEST_ALGO_DFLT = "SHA";
    public static final String AUTH_DIGEST_SIGN_ALGO_PROP = "auth.digest.sign.algo";
    public static final String AUTH_DIGEST_SIGN_ALGO_DFLT = "DSA";
    public static final String AUTH_DIGEST_KEYGEN_ALGO_PROP = "auth.digest.key.algo";
    public static final String AUTH_DIGEST_KEYGEN_ALGO_DFLT = "DSA";
    public static final String AUTH_DIGEST_KEYGEN_SIZE_PROP = "auth.digest.key.strength";
    public static final String AUTH_DIGEST_KEYGEN_SIZE_DFLT = "1024";
    public static final int AUTH_DIGEST_KEYGEN_SIZE_MAX = 1024;
    public static final String AUTH_DIGEST_MSG_INTG_PROP = "auth.digest.msg.integrity";
    public static final String AUTH_DIGEST_MSG_INTG_DFLT = "on";
    private String digestAlgo;
    private String signAlgo;
    private String keyAlgo;
    private int strength;

    public DigestAuthFlavor() throws AuthenticationException {
        super(0);
        this.digestAlgo = AUTH_DIGEST_DIGEST_ALGO_DFLT;
        this.signAlgo = "DSA";
        this.keyAlgo = "DSA";
        this.strength = new Integer(AUTH_DIGEST_KEYGEN_SIZE_DFLT);
    }

    public DigestAuthFlavor(String string, String string2, String string3, int n) throws AuthenticationException {
        super(0);
        if (string == null || string.trim().length() == 0) {
            throw new AuthenticationException("EXSS_BSA", (Object)"Digest");
        }
        this.digestAlgo = string;
        if (string2 == null || string2.trim().length() == 0) {
            throw new AuthenticationException("EXSS_BSA", (Object)"Digest");
        }
        this.signAlgo = string2;
        if (string3 == null || string3.trim().length() == 0) {
            throw new AuthenticationException("EXSS_BSA", (Object)"Digest");
        }
        this.keyAlgo = string3;
        if (n <= 0) {
            throw new AuthenticationException("EXSS_BKS", (Object)"Digest");
        }
        this.strength = n;
    }

    public AuthenticationFlavor newCopy() throws AuthenticationException {
        DigestAuthFlavor digestAuthFlavor = new DigestAuthFlavor(this.digestAlgo, this.signAlgo, this.keyAlgo, this.strength);
        return digestAuthFlavor;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgo;
    }

    public void setDigestAlgorithm(String string) throws AuthenticationException {
        if (string == null || string.trim().length() == 0) {
            throw new AuthenticationException("EXSS_BSA", (Object)"Digest");
        }
        this.digestAlgo = string;
    }

    public String getSignatureAlgorithm() {
        return this.signAlgo;
    }

    public void setSignatureAlgorithm(String string) throws AuthenticationException {
        if (string == null || string.trim().length() == 0) {
            throw new AuthenticationException("EXSS_BSA", (Object)"Digest");
        }
        this.signAlgo = string;
    }

    public String getKeyGenerationAlgorithm() {
        return this.keyAlgo;
    }

    public void setKeyGenerationAlgorithm(String string) throws AuthenticationException {
        if (string == null || string.trim().length() == 0) {
            throw new AuthenticationException("EXSS_BSA", (Object)"Digest");
        }
        this.keyAlgo = string;
    }

    public int getKeyStrength() {
        return this.strength;
    }

    public void setKeyStrength(int n) throws AuthenticationException {
        if (n <= 0) {
            throw new AuthenticationException("EXSS_BKS", (Object)"Digest");
        }
        this.strength = n;
    }
}

