/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ChangeAppState;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.IClientResource;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.VCommonInfo;
import com.sun.admin.patchmgr.client.ApplicationContext;
import com.sun.admin.patchmgr.client.Content;
import com.sun.admin.patchmgr.client.MainMenuBar;
import com.sun.admin.patchmgr.client.MainToolBar;
import com.sun.admin.patchmgr.client.NavigationSelectionListener;
import com.sun.admin.patchmgr.client.PatchActionsListener;
import com.sun.admin.patchmgr.client.PatchTree;
import com.sun.admin.patchmgr.client.ServiceWrapper;
import com.sun.admin.patchmgr.client.TreeNodeData;
import com.sun.admin.patchmgr.common.PatchException;
import com.sun.management.viper.CriticalStopException;
import com.sun.management.viper.Tool;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.console.VConsoleActionListener;
import com.sun.management.viper.console.VConsoleEvent;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VLogEvent;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VAboutBox;
import com.sun.management.viper.console.gui.VBusyPanel;
import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class VPatchMgr
implements Tool,
PropertyChangeListener,
VConsoleActionListener,
IClientResource {
    private ServiceWrapper patchm;
    private VConsoleProperties properties = null;
    private VDisplayModel displayModel = null;
    private JFrame consoleFrame = null;
    private ApplicationContext applicationContext = null;
    private ToolInfrastructure infrastructure = null;
    private String MgmtServerName = "";
    private boolean bRunning = false;
    private Vector consoleListeners = new Vector();
    private Vector propertyChangeListeners = new Vector();
    private Vector navigationSelectionListeners = new Vector();
    private VDisplayModel model;
    private MainMenuBar menuBar = null;
    private MainToolBar toolBar = null;
    private PatchTree theTree = null;
    private ResourceBundle resourceBundle = null;
    private ResourceBundle cisBundle = null;
    private int busyCount = 0;
    private Component glassPane = null;
    private VBusyPanel busyPanel = null;
    private AdminException initException = null;
    private boolean isCriticalStop = false;
    private String origViewSetting = "";

    public VPatchMgr() {
        try {
            this.resourceBundle = ResourceManager.getBundle((String)"com.sun.admin.patchmgr.client.resources.Resources", this.getClass());
        }
        catch (Exception exception) {
            this.reportErrorException(exception);
            this.resourceBundle = null;
        }
        try {
            this.cisBundle = ResourceManager.getBundle((String)VCommonInfo.resourceClass, this.getClass());
        }
        catch (Exception exception) {
            this.reportErrorException(exception);
            this.cisBundle = null;
        }
        this.menuBar = new MainMenuBar(this);
        this.toolBar = new MainToolBar(this);
        this.theTree = new PatchTree(this);
        String string = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"FetchPatches");
        this.busyPanel = new VBusyPanel(string);
        this.getScopeNode().setResultPane((Component)this.busyPanel);
        this.fireConsoleAction(new VConsoleEvent((Object)this, "vconsole.updatescope", (Object)this.getScopeNode()));
    }

    public void addConsoleActionListener(VConsoleActionListener vConsoleActionListener) {
        if (vConsoleActionListener != null) {
            this.consoleListeners.addElement(vConsoleActionListener);
        }
    }

    public void fireConsoleAction(VConsoleEvent vConsoleEvent) {
        int n = 0;
        while (n < this.consoleListeners.size()) {
            VConsoleActionListener vConsoleActionListener = (VConsoleActionListener)this.consoleListeners.elementAt(n);
            vConsoleActionListener.consoleAction(vConsoleEvent);
            ++n;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.propertyChangeListeners.addElement(propertyChangeListener);
        if (this.properties != null) {
            this.properties.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void firePropertyChanged(PropertyChangeEvent propertyChangeEvent) {
        int n = 0;
        while (n < this.propertyChangeListeners.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.propertyChangeListeners.elementAt(n);
            propertyChangeListener.propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public void addNavigationSelectionListener(NavigationSelectionListener navigationSelectionListener) {
        this.navigationSelectionListeners.addElement(navigationSelectionListener);
    }

    private void fireNavigationSelection(VConsoleEvent vConsoleEvent) {
        int n = 0;
        while (n < this.navigationSelectionListeners.size()) {
            NavigationSelectionListener navigationSelectionListener = (NavigationSelectionListener)this.navigationSelectionListeners.elementAt(n);
            navigationSelectionListener.valueChanged((VScopeNode)vConsoleEvent.getPayload());
            ++n;
        }
    }

    public VScopeNode getCurrentNode() {
        return this.theTree.getCurrentNode();
    }

    public ServiceWrapper getpatchM() {
        return this.patchm;
    }

    public void destroy() {
    }

    public VScopeNode getScopeNode() {
        return this.theTree.getRootNode();
    }

    public void init(ToolInfrastructure toolInfrastructure) throws CriticalStopException {
        this.infrastructure = toolInfrastructure;
        try {
            this.patchm = this.applicationContext.getServiceWrapper(toolInfrastructure);
        }
        catch (AdminException adminException) {
            this.initException = adminException;
            String string = "<HTML><BODY>";
            string = string + ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"DESCRIPTION");
            string = string + "</p><p>" + adminException.getLocalizedMessage() + "</p>";
            string = string + "</BODY></HTML>";
            ChangeAppState.setErrorState((VScopeNode)this.getScopeNode(), (String)string);
            String string2 = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"err_log_summary");
            String string3 = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"err_log_message");
            String string4 = adminException.getLocalizedMessage();
            VLogEvent vLogEvent = new VLogEvent((Object)this, 30, new Date(), string2, string3, string4, (Throwable)adminException, null);
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)vLogEvent);
            this.fireConsoleAction(vConsoleEvent);
            return;
        }
        if (!this.patchm.hasPatchReadAuthorization()) {
            String string = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"warn_log_detail");
            this.initException = new PatchException(string);
            String string5 = "<HTML><BODY>";
            string5 = string5 + ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"DESCRIPTION");
            string5 = string5 + "</p><p>" + this.initException.getLocalizedMessage() + "</p>";
            string5 = string5 + "</BODY></HTML>";
            ChangeAppState.setWarningState((VScopeNode)this.getScopeNode(), (String)string5);
            String string6 = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"warn_log_summary");
            String string7 = ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"warn_log_message");
            VLogEvent vLogEvent = new VLogEvent((Object)this, 20, new Date(), string6, string7, this.initException.getLocalizedMessage(), (Throwable)this.initException, null);
            VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.logevent", (Object)vLogEvent);
            this.fireConsoleAction(vConsoleEvent);
            return;
        }
    }

    public ToolInfrastructure getToolInfrastructure() {
        return this.infrastructure;
    }

    public String getServerName() {
        String string = "";
        string = this.applicationContext.getMGMTserverName();
        return string;
    }

    public int runCommandLine(String[] stringArray, InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        return -1;
    }

    public void setProperties(VConsoleProperties vConsoleProperties) {
        this.properties = vConsoleProperties;
        if (vConsoleProperties != null) {
            Object object;
            this.glassPane = this.getFrame().getGlassPane();
            this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
            this.glassPane.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                }
            });
            this.displayModel = (VDisplayModel)vConsoleProperties.getPropertyObject("vconsole.displaymodel");
            this.consoleFrame = (JFrame)vConsoleProperties.getPropertyObject("vconsole.frame");
            int n = 0;
            while (n < this.propertyChangeListeners.size()) {
                object = (PropertyChangeListener)this.propertyChangeListeners.elementAt(n);
                vConsoleProperties.addPropertyChangeListener((PropertyChangeListener)object);
                ++n;
            }
            object = new PropertyChangeEvent(this, "vconsole.buttondisplay", "", vConsoleProperties.getProperty("vconsole.buttondisplay"));
            this.firePropertyChanged((PropertyChangeEvent)object);
        }
    }

    public void setToolContext(ToolContext toolContext) {
        this.applicationContext = new ApplicationContext(this, toolContext);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void start() throws CriticalStopException {
        if (this.initException != null) {
            if (this.isCriticalStop) {
                return;
            }
            this.reportErrorException((Exception)((Object)this.initException));
            this.isCriticalStop = true;
            throw new CriticalStopException(this.initException.getLocalizedMessage());
        }
        this.bRunning = true;
        this.origViewSetting = this.properties.getProperty("vconsole.iconstyle");
        this.properties.setProperty("vconsole.iconviewsenabled", "false");
        this.properties.setProperty("vconsole.iconstyle", "details");
        this.properties.setProperty("vconsole.defaultcolumnheader", ResourceStrings.getString((ResourceBundle)this.getResourceBundle(), (String)"PatchIDColHeader"));
        String string = "vconsole.sortup";
        Integer[] integerArray = new Integer[]{new Integer(0)};
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, string, (Object)integerArray);
        this.fireConsoleAction(vConsoleEvent);
        this.model = (VDisplayModel)this.properties.getPropertyObject("vconsole.displaymodel");
        VConsoleEvent vConsoleEvent2 = new VConsoleEvent((Object)this, "vconsole.scopeselected", (Object)this.model.getSelectedNavigationNode());
        this.fireNavigationSelection(vConsoleEvent2);
    }

    public void stop() throws CriticalStopException {
        this.properties.setProperty("vconsole.iconstyle", this.origViewSetting);
        this.bRunning = false;
    }

    public VConsoleProperties getProperties() {
        return this.properties;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("vconsole.displaymodel")) {
            this.displayModel = (VDisplayModel)propertyChangeEvent.getNewValue();
        } else if (string.equals("vconsole.frame")) {
            this.consoleFrame = (JFrame)propertyChangeEvent.getNewValue();
        }
    }

    public void consoleAction(VConsoleEvent vConsoleEvent) {
        if (!this.bRunning) {
            return;
        }
        String string = vConsoleEvent.getID();
        if (string.equals("vconsole.refresh")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "refresh");
            PatchActionsListener patchActionsListener = new PatchActionsListener(this, false);
            patchActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.sechelpselection")) {
            Vector vector = (Vector)vConsoleEvent.getPayload();
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.onSelection(vector);
        } else if (string.equals("vconsole.scopechildopened")) {
            this.getTree().getCurrentContent().onDoubleClick();
        } else if (string.equals("vconsole.delete")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "Delete");
            PatchActionsListener patchActionsListener = new PatchActionsListener(this, false);
            patchActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.displayproperties")) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "viewDetails");
            PatchActionsListener patchActionsListener = new PatchActionsListener(this, false);
            patchActionsListener.actionPerformed(actionEvent);
        } else if (string.equals("vconsole.sortup") || string.equals("vconsole.sortdown")) {
            TreeNodeData treeNodeData = (TreeNodeData)this.getCurrentNode().getPayload();
            Content content = treeNodeData.getContent();
            content.saveSortPreferences();
        }
    }

    public void aboutPatchMgr() {
        VAboutBox vAboutBox = new VAboutBox();
        vAboutBox.setTitle(ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"MARKETING_NAME") + " " + ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"VERSION"));
        vAboutBox.setDescription(ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"Copyright"));
        Dimension dimension = vAboutBox.getMinimumSize();
        FontMetrics fontMetrics = vAboutBox.getFontMetrics(vAboutBox.getFont());
        dimension.height += 2 * fontMetrics.getHeight();
        vAboutBox.setMinimumSize(dimension);
        VDialog vDialog = new VDialog((Frame)this.consoleFrame, true);
        vAboutBox.setContainer((VContainer)vDialog);
        ActionString actionString = new ActionString(this.resourceBundle, "HelpAbout");
        vDialog.setTitle(actionString.getString());
        vDialog.getContentPane().setLayout(new BorderLayout());
        vDialog.getContentPane().add((Component)vAboutBox, "Center");
        vDialog.pack();
        vDialog.showCenter((Component)this.consoleFrame);
    }

    public MainMenuBar getMenuBar() {
        return this.menuBar;
    }

    public MainToolBar getToolBar() {
        return this.toolBar;
    }

    public PatchTree getTree() {
        return this.theTree;
    }

    public JFrame getFrame() {
        return (JFrame)this.properties.getPropertyObject("vconsole.frame");
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public ResourceBundle getCisBundle() {
        return this.cisBundle;
    }

    public VDisplayModel getDisplayModel() {
        return this.model;
    }

    public void setInfoBar(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.updateselinfo", (Object)string);
        this.fireConsoleAction(vConsoleEvent);
    }

    public void setStatusBar(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        VConsoleEvent vConsoleEvent = new VConsoleEvent((Object)this, "vconsole.updatestatus", (Object)string);
        this.fireConsoleAction(vConsoleEvent);
    }

    public ImageIcon loadImageIcon(String string) {
        String string2 = "images/" + string;
        return ConsoleUtility.loadImageIcon((String)string2, this.getClass());
    }

    public void reportErrorException(Exception exception) {
        AdminException adminException;
        String string = "";
        while (exception != null) {
            if (exception instanceof AdminException) {
                adminException = (AdminException)((Object)exception);
                string = string + "\n" + adminException.getLocalizedMessage();
                if (adminException.isEmbeddedException()) {
                    exception = adminException.getEmbeddedException();
                    continue;
                }
                exception = null;
                continue;
            }
            string = string + "\n" + exception.getMessage();
            exception = null;
        }
        adminException = new ErrorDialog(this.getFrame(), ResourceStrings.getString((ResourceBundle)this.resourceBundle, (String)"ErrorTitle"), string);
    }

    public void waitOn() {
        this.setBusy(true);
    }

    public void waitOff() {
        this.setBusy(false);
    }

    public boolean isWaitOn() {
        return this.busyCount > 0;
    }

    private synchronized void setBusy(boolean bl) {
        if (this.glassPane == null) {
            return;
        }
        if (bl) {
            ++this.busyCount;
            if (this.busyCount == 1) {
                this.properties.setProperty("vconsole.working", "true");
            }
        } else {
            --this.busyCount;
            this.busyCount = Math.max(0, this.busyCount);
            if (this.busyCount == 0) {
                this.properties.setProperty("vconsole.working", "false");
            }
        }
    }

    public Vector getInstalledPatches() {
        Vector vector = new Vector();
        try {
            vector = this.getpatchM().getAllInstalledPatches();
        }
        catch (AdminException adminException) {
            this.reportErrorException((Exception)((Object)adminException));
        }
        return vector;
    }
}

