/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.IClientResource;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.ServiceWrapper;
import com.sun.admin.patchmgr.common.PatchMgrObj;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class SystemComparator {
    private String templateArch = "";
    private String templateOS = "";
    private String templateOSversion = "";
    private Vector templatePatches = new Vector();
    private Hashtable templatePatchesHT = null;
    private IClientResource theApp = null;
    private ResourceBundle bundle = null;

    public SystemComparator(IClientResource iClientResource, ResourceBundle resourceBundle) {
        this.theApp = iClientResource;
        this.bundle = resourceBundle;
    }

    public String setTemplate(String string, ServiceWrapper serviceWrapper) {
        try {
            this.templateArch = serviceWrapper.getArch();
        }
        catch (AdminException adminException) {
            Object[] objectArray = new Object[]{string};
            return MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_arch_unknown"), objectArray);
        }
        try {
            this.templateOS = serviceWrapper.getOS().getSunOSRelease();
        }
        catch (AdminException adminException) {
            Object[] objectArray = new Object[]{string};
            return MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_os_unknown"), objectArray);
        }
        try {
            this.templateOSversion = serviceWrapper.getOS().getSunOSVersion();
        }
        catch (AdminException adminException) {
            Object[] objectArray = new Object[]{string};
            return MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_os_ver_unknown"), objectArray);
        }
        try {
            this.templatePatches = serviceWrapper.getAllInstalledPatches();
        }
        catch (AdminException adminException) {
            Object[] objectArray = new Object[]{string};
            return MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_patches_unknown"), objectArray);
        }
        this.templatePatchesHT = new Hashtable();
        int n = 0;
        while (n < this.templatePatches.size()) {
            PatchMgrObj patchMgrObj = (PatchMgrObj)this.templatePatches.elementAt(n);
            if (patchMgrObj != null) {
                this.templatePatchesHT.put(patchMgrObj.getPatchName(), patchMgrObj);
            }
            ++n;
        }
        return null;
    }

    public String compareToTemplate(String string, ServiceWrapper serviceWrapper) {
        Object[] objectArray;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        String string5 = null;
        String string6 = null;
        try {
            string2 = serviceWrapper.getArch();
        }
        catch (AdminException adminException) {
            Object[] objectArray2 = new Object[]{string};
            return MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_arch_unknown"), objectArray2);
        }
        try {
            string3 = serviceWrapper.getOS().getSunOSRelease();
        }
        catch (AdminException adminException) {
            Object[] objectArray3 = new Object[]{string};
            return MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_os_unknown"), objectArray3);
        }
        try {
            string4 = serviceWrapper.getOS().getSunOSVersion();
        }
        catch (AdminException adminException) {
            Object[] objectArray4 = new Object[]{string};
            return MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_os_ver_unknown"), objectArray4);
        }
        try {
            vector = serviceWrapper.getAllInstalledPatches();
        }
        catch (AdminException adminException) {
            Object[] objectArray5 = new Object[]{string};
            return MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_patches_unknown"), objectArray5);
        }
        if (!this.templateOS.equals(string3)) {
            objectArray = new Object[]{string, string3, this.templateOS};
            string6 = MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_os_mismatch"), objectArray);
            vector2.add(string6);
        } else if (!this.templateOSversion.equals(string4)) {
            objectArray = new Object[]{string, string4, this.templateOSversion};
            string6 = MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_osversion_mismatch"), objectArray);
            vector2.add(string6);
        }
        if (!this.templateArch.equals(string2)) {
            objectArray = new Object[]{string, string2, this.templateArch};
            string6 = MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_arch_mismatch"), objectArray);
            vector2.add(string6);
        }
        if (vector.size() != this.templatePatches.size()) {
            objectArray = new Object[]{string};
            string6 = MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_patch_mismatch"), objectArray);
            vector2.add(string6);
        } else {
            int n = 0;
            while (n < vector.size()) {
                PatchMgrObj patchMgrObj = (PatchMgrObj)vector.elementAt(n);
                if (patchMgrObj != null && !this.templatePatchesHT.containsKey(patchMgrObj.getPatchName())) {
                    Object[] objectArray6 = new Object[]{string};
                    string6 = MessageFormat.format(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"er_patch_mismatch"), objectArray6);
                    vector2.add(string6);
                    break;
                }
                ++n;
            }
        }
        if (vector2.size() != 0) {
            int n = 0;
            while (n < vector2.size()) {
                string5 = string5 == null ? (String)vector2.elementAt(n) : string5 + "\n" + (String)vector2.elementAt(n);
                ++n;
            }
        }
        return string5;
    }
}

