/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.ContentEvent;
import com.sun.admin.patchmgr.client.ContentListener;
import com.sun.admin.patchmgr.client.PatchActionsListener;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.VScopeNode;
import com.sun.management.viper.console.gui.VDisplayModel;
import com.sun.management.viper.util.ResourceManager;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;

public abstract class Content {
    private Vector listeners = new Vector();
    protected boolean bRefresh = false;
    protected VScopeNode treeNode = null;
    protected VScopeNode rootNode = null;
    protected Vector vDataCache = new Vector();
    protected VConsoleProperties properties = null;
    protected VDisplayModel displayModel = null;
    protected VPatchMgr theApp;

    protected abstract void updateSortPreferences();

    protected abstract void saveSortPreferences();

    protected abstract String getSortAttribute();

    protected abstract String[][] getColumnHeaders();

    protected abstract void find(Object var1);

    public Content(VPatchMgr vPatchMgr) {
        this.theApp = vPatchMgr;
    }

    protected void setDisplayModel() {
        this.properties = this.theApp.getProperties();
        this.displayModel = (VDisplayModel)this.properties.getPropertyObject("vconsole.displaymodel");
        this.setDefaultColumnHeader();
    }

    public abstract void setDefaultColumnHeader();

    public Vector getSelected() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        VDisplayModel vDisplayModel = (VDisplayModel)vConsoleProperties.getPropertyObject("vconsole.displaymodel");
        return vDisplayModel.getSelectedNodes();
    }

    public void setSelected(Vector vector) {
        this.theApp.getDisplayModel().setSelectedNodes(vector);
        this.onSelection(vector);
    }

    public void onSelection(Vector vector) {
        this.fireItemPressed(vector.size());
    }

    public int getNumSelections() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        VDisplayModel vDisplayModel = (VDisplayModel)vConsoleProperties.getPropertyObject("vconsole.displaymodel");
        return vDisplayModel.getSelectedNodes().size();
    }

    public void clearSelection() {
        VConsoleProperties vConsoleProperties = this.theApp.getProperties();
        VDisplayModel vDisplayModel = (VDisplayModel)vConsoleProperties.getPropertyObject("vconsole.displaymodel");
        vDisplayModel.clearSelection();
        this.fireItemPressed(0);
    }

    protected String[][] constructColumnHeaders(Object[][] objectArray) {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        int n = objectArray.length;
        String[][] stringArray = new String[n][3];
        JLabel jLabel = new JLabel();
        jLabel.setFont(ResourceManager.labelFont);
        FontMetrics fontMetrics = jLabel.getFontMetrics(ResourceManager.labelFont);
        jLabel.setFont(ResourceManager.bodyFont);
        FontMetrics fontMetrics2 = jLabel.getFontMetrics(ResourceManager.labelFont);
        int n2 = 0;
        while (n2 < n) {
            String string = (String)objectArray[n2][0];
            stringArray[n2][0] = ResourceStrings.getString((ResourceBundle)resourceBundle, (String)string);
            int n3 = fontMetrics.stringWidth(stringArray[n2][0]);
            n3 += fontMetrics.stringWidth("AAAA");
            int n4 = (Integer)objectArray[n2][1];
            int n5 = 0;
            if (n4 > 20000) {
                n5 = 20000;
            } else if (n4 > 10000) {
                n5 = 10000;
            }
            int n6 = fontMetrics2.stringWidth("A");
            n6 *= (n4 -= n5);
            stringArray[n2][1] = new String(String.valueOf(Math.max(n3, n6 += n5)));
            ++n2;
        }
        return stringArray;
    }

    public abstract void refresh();

    public abstract void viewDetails();

    public abstract void installPatch();

    public abstract void installMMPatch();

    public abstract void downloadPatch();

    public abstract void analyzePatch();

    public abstract void deleteSelected();

    public void onDoubleClick() {
        this.fireItemPressed(2);
        ActionEvent actionEvent = new ActionEvent(this, 1001, "viewDetails");
        PatchActionsListener patchActionsListener = new PatchActionsListener(this.theApp);
        patchActionsListener.actionPerformed(actionEvent);
    }

    public void openSelected() {
    }

    public abstract String whatAmI();

    protected abstract void updateInfoBar();

    public boolean isFilteringSupported() {
        return false;
    }

    public boolean isShowByTypeSupported() {
        return false;
    }

    public void showByType() {
    }

    public void setTreeNode(VScopeNode vScopeNode) {
        this.treeNode = vScopeNode;
    }

    public VScopeNode getTreeNode() {
        return this.treeNode;
    }

    public VScopeNode getInternalRoot() {
        return this.rootNode;
    }

    public Vector getDataCache() {
        return this.vDataCache;
    }

    public abstract void clear();

    public boolean isRefreshed() {
        return this.bRefresh;
    }

    public synchronized void addContentListener(ContentListener contentListener) {
        this.listeners.addElement(contentListener);
    }

    public synchronized void removeContentListener(ContentListener contentListener) {
        this.listeners.removeElement(contentListener);
    }

    protected void fireItemPressed(int n) {
        ContentEvent contentEvent = new ContentEvent(this, n, this.getSortAttribute(), null);
        int n2 = 0;
        while (n2 < this.listeners.size()) {
            ContentListener contentListener = (ContentListener)this.listeners.elementAt(n2);
            contentListener.itemPressed(contentEvent);
            ++n2;
        }
    }
}

