/*
 * Decompiled with CFR 0.152.
 */
package sun.servlet.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import sun.servlet.ServletConnection;
import sun.servlet.http.HttpRequest;
import sun.servlet.http.HttpResponse;
import sun.servlet.http.HttpServer;
import sun.servlet.http.MessageBytes;

public class HttpServerHandler
implements Runnable,
ServletConnection {
    protected HttpServer server;
    protected final HttpRequest req = new HttpRequest();
    protected final HttpResponse res = new HttpResponse();
    protected Socket socket;
    protected byte[] buf = new byte[512];
    protected static String PREFIX = "/servlet/";
    protected static int PREFIX_LEN = PREFIX.length();

    protected HttpServerHandler(HttpServer httpServer) {
        this.server = httpServer;
        this.req.setSessionContext(httpServer.getSessionContext());
        this.req.setResponse(this.res);
    }

    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public String getRealPath(String string) {
        return this.server.getRealPath(string);
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public String getServerName() {
        return this.server.host;
    }

    public int getServerPort() {
        return this.server.port;
    }

    protected void handleConnection(Socket socket) throws IOException {
        this.req.init(this);
        this.res.init(this);
        while (this.req.next()) {
            this.res.next();
            if (this.req.getMajorVersion() < 1) {
                this.res.printKeepAlive();
            } else if (this.req.getMajorVersion() == 1) {
                this.res.printKeepAlive();
                this.res.setProtocol("HTTP/1.0");
                this.res.setHeader("Server", this.server.name);
            } else {
                this.res.setProtocol("HTTP/1.0");
                this.res.setHeader("Server", this.server.name);
                this.res.sendError(505);
                break;
            }
            this.res.setKeepAlive(this.req.getKeepAlive());
            try {
                this.sendResponse(this.req, this.res);
            }
            catch (Exception exception) {
                if (this.res.getTotalBytes() == 0) {
                    try {
                        this.res.sendError(500);
                    }
                    catch (IOException iOException) {}
                }
                exception.printStackTrace();
            }
            this.req.finish();
            this.res.finish();
            if (!this.res.getKeepAlive()) break;
        }
    }

    protected String parsePath(MessageBytes messageBytes, HttpRequest httpRequest) {
        byte[] byArray = messageBytes.getBytes();
        int n = messageBytes.getOffset() + PREFIX_LEN;
        int n2 = messageBytes.getLength() - PREFIX_LEN;
        int n3 = n;
        while (n3 < n + n2 && byArray[n3] != 47) {
            ++n3;
        }
        if (n3 < n + n2) {
            httpRequest.setPathInfo(byArray, n3, n + n2 - n3);
        } else {
            n3 = n + n2;
        }
        String string = new String(byArray, 0, n, n3 - n);
        httpRequest.setServletPath(byArray, n -= PREFIX_LEN, n3 - n);
        return string;
    }

    public void run() {
        Socket socket;
        while ((socket = (Socket)this.server.getConnection()) != null) {
            try {
                this.socket = socket;
                this.handleConnection(socket);
                socket.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void sendResponse(HttpRequest httpRequest, HttpResponse httpResponse) throws ServletException, IOException {
        MessageBytes messageBytes = httpRequest.getRequestPath();
        if (messageBytes.startsWith(PREFIX)) {
            String string = this.parsePath(messageBytes, httpRequest);
            if (string != null) {
                Servlet servlet = this.server.getServlet(string);
                if (servlet != null) {
                    if (servlet instanceof SingleThreadModel) {
                        Servlet servlet2 = servlet;
                        synchronized (servlet2) {
                            servlet.service(httpRequest, httpResponse);
                        }
                    } else {
                        servlet.service(httpRequest, httpResponse);
                    }
                    return;
                }
                System.err.println("Servlet not found: " + string);
            }
        } else {
            String string = httpRequest.getMethod();
            if (string.equals("GET") || string.equals("HEAD")) {
                httpResponse.sendError(403, "Will not serve files, only servlets");
                return;
            }
        }
        httpResponse.sendError(404);
    }
}

