/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.Serializable;
import java.net.MalformedURLException;

public final class URL
implements Serializable {
    private String authority = null;
    private String file = null;
    private String host = null;
    private String path = null;
    private int port = -1;
    private String protocol = null;
    private String query = null;
    private String ref = null;
    private String userInfo = null;

    public URL(String spec) throws MalformedURLException {
        this(null, spec);
    }

    public URL(String protocol, String host, int port, String file) throws MalformedURLException {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        int hash = file.indexOf(35);
        this.file = hash < 0 ? file : file.substring(0, hash);
        this.ref = hash < 0 ? null : file.substring(hash + 1);
        int question = file.lastIndexOf(63);
        if (question >= 0) {
            this.query = file.substring(question + 1);
            this.path = file.substring(0, question);
        } else {
            this.path = file;
        }
        if (host != null && host.length() > 0) {
            this.authority = port == -1 ? host : String.valueOf(host) + ":" + port;
        }
    }

    public URL(String protocol, String host, String file) throws MalformedURLException {
        this(protocol, host, -1, file);
    }

    public URL(URL context, String spec) throws MalformedURLException {
        String original = spec;
        int start = 0;
        String newProtocol = null;
        boolean aRef = false;
        try {
            char c;
            int limit = spec.length();
            while (limit > 0 && spec.charAt(limit - 1) <= ' ') {
                --limit;
            }
            while (start < limit && spec.charAt(start) <= ' ') {
                ++start;
            }
            if (spec.regionMatches(true, start, "url:", 0, 4)) {
                start += 4;
            }
            if (start < spec.length() && spec.charAt(start) == '#') {
                aRef = true;
            }
            int i = start;
            while (!aRef && i < limit && (c = spec.charAt(i)) != '/') {
                if (c == ':') {
                    String s;
                    newProtocol = s = spec.substring(start, i).toLowerCase();
                    start = i + 1;
                    break;
                }
                ++i;
            }
            this.protocol = newProtocol;
            if (context != null && (newProtocol == null || newProtocol.equalsIgnoreCase(context.getProtocol()))) {
                if (context.getPath() != null && context.getPath().startsWith("/")) {
                    newProtocol = null;
                }
                if (newProtocol == null) {
                    this.protocol = context.getProtocol();
                    this.authority = context.getAuthority();
                    this.userInfo = context.getUserInfo();
                    this.host = context.getHost();
                    this.port = context.getPort();
                    this.file = context.getFile();
                    int question = this.file.lastIndexOf("?");
                    this.path = question < 0 ? this.file : this.file.substring(0, question);
                }
            }
            if (this.protocol == null) {
                throw new MalformedURLException("no protocol: " + original);
            }
            i = spec.indexOf(35, start);
            if (i >= 0) {
                this.ref = spec.substring(i + 1, limit);
                limit = i;
            }
            this.parse(spec, start, limit);
            if (context != null) {
                this.normalize();
            }
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MalformedURLException(e.toString());
        }
    }

    private boolean compare(String first, String second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        return first.equals(second);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof URL)) {
            return false;
        }
        URL other = (URL)obj;
        if (!this.sameFile(other)) {
            return false;
        }
        return this.compare(this.ref, other.getRef());
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getFile() {
        if (this.file == null) {
            return "";
        }
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        if (this.path == null) {
            return "";
        }
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRef() {
        return this.ref;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public void normalize() throws MalformedURLException {
        int index2;
        int index;
        if (this.path == null) {
            this.file = this.query != null ? "?" + this.query : "";
            return;
        }
        String normalized = this.path;
        if (normalized.equals("/.")) {
            this.path = "/";
            this.file = this.query != null ? String.valueOf(this.path) + "?" + this.query : this.path;
            return;
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = String.valueOf(normalized.substring(0, index)) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                throw new MalformedURLException("Invalid relative URL reference");
            }
            index2 = normalized.lastIndexOf(47, index - 1);
            normalized = String.valueOf(normalized.substring(0, index2)) + normalized.substring(index + 3);
        }
        if (normalized.endsWith("/.")) {
            normalized = normalized.substring(0, normalized.length() - 1);
        }
        if (normalized.endsWith("/..")) {
            index = normalized.length() - 3;
            index2 = normalized.lastIndexOf(47, index - 1);
            if (index2 < 0) {
                throw new MalformedURLException("Invalid relative URL reference");
            }
            normalized = normalized.substring(0, index2 + 1);
        }
        this.path = normalized;
        this.file = this.query != null ? String.valueOf(this.path) + "?" + this.query : this.path;
    }

    private void parse(String spec, int start, int limit) throws MalformedURLException {
        int question = spec.lastIndexOf(63, limit - 1);
        if (question >= 0 && question < limit) {
            this.query = spec.substring(question + 1, limit);
            limit = question;
        } else {
            this.query = null;
        }
        if (spec.indexOf("//", start) == start) {
            int pathStart = spec.indexOf("/", start + 2);
            if (pathStart >= 0 && pathStart < limit) {
                this.authority = spec.substring(start + 2, pathStart);
                start = pathStart;
            } else {
                this.authority = spec.substring(start + 2, limit);
                start = limit;
            }
            if (this.authority.length() > 0) {
                int colon;
                int at = this.authority.indexOf(64);
                if (at >= 0) {
                    this.userInfo = this.authority.substring(0, at);
                }
                if ((colon = this.authority.indexOf(58, at + 1)) >= 0) {
                    try {
                        this.port = Integer.parseInt(this.authority.substring(colon + 1));
                    }
                    catch (NumberFormatException e) {
                        throw new MalformedURLException(e.toString());
                    }
                    this.host = this.authority.substring(at + 1, colon);
                } else {
                    this.host = this.authority.substring(at + 1);
                    this.port = -1;
                }
            }
        }
        if (spec.indexOf("/", start) == start) {
            this.path = spec.substring(start, limit);
            this.file = this.query != null ? String.valueOf(this.path) + "?" + this.query : this.path;
            return;
        }
        if (this.path == null) {
            this.file = this.query != null ? "?" + this.query : null;
            return;
        }
        if (!this.path.startsWith("/")) {
            throw new MalformedURLException("Base path does not start with '/'");
        }
        if (!this.path.endsWith("/")) {
            this.path = String.valueOf(this.path) + "/../";
        }
        this.path = String.valueOf(this.path) + spec.substring(start, limit);
        this.file = this.query != null ? String.valueOf(this.path) + "?" + this.query : this.path;
    }

    public boolean sameFile(URL other) {
        if (!this.compare(this.protocol, other.getProtocol())) {
            return false;
        }
        if (!this.compare(this.host, other.getHost())) {
            return false;
        }
        if (this.port != other.getPort()) {
            return false;
        }
        return this.compare(this.file, other.getFile());
    }

    public String toExternalForm() {
        StringBuffer sb = new StringBuffer();
        if (this.protocol != null) {
            sb.append(this.protocol);
            sb.append(":");
        }
        if (this.authority != null) {
            sb.append("//");
            sb.append(this.authority);
        }
        if (this.path != null) {
            sb.append(this.path);
        }
        if (this.query != null) {
            sb.append('?');
            sb.append(this.query);
        }
        if (this.ref != null) {
            sb.append('#');
            sb.append(this.ref);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("URL[");
        sb.append("authority=");
        sb.append(this.authority);
        sb.append(", file=");
        sb.append(this.file);
        sb.append(", host=");
        sb.append(this.host);
        sb.append(", port=");
        sb.append(this.port);
        sb.append(", protocol=");
        sb.append(this.protocol);
        sb.append(", query=");
        sb.append(this.query);
        sb.append(", ref=");
        sb.append(this.ref);
        sb.append(", userInfo=");
        sb.append(this.userInfo);
        sb.append("]");
        return sb.toString();
    }
}

