/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.core.ApplicationContext;
import org.apache.catalina.loader.ContextNotifier;
import org.apache.catalina.loader.Extension;
import org.apache.catalina.loader.Reloader;
import org.apache.catalina.loader.StandardClassLoader;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.apache.naming.resources.Resource;

public final class StandardLoader
implements Lifecycle,
Loader,
PropertyChangeListener,
Runnable {
    private int checkInterval = 15;
    private Reloader classLoader = null;
    private Container container = null;
    private int debug = 0;
    private boolean delegate = false;
    private static final String info = "org.apache.catalina.loader.StandardLoader/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private String loaderClass = "org.apache.catalina.loader.StandardClassLoader";
    private ClassLoader parentClassLoader = null;
    private boolean reloadable = false;
    private String[] repositories = new String[0];
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.loader");
    private boolean started = false;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "StandardLoader";

    public StandardLoader() {
        this(null);
    }

    public StandardLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addRepository(String repository) {
        if (this.debug >= 1) {
            this.log(sm.getString("standardLoader.addRepository", repository));
        }
        int i = 0;
        while (i < this.repositories.length) {
            if (repository.equals(this.repositories[i])) {
                return;
            }
            ++i;
        }
        String[] results = new String[this.repositories.length + 1];
        int i2 = 0;
        while (i2 < this.repositories.length) {
            results[i2] = this.repositories[i2];
            ++i2;
        }
        results[this.repositories.length] = repository;
        this.repositories = results;
        if (this.started && this.classLoader != null) {
            this.classLoader.addRepository(repository);
            this.setClassPath();
        }
    }

    private boolean copy(InputStream is, OutputStream os) {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void copyClassesRepository() {
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        String classpath = (String)servletContext.getAttribute("org.apache.catalina.jsp_classpath");
        if (classpath == null) {
            classpath = "";
        }
        DirContext resources = this.container.getResources();
        String classesName = "/WEB-INF/classes";
        try {
            Object object = resources.lookup(classesName);
            if (!(object instanceof DirContext)) {
                return;
            }
            resources = (DirContext)object;
        }
        catch (NamingException namingException) {
            return;
        }
        String absoluteClassesPath = servletContext.getRealPath(classesName);
        if (absoluteClassesPath != null) {
            if (!classpath.equals("")) {
                classpath = String.valueOf(File.pathSeparator) + classpath;
            }
            classpath = String.valueOf(absoluteClassesPath) + classpath;
        } else {
            File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
            if (workDir != null) {
                if (!classpath.equals("")) {
                    classpath = String.valueOf(File.pathSeparator) + classpath;
                }
                File classesDir = new File(workDir, classesName);
                classesDir.mkdirs();
                classpath = String.valueOf(classesDir.getAbsolutePath()) + classpath;
                this.copyDir(resources, classesDir);
            }
        }
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)classpath);
        if (servletContext instanceof ApplicationContext) {
            ((ApplicationContext)servletContext).setAttributeReadOnly("org.apache.catalina.jsp_classpath");
        }
    }

    private boolean copyDir(DirContext srcDir, File destDir) {
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = srcDir.list("");
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)namingEnumeration.nextElement();
                String name = ncPair.getName();
                Object object = srcDir.lookup(name);
                File currentFile = new File(destDir, name);
                if (object instanceof Resource) {
                    FileOutputStream os;
                    InputStream is = ((Resource)object).streamContent();
                    if (this.copy(is, os = new FileOutputStream(currentFile))) continue;
                    return false;
                }
                if (object instanceof InputStream) {
                    FileOutputStream os = new FileOutputStream(currentFile);
                    if (this.copy((InputStream)object, os)) continue;
                    return false;
                }
                if (!(object instanceof DirContext)) continue;
                currentFile.mkdir();
                this.copyDir((DirContext)object, currentFile);
            }
        }
        catch (NamingException namingException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public String[] findRepositories() {
        return this.repositories;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoader;
    }

    public Container getContainer() {
        return this.container;
    }

    public int getDebug() {
        return this.debug;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public String getInfo() {
        return info;
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    private void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardLoader[" + this.container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardLoader[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardLoader[" + this.container.getName() + "] " + message, throwable);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardLoader[" + containerName + "]: " + message);
            System.out.println(String.valueOf(String.valueOf(throwable)));
            throwable.printStackTrace(System.out);
        }
    }

    public boolean modified() {
        return this.classLoader.modified();
    }

    private void notifyContext() {
        ContextNotifier notifier = new ContextNotifier((Context)this.container);
        new Thread(notifier).start();
    }

    public void propertyChange(PropertyChangeEvent event) {
        block3: {
            if (!(event.getSource() instanceof Context)) {
                return;
            }
            Context context = (Context)event.getSource();
            if (!event.getPropertyName().equals("reloadable")) break block3;
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.log(sm.getString("standardLoader.reloadable", event.getNewValue().toString()));
            }
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void run() {
        if (this.debug >= 1) {
            this.log("BACKGROUND THREAD Starting");
        }
        DirContextURLStreamHandler.bindThread((DirContext)this.container.getResources());
        while (!this.threadDone) {
            this.threadSleep();
            if (!this.classLoader.modified()) continue;
            this.notifyContext();
            break;
        }
        DirContextURLStreamHandler.unbindThread();
        if (this.debug >= 1) {
            this.log("BACKGROUND THREAD Stopping");
        }
    }

    public void setCheckInterval(int checkInterval) {
        int oldCheckInterval = this.checkInterval;
        this.checkInterval = checkInterval;
        this.support.firePropertyChange("checkInterval", new Integer(oldCheckInterval), new Integer(this.checkInterval));
    }

    private void setClassLoader() {
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        servletContext.setAttribute("org.apache.catalina.classloader", (Object)this.getClassLoader());
        if (servletContext instanceof ApplicationContext) {
            ((ApplicationContext)servletContext).setAttributeReadOnly("org.apache.catalina.classloader");
        }
    }

    private void setClassPath() {
        File workDir;
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        StringBuffer classpath = new StringBuffer();
        ClassLoader loader = this.getClassLoader();
        int layers = 0;
        int n = 0;
        while (layers < 3 && loader != null) {
            if (!(loader instanceof URLClassLoader)) break;
            URL[] repositories = ((URLClassLoader)loader).getURLs();
            int i = 0;
            while (i < repositories.length) {
                block29: {
                    String repository;
                    block27: {
                        block28: {
                            block26: {
                                repository = repositories[i].toString();
                                if (!repository.startsWith("file://")) break block26;
                                repository = repository.substring(7);
                                break block27;
                            }
                            if (!repository.startsWith("file:")) break block28;
                            repository = repository.substring(5);
                            break block27;
                        }
                        if (!repository.startsWith("jndi:")) break block29;
                        repository = servletContext.getRealPath(repository.substring(5));
                    }
                    if (repository != null && !repository.endsWith("/")) {
                        if (n > 0) {
                            classpath.append(File.pathSeparator);
                        }
                        classpath.append(repository);
                        ++n;
                    }
                }
                ++i;
            }
            loader = loader.getParent();
            ++layers;
        }
        if ((workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir")) != null) {
            DirContext resources = this.container.getResources();
            String libName = "/WEB-INF/lib";
            File destDir = new File(workDir, libName);
            if (servletContext.getRealPath(libName) == null) {
                destDir.mkdirs();
            }
            DirContext libDir = null;
            try {
                Object object = resources.lookup(libName);
                if (object instanceof DirContext) {
                    libDir = (DirContext)object;
                }
            }
            catch (NamingException namingException) {}
            if (libDir != null) {
                try {
                    NamingEnumeration<NameClassPair> namingEnumeration = resources.list(libName);
                    while (namingEnumeration.hasMoreElements()) {
                        NameClassPair ncPair = (NameClassPair)namingEnumeration.nextElement();
                        String filename = ncPair.getName();
                        if (!filename.endsWith(".jar")) continue;
                        String realPath = servletContext.getRealPath(String.valueOf(libName) + "/" + filename);
                        if (realPath != null) {
                            if (n > 0) {
                                classpath.append(File.pathSeparator);
                            }
                            ++n;
                            classpath.append(realPath);
                            continue;
                        }
                        try {
                            URL fileURL = servletContext.getResource(String.valueOf(libName) + "/" + filename);
                            this.log(" Adding 'file: " + libName + "/" + filename + "'");
                            File dest = new File(destDir, filename);
                            if (!this.copy(fileURL.openStream(), new FileOutputStream(dest))) continue;
                            if (n > 0) {
                                classpath.append(File.pathSeparator);
                            }
                            ++n;
                            classpath.append(dest.getAbsolutePath());
                        }
                        catch (MalformedURLException malformedURLException) {
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (NamingException namingException) {}
            }
        }
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)classpath.toString());
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener(this);
        }
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setReloadable(((Context)this.container).getReloadable());
            ((Context)this.container).addPropertyChangeListener(this);
        }
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", new Integer(oldDebug), new Integer(this.debug));
    }

    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", new Boolean(oldDelegate), new Boolean(this.delegate));
    }

    private void setJasperEnvironment() {
        this.setClassLoader();
        this.setClassPath();
        this.copyClassesRepository();
    }

    public void setLoaderClass() {
        this.loaderClass = this.loaderClass;
    }

    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", new Boolean(oldReloadable), new Boolean(this.reloadable));
        if (!this.started) {
            return;
        }
        if (!oldReloadable && this.reloadable) {
            this.threadStart();
        } else if (oldReloadable && !this.reloadable) {
            this.threadStop();
        }
    }

    private void setRepositories() {
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        URL classesURL = null;
        try {
            classesURL = servletContext.getResource("/WEB-INF/classes");
        }
        catch (MalformedURLException malformedURLException) {
            classesURL = null;
        }
        if (classesURL != null) {
            int index;
            String classesURLString = classesURL.toString();
            if (classesURLString.indexOf(92) >= 0) {
                classesURLString = classesURLString.replace('\\', '/');
            }
            while ((index = classesURLString.indexOf("/./")) >= 0) {
                classesURLString = String.valueOf(classesURLString.substring(0, index)) + classesURLString.substring(index + 2);
            }
            while ((index = classesURLString.indexOf("/../")) > 0) {
                int index2 = classesURLString.lastIndexOf(47, index - 1);
                classesURLString = String.valueOf(classesURLString.substring(0, index2)) + classesURLString.substring(index + 3);
            }
            this.addRepository(String.valueOf(classesURLString) + "/");
        }
        DirContext resources = this.container.getResources();
        String libName = "/WEB-INF/lib";
        Object libDir = null;
        try {
            NamingEnumeration<NameClassPair> namingEnumeration = resources.list(libName);
            while (namingEnumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)namingEnumeration.nextElement();
                String filename = String.valueOf(libName) + "/" + ncPair.getName();
                if (!filename.endsWith(".jar")) continue;
                try {
                    URL url = servletContext.getResource(filename);
                    url = new URL("jar:" + url.toString() + "!/");
                    this.addRepository(url.toString());
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (NamingException namingException) {}
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("standardLoader.alreadyStarted"));
        }
        if (this.debug >= 1) {
            this.log(sm.getString("standardLoader.starting"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        DirContextURLStreamHandlerFactory streamHandlerFactory = new DirContextURLStreamHandlerFactory();
        try {
            URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)streamHandlerFactory);
        }
        catch (Throwable throwable) {}
        this.setRepositories();
        try {
            this.classLoader = this.parentClassLoader == null ? new StandardClassLoader() : new StandardClassLoader(this.parentClassLoader);
            ((StandardClassLoader)this.classLoader).setDebug(this.debug);
            int i = 0;
            while (i < this.repositories.length) {
                this.classLoader.addRepository(this.repositories[i]);
                ++i;
            }
            ((StandardClassLoader)this.classLoader).setDelegate(this.delegate);
            if (this.container instanceof Context) {
                ServletContext servletContext = ((Context)this.container).getServletContext();
                try {
                    String contextRoot;
                    URL contextURL = servletContext.getResource("/");
                    if (contextURL != null) {
                        ((StandardClassLoader)this.classLoader).setPermissions(contextURL);
                        String jarUrl = "jar:" + contextURL.toString() + "WEB-INF/lib/";
                        ((StandardClassLoader)this.classLoader).setPermissions(jarUrl);
                    }
                    if ((contextRoot = servletContext.getRealPath("/")) != null) {
                        ((StandardClassLoader)this.classLoader).setPermissions(contextRoot);
                        String rootUrl = "file:" + contextRoot;
                        ((StandardClassLoader)this.classLoader).setPermissions(rootUrl);
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            if (this.classLoader instanceof Lifecycle) {
                ((Lifecycle)this.classLoader).start();
            }
            DirContextURLStreamHandler.bind((ClassLoader)((ClassLoader)this.classLoader), (DirContext)this.container.getResources());
        }
        catch (Throwable t) {
            throw new LifecycleException("start: ", t);
        }
        this.validatePackages();
        this.setJasperEnvironment();
        if (this.reloadable) {
            this.log(sm.getString("standardLoader.reloading"));
            try {
                this.threadStart();
            }
            catch (IllegalStateException e) {
                throw new LifecycleException(e);
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("standardLoader.notStarted"));
        }
        if (this.debug >= 1) {
            this.log(sm.getString("standardLoader.stopping"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.reloadable) {
            this.threadStop();
        }
        if (this.container instanceof Context) {
            ServletContext servletContext = ((Context)this.container).getServletContext();
            servletContext.removeAttribute("org.apache.catalina.classloader");
            servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        }
        if (this.classLoader instanceof Lifecycle) {
            ((Lifecycle)this.classLoader).stop();
        }
        this.classLoader = null;
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        if (!this.reloadable) {
            throw new IllegalStateException(sm.getString("standardLoader.notReloadable"));
        }
        if (!(this.container instanceof Context)) {
            throw new IllegalStateException(sm.getString("standardLoader.notContext"));
        }
        if (this.debug >= 1) {
            this.log(" Starting background thread");
        }
        this.threadDone = false;
        this.threadName = "StandardLoader[" + this.container.getName() + "]";
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        if (this.debug >= 1) {
            this.log(" Stopping background thread");
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.thread = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("StandardLoader[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    private void validatePackages() throws LifecycleException {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader instanceof StandardClassLoader) {
            Extension[] available = ((StandardClassLoader)classLoader).findAvailable();
            Extension[] required = ((StandardClassLoader)classLoader).findRequired();
            if (this.debug >= 1) {
                this.log("Optional Packages:  available=" + available.length + ", required=" + required.length);
            }
            int i = 0;
            while (i < required.length) {
                if (this.debug >= 1) {
                    this.log("Checking for required package " + required[i]);
                }
                boolean found = false;
                int j = 0;
                while (j < available.length) {
                    if (available[j].isCompatibleWith(required[i])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    throw new LifecycleException("Missing optional package " + required[i]);
                }
                ++i;
            }
        }
    }
}

